/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yto56.basic.framework.rest.filter;

import cn.com.yto56.basic.framework.core.util.EmptyUtils;
import cn.com.yto56.basic.framework.core.util.IdUtil;
import cn.com.yto56.basic.framework.core.util.IpUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;

public class RequestFilter
implements Filter,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(RequestFilter.class);
    private static final List<String> excludes = new ArrayList<String>(Arrays.asList(".js", ".css", ".woff", ".ico", ".png", ".jpg", ".gif", ".html"));
    private String contextPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("HttpFilter can't handle an non-http request");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.isExclusion(httpRequest.getRequestURI(), httpRequest)) {
            chain.doFilter(request, response);
            return;
        }
        this.buildRequestId(httpRequest);
        try {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        finally {
            MDC.clear();
        }
    }

    private void buildRequestId(HttpServletRequest httpRequest) {
        String requestId = httpRequest.getHeader("requestId");
        if (StringUtils.isEmpty((CharSequence)requestId)) {
            requestId = IdUtil.getSeqID();
        }
        MDC.put((String)"requestId", (String)requestId);
        MDC.put((String)"serverIp", (String)IpUtil.getIp());
        MDC.put((String)"clientIp", (String)this.getRemoteAddr(httpRequest));
    }

    public boolean isExclusion(String requestURI, HttpServletRequest request) {
        if ("/".equals(requestURI)) {
            return true;
        }
        if (HttpMethod.OPTIONS.toString().equals(request.getMethod())) {
            return true;
        }
        if (excludes == null) {
            return false;
        }
        if (this.contextPath != null && requestURI.startsWith(this.contextPath) && !(requestURI = requestURI.substring(this.contextPath.length())).startsWith("/")) {
            requestURI = "/" + requestURI;
        }
        for (String pattern : excludes) {
            if (!requestURI.endsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public String getRemoteAddr(HttpServletRequest request) {
        String ip = request.getRemoteAddr();
        if (EmptyUtils.isNotEmpty((Object)ip)) {
            String[] newIp = ip.split(",");
            return newIp[0].trim();
        }
        return ip;
    }

    public void destroy() {
    }

    public int getOrder() {
        return 500;
    }
}

