/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yto56.basic.framework.rest.monitor;

import cn.com.yto56.basic.framework.core.exception.SysException;
import cn.com.yto56.basic.framework.core.exception.YtoConfigurationErrorException;
import cn.com.yto56.basic.framework.core.exception.YtoErrorAuthenticationException;
import cn.com.yto56.basic.framework.core.exception.YtoErrorOperationException;
import cn.com.yto56.basic.framework.core.exception.YtoErrorServerException;
import cn.com.yto56.basic.framework.core.exception.YtoException;
import cn.com.yto56.basic.framework.core.exception.YtoInvalidArgumentException;
import cn.com.yto56.basic.framework.core.exception.YtoInvalidPermissionException;
import cn.com.yto56.basic.framework.core.exception.YtoMissingArgumentException;
import cn.com.yto56.basic.framework.core.exception.YtoNotFoundException;
import cn.com.yto56.basic.framework.core.exception.YtoServerTimeoutException;
import cn.com.yto56.basic.framework.model.rest.BaseResponse;
import cn.com.yto56.basic.framework.model.rest.DataResult;
import cn.com.yto56.basic.framework.rest.monitor.IErrorMsgHandler;
import java.io.Serializable;
import java.time.ZonedDateTime;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    public static final String DEFAULT_ERROR_VIEW = "error";
    @Autowired(required=false)
    IErrorMsgHandler hander;

    @ExceptionHandler(value={YtoErrorAuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public DataResult<BaseResponse> authErrorHandler(HttpServletRequest req, SysException e) {
        return this.buildErrorResponse(e.getCode(), e.getMessage(), e.getReturnObj());
    }

    @ExceptionHandler(value={YtoErrorOperationException.class, YtoInvalidPermissionException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public DataResult<BaseResponse> invalidPermissionErrorHandler(HttpServletRequest req, SysException e) {
        return this.buildErrorResponse(e.getCode(), e.getMessage(), e.getReturnObj());
    }

    @ExceptionHandler(value={YtoConfigurationErrorException.class, YtoErrorServerException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public DataResult<BaseResponse> genalErrorHandler(HttpServletRequest req, SysException e) {
        return this.buildErrorResponse(e.getCode(), e.getMessage(), e.getReturnObj());
    }

    @ExceptionHandler(value={YtoServerTimeoutException.class})
    @ResponseStatus(value=HttpStatus.REQUEST_TIMEOUT)
    @ResponseBody
    public DataResult<BaseResponse> timeoutErrorHandler(HttpServletRequest req, SysException e) {
        return this.buildErrorResponse(e.getCode(), e.getMessage(), e.getReturnObj());
    }

    @ExceptionHandler(value={YtoNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public DataResult<BaseResponse> notFoundErrorHandler(HttpServletRequest req, SysException e) {
        return this.buildErrorResponse(e.getCode(), e.getMessage(), e.getReturnObj());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class, YtoMissingArgumentException.class, YtoInvalidArgumentException.class, YtoException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public DataResult<BaseResponse> argumentsError(HttpServletRequest req, Exception e) throws Exception {
        return this.buildErrorResponse(((YtoException)e).getCode(), ((YtoException)e).getMessage(), null);
    }

    private String getReqUrl(HttpServletRequest req) {
        try {
            String path = req.getRequestURI();
            String queryStr = req.getQueryString();
            if (queryStr != null) {
                path = path + "?" + req.getQueryString();
            }
            return path;
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public DataResult<BaseResponse> buildErrorResponse(int status, String message, Object data) {
        DataResult dataResult = new DataResult();
        dataResult.setStatus(status);
        dataResult.setMessage(message);
        if (data instanceof BaseResponse) {
            dataResult.setData((Serializable)((BaseResponse)data));
        }
        dataResult.setTimestamp(ZonedDateTime.now());
        return dataResult;
    }
}

