/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter;

import com.yto.monitor.adapter.cache.LatticeCacheService;
import com.yto.monitor.adapter.config.AdapterServerConfig;
import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.config.SystemConfig;
import com.yto.monitor.adapter.job.HourJob;
import com.yto.monitor.adapter.job.MinuteJob;
import com.yto.monitor.adapter.job.thread.BaseDataInitThread;
import com.yto.monitor.adapter.job.thread.ThreadManagement;
import com.yto.monitor.adapter.netty.server.NettyServer;
import com.yto.monitor.adapter.netty.server.light.LightNettyServer;
import com.yto.monitor.adapter.schedule.SchedulerJobManager;
import com.yto.monitor.adapter.service.CfgService;
import com.yto.monitor.adapter.service.DataMigrationService;
import com.yto.monitor.adapter.service.IAppInfoService;
import com.yto.monitor.adapter.service.IBaseDataSynService;
import com.yto.monitor.adapter.service.ManageConfigService;
import com.yto.monitor.adapter.service.download.DataSyncService;
import com.yto.monitor.adapter.service.login.ExpUserLoginService;
import com.yto.monitor.adapter.service.login.ISystemLoginService;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.adapter.service.newDevice.IExpOperationTableService;
import com.yto.monitor.adapter.service.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class SystemCommandLineRunner
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(SystemCommandLineRunner.class);
    @Autowired
    private SchedulerJobManager schedulerJobManager;
    @Autowired
    private AdapterServerConfig serverConfig;
    @Autowired
    private NettyServer nettyServer;
    @Autowired
    private LightNettyServer lightNettyServer;
    @Autowired
    IBaseDataSynService baseDataSynService;
    @Autowired
    private ThreadManagement threadManagement;
    @Autowired
    private IExpOperationTableService iExpOperationTableService;
    @Autowired
    private IAppInfoService appInfoService;
    @Autowired
    private IExpAutoDeviceService autoDeviceService;
    @Autowired
    private ISystemLoginService loginService;
    @Autowired
    private SysPropertiesConfig sysPropertiesConfig;
    @Autowired
    private DataMigrationService dataMigrationService;
    @Autowired
    private SystemConfig systemConfig;
    @Autowired
    private ExpUserLoginService expUserLoginService;
    @Autowired
    private LatticeCacheService latticeCacheService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private MinuteJob minuteJob;
    @Autowired
    private HourJob hourJob;
    @Autowired
    private DataSyncService dataSyncService;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private CfgService cfgService;
    @Autowired
    private ManageConfigService manageConfigService;

    public void run(String ... args) throws Exception {
        if (!this.systemService.isDevEnv() && !this.systemService.checkHeapMemory(500L)) {
            System.exit(0);
        }
        if (!this.loginService.login(this.systemConfig.getClientUserName(), this.systemConfig.getClientPassword())) {
            logger.info("\u767b\u5f55\u5931\u8d25\uff0c\u7cfb\u7edf\u9000\u51fa");
            System.exit(0);
        }
        this.sysPropertiesConfig.init();
        this.expUserLoginService.setUserCache();
        this.expUserLoginService.startTokenRefreshTask();
        this.dataMigrationService.execute();
        this.manageConfigService.refreshManageConfig();
        this.schedulerJobManager.scheduleAllJobs();
        this.minuteJob.start();
        this.hourJob.start();
        this.dataSyncService.firstSyncData();
        this.commonConfig.initCarLayerWcsList();
        this.threadManagement.initHealthHeard();
        this.appInfoService.systemStartAutoCreateAppInfo();
        BaseDataInitThread.execute((IBaseDataSynService)this.baseDataSynService);
        if (this.serverConfig.getStartTcpServer() == 1) {
            logger.info("\u521d\u59cb\u5316Netty\u670d\u52a1\uff0c\u7aef\u53e3\uff1a" + this.serverConfig.getAdapterServerPort());
            this.nettyServer.start(this.serverConfig.getAdapterServerPort().intValue());
        }
        if (this.serverConfig.getStartUpLightChannel() == 1) {
            logger.info("\u521d\u59cb\u5316Netty light\u670d\u52a1\uff0c\u7aef\u53e3\uff1a" + this.serverConfig.getLightAutomatePort());
            this.lightNettyServer.start(this.serverConfig.getLightAutomatePort().intValue());
        }
        this.cfgService.refreshClientConfigParam();
        this.autoDeviceService.initToCache();
        this.iExpOperationTableService.initToCache();
        this.latticeCacheService.refresh();
    }
}

