/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.cache;

import com.yto.monitor.adapter.entity.newDevice.TExpAutoDevice;
import com.yto.monitor.adapter.entity.newDevice.TExpLattice;
import com.yto.monitor.adapter.entity.newDevice.TExpLatticeScheme;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.adapter.service.newDevice.IExpLatticeSchemeService;
import com.yto.monitor.adapter.service.newDevice.IExpLatticeService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LatticeCacheService {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private IExpAutoDeviceService expAutoDeviceService;
    @Autowired
    private IExpLatticeSchemeService expLatticeSchemeService;
    @Autowired
    private IExpLatticeService expLatticeService;
    public static Map<String, TExpAutoDevice> crossBeltIpPortCache = new ConcurrentHashMap();
    public static Map<String, TExpAutoDevice> crossBeltDeviceIdCache = new ConcurrentHashMap();
    public static Map<String, TExpLatticeScheme> crossBeltSchemeCache = new ConcurrentHashMap();
    public static Map<String, TExpAutoDevice> matrixCache = new ConcurrentHashMap();
    public static Map<String, TExpLatticeScheme> matrixSchemeCache = new ConcurrentHashMap();
    public static Map<String, TExpAutoDevice> endLineDeviceCache = new ConcurrentHashMap();
    public static Map<String, TExpLatticeScheme> endLineSchemeCache = new ConcurrentHashMap();
    public static Map<String, TExpLattice> endLineLatticeCache = new ConcurrentHashMap();
    public static Map<String, List<TExpLattice>> allEndLineLatticeCache = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
        scheduledThreadPool.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 3L, 2L, TimeUnit.MINUTES);
    }

    public void refresh() {
        long start;
        List autoDevices = new ArrayList();
        try {
            start = System.currentTimeMillis();
            autoDevices = this.expAutoDeviceService.refreshAutoDevicesCache();
            logger.info("\u5237\u65b0\u4ea4\u53c9\u5e26\u8bbe\u5907:{}\u4e2a,\u8017\u65f6:{}", (Object)crossBeltDeviceIdCache.size(), (Object)(System.currentTimeMillis() - start));
            logger.info("\u5237\u65b0\u77e9\u9635\u8bbe\u5907:{}\u4e2a,\u8017\u65f6:{}", (Object)matrixCache.size(), (Object)(System.currentTimeMillis() - start));
            logger.info("\u5237\u65b0\u672b\u7aef\u7ebf\u8bbe\u5907:{}\u4e2a,\u8017\u65f6:{}", (Object)endLineDeviceCache.size(), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u8bbe\u5907\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
        }
        try {
            start = System.currentTimeMillis();
            this.expLatticeSchemeService.refreshAutoDevicesCache(autoDevices);
            logger.info("\u5237\u65b0\u4ea4\u53c9\u5e26\u8bbe\u5907\u683c\u53e3\u65b9\u6848:{}\u4e2a,\u8017\u65f6:{}", (Object)crossBeltSchemeCache.size(), (Object)(System.currentTimeMillis() - start));
            logger.info("\u5237\u65b0\u77e9\u9635\u8bbe\u5907\u683c\u53e3\u65b9\u6848:{}\u4e2a,\u8017\u65f6:{}", (Object)matrixSchemeCache.size(), (Object)(System.currentTimeMillis() - start));
            logger.info("\u5237\u65b0\u672b\u7aef\u7ebf\u8bbe\u5907\u683c\u53e3\u65b9\u6848:{}\u4e2a,\u8017\u65f6:{}", (Object)endLineSchemeCache.size(), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u8bbe\u5907\u683c\u53e3\u65b9\u6848\u5f02\u5e38", (Throwable)e);
        }
        try {
            long start2 = System.currentTimeMillis();
            this.expLatticeService.getEndLineLatticeService().refreshEndLineLatticeCache();
            logger.info("\u5237\u65b0\u672b\u7aef\u7ebf\u683c\u53e3\u660e\u7ec6:{}\u4e2a,\u8017\u65f6:{}", (Object)endLineLatticeCache.size(), (Object)(System.currentTimeMillis() - start2));
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u672b\u7aef\u7ebf\u683c\u53e3\u660e\u7ec6\u5f02\u5e38", (Throwable)e);
        }
    }
}

