/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.config;

import com.yto.monitor.adapter.service.observer.BizTypeEnum;
import com.yto.monitor.adapter.service.observer.MessageObj;
import com.yto.monitor.common.util.ExpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.util.CollectionUtils;

@Configuration
@PropertySource(value={"classpath:config/commonConfig.properties"})
public class CommonConfig {
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);
    public static List<String> CAR_LAYER_WCS_LIST = new ArrayList();
    @Value(value="${image_location}")
    private String imageLocation;
    @Value(value="${image_max_size}")
    private String imageMaxSize;
    @Value(value="${request_total_size}")
    private String requestTotalSize;
    @Value(value="c^n1J#%vnC&ilWoi")
    private String imageUploadKey;
    @Value(value="H$J#%nnMb1iJ#&lrOi")
    private String oxmsFileUploadKey;
    @Value(value="${image_upload_charset:UTF-8}")
    private String imageUploadCharset;
    @Value(value="${image_upload_max_retry_count:5}")
    private int imageUploadMaxRetryCount;
    @Value(value="${max_exceptionCount:50}")
    private int maxExceptionCount;
    @Value(value="${delete_timeout:2}")
    private int deleteTimeOut;
    @Value(value="${induction_data_save_day:20}")
    private int inductionDataSaveDay;
    @Value(value="${exception_falling_save_day:20}")
    private int exceptionFallingSaveDay;
    @Value(value="${delete_cross_belt:20}")
    private int deleteCrossBeltData;
    @Value(value="${image_upload_app_id:img_Monitor_Adapter}")
    private String appId;
    @Value(value="${oxms_app_id:yto-automatic-ssi}")
    private String oxmsAppId;
    @Value(value="${dayOfUploadImage}")
    private int dayOfUploadImage;
    @Value(value="${uploadImageSwitch}")
    private int uploadImageSwitch;
    @Value(value="${uploadImageCorePoolSize:3}")
    private int uploadImageCorePoolSize;
    @Value(value="${uploadImageMaxBandWidth:150}")
    private int uploadImageMaxBandWidth;
    @Value(value="${saveCheckTableDay:5}")
    private int saveCheckTableDay;
    @Value(value="${receiveImageSwitch}")
    private int receiveImageSwitch;
    @Value(value="${system_disk}")
    private String systemDisk;
    @Value(value="${onlyAQCheck:0}")
    private int onlyAQCheck;
    @Value(value="${checkEmp3Code:1}")
    private int checkEmp3Code;
    @Value(value="${upload_image_speed_limit:0}")
    private int uploadImageSpeedLimit;
    @Value(value="${electronicScreenFieldValue:1500}")
    private int electronicScreenFieldValue;
    @Value(value="${zipImageSwitch:0}")
    private int zipImageSwitch;
    @Value(value="${checkImageRepeated:1}")
    private int checkImageRepeated;
    @Value(value="${uploadModel}")
    private int uploadModel;
    @Value(value="${deleteImageWhenUpload:0}")
    private int deleteImageWhenUpload;
    @Value(value="${receiveImageDetailLog:0}")
    private int receiveImageDetailLog;
    @Value(value="${updateAppNewWay}")
    private int updateAppNewWay;
    @Value(value="${minHeapMemory}")
    private Long minHeapMemory;
    @Value(value="${calcInoutOnFirstUpload:0}")
    private int calcInoutOnFirstUpload;
    @Value(value="${needToken:1}")
    private String needToken;
    @Value(value="${flashControl:04}")
    private String flashControl;
    @Value(value="${volumeControl:08}")
    private String volumeControl;
    @Value(value="${playMode:00}")
    private String playMode;
    @Value(value="${musicSelect:02}")
    private String musicSelect;
    @Value(value="${syncMaxCount:5}")
    private Integer syncMaxCount;
    @Value(value="${systemInfoPush:2}")
    private String systemInfoPush;
    @Value(value="${calcCarLayer:0}")
    private String calcCarLayer;

    public String getNeedToken() {
        return this.needToken;
    }

    public void setNeedToken(String needToken) {
        this.needToken = needToken;
    }

    public int getCalcInoutOnFirstUpload() {
        return this.calcInoutOnFirstUpload;
    }

    public void setCalcInoutOnFirstUpload(int calcInoutOnFirstUpload) {
        this.calcInoutOnFirstUpload = calcInoutOnFirstUpload;
    }

    public String getSystemInfoPush() {
        return this.systemInfoPush;
    }

    public Integer getSyncMaxCount() {
        return this.syncMaxCount;
    }

    public String getCalcCarLayer() {
        return this.calcCarLayer;
    }

    public void setCalcCarLayer(String calcCarLayer) {
        this.calcCarLayer = calcCarLayer;
    }

    public String getFlashControl() {
        return this.flashControl;
    }

    public void setFlashControl(String flashControl) {
        this.flashControl = flashControl;
    }

    public String getVolumeControl() {
        return this.volumeControl;
    }

    public void setVolumeControl(String volumeControl) {
        this.volumeControl = volumeControl;
    }

    public String getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(String playMode) {
        this.playMode = playMode;
    }

    public String getMusicSelect() {
        return this.musicSelect;
    }

    public void setMusicSelect(String musicSelect) {
        this.musicSelect = musicSelect;
    }

    public Long getMinHeapMemory() {
        return this.minHeapMemory;
    }

    public int getUpdateAppNewWay() {
        return this.updateAppNewWay;
    }

    public int getReceiveImageDetailLog() {
        return this.receiveImageDetailLog;
    }

    public int getDeleteImageWhenUpload() {
        return this.deleteImageWhenUpload;
    }

    public int getUploadImageSpeedLimit() {
        return this.uploadImageSpeedLimit;
    }

    public int getReceiveImageSwitch() {
        return this.receiveImageSwitch;
    }

    public int getOnlyAQCheck() {
        return this.onlyAQCheck;
    }

    public String getSystemDisk() {
        return this.systemDisk;
    }

    public int getSaveCheckTableDay() {
        return this.saveCheckTableDay;
    }

    public int getUploadImageSwitch() {
        return this.uploadImageSwitch;
    }

    public int getDayOfUploadImage() {
        return this.dayOfUploadImage;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getOxmsAppId() {
        return this.oxmsAppId;
    }

    public int getInductionDataSaveDay() {
        return this.inductionDataSaveDay;
    }

    public int getExceptionFallingSaveDay() {
        return this.exceptionFallingSaveDay;
    }

    public int getDeleteCrossBeltData() {
        return this.deleteCrossBeltData;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public String getImageMaxSize() {
        return this.imageMaxSize;
    }

    public String getRequestTotalSize() {
        return this.requestTotalSize;
    }

    public String getImageUploadKey() {
        return this.imageUploadKey;
    }

    public String getImageUploadCharset() {
        return this.imageUploadCharset;
    }

    public String getOxmsFileUploadKey() {
        return this.oxmsFileUploadKey;
    }

    public int getImageUploadMaxRetryCount() {
        return this.imageUploadMaxRetryCount;
    }

    public int getMaxExceptionCount() {
        return this.maxExceptionCount;
    }

    public int getDeleteTimeOut() {
        return this.deleteTimeOut;
    }

    public int getCheckEmp3Code() {
        return this.checkEmp3Code;
    }

    public int getUploadImageCorePoolSize() {
        return this.uploadImageCorePoolSize;
    }

    public int getUploadImageMaxBandWidth() {
        return this.uploadImageMaxBandWidth;
    }

    public int getElectronicScreenFieldValue() {
        return this.electronicScreenFieldValue;
    }

    public int getZipImageSwitch() {
        return this.zipImageSwitch;
    }

    public int getUploadModel() {
        return this.uploadModel;
    }

    public int getCheckImageRepeated() {
        return this.checkImageRepeated;
    }

    public int checkModel(MessageObj messageObj) {
        switch (this.uploadModel) {
            case 1: {
                logger.warn("\u5f53\u524d\u6a21\u5f0f\u4ec5\u64cd\u4f5c\u91cf\u4e0a\u4f20!");
                if (messageObj.getBizTypeEnum().equals((Object)BizTypeEnum.Task_ALL)) {
                    messageObj.setBizTypeEnum(BizTypeEnum.Task_Operation);
                }
                if (!messageObj.getBizTypeEnum().equals((Object)BizTypeEnum.Task_Image) && !messageObj.getBizTypeEnum().equals((Object)BizTypeEnum.Task_Image_Delete)) break;
                return -1;
            }
            case 2: {
                logger.warn("\u5f53\u524d\u6a21\u5f0f\u4ec5\u56fe\u7247\u4e0a\u4f20\u53ca\u5220\u9664!");
                if (messageObj.getBizTypeEnum().equals((Object)BizTypeEnum.Task_ALL)) {
                    messageObj.setBizTypeEnum(BizTypeEnum.Task_Image);
                }
                if (!messageObj.getBizTypeEnum().equals((Object)BizTypeEnum.Task_Operation)) break;
                return -1;
            }
            case 3: {
                logger.warn("\u4ec5\u56fe\u7247\u5220\u9664!");
                if (messageObj.getBizTypeEnum().equals((Object)BizTypeEnum.Task_ALL)) {
                    messageObj.setBizTypeEnum(BizTypeEnum.Task_Image_Delete);
                }
                if (!messageObj.getBizTypeEnum().equals((Object)BizTypeEnum.Task_Operation) && !messageObj.getBizTypeEnum().equals((Object)BizTypeEnum.Task_Image)) break;
                return -1;
            }
        }
        return 1;
    }

    public String[] getAlarmLightConf() {
        String[] array = new String[]{this.flashControl, this.volumeControl, this.playMode, this.musicSelect};
        return array;
    }

    public void initCarLayerWcsList() {
        if ("0".equals(this.calcCarLayer) || !this.calcCarLayer.contains(":")) {
            logger.info("\u5f53\u524d\u9700\u8981\u5904\u7406\u5c0f\u8f66\u5c42\u53f7\u7684WCS\u7f13\u5b58:{}", (Object)CAR_LAYER_WCS_LIST);
            return;
        }
        if (this.calcCarLayer.contains(";")) {
            String[] wcsArrays;
            for (String wcs : wcsArrays = this.calcCarLayer.split(";")) {
                this.addWcsIpPort(wcs);
            }
        } else {
            this.addWcsIpPort(this.calcCarLayer);
        }
        logger.info("\u5f53\u524d\u9700\u8981\u5904\u7406\u5c0f\u8f66\u5c42\u53f7\u7684WCS\u7f13\u5b58:{}", (Object)CAR_LAYER_WCS_LIST);
    }

    private void addWcsIpPort(String calcCarLayer) {
        String ip;
        if (calcCarLayer.contains(":") && ExpUtils.isNotBlank((String)(ip = calcCarLayer.split(":")[0])) && ip.matches("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$")) {
            CAR_LAYER_WCS_LIST.add(calcCarLayer);
        }
    }

    public boolean needCalcCarLayer(String wcsIpPort) {
        if (ExpUtils.isBlank((String)wcsIpPort)) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)CAR_LAYER_WCS_LIST)) {
            return false;
        }
        return CAR_LAYER_WCS_LIST.contains(wcsIpPort);
    }
}

