/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.config;

import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.interceptor.AuthorizeInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class GoWebMvcConfigurerAdapter
implements WebMvcConfigurer {
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private AuthorizeInterceptor authorizeInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.authorizeInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/error", "/css/**", "/js/**", "/index.html", "/img/**", "/fonts/**", "/favicon.ico", "/favicon1.ico"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String imageLocation = this.commonConfig.getImageLocation();
        String replace = imageLocation.replace("\\", "/");
        String url = "file:" + replace + "/";
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"resources/", "static/", "public/", "META-INF/resources/"}).addResourceLocations(new String[]{"classpath:resources/", "classpath:static/", "classpath:public/", "classpath:META-INF/resources/"}).addResourceLocations(new String[]{"file:///tmp/webapps/"}).addResourceLocations(new String[]{url});
    }

    @Bean
    public CorsFilter corsFilter() {
        CorsConfiguration config = new CorsConfiguration();
        config.addAllowedOrigin("*");
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedMethod("*");
        config.addAllowedHeader("*");
        config.addExposedHeader("Content-Type");
        config.addExposedHeader("X-Requested-With");
        config.addExposedHeader("accept");
        config.addExposedHeader("Origin");
        config.addExposedHeader("Authorization");
        config.addExposedHeader("UserCode");
        config.addExposedHeader("Access-Control-Request-Method");
        config.addExposedHeader("Access-Control-Request-Headers");
        UrlBasedCorsConfigurationSource configSource = new UrlBasedCorsConfigurationSource();
        configSource.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)configSource);
    }
}

