/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.config;

import com.yto.monitor.adapter.service.system.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class Swagger2Config {
    @Value(value="${swagger.basePackage}")
    private String basePackage;
    @Value(value="${swagger.title}")
    private String title;
    @Value(value="${swagger.contact}")
    private String contact;
    @Value(value="${swagger.version}")
    private String version;
    @Autowired
    private SystemService systemService;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).enable(this.systemService.isDevEnv()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.basePackage)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.title).contact(new Contact(this.contact, this.contact, this.contact)).version(this.version).build();
    }
}

