/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.config;

import cn.yto.ypush.spring.context.LoadIOTConfigEvent;
import com.yto.monitor.adapter.constant.OrgTypeEnum;
import com.yto.monitor.adapter.constant.SysPropType;
import com.yto.monitor.adapter.entity.SysProperties;
import com.yto.monitor.adapter.mapper.OrgInfoMapper;
import com.yto.monitor.adapter.service.CheckWhiteListService;
import com.yto.monitor.adapter.service.IAppInfoService;
import com.yto.monitor.adapter.service.SysPropertiesService;
import com.yto.monitor.adapter.service.download.OrgInfoService;
import com.yto.monitor.common.entity.base.OrgInfoEntity;
import com.yto.monitor.common.entity.response.CheckWhiteResp;
import com.yto.monitor.common.util.ExpUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@DependsOn(value={"dataBaseService"})
public class SysPropertiesConfig {
    private static final Logger logger = LoggerFactory.getLogger(SysPropertiesConfig.class);
    public static final String TOPIC_PREFIX = "sys/monitor";
    private static String orgCode;
    private static String orgName;
    private static String orgType;
    @Autowired
    private SysPropertiesService sysPropertiesService;
    @Autowired
    private OrgInfoMapper orgInfoMapper;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IAppInfoService appInfoService;
    @Autowired
    private CheckWhiteListService checkWhiteListService;
    @Autowired
    private OrgInfoService orgInfoService;

    public static String getOrgType() {
        return orgType;
    }

    public static String getOrgCode() {
        return orgCode;
    }

    private static void setOrgType(String type) {
        orgType = type;
    }

    public static String getOrgName() {
        return orgName;
    }

    public static void setOrgName(String orgName) {
        SysPropertiesConfig.orgName = orgName;
    }

    public void init() {
        logger.info("\u6b63\u5728\u52a0\u8f7d\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f...");
        try {
            List properList = this.sysPropertiesService.getAllProps();
            properList.stream().filter(item -> StringUtils.isNotBlank((String)item.getPropValue())).forEach(item -> {
                if (item.getPropKey().equalsIgnoreCase(SysPropType.opOrgCode.toString()) || item.getPropKey().equalsIgnoreCase(SysPropType.opOrgId.toString()) || item.getPropKey().equalsIgnoreCase(SysPropType.ORG_CODE.toString())) {
                    if (StringUtils.isBlank((String)orgCode)) {
                        orgCode = item.getPropValue();
                    }
                } else if (item.getPropKey().equalsIgnoreCase(SysPropType.opOrgName.toString())) {
                    orgName = item.getPropValue();
                }
            });
            if (StringUtils.isBlank((String)orgCode)) {
                logger.error("\u67e5\u8be2\u8868T_SYS_PROPERTIES\u6570\u636eOrgCode\u4e3a\u7a7a");
                throw new Exception("\u67e5\u8be2\u8868T_SYS_PROPERTIES\u6570\u636eOrgCode\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)orgName)) {
                logger.info("\u67e5\u8be2\u8868T_SYS_PROPERTIES\u6570\u636eOrgName\u4e3a\u7a7a,\u5373\u5c06\u67e5\u8be2\u672c\u5730\u5e93");
                OrgInfoEntity orgInfoEntity = this.orgInfoMapper.getOrgInfoByCode(orgCode);
                if (orgInfoEntity != null) {
                    orgName = orgInfoEntity.getName();
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8868T_SYS_PROPERTIES\u51fa\u9519", e.getCause());
            throw new RuntimeException("\u67e5\u8be2\u8868T_SYS_PROPERTIES\u51fa\u9519");
        }
        SysPropertiesConfig.print();
        if (ExpUtils.isNotBlank((String)orgCode)) {
            CheckWhiteResp resp;
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("orgCode", orgCode);
            String monitorSysVersion = this.appInfoService.getMonitorSysVersion();
            if (ExpUtils.isNotBlank((String)monitorSysVersion)) {
                args.put("version", monitorSysVersion);
            }
            OrgInfoEntity orgInfoByCode = this.orgInfoService.getOrgInfoByCode(orgCode, false);
            String orgType = Optional.ofNullable(orgInfoByCode).map(OrgInfoEntity::getType).orElse("");
            SysPropertiesConfig.setOrgType((String)orgType);
            if (!OrgTypeEnum.TRANSFER_CENTER.getType().equals(orgType) && Objects.nonNull(resp = this.checkWhiteListService.requestWhiteList(orgCode)) && ExpUtils.isBlank((String)resp.getSecret())) {
                logger.info("orgCode:{} \u767d\u540d\u5355\u5df2\u7ecf\u7981\u7528\u6216\u8005\u5220\u9664,\u5c06\u81ea\u52a8\u9000\u51fa", (Object)orgCode);
                System.exit(0);
            }
            this.applicationContext.publishEvent((ApplicationEvent)new LoadIOTConfigEvent(this.applicationContext, args));
        }
    }

    public static void print() {
        logger.info("\u7cfb\u7edf\u914d\u7f6e\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\uff1a" + orgCode + "\uff0c\u540d\u79f0: " + orgName);
    }

    public void refreshOrgInfo() {
        List properList = this.sysPropertiesService.getAllProps();
        if (CollectionUtils.isEmpty((Collection)properList)) {
            return;
        }
        Stream<SysProperties> sysPropertiesStream = properList.stream().filter(item -> StringUtils.isNotBlank((String)item.getPropValue()));
        AtomicBoolean orgCodeFromOpOrgCode = new AtomicBoolean(false);
        AtomicBoolean orgNameFromOpOrgName = new AtomicBoolean(false);
        sysPropertiesStream.forEach(item -> {
            if (item.getPropKey().equalsIgnoreCase(SysPropType.opOrgCode.toString())) {
                orgCodeFromOpOrgCode.set(true);
                orgCode = item.getPropValue();
            } else if (item.getPropKey().equalsIgnoreCase(SysPropType.opOrgName.toString())) {
                orgNameFromOpOrgName.set(true);
                orgName = item.getPropValue();
            }
        });
        if (!orgCodeFromOpOrgCode.get()) {
            sysPropertiesStream.forEach(item -> {
                if (item.getPropKey().equalsIgnoreCase(SysPropType.ORG_CODE.toString())) {
                    logger.info("\u5c06T_SYS_PROPERTIE\u7684ORG_CODE:{}\u8d4b\u503c\u7ed9\u5f53\u524dSysPropertiesConfig\u7684orgCode", (Object)item.getPropValue());
                    orgCode = item.getPropValue();
                }
            });
        }
        if (!orgNameFromOpOrgName.get() && ExpUtils.isNotBlank((String)orgCode)) {
            logger.info("\u67e5\u8be2\u8868T_SYS_PROPERTIES\u6570\u636eOrgName\u4e3a\u7a7a,\u5373\u5c06\u67e5\u8be2\u672c\u5730\u5e93");
            OrgInfoEntity orgInfoEntity = this.orgInfoMapper.getOrgInfoByCode(orgCode);
            if (orgInfoEntity != null) {
                orgName = orgInfoEntity.getName();
            }
        }
        logger.info("\u5237\u65b0\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\uff1a" + orgCode + "\uff0c\u540d\u79f0: " + orgName);
    }
}

