/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.constant;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum LatticeOptTypeEnum {
    NORMAL("0", "\u4e0d\u751f\u6210\u843d\u683c", Boolean.valueOf(false), true, false, false, false),
    BUILD_PACK("1", "\u5efa\u5305", Boolean.valueOf(false), true, false, false, false),
    UPLOAD("2", "\u4e0a\u8f66", Boolean.valueOf(false), true, false, true, true),
    DISPATCH("3", "\u6d3e\u4ef6", Boolean.valueOf(false), true, false, true, true),
    STATION("4", "\u9a7f\u7ad9\u76f4\u9001", Boolean.valueOf(true), true, false, false, false),
    COUNTRY_STATION("5", "\u6d3e\u5165\u5408\u4e00", Boolean.valueOf(false), true, false, false, false),
    NO_DROP("6", "\u4e0d\u751f\u6210\u4f9b\u4ef6\u4e0e\u843d\u683c", Boolean.valueOf(false), true, false, false, false),
    NO_TRACKS("7", "\u53ea\u5206\u62e3\u4e0d\u751f\u6210\u8f68\u8ff9", Boolean.valueOf(false), false, false, true, true),
    WAREHOUSE_SCAN("8", "\u8fdb\u4ed3\u626b\u63cf", Boolean.valueOf(false), true, false, false, false),
    STARTING_POINT_RETURN_SCAN("9", "\u59cb\u53d1\u7aef\u9000\u56de\u626b\u63cf", Boolean.valueOf(false), false, false, true, false),
    DISPATCH_AND_STARTING_POINT_RETURN_SCAN("10", "\u6d3e\u4ef6+\u59cb\u53d1\u7aef\u9000\u56de\u626b\u63cf", Boolean.valueOf(false), false, false, true, false);

    private String type;
    private String name;
    private Boolean disabled;
    private boolean normalLat;
    private boolean latDetail1;
    private boolean latDetail2;
    private boolean latDetail3;

    public static LatticeOptTypeEnum getEnumByType(String type, boolean disabled) {
        if (StringUtils.isBlank((String)type)) {
            return null;
        }
        for (LatticeOptTypeEnum value : LatticeOptTypeEnum.values()) {
            if (!value.type.equals(type) || value.disabled != disabled) continue;
            return value;
        }
        return null;
    }

    public static LatticeOptTypeEnum getEnumByName(String name, boolean disabled) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        if ("\u665a\u73ed\u5165\u5e93\u5f85\u53d6".equals(name)) {
            return COUNTRY_STATION;
        }
        for (LatticeOptTypeEnum value : LatticeOptTypeEnum.values()) {
            if (!value.name.equals(name) || value.disabled != disabled) continue;
            return value;
        }
        return null;
    }

    public static List<LatticeOptTypeEnum> effectiveValues() {
        return Arrays.stream(LatticeOptTypeEnum.values()).filter(e -> e.getDisabled() == false).collect(Collectors.toList());
    }

    public static List<LatticeOptTypeEnum> normalLatValues() {
        return Arrays.stream(LatticeOptTypeEnum.values()).filter(e -> e.getDisabled() == false && e.isNormalLat()).collect(Collectors.toList());
    }

    private LatticeOptTypeEnum(String type, String name, Boolean disabled, boolean normalLat, boolean latDetail1, boolean latDetail2, boolean latDetail3) {
        this.type = type;
        this.name = name;
        this.disabled = disabled;
        this.normalLat = normalLat;
        this.latDetail1 = latDetail1;
        this.latDetail2 = latDetail2;
        this.latDetail3 = latDetail3;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public boolean isNormalLat() {
        return this.normalLat;
    }

    public boolean isLatDetail1() {
        return this.latDetail1;
    }

    public boolean isLatDetail2() {
        return this.latDetail2;
    }

    public boolean isLatDetail3() {
        return this.latDetail3;
    }
}

