/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.entity.AlarmLight;
import com.yto.monitor.adapter.mpush.listener.ConsumingMsgServiceImpl;
import com.yto.monitor.adapter.netty.server.framework.business.datastruct.SocketClientObj;
import com.yto.monitor.adapter.netty.server.light.LightGateWay;
import com.yto.monitor.adapter.service.AlarmLightService;
import com.yto.monitor.adapter.utils.AlarmMsgHelper;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Yto_MonitorServer"})
public class AlarmLightManagerController {
    private static final Logger logger = LoggerFactory.getLogger(AlarmLightManagerController.class);
    @Autowired
    private AlarmLightService alarmLightService;
    @Autowired
    private LightGateWay lightGateWay;
    @Autowired
    private CommonConfig commonConfig;

    @HeadTokenVerification
    @PostMapping(value={"/alarmLight/search"})
    public ClientHttpResponse search(@RequestBody AlarmLight request) {
        ClientHttpResponse httpResponse = new ClientHttpResponse();
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StringUtils.isNotBlank((CharSequence)request.getIp()), AlarmLight::getIp, (Object)request.getIp());
        List list = this.alarmLightService.list((Wrapper)eq);
        ArrayList<AlarmLight> res = new ArrayList<AlarmLight>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Map<String, List<AlarmLight>> collect = list.stream().collect(Collectors.groupingBy(AlarmLight::getIp));
            for (Map.Entry<String, List<AlarmLight>> entry : collect.entrySet()) {
                AlarmLight alarmLight = new AlarmLight();
                alarmLight.setIp(entry.getKey());
                alarmLight.setCameraInfoList(new ArrayList());
                List<AlarmLight> value = entry.getValue();
                if (!CollectionUtils.isEmpty(value)) {
                    alarmLight.setId(value.get(0).getId());
                    for (AlarmLight light : value) {
                        AlarmLight.CameraInfo cameraInfo = new AlarmLight.CameraInfo();
                        cameraInfo.setCameraIndexCode(light.getCameraIndexCode());
                        cameraInfo.setCameraName(light.getCameraName());
                        alarmLight.getCameraInfoList().add(cameraInfo);
                    }
                }
                res.add(alarmLight);
            }
        }
        httpResponse.setData(res);
        return httpResponse;
    }

    @HeadTokenVerification
    @GetMapping(value={"/alarmLight/opearte"})
    public ClientHttpResponse operate(@RequestParam(value="mode") String mode, @RequestParam(value="ip") String ip, @RequestParam(required=false) List<String> params) {
        ClientHttpResponse httpResponse = new ClientHttpResponse();
        SocketClientObj socketClientObj = this.lightGateWay.getSocketClientObj(ip);
        if (Objects.isNull(socketClientObj) || !socketClientObj.channel.isOpen()) {
            httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u6839\u636e" + ip + "\u672a\u627e\u5230\u53ef\u7528\u7684socket \u8fde\u63a5");
            return httpResponse;
        }
        boolean result = false;
        if ("1".equals(mode)) {
            if (CollectionUtils.isEmpty(params)) {
                httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                httpResponse.setRespMessage("\u672a\u8bbe\u7f6e\u706f\u7684\u53c2\u6570");
                return httpResponse;
            }
            String[] paramArray = params.toArray(new String[0]);
            if (paramArray.length != 4) {
                httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                httpResponse.setRespMessage("\u706f\u7684\u53c2\u6570\u8bbe\u7f6e\u4e0d\u6b63\u786e");
                return httpResponse;
            }
            String msg = AlarmMsgHelper.genDiffMsgByMode((String)mode, (String)"01", (String)"10", (String)"001A", (String)"4", (String[])paramArray);
            result = socketClientObj.sendHexData(msg, logger);
            ConsumingMsgServiceImpl.lightSendTimeMap.put(ip, System.currentTimeMillis());
        } else if ("0".equals(mode)) {
            String msg = AlarmMsgHelper.genDiffMsgByMode((String)mode, (String)"01", (String)"10", (String)"001A", (String)"4", (String[])new String[0]);
            result = socketClientObj.sendHexData(msg, logger);
            ConsumingMsgServiceImpl.lightSendTimeMap.remove(ip);
        }
        httpResponse.setData((Object)result);
        return httpResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/alarmLight/add"})
    public ClientHttpResponse alarmLightAdd(@RequestBody AlarmLight request) {
        ClientHttpResponse httpResponse = new ClientHttpResponse();
        if (CollectionUtils.isEmpty((Collection)request.getCameraInfoList())) {
            httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u76d1\u63a7\u70b9\u4f4d");
            return httpResponse;
        }
        try {
            int count = this.alarmLightService.count((Wrapper)new LambdaQueryWrapper().eq(AlarmLight::getIp, (Object)request.getIp()));
            if (count > 0) {
                httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                httpResponse.setRespMessage("\u8be5ip\u5df2\u88ab\u914d\u7f6e");
                return httpResponse;
            }
            List cameraInfoList = request.getCameraInfoList();
            for (AlarmLight.CameraInfo cameraInfo : cameraInfoList) {
                List list = this.alarmLightService.list((Wrapper)new LambdaQueryWrapper().eq(AlarmLight::getCameraIndexCode, (Object)cameraInfo.getCameraIndexCode()));
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                for (AlarmLight alarmLight : list) {
                    if (alarmLight.getIp().equals(request.getIp())) continue;
                    httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    httpResponse.setRespMessage("\u70b9\u4f4d[" + cameraInfo.getCameraName() + "]\u5df2\u7ecf\u88ab\u5176\u4ed6\u706f\u7ed1\u5b9a");
                    return httpResponse;
                }
            }
            for (AlarmLight.CameraInfo cameraInfo : cameraInfoList) {
                AlarmLight alarmLight = new AlarmLight();
                alarmLight.setIp(request.getIp());
                alarmLight.setCameraName(cameraInfo.getCameraName());
                alarmLight.setCameraIndexCode(cameraInfo.getCameraIndexCode());
                this.alarmLightService.save((Object)alarmLight);
            }
            httpResponse.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            httpResponse.setRespMessage("\u6dfb\u52a0\u6210\u529f");
            return httpResponse;
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u62a5\u8b66\u706f\u5f02\u5e38", (Throwable)e);
            httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u6dfb\u52a0\u5931\u8d25");
            return httpResponse;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/alarmLight/edit"})
    public ClientHttpResponse alarmLightEdit(@RequestBody AlarmLight request) {
        ClientHttpResponse httpResponse = new ClientHttpResponse();
        if (CollectionUtils.isEmpty((Collection)request.getCameraInfoList())) {
            httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u76d1\u63a7\u70b9\u4f4d");
            return httpResponse;
        }
        try {
            List cameraInfoList = request.getCameraInfoList();
            for (AlarmLight.CameraInfo cameraInfo : cameraInfoList) {
                List list = this.alarmLightService.list((Wrapper)new LambdaQueryWrapper().eq(AlarmLight::getCameraIndexCode, (Object)cameraInfo.getCameraIndexCode()));
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                for (AlarmLight alarmLight : list) {
                    if (alarmLight.getIp().equals(request.getIp()) || alarmLight.getId().equals(request.getId())) continue;
                    httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    httpResponse.setRespMessage("\u70b9\u4f4d[" + cameraInfo.getCameraName() + "]\u5df2\u7ecf\u88ab\u5176\u4ed6\u706f\u7ed1\u5b9a");
                    return httpResponse;
                }
            }
            this.alarmLightService.remove((Wrapper)new LambdaQueryWrapper().eq(AlarmLight::getIp, (Object)request.getIp()));
            for (AlarmLight.CameraInfo cameraInfo : cameraInfoList) {
                AlarmLight alarmLight = new AlarmLight();
                alarmLight.setIp(request.getIp());
                alarmLight.setCameraName(cameraInfo.getCameraName());
                alarmLight.setCameraIndexCode(cameraInfo.getCameraIndexCode());
                this.alarmLightService.save((Object)alarmLight);
            }
            httpResponse.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            httpResponse.setRespMessage("\u4fee\u6539\u6210\u529f");
            return httpResponse;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u62a5\u8b66\u706f\u5f02\u5e38", (Throwable)e);
            httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u6dfb\u52a0\u5931\u8d25");
            return httpResponse;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/alarmLight/delete"})
    public ClientHttpResponse alarmLightDelete(@RequestParam(value="ip") String ip) {
        ClientHttpResponse httpResponse = new ClientHttpResponse();
        if (StringUtils.isBlank((CharSequence)ip)) {
            httpResponse.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("IP\u4e3a\u7a7a");
            return httpResponse;
        }
        this.alarmLightService.remove((Wrapper)new LambdaQueryWrapper().eq(AlarmLight::getIp, (Object)ip));
        httpResponse.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        httpResponse.setRespMessage("\u5220\u9664\u6210\u529f");
        return httpResponse;
    }
}

