/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.gson.reflect.TypeToken;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.config.UrlConfig;
import com.yto.monitor.adapter.constant.AlertEnum;
import com.yto.monitor.adapter.constant.ImageTokenRespEnum;
import com.yto.monitor.adapter.constant.OrgTypeEnum;
import com.yto.monitor.adapter.controller.CenterAppManageController;
import com.yto.monitor.adapter.controller.system.SystemManager;
import com.yto.monitor.adapter.entity.AppGroup;
import com.yto.monitor.adapter.entity.ExpMonitorCodeVison;
import com.yto.monitor.adapter.entity.request.AlertCommonReq;
import com.yto.monitor.adapter.entity.response.AppNewVersionTipResp;
import com.yto.monitor.adapter.service.AlertUploadService;
import com.yto.monitor.adapter.service.AppGroupService;
import com.yto.monitor.adapter.service.DeviceLoginService;
import com.yto.monitor.adapter.service.IAppInfoService;
import com.yto.monitor.adapter.service.download.OrgInfoService;
import com.yto.monitor.adapter.utils.CommonUtil;
import com.yto.monitor.adapter.utils.CommonUtils;
import com.yto.monitor.adapter.utils.FileUtil;
import com.yto.monitor.adapter.utils.UpgradeUtils;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.AppUpdateEntity;
import com.yto.monitor.common.entity.AppVersionEntity;
import com.yto.monitor.common.entity.ExpDeviceLoginHistory;
import com.yto.monitor.common.entity.Page;
import com.yto.monitor.common.entity.base.OrgInfoEntity;
import com.yto.monitor.common.entity.response.AppInfoEntity;
import com.yto.monitor.common.entity.response.AppUpgradeInfo;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.exception.ExpException;
import com.yto.monitor.common.http.ClientHttpRequest;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.AlibabaJsonUtil;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Api(tags={"\u5e94\u7528\u4e0b\u8f7d\u5347\u7ea7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/Yto_MonitorServer/software/"})
public class CenterAppManageController {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Value(value="${server.port}")
    private String serverPort;
    @Autowired
    private IAppInfoService appInfoService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private DeviceLoginService deviceLoginService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private AppGroupService appGroupService;
    @Autowired
    private AlertUploadService alertUploadService;

    @HeadTokenVerification
    @PostMapping(value={"listAppNames"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5e94\u7528\u540d", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse listAppNames() {
        logger.info("\u6536\u5230\u83b7\u53d6\u6240\u6709\u5e94\u7528\u540d\u8bf7\u6c42\u3002");
        ClientHttpResponse response = new ClientHttpResponse();
        List appNames = this.appInfoService.selectAllAppNames();
        response.setData((Object)appNames);
        logger.info("\u54cd\u5e94\u83b7\u53d6\u6240\u6709\u5e94\u7528\u540d\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @PostMapping(value={"listAllAppInfo"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5e94\u7528\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse listAllAppInfo(@RequestBody JSONObject request, @RequestParam(value="needLog", required=false, defaultValue="0") int needLog, @RequestParam(required=false) boolean needCheckMaxVersion) {
        boolean needLogBool;
        boolean bl = needLogBool = needLog == 1;
        if (needLogBool) {
            logger.info("\u6536\u5230\u83b7\u53d6\u6240\u6709\u5e94\u7528\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + GoogleJsonUtil.toJson((Object)request));
        }
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            Page page = (Page)request.getObject("page", Page.class);
            AppInfoEntity condition = (AppInfoEntity)request.getObject("condition", AppInfoEntity.class);
            page.setPageData(this.appInfoService.listAllAppInfo(condition, page, needLogBool, needCheckMaxVersion));
            page.setTotal(this.appInfoService.countByCondition(condition));
            response.setData((Object)page);
        }
        catch (Exception e) {
            if (needLogBool) {
                logger.error("\u67e5\u8be2\u5e94\u7528\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u5f02\u5e38");
        }
        return response;
    }

    @PostMapping(value={"checkAppNewVersion"}, produces={"application/json"})
    @ApiOperation(value="\u68c0\u67e5app\u65b0\u7248\u672c", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse<AppNewVersionTipResp> checkAppNewVersion() {
        ClientHttpResponse response = new ClientHttpResponse();
        AppNewVersionTipResp tipResp = new AppNewVersionTipResp();
        tipResp.setNewVersionAppears(Boolean.valueOf(false));
        tipResp.setAppInfoList(new ArrayList(2));
        response.setData((Object)tipResp);
        try {
            List<String> needCheckAppNames = Arrays.asList("\u76d1\u63a7\u7f51\u5173", "\u4e1a\u52a1\u7f51\u5173");
            List appList = this.appInfoService.selectByAppNames(needCheckAppNames);
            if (CollectionUtils.isEmpty((Collection)appList)) {
                return response;
            }
            Map<String, List<AppInfoEntity>> appListMap = appList.stream().collect(Collectors.groupingBy(AppInfoEntity::getAppName));
            block2: for (String appName : needCheckAppNames) {
                String maxVersion = this.appInfoService.remoteMaxVersion(appName);
                if (StringUtils.isBlank((CharSequence)maxVersion)) continue;
                List<AppInfoEntity> appListItem = appListMap.get(appName);
                for (AppInfoEntity item : appListItem) {
                    if (CommonUtils.compareVersion((String)maxVersion, (String)item.getAppVersion()) != 1) continue;
                    tipResp.setNewVersionAppears(Boolean.valueOf(true));
                    AppNewVersionTipResp.AppInfo appInfo = new AppNewVersionTipResp.AppInfo(appName, maxVersion);
                    tipResp.getAppInfoList().add(appInfo);
                    continue block2;
                }
            }
            return response;
        }
        catch (Exception e) {
            logger.info("\u68c0\u67e5app\u65b0\u7248\u672c\u5f02\u5e38", (Throwable)e);
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            return response;
        }
    }

    @PostMapping(value={"listAllAppInfoNoPage"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u4fe1\u606f\uff0c\u65e0\u5206\u9875\u6761\u4ef6", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse listAllAppInfoNoPage(@RequestBody AppInfoEntity request) {
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            List appInfoEntities = this.appInfoService.selectAll(request);
            response.setData((Object)appInfoEntities);
        }
        catch (Exception e) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u5f02\u5e38");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"addAppInfo"}, produces={"application/json"})
    @ApiOperation(value="\u6dfb\u52a0\u5e94\u7528\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse addAppInfo(@RequestBody AppInfoEntity appInfo) {
        logger.info("\u6536\u5230\u6dfb\u52a0\u5e94\u7528\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + GoogleJsonUtil.toJson((Object)appInfo));
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            this.appInfoService.addAppInfo(appInfo);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5e94\u7528\u4fe1\u606f\u5f02\u5e38\u3002", e.getCause());
            response.setRespcode(ResponseTypeEnum.APP_ADD_ERROR.getRespCode());
            response.setRespMessage(ResponseTypeEnum.APP_ADD_ERROR.getRespMessage());
        }
        logger.info("\u54cd\u5e94\u6dfb\u52a0\u5e94\u7528\u4fe1\u606f\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @PostMapping(value={"checkRepeatAppInfo"}, produces={"application/json"})
    @ApiOperation(value="\u5e94\u7528\u4fe1\u606f\u91cd\u590d\u6821\u9a8c", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse checkRepeatAppInfo(@RequestBody AppInfoEntity appInfo) {
        logger.info("\u6536\u5230\u5e94\u7528\u4fe1\u606f\u91cd\u590d\u6821\u9a8c\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + GoogleJsonUtil.toJson((Object)appInfo));
        ClientHttpResponse response = new ClientHttpResponse();
        if (this.appInfoService.isRepeatAppInfo(appInfo)) {
            response.setRespcode(ResponseTypeEnum.APP_REPEAT.getRespCode());
            response.setRespMessage(ResponseTypeEnum.APP_REPEAT.getRespMessage());
        }
        logger.info("\u54cd\u5e94\u5e94\u7528\u4fe1\u606f\u91cd\u590d\u6821\u9a8c\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @PostMapping(value={"checkRepeatApp"}, produces={"application/json"})
    @ApiOperation(value="\u5e94\u7528\u4fe1\u606f\u91cd\u590d\u6821\u9a8c", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse checkRepeatApp(@RequestBody AppInfoEntity appInfo) {
        logger.info("\u6536\u5230\u5e94\u7528\u4fe1\u606f\u91cd\u590d\u6821\u9a8c\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + GoogleJsonUtil.toJson((Object)appInfo));
        ClientHttpResponse response = new ClientHttpResponse();
        response.setData((Object)this.appInfoService.getRepeatAppId(appInfo));
        logger.info("\u54cd\u5e94\u5e94\u7528\u4fe1\u606f\u91cd\u590d\u6821\u9a8c\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"delAppInfo"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse delAppInfo(@RequestParam(value="id") String id) {
        logger.info("\u6536\u5230\u5220\u9664\u5e94\u7528\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + id);
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            this.appInfoService.delAppInfo(Integer.parseInt(id));
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5e94\u7528\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            response.setRespcode(ResponseTypeEnum.APP_DEL_ERROR.getRespCode());
            response.setRespMessage(ResponseTypeEnum.APP_DEL_ERROR.getRespMessage());
        }
        logger.info("\u54cd\u5e94\u5220\u9664\u5e94\u7528\u4fe1\u606f\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"batchDeleteApp"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse delAppInfo(@RequestBody List<AppInfoEntity> list) {
        logger.info("\u6536\u5230\u6279\u91cf\u5220\u9664\u5e94\u7528\u4fe1\u606f\u8bf7\u6c42 {}", (Object)JSONObject.toJSONString(list));
        ClientHttpResponse response = new ClientHttpResponse();
        if (CollectionUtils.isEmpty(list)) {
            response.setRespcode(ResponseTypeEnum.APP_DEL_ERROR.getRespCode());
            response.setRespMessage("\u8bf7\u9009\u62e9\u9700\u5220\u9664\u7684\u5e94\u7528");
            return response;
        }
        try {
            for (AppInfoEntity appInfoEntity : list) {
                this.appInfoService.delAppInfo(appInfoEntity.getId());
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5e94\u7528\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            response.setRespcode(ResponseTypeEnum.APP_DEL_ERROR.getRespCode());
            response.setRespMessage(ResponseTypeEnum.APP_DEL_ERROR.getRespMessage());
        }
        logger.info("\u54cd\u5e94\u5220\u9664\u5e94\u7528\u4fe1\u606f\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"modifyAppInfo"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u5e94\u7528\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse modifyAppInfo(@RequestBody AppInfoEntity appInfo) {
        logger.info("\u6536\u5230\u4fee\u6539\u5e94\u7528\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + GoogleJsonUtil.toJson((Object)appInfo));
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            this.appInfoService.modifyAppInfo(appInfo);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5e94\u7528\u4fe1\u606f\u5f02\u5e38\u3002", e.getCause());
            response.setRespcode(ResponseTypeEnum.APP_MODIFY_ERROR.getRespCode());
            response.setRespMessage(ResponseTypeEnum.APP_MODIFY_ERROR.getRespMessage());
        }
        logger.info("\u54cd\u5e94\u4fee\u6539\u5e94\u7528\u4fe1\u606f\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"updateApp"}, produces={"application/json"})
    @ApiOperation(value="\u5e94\u7528\u66f4\u65b0", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse updateApp(@RequestBody AppInfoEntity appInfoEntity) {
        logger.info("\u6536\u5230\u5e94\u7528\u66f4\u65b0\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + GoogleJsonUtil.toJson((Object)appInfoEntity));
        ClientHttpResponse response = new ClientHttpResponse();
        boolean targetDownload = false;
        String IPAndPort = "http://" + appInfoEntity.getAppIPAddress() + ":" + appInfoEntity.getAppPort();
        if (!"\u667a\u6167\u4e2d\u5fc3".equals(appInfoEntity.getAppName()) && !"WCS".equals(appInfoEntity.getAppName())) {
            try {
                this.appInfoService.checkBusiGatewaySystemStatus(appInfoEntity);
            }
            catch (ExpException ex) {
                logger.error(ex.getErrorMessage());
                response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                response.setRespMessage(ex.getErrorMessage());
                return response;
            }
            catch (Exception ex) {
                logger.error("\u68c0\u6d4b\u7f51\u5173\u7cfb\u7edf\u5f02\u5e38", (Throwable)ex);
            }
            String getAppVersionUrl = IPAndPort + "/Yto_Server/checkIsNewVersion";
            ResponseEntity responseEntity = CommonUtil.sendPostRequest((RestTemplate)CommonUtil.getRestTemplate((int)1000), (String)getAppVersionUrl, null, String.class);
            if (responseEntity != null && HttpStatus.OK.value() == responseEntity.getStatusCodeValue()) {
                logger.info("\u68c0\u6d4b\u5230\u9700\u8981\u76ee\u6807\u4e0b\u8f7d...");
                targetDownload = true;
            }
        }
        boolean isWcs = "WCS".equals(appInfoEntity.getAppName());
        boolean fastdfsDownload = this.fastdfsDownload(targetDownload, appInfoEntity.getFastdfs());
        if (isWcs) {
            fastdfsDownload = true;
            targetDownload = true;
        }
        logger.info("\u662f\u5426\u76ee\u6807\u4e0b\u8f7d\u5b89\u88c5\u5305:{},\u662f\u5426\u5f00\u542ffastdfs:{},\u76ee\u6807\u662f\u5426\u652f\u6301fastdfs:{}", new Object[]{targetDownload, fastdfsDownload, appInfoEntity.getFastdfs()});
        String base64UserMsg = null;
        String fileName = null;
        String appUrl = null;
        RestTemplate restTemp = CommonUtil.getRestTemplate((int)300000);
        if (!fastdfsDownload) {
            logger.info("\u672a\u5f00\u542ffastdfs\u4e0b\u8f7d");
            AppUpdateEntity msgBody = new AppUpdateEntity();
            msgBody.setAppName(appInfoEntity.getAppName());
            msgBody.setOrgCode(SysPropertiesConfig.getOrgCode());
            msgBody.setAppVersion(appInfoEntity.getAppMaxVersion());
            ResponseEntity responseEntity = CommonUtil.sendPostRequest((RestTemplate)restTemp, (String)UrlConfig.MethodEnum.getAppPath.getMethod(), (Object)msgBody, String.class);
            ClientHttpResponse resp = (ClientHttpResponse)CommonUtil.convertJsonToBean((String)((String)responseEntity.getBody()), (TypeToken)new /* Unavailable Anonymous Inner Class!! */);
            logger.info("\u65e7\u65b9\u5f0f\u4e0b\u8f7d\u5305,\u7b2c\u4e00\u6b21\u8bf7\u6c42\u54cd\u5e94\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)resp));
            if (ResponseTypeEnum.SUCCESS.getRespCode().equals(resp.getRespcode())) {
                String appPath = (String)resp.getData();
                appPath = appPath.replaceAll("\\\\", "/");
                appUrl = UrlConfig.MethodEnum.fileBaseUrl.getMethod() + appPath;
                String userMsg = "yto_automation:pHK%6CqFEU92";
                base64UserMsg = Base64.getEncoder().encodeToString(userMsg.getBytes());
                fileName = appPath.split("/")[1];
            }
        }
        String targetUrl = "";
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        if (targetDownload) {
            targetUrl = IPAndPort + (isWcs ? "/wcs/Yto_Server/updateAppNew" : "/Yto_Server/updateAppNew");
            AppUpgradeInfo upgradeInfo = new AppUpgradeInfo();
            if (fastdfsDownload) {
                upgradeInfo.setAppFileName(appInfoEntity.getAppName());
            } else {
                upgradeInfo.setAppUrl(appUrl);
                upgradeInfo.setBase64UserMsg(base64UserMsg);
                upgradeInfo.setAppFileName(fileName);
            }
            upgradeInfo.setVersion(appInfoEntity.getAppMaxVersion());
            upgradeInfo.setExtend1(fastdfsDownload ? 1 : 0);
            param.add((Object)"filePath", (Object)AlibabaJsonUtil.toJsonString((Object)upgradeInfo));
        } else {
            String file;
            File newAppFile;
            targetUrl = IPAndPort + "/Yto_Server/updateApp";
            AppUpdateEntity msgBody = new AppUpdateEntity();
            byte[] binary = null;
            if (fastdfsDownload) {
                HashMap result = new HashMap(5);
                msgBody.setAppName(appInfoEntity.getAppName());
                msgBody.setAppVersion(appInfoEntity.getAppMaxVersion());
                this.appInfoService.downloadAppNewWay(result, msgBody);
                if (CollectionUtils.isEmpty(result)) {
                    response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                    response.setRespMessage(ResponseTypeEnum.APP_UPDATE_ERROR.getRespMessage());
                    logger.error("\u65b0\u63a5\u53e3\u4e0b\u8f7d\u5b89\u88c5\u5305\u7ed3\u679c\u4e3a\u7a7a!");
                    return response;
                }
                binary = (byte[])result.get("appBinary");
                fileName = String.valueOf(result.get("appFileName"));
                param.add((Object)"version", (Object)String.valueOf(result.get("appVersion")));
            } else {
                binary = UpgradeUtils.getResource(appUrl, base64UserMsg);
                param.add((Object)"version", (Object)appInfoEntity.getAppMaxVersion());
            }
            if ("\u667a\u6167\u4e2d\u5fc3".equals(appInfoEntity.getAppName())) {
                param.add((Object)"orgCode", (Object)SysPropertiesConfig.getOrgCode());
            }
            if ((newAppFile = UpgradeUtils.saveAppFileToLocalDisk((byte[])binary, (String)(file = this.appInfoService.getSavePath(appInfoEntity.getAppName(), appInfoEntity.getAppMaxVersion()) + File.separator + fileName))) == null) {
                response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                response.setRespMessage("\u4fdd\u5b58\u5b89\u88c5\u5305\u5931\u8d25");
                return response;
            }
            param.add((Object)"file", (Object)new FileSystemResource(newAppFile));
        }
        try {
            String respStr = (String)restTemp.postForObject(targetUrl, (Object)param, String.class, new Object[0]);
            logger.info("\u76ee\u6807\u7f51\u5173\u7684\u66f4\u65b0\u63a5\u53e3:{},\u54cd\u5e94\u7ed3\u679c:{}", (Object)targetUrl, (Object)respStr);
            return (ClientHttpResponse)CommonUtil.convertJsonToBean((String)respStr, (TypeToken)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
            response.setRespMessage(ResponseTypeEnum.APP_UPDATE_ERROR.getRespMessage());
            logger.error("\u8bf7\u6c42\u76ee\u6807\u7f51\u5173\u7684\u66f4\u65b0\u63a5\u53e3:{}\u65f6\u5f02\u5e38", (Object)targetUrl, (Object)e);
        }
        return response;
    }

    private void updateUpgradeTime(AppInfoEntity appInfoEntity) {
        try {
            AppInfoEntity param = new AppInfoEntity();
            param.setUpgradeTime(appInfoEntity.getUpgradeTime() == null ? new Date() : appInfoEntity.getUpgradeTime());
            param.setId(appInfoEntity.getId());
            this.appInfoService.updateAppInfo(param);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539app\u5347\u7ea7\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean fastdfsDownload(boolean targetDownload, Boolean fastdfsSupport) {
        int updateAppNewWay = this.commonConfig.getUpdateAppNewWay();
        if (targetDownload) {
            return updateAppNewWay == 1 && fastdfsSupport != null && fastdfsSupport != false;
        }
        return updateAppNewWay == 1;
    }

    private boolean checkIsMySelf(AppInfoEntity appInfoEntity) {
        boolean isMySelfBoolen = false;
        String getSystemPIdUrl = "http://" + appInfoEntity.getAppIPAddress() + ":" + appInfoEntity.getAppPort() + "/Yto_Server/getSystemPId";
        try {
            RestTemplate restTemp = CommonUtil.getRestTemplate((int)3000);
            String respStr = (String)restTemp.postForObject(getSystemPIdUrl, null, String.class, new Object[0]);
            ClientHttpResponse response = (ClientHttpResponse)CommonUtil.convertJsonToBean((String)respStr, (TypeToken)new /* Unavailable Anonymous Inner Class!! */);
            if (response != null && response.getData() != null && response.getData().equals(ExpUtils.PID)) {
                isMySelfBoolen = true;
            }
        }
        catch (Exception e) {
            logger.warn("\u63a5\u53e3\u8c03\u7528\u8d85\u65f6,\u53ef\u80fd\u63a5\u53e3\u4e0d\u5b58\u5728\uff01" + getSystemPIdUrl);
        }
        return isMySelfBoolen;
    }

    @PostMapping(value={"restartApp"}, produces={"application/json"})
    @ApiOperation(value="\u91cd\u542f\u5e94\u7528", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse restartApp(@RequestParam(value="newAppFolder", required=false) String newAppFolder, @RequestBody AppInfoEntity appInfoEntity) {
        logger.info("\u6536\u5230\u91cd\u542f\u5e94\u7528\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a{},{}", (Object)newAppFolder, (Object)GoogleJsonUtil.toJson((Object)appInfoEntity));
        ClientHttpResponse response = new ClientHttpResponse();
        boolean hasNewAppFolder = false;
        if (StringUtils.isNotBlank((CharSequence)newAppFolder)) {
            hasNewAppFolder = true;
            appInfoEntity.setUpgradeTime(new Date());
        }
        if ("\u76d1\u63a7\u7f51\u5173".equals(appInfoEntity.getAppName()) && this.checkIsMySelf(appInfoEntity)) {
            File restartBatPath;
            if (!hasNewAppFolder) {
                newAppFolder = FileUtil.getAppDir();
            }
            if ((restartBatPath = new File(newAppFolder + File.separator + UpgradeUtils.getRestartScriptName())).exists() && restartBatPath.isFile()) {
                appInfoEntity.setLastModifyTime(null);
                appInfoEntity.setUpgradeTime(new Date());
                this.appInfoService.feedbackUpdateResult(appInfoEntity);
                appInfoEntity.setReloadToIndex(true);
                if (hasNewAppFolder) {
                    this.updateUpgradeTime(appInfoEntity);
                }
                SystemManager.threadPool.submit((Runnable)new SystemManager.RestartSystemThread(newAppFolder, this.serverPort));
                response.setData((Object)appInfoEntity);
                response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
                response.setRespMessage("\u5e94\u7528\u91cd\u542f\u6210\u529f\uff0c\u5c06\u5237\u65b0\u9875\u9762\uff0c\u8bf7\u7a0d\u7b49\u3002");
            } else {
                response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                response.setRespMessage("\u5e94\u7528\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
                logger.error("\u5e94\u7528\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8def\u5f84\uff1a" + newAppFolder);
            }
        } else {
            String ipAndPort = "http://" + appInfoEntity.getAppIPAddress() + ":" + appInfoEntity.getAppPort();
            boolean isWcs = "WCS".equals(appInfoEntity.getAppName());
            String restartAppUrl = ipAndPort + (isWcs ? "/wcs/Yto_Server/restartApp" : "/Yto_Server/restartApp");
            LinkedMultiValueMap urlParam = new LinkedMultiValueMap();
            urlParam.add((Object)"newAppFolder", (Object)newAppFolder);
            logger.info("\u91cd\u542f\u670d\u52a1\u5730\u5740\uff1a{},newAppFolder\uff1a{}", (Object)restartAppUrl, (Object)newAppFolder);
            String respStr = (String)this.restTemplate.postForObject(restartAppUrl, (Object)urlParam, String.class, new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)respStr)) {
                response = (ClientHttpResponse)CommonUtil.convertJsonToBean((String)respStr, (TypeToken)new /* Unavailable Anonymous Inner Class!! */);
                if (ResponseTypeEnum.SUCCESS.getRespCode().equals(response.getRespcode())) {
                    try {
                        Thread.sleep(30000L);
                        String getAppVersionUrl = ipAndPort + (isWcs ? "/wcs/Yto_Server/getAppVersion" : "/Yto_Server/getAppVersion");
                        for (int i = 0; i < 6; ++i) {
                            Thread.sleep(8000L);
                            ResponseEntity versionResponseEntity = null;
                            try {
                                versionResponseEntity = CommonUtil.sendPostRequestNoCatch((RestTemplate)this.restTemplate, (String)getAppVersionUrl, null, String.class);
                            }
                            catch (Exception e) {
                                logger.info("\u68c0\u6d4b\u76ee\u6807\u662f\u5426\u91cd\u542f\u6210\u529f\u65f6\uff0c\u8bf7\u6c42getAppVersion\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                            }
                            if (versionResponseEntity != null && HttpStatus.OK.value() == versionResponseEntity.getStatusCodeValue()) {
                                ClientHttpResponse versionResponse = (ClientHttpResponse)CommonUtil.convertJsonToBean((String)((String)versionResponseEntity.getBody()), (TypeToken)new /* Unavailable Anonymous Inner Class!! */);
                                String compareVersion = appInfoEntity.getAppMaxVersion();
                                if (!hasNewAppFolder) {
                                    compareVersion = appInfoEntity.getAppVersion();
                                }
                                String targetVersion = (String)versionResponse.getData();
                                String gatewayPath = "";
                                try {
                                    JSONObject dataJson = JSON.parseObject((String)targetVersion);
                                    targetVersion = dataJson.getString("version");
                                    gatewayPath = dataJson.getString("gatewayPath");
                                }
                                catch (Exception e) {
                                    targetVersion = (String)versionResponse.getData();
                                }
                                logger.info("\u91cd\u542f\u540e\u7684app\u7248\u672c:{}", (Object)targetVersion);
                                if (compareVersion.equals(targetVersion)) {
                                    appInfoEntity.setAppVersion(targetVersion);
                                    appInfoEntity.setGatewayPath(gatewayPath);
                                    response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
                                    response.setRespMessage("\u5e94\u7528\u91cd\u542f\u6210\u529f");
                                    response.setData((Object)appInfoEntity);
                                    appInfoEntity.setLastModifyTime(null);
                                    this.appInfoService.feedbackUpdateResult(appInfoEntity);
                                } else {
                                    logger.error("\u5e94\u7528\u91cd\u542f\u65f6\uff0c\u7248\u672c\u53f7\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u91cd\u542f\u5931\u8d25\u3002compareVersion:{},targetVersion:{}", (Object)compareVersion, (Object)targetVersion);
                                    response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                                    response.setRespMessage("\u5e94\u7528\u91cd\u542f\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u91cd\u542f\u3002");
                                }
                                break;
                            }
                            logger.error("\u7b2c{}\u6b21\u68c0\u67e5\u91cd\u542f,\u5bf9\u54cd\u5e94\u4e3a\u7a7a(\u8868\u793a\u76ee\u6807\u5e94\u7528\u8fd8\u672a\u91cd\u542f\u5b8c\u6210)", (Object)(i + 1));
                            response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                            response.setRespMessage("\u5e94\u7528\u91cd\u542f\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u91cd\u542f\u3002");
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5e94\u7528\u91cd\u542f\u65f6\uff0c\u91cd\u542f\u5931\u8d25\u3002");
                        response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                        response.setRespMessage("\u5e94\u7528\u91cd\u542f\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u91cd\u542f\u3002");
                    }
                }
            }
            if (!ResponseTypeEnum.SUCCESS.getRespCode().equals(response.getRespcode())) {
                this.restartFail(appInfoEntity);
            }
        }
        logger.info("\u54cd\u5e94\u91cd\u542f\u5e94\u7528\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    private void restartFail(AppInfoEntity appInfoEntity) {
        AlertCommonReq requestBody = this.alertUploadService.buildRequestBody();
        requestBody.setWarningType(Integer.valueOf(AlertEnum.START_FAILED.getKey()));
        requestBody.setWarningContent(appInfoEntity.getAppName() + "[" + appInfoEntity.getAppIPAddress() + ":" + appInfoEntity.getAppPort() + "] \u91cd\u542f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
        this.alertUploadService.upload(requestBody);
    }

    @PostMapping(value={"checkUpClientApp"}, produces={"application/json"})
    @ApiOperation(value="\u6761\u7801\u5a01\u89c6\u68c0\u67e5\u66f4\u65b0\u63a5\u53e3", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse checkUpClientApp(@RequestBody AppUpdateEntity baseInfo) {
        String baseInfoJson = GoogleJsonUtil.toJson((Object)baseInfo);
        logger.info("\u6536\u5230\u6761\u7801\u5a01\u89c6\u68c0\u67e5\u66f4\u65b0\u63a5\u53e3\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + baseInfoJson);
        baseInfo.setOrgCode(SysPropertiesConfig.getOrgCode());
        ClientHttpResponse response = new ClientHttpResponse();
        logger.info("\u8bf7\u6c42\u8fdc\u7a0b\u68c0\u67e5\u66f4\u65b0\u63a5\u53e3\uff1a{}", (Object)GoogleJsonUtil.toJson((Object)baseInfo));
        AppVersionEntity versionEntity = UpgradeUtils.remoteAppVersion((String)baseInfo.getAppVersion(), (String)"\u6761\u7801\u5a01\u89c6", (String)baseInfo.getMac());
        String maxVersion = null;
        if (null == versionEntity) {
            response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
            response.setRespMessage(ResponseTypeEnum.APP_UPDATE_ERROR.getRespMessage());
        } else {
            maxVersion = versionEntity.getVersion();
        }
        if (!StringUtils.isEmpty((CharSequence)baseInfo.getMac())) {
            this.saveAppVersionInfo(baseInfo, versionEntity);
        }
        if (StringUtils.isNotBlank((CharSequence)maxVersion) && !maxVersion.equals(baseInfo.getAppVersion())) {
            response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u6709\u65b0\u7684\u7248\u672c\u53ef\u5347\u7ea7");
            response.setData((Object)versionEntity);
        } else {
            response.setRespcode(ResponseTypeEnum.NO_UPDATE_APP.getRespCode());
            response.setRespMessage(ResponseTypeEnum.NO_UPDATE_APP.getRespMessage());
        }
        logger.info("\u54cd\u5e94\u6761\u7801\u5a01\u89c6\u68c0\u67e5\u66f4\u65b0\u63a5\u53e3\u8bf7\u6c42\uff0c\u7ed3\u679c\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @PostMapping(value={"v1/checkUpClientApp"}, produces={"application/json"})
    @ApiOperation(value="\u6761\u7801\u5a01\u89c6\u68c0\u67e5\u66f4\u65b0\u63a5\u53e3v1", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse checkUpClientAppV1(@RequestBody AppUpdateEntity baseInfo) {
        String baseInfoJson = GoogleJsonUtil.toJson((Object)baseInfo);
        logger.info("\u6536\u5230\u6761\u7801\u5a01\u89c6\u68c0\u67e5\u66f4\u65b0\u63a5\u53e3\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + baseInfoJson);
        baseInfo.setOrgCode(SysPropertiesConfig.getOrgCode());
        ClientHttpResponse response = new ClientHttpResponse();
        logger.info("\u8bf7\u6c42\u8fdc\u7a0b\u68c0\u67e5\u66f4\u65b0\u63a5\u53e3\uff1a{}", (Object)GoogleJsonUtil.toJson((Object)baseInfo));
        AppVersionEntity versionEntity = UpgradeUtils.remoteAppVersion((String)baseInfo.getAppVersion(), (String)"\u6761\u7801\u5a01\u89c6", (String)baseInfo.getMac());
        if (!StringUtils.isEmpty((CharSequence)baseInfo.getMac())) {
            this.saveAppVersionInfo(baseInfo, versionEntity);
        }
        if (null == versionEntity) {
            response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
            response.setRespMessage("\u83b7\u53d6\u6700\u65b0\u7248\u672c\u4fe1\u606f\u5931\u8d25");
        } else {
            response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            response.setData((Object)versionEntity);
        }
        logger.info("\u54cd\u5e94\u6761\u7801\u5a01\u89c6\u68c0\u67e5\u66f4\u65b0\u63a5\u53e3\u8bf7\u6c42\uff0c\u7ed3\u679c\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    private void saveAppVersionInfo(AppUpdateEntity baseInfo, AppVersionEntity versionEntity) {
        ExpMonitorCodeVison codeVisonOld = this.appInfoService.getMonitorCodeVison(baseInfo.getMac());
        ExpMonitorCodeVison codeVisonInfo = new ExpMonitorCodeVison();
        codeVisonInfo.setAppName("\u6761\u7801\u5a01\u89c6");
        codeVisonInfo.setMac(baseInfo.getMac());
        if (versionEntity != null) {
            codeVisonInfo.setAppMaxVersion(versionEntity.getVersion());
            codeVisonInfo.setAppMaxVueVersion(versionEntity.getVueVersion());
        } else {
            codeVisonInfo.setAppMaxVersion(baseInfo.getAppVersion());
            codeVisonInfo.setAppMaxVueVersion(baseInfo.getVueVersion());
        }
        Date date = new Date();
        codeVisonInfo.setAppVersion(baseInfo.getAppVersion());
        codeVisonInfo.setAppVueVersion(baseInfo.getVueVersion());
        codeVisonInfo.setLateLoginTime(date);
        codeVisonInfo.setAppStatus(1);
        if (codeVisonOld != null) {
            if (!baseInfo.getAppVersion().equals(codeVisonOld.getAppVersion())) {
                codeVisonInfo.setSendStatus(Integer.valueOf(0));
                codeVisonInfo.setUpgradeTime(date);
                codeVisonInfo.setUpdateTime(date);
            } else if (codeVisonOld.getUpgradeTime() == null) {
                codeVisonInfo.setUpgradeTime(date);
            }
        } else {
            codeVisonInfo.setSendStatus(Integer.valueOf(0));
            codeVisonInfo.setUpgradeTime(date);
            codeVisonInfo.setUpdateTime(date);
        }
        try {
            this.appInfoService.saveCodeVisonInfo(codeVisonInfo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6761\u7801\u5a01\u89c6\u4fe1\u606f\u51fa\u73b0\u9519\u8bef\u3002", (Throwable)e);
        }
    }

    @GetMapping(value={"updateClientApp"})
    @ApiOperation(value="\u6761\u7801\u5a01\u89c6\u66f4\u65b0\u63a5\u53e3(\u65b0)", httpMethod="GET")
    public ResponseEntity<Object> updateClientApp(@RequestParam(value="appName") String appName, @RequestParam(value="appVersion") String appVersion, @RequestParam(value="mac") String mac) {
        logger.info("\u6536\u5230\u6761\u7801\u5a01\u89c6\u66f4\u65b0\u63a5\u53e3\u8bf7\u6c42\uff0c\u5e94\u7528\u540d\u79f0\uff1a{}\uff0c\u4e0b\u8f7d\u7248\u672c\u53f7\uff1a{},mac:{}", new Object[]{appName, appVersion, mac});
        HttpHeaders headers = new HttpHeaders();
        try {
            File resFile = null;
            String appMd5 = null;
            String appSha1 = null;
            String errorMsg = null;
            for (int i = 0; i < 5; ++i) {
                logger.info("\u5f00\u59cb\u7b2c{}\u6b21\u83b7\u53d6\u6587\u4ef6", (Object)(i + 1));
                Map resMap = this.appInfoService.getClientAppFile(appVersion, appName, mac);
                if (CollectionUtils.isEmpty((Map)resMap) || (resFile = (File)resMap.get("file")) == null) continue;
                logger.info("\u83b7\u53d6\u5230\u6587\u4ef6\uff0c\u5927\u5c0f\uff1a{}\uff0c\u8def\u5f84{}", (Object)String.format("%.3f", (double)resFile.length() / 1024.0 / 1024.0), (Object)resFile.getPath());
                appSha1 = UpgradeUtils.getFileSha1((File)resFile);
                appMd5 = UpgradeUtils.getFileMd5((File)resFile);
                logger.info("\u76d1\u63a7\u7f51\u5173\u8ba1\u7b97MD5:{},sha1:{}", (Object)appMd5, (Object)appSha1);
                String webSha1 = (String)resMap.get("fileSha1");
                String webMd5 = (String)resMap.get("fileMd5");
                logger.info("\u7ba1\u7406\u5e73\u53f0\u8ba1\u7b97MD5:{},sha1:{}", (Object)webMd5, (Object)webSha1);
                if (webSha1 != null && !webSha1.equals(appSha1)) {
                    errorMsg = "\u76d1\u63a7\u7f51\u5173\u4e0e\u7ba1\u7406\u5e73\u53f0\u7684sha1\u6821\u9a8c\u4e0d\u901a\u8fc7";
                    logger.info("sha1\u6821\u9a8c\u4e0d\u901a\u8fc7,\u7ba1\u7406\u5e73\u53f0\u7684sha1\uff1a{}", (Object)webSha1);
                    resFile.delete();
                    continue;
                }
                if (webMd5 != null && !webMd5.equals(appMd5)) {
                    errorMsg = "\u76d1\u63a7\u7f51\u5173\u4e0e\u7ba1\u7406\u5e73\u53f0\u7684md5\u6821\u9a8c\u4e0d\u901a\u8fc7";
                    logger.info("md5\u6821\u9a8c\u4e0d\u901a\u8fc7,\u7ba1\u7406\u5e73\u53f0\u7684md5\uff1a{}", (Object)webMd5);
                    resFile.delete();
                    continue;
                }
                errorMsg = null;
                break;
            }
            if (resFile != null && resFile.exists()) {
                headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
                headers.setContentDispositionFormData("attachment", new String(resFile.getName().getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
                headers.add("md5", appMd5);
                headers.add("sha1", appSha1);
                headers.setContentLength(resFile.length());
                if (this.saveCodeVisionInfo(mac, appVersion, appName)) {
                    try {
                        ExpMonitorCodeVison codeVison = this.appInfoService.getMonitorCodeVison(mac);
                        if (codeVison != null) {
                            this.appInfoService.codeVersionSendServer(Collections.singletonList(codeVison));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u4e0a\u62a5\u5ba2\u6237\u7aef\u7248\u672c\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    }
                }
                logger.info("\u6700\u7ec8\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef\u6587\u4ef6,\u5927\u5c0f:{},\u8def\u5f84:{}", (Object)String.format("%.3f", (double)resFile.length() / 1024.0 / 1024.0), (Object)resFile.getPath());
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new InputStreamResource((InputStream)new FileInputStream(resFile)));
            }
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            logger.info("\u672a\u4e0b\u8f7d\u5230\u6b63\u786e\u6587\u4ef6,\u672c\u5730\u4e0d\u4f1a\u4fdd\u5b58\u9519\u8bef\u7684\u6587\u4ef6");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)this.downFailBody(ResponseTypeEnum.APP_FILE_INVALID.getRespCode(), errorMsg != null ? errorMsg : "\u76d1\u63a7\u7f51\u5173\u83b7\u53d6\u5b89\u88c5\u5305\u5931\u8d25"));
        }
        catch (Exception e) {
            logger.error("\u6761\u7801\u5a01\u89c6\u66f4\u65b0\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)this.downFailBody(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode(), "\u76d1\u63a7\u7f51\u5173\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u76d1\u63a7\u7f51\u5173\u65e5\u5fd7"));
        }
    }

    private String downFailBody(String code, String message) {
        ClientHttpResponse response = new ClientHttpResponse();
        response.setRespcode(code);
        response.setRespMessage(message);
        return JSONObject.toJSONString((Object)response);
    }

    private boolean saveCodeVisionInfo(String mac, String appVersion, String appName) {
        if (StringUtils.isBlank((CharSequence)mac)) {
            return false;
        }
        Date date = new Date();
        ExpMonitorCodeVison codeVisonInfo = new ExpMonitorCodeVison();
        codeVisonInfo.setAppName("\u6761\u7801\u5a01\u89c6");
        codeVisonInfo.setMac(mac);
        if ("\u6761\u7801\u5a01\u89c6".equals(appName)) {
            codeVisonInfo.setAppVersion(appVersion);
            codeVisonInfo.setAppMaxVersion(appVersion);
        } else if ("\u6761\u7801\u5a01\u89c6Vue".equals(appName)) {
            codeVisonInfo.setAppVueVersion(appVersion);
            codeVisonInfo.setAppMaxVueVersion(appVersion);
        }
        codeVisonInfo.setAppStatus(0);
        codeVisonInfo.setUpgradeTime(date);
        codeVisonInfo.setSendStatus(Integer.valueOf(0));
        codeVisonInfo.setUpdateTime(date);
        try {
            this.appInfoService.saveCodeVisonInfo(codeVisonInfo);
            return true;
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6761\u7801\u5a01\u89c6\u4fe1\u606f\u51fa\u73b0\u9519\u8bef\u3002", (Throwable)e);
            return false;
        }
    }

    @PostMapping(value={"getCodeVisonInfo"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u4e2d\u5fc3\u6761\u7801\u5a01\u89c6\u7684\u4fe1\u606f(\u4e2d\u5fc3\u7ba1\u7406\u540e\u53f0)", httpMethod="POST", consumes="application/json;charset=UTF-8")
    public HttpBaseResponse getCodeVisonInfo(@RequestBody Page page, @RequestParam(required=true) String appStatus) {
        logger.info("\u6536\u5230\u76d1\u63a7\u7f51\u5173\u83b7\u53d6\u6761\u7801\u5a01\u89c6\u8be6\u7ec6\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)page));
        HttpBaseResponse response = HttpBaseResponse.success();
        Page pageResponse = new Page();
        try {
            pageResponse = this.appInfoService.getCodeVisonInfo(page, appStatus);
            response.setData((Object)pageResponse);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e2d\u5fc3\u6761\u7801\u5a01\u89c6\u7684\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getCause());
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u770b\u670d\u52a1\u7aef\u65e5\u5fd7");
        }
        return response;
    }

    @PostMapping(value={"isExistCodeVison"}, produces={"application/json"})
    @ApiOperation(value="\u672c\u5730\u5e93\u4e2d\u662f\u5426\u5b58\u5728\u6761\u7801\u5a01\u89c6(\u4e2d\u5fc3\u7ba1\u7406\u540e\u53f0)", httpMethod="POST", consumes="application/json;charset=UTF-8")
    public HttpBaseResponse isExistCodeVison(@RequestParam(required=true) String appName) {
        logger.info("\u6536\u5230\u76d1\u63a7\u7f51\u5173\u5224\u65ad\u6761\u7801\u5a01\u89c6\u662f\u5426\u5df2\u7ecf\u5b58\u5728\uff1a" + appName);
        HttpBaseResponse response = HttpBaseResponse.success();
        try {
            boolean b = this.appInfoService.isExistCodeVison(appName);
            response.setData((Object)b);
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u672c\u5730\u5e93\u4e2d\u662f\u5426\u5b58\u5728\u6761\u7801\u5a01\u89c6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getCause());
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u770b\u670d\u52a1\u7aef\u65e5\u5fd7");
        }
        return response;
    }

    @PostMapping(value={"/osdLoginUpload"})
    @ApiOperation(value="osd\u4fe1\u606f\u4fdd\u5b58")
    public ClientHttpResponse osdLoginUpload(@RequestBody ClientHttpRequest<ExpDeviceLoginHistory> baseInfo) {
        logger.info("\u63a5\u53d7\u5230\u7684\u6570\u636e\u4e3a:" + GoogleJsonUtil.toJson(baseInfo));
        ClientHttpResponse resp = new ClientHttpResponse();
        if (baseInfo != null) {
            ExpDeviceLoginHistory expDevLogin = (ExpDeviceLoginHistory)baseInfo.getBody();
            boolean checkParam = this.paramValidate(expDevLogin);
            if (!checkParam) {
                resp.setRespcode("100");
                resp.setRespMessage(ImageTokenRespEnum.NULL_REQUIRED_PARAM.getMessage());
                return resp;
            }
            expDevLogin.setDeviceType("16");
            int result = this.deviceLoginService.saveOsdMessage(expDevLogin);
            if (result >= 1) {
                resp.setRespcode("000");
                resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
            } else {
                resp.setRespcode("100");
                resp.setRespMessage("\u64cd\u4f5c\u901a\u7528\u5931\u8d25");
            }
        } else {
            resp.setRespcode("100");
            resp.setRespMessage(ImageTokenRespEnum.NULL_REQUIRED_PARAM.getMessage());
        }
        return resp;
    }

    @ApiOperation(value="\u5207\u6362\u5e94\u7528\u5728\u7ebf\u6a21\u5f0f")
    @PostMapping(value={"/onLineChange"})
    public ClientHttpResponse onLineChange(@RequestBody AppInfoEntity appInfoEntity) {
        logger.info("\u6536\u5230\u5207\u6362\u5e94\u7528\u5728\u7ebf\u72b6\u6001\u8bf7\u6c42,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)appInfoEntity));
        ClientHttpResponse resp = new ClientHttpResponse();
        if (!"\u4e1a\u52a1\u7f51\u5173".equals(appInfoEntity.getAppName()) || appInfoEntity.getAppStatus() != 1) {
            resp.setRespcode("100");
            resp.setRespMessage("\u5f53\u524d\u5e94\u7528\u975e\u4e1a\u52a1\u7f51\u5173\u6216\u5e94\u7528\u672a\u542f\u7528!");
            return resp;
        }
        OrgInfoEntity orgInfoByCode = this.orgInfoService.getOrgInfoByCode(SysPropertiesConfig.getOrgCode(), true);
        if (orgInfoByCode == null || orgInfoByCode.getType() == null || !OrgTypeEnum.TRANSFER_CENTER.getType().equals(orgInfoByCode.getType().toUpperCase())) {
            logger.info("orgType:{},transferCenter:{}", (Object)orgInfoByCode.getType(), (Object)appInfoEntity.getTransferCenter());
            resp.setRespcode("100");
            resp.setRespMessage("\u975e\u4e2d\u5fc3\u7ec4\u7ec7\uff0c\u4e0d\u53ef\u5207\u6362!");
            return resp;
        }
        String url = null;
        6 urlParam = new /* Unavailable Anonymous Inner Class!! */;
        JSONObject msgBody = new JSONObject();
        if (appInfoEntity.getOffLine().booleanValue()) {
            url = "http://" + appInfoEntity.getAppIPAddress() + ":" + appInfoEntity.getAppPort() + "/Yto_BusiGateway/client/utils/online";
        } else {
            url = "http://" + appInfoEntity.getAppIPAddress() + ":" + appInfoEntity.getAppPort() + "/Yto_BusiGateway/client/utils/offline";
            JSONObject inner = new JSONObject();
            inner.put("extend1", (Object)"pdanewtest.yto56.com.cn");
            inner.put("extend2", (Object)"9292");
            msgBody.put("body", (Object)inner);
        }
        String respStr = CommonUtil.sendRequest((RestTemplate)CommonUtil.getRestTemplate((int)200), (String)url, (Object)msgBody, (Map)urlParam);
        logger.info("\u5207\u6362\u5728/\u79bb\u7ebf\u6a21\u5f0f\u54cd\u5e94\u7ed3\u679c:{}", (Object)respStr);
        if (StringUtils.isBlank((CharSequence)respStr) || !respStr.contains("200")) {
            resp.setRespcode("100");
            resp.setRespMessage("\u5207\u6362\u5931\u8d25");
            return resp;
        }
        return resp;
    }

    @PostMapping(value={"/offLineAll"})
    @ApiOperation(value="\u4e00\u952e\u79bb\u7ebf(\u5168\u90e8\u4e1a\u52a1\u7f51\u5173\u79bb\u7ebf)")
    public ClientHttpResponse offLineAll() {
        logger.info("\u6536\u5230\u4e00\u952e\u79bb\u7ebf\u8bf7\u6c42");
        ClientHttpResponse resp = new ClientHttpResponse();
        try {
            AppInfoEntity appInfoEntity = new AppInfoEntity();
            appInfoEntity.setAppName("\u4e1a\u52a1\u7f51\u5173");
            List list = this.appInfoService.selectAll(appInfoEntity);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                7 urlParam = new /* Unavailable Anonymous Inner Class!! */;
                JSONObject msgBody = new JSONObject();
                JSONObject body = new JSONObject();
                body.put("extend1", (Object)"pdanewtest.yto56.com.cn");
                body.put("extend2", (Object)"9292");
                msgBody.put("body", (Object)body);
                list.forEach(arg_0 -> CenterAppManageController.lambda$offLineAll$0(msgBody, (Map)urlParam, arg_0));
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("\u4e00\u952e\u79bb\u7ebf\u53d1\u751f\u9519\u8bef", (Throwable)e);
            resp.setRespcode("100");
            resp.setRespMessage("\u4e00\u952e\u79bb\u7ebf\u5931\u8d25");
            return resp;
        }
    }

    @GetMapping(value={"/groupList"})
    public ClientHttpResponse<List<AppGroup>> selectAppGroupList() {
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            List list = this.appGroupService.list(null);
            response.setData((Object)(list == null ? Collections.emptyList() : list));
            return response;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5206\u7ec4\u5f02\u5e38", (Throwable)e);
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.GENERAL_FAIL.getRespMessage());
            return response;
        }
    }

    @PostMapping(value={"/addAppGroup"})
    public ClientHttpResponse addAppGroup(@RequestBody AppGroup appGroup) {
        ClientHttpResponse response = new ClientHttpResponse();
        if (StringUtils.isBlank((CharSequence)appGroup.getName())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u7ec4\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return response;
        }
        try {
            int count = this.appGroupService.count((Wrapper)new LambdaQueryWrapper().eq(AppGroup::getName, (Object)appGroup.getName()));
            if (count > 0) {
                response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u7ec4\u540d\u5df2\u5b58\u5728\uff1a" + appGroup.getName());
                return response;
            }
            this.appGroupService.save((Object)appGroup);
            response.setRespMessage("\u6dfb\u52a0\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5206\u7ec4\u5f02\u5e38", (Throwable)e);
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u6dfb\u52a0\u5f02\u5e38");
            return response;
        }
    }

    @PostMapping(value={"/delAppGroup"})
    public ClientHttpResponse delAppGroup(@RequestBody AppGroup appGroup) {
        ClientHttpResponse response = new ClientHttpResponse();
        if (appGroup.getId() == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u53c2\u6570\u9519\u8bef");
            return response;
        }
        try {
            int count = this.appInfoService.countByGroupName(appGroup.getName());
            if (count > 0) {
                response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u7ec4\u540d\u79f0\uff1a" + appGroup.getName() + " \u5df2\u88ab\u4f7f\u7528");
                return response;
            }
            this.appGroupService.remove((Wrapper)new LambdaQueryWrapper().eq(AppGroup::getId, (Object)appGroup.getId()));
            response.setRespMessage("\u5220\u9664\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5206\u7ec4\u5f02\u5e38", (Throwable)e);
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5220\u9664\u5f02\u5e38");
            return response;
        }
    }

    public Boolean paramValidate(ExpDeviceLoginHistory expDevLogin) {
        if (StringUtils.isBlank((CharSequence)expDevLogin.getDeviceMac())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)expDevLogin.getDeviceName())) {
            return false;
        }
        if (expDevLogin.getLoginTime() == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)expDevLogin.getLoginUserCode())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)expDevLogin.getLoginUserName())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)expDevLogin.getExtand1())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)expDevLogin.getExtand2())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)expDevLogin.getExtand3())) {
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$offLineAll$0(JSONObject msgBody, Map urlParam, AppInfoEntity e) {
        if (e.getAppStatus() == 1 && !e.getOffLine().booleanValue()) {
            String url = "http://" + e.getAppIPAddress() + ":" + e.getAppPort() + "/Yto_BusiGateway/client/utils/offline";
            try {
                CommonUtil.sendRequestNoCatch((RestTemplate)CommonUtil.getRestTemplate((int)200), (String)url, (Object)msgBody, (Map)urlParam, null);
            }
            catch (Exception ex) {
                logger.info("\u8bf7\u6c42\u3010{}\u3011\u5f02\u5e38:{}", (Object)url, (Object)ex.getMessage());
            }
        }
    }
}

