/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.entity.cleandata.CleanDataReq;
import com.yto.monitor.adapter.entity.cleandata.CleanDataResp;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.service.BaseDataOperateService;
import com.yto.monitor.adapter.service.impl.ExpWayBillCheckMapperService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"Yto_MonitorGateway/table"})
@RestController
@Api(value="\u6570\u636e\u6e05\u7406")
public class CleanDataController {
    private static final Logger log = LoggerFactory.getLogger(CleanDataController.class);
    @Autowired
    private ExpWayBillCheckMapperService expWayBillCheckService;
    @Autowired
    private BaseDataOperateService baseDataOperateService;
    public static final String MINTOR_GATEWAY_TYPE = "2";
    public static final String MINTOR_SERVICE_TYPE_OPT = "1";
    public static final String MINTOR_SERVICE_TYPE_BAG_RULE_V1 = "6";

    @HeadTokenVerification
    @PostMapping(value={"/check/clean"})
    public ClientHttpResponse checkVersion(@RequestBody CleanDataReq req) {
        log.info("\u6536\u5230\u6570\u636e\u6e05\u7406\u8bf7\u6c42" + GoogleJsonUtil.toJson((Object)req));
        ClientHttpResponse resp = new ClientHttpResponse();
        if (!MINTOR_GATEWAY_TYPE.equals(req.getGateWayType())) {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage("\u4f20\u5165\u7684\u5220\u9664\u7f51\u5173\u7c7b\u578b\u975e\u6cd5");
            log.info("\u6570\u636e\u6e05\u7406\u54cd\u5e94" + GoogleJsonUtil.toJson((Object)resp));
            return resp;
        }
        if (req.getCount() <= 0) {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage("\u4f20\u5165\u7684\u5220\u9664\u6761\u6570\u975e\u6cd5");
            log.info("\u6570\u636e\u6e05\u7406\u54cd\u5e94" + GoogleJsonUtil.toJson((Object)resp));
            return resp;
        }
        if (MINTOR_SERVICE_TYPE_OPT.equals(req.getServiceType())) {
            CleanDataResp data = this.expWayBillCheckService.handleCleanCheckData(req);
            if (Objects.nonNull(data) && ExpUtils.isNotBlank((String)data.getErrorMsg())) {
                resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                resp.setRespMessage(data.getErrorMsg());
            } else {
                resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
                resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            }
            resp.setData((Object)data);
        } else if (MINTOR_SERVICE_TYPE_BAG_RULE_V1.equals(req.getServiceType())) {
            BaseResp baseResp = this.baseDataOperateService.cleanBagRuleV1();
            if (!"000".equals(baseResp.getCode())) {
                resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                resp.setRespMessage(baseResp.getMsg());
                return resp;
            }
            resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            resp.setData(baseResp.getData());
        }
        log.info("\u6570\u636e\u6e05\u7406\u54cd\u5e94" + GoogleJsonUtil.toJson((Object)resp));
        return resp;
    }
}

