/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.entity.request.ExpClientQueryInfo;
import com.yto.monitor.adapter.service.SysSwitchService;
import com.yto.monitor.adapter.service.TableService;
import com.yto.monitor.adapter.utils.SpringBeanUtil;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.ExpClientQueryRespInfo;
import com.yto.monitor.common.entity.ExpClientTableQueryInfo;
import com.yto.monitor.common.http.ClientHttpRequest;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u7aef\u6570\u636e\u67e5\u8be2\u63a5\u53e3"})
@RequestMapping(value={"/Yto_MonitorGateway/client/query"})
public class ClientQueryController {
    private static final Logger logger = LoggerFactory.getLogger(ClientQueryController.class);
    @Autowired
    TableService tableService;
    @Autowired
    SysSwitchService sysSwitchService;
    public static final String T_EXP_BAG_RULE_V1 = "T_EXP_BAG_RULE_V1";

    @PostMapping(value={"/table"}, produces={"application/json"})
    @ApiOperation(value="\u901a\u7528\u8868\u67e5\u8be2", httpMethod="POST", produces="application/json")
    public ClientHttpResponse table(@RequestBody ClientHttpRequest<ExpClientTableQueryInfo> baseInfo) {
        ClientHttpResponse resp = new ClientHttpResponse();
        ExpClientTableQueryInfo body = (ExpClientTableQueryInfo)baseInfo.getBody();
        if (StringUtils.isBlank((String)body.getTableName())) {
            resp.setRespcode("100");
            resp.setRespMessage("tableName\u4e0d\u80fd\u4e3a\u7a7a");
            return resp;
        }
        boolean mysql = true;
        if (!StringUtils.isBlank((String)body.getDbType()) && body.getDbType().equals("2")) {
            mysql = false;
        }
        String columns = "*";
        if (!StringUtils.isBlank((String)body.getColumns())) {
            columns = body.getColumns();
        }
        String tableName = body.getTableName();
        String conditon = "";
        if (!StringUtils.isBlank((String)body.getCondition())) {
            conditon = body.getCondition();
        }
        Integer pageSize = null;
        Integer pageNo = null;
        if (!StringUtils.isBlank((String)body.getCurrent())) {
            pageNo = Integer.parseInt(body.getCurrent());
        }
        if (!StringUtils.isBlank((String)body.getSize())) {
            pageSize = Integer.parseInt(body.getSize());
        }
        PageInfo result = this.tableService.queryByPage(mysql, columns, tableName, conditon, pageNo, pageSize);
        ExpClientQueryRespInfo respInfo = new ExpClientQueryRespInfo();
        respInfo.setBusiData((Serializable)result);
        resp.setData((Object)respInfo);
        resp.setRespcode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        return resp;
    }

    @PostMapping(value={"/querySwitch"}, produces={"application/json"})
    @ApiOperation(value="\u672c\u5730\u5f00\u5173\u6216tcp\u7aef\u53e3\u67e5\u8be2", httpMethod="POST", produces="application/json")
    public ClientHttpResponse querySwitch(@RequestBody ClientHttpRequest<ExpClientQueryInfo> baseInfo) {
        ExpClientQueryInfo respInfo = null;
        ClientHttpResponse resp = new ClientHttpResponse();
        logger.info("\u8bf7\u6c42\u53c2\u6570" + GoogleJsonUtil.toJson(baseInfo));
        respInfo = this.sysSwitchService.getFieldValueByName(((ExpClientQueryInfo)baseInfo.getBody()).getQueryType(), (Object)SpringBeanUtil.getAdapterServerConfig());
        resp.setData((Object)respInfo);
        resp.setRespcode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        return resp;
    }

    @PostMapping(value={"/countBagRulesV1"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u67e5\u8be2\u5efa\u5305\u89c4\u5219\u65b0\u8868\u6570\u636e", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse countBagRulesV1(@RequestBody ClientHttpRequest<ExpClientQueryInfo> baseInfo) {
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            HashMap<String, Long> map = new HashMap<String, Long>();
            int countV1 = this.tableService.sqlTableCount(T_EXP_BAG_RULE_V1);
            map.put("count", Long.valueOf(countV1));
            response.setData(map);
            logger.info("\u67e5\u8be2\u5efa\u5305\u89c4\u5219\u65b0\u8868\u6570\u636e\uff01");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5efa\u5305\u89c4\u5219\u65b0\u8868\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u5efa\u5305\u89c4\u5219\u65b0\u8868\u6570\u636e\u51fa\u9519!");
        }
        return response;
    }
}

