/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.controller.ClientWebSocketServer;
import com.yto.monitor.adapter.controller.DwsAdapterController;
import com.yto.monitor.adapter.entity.newDevice.TExpOperationTable;
import com.yto.monitor.adapter.service.DeviceStatusService;
import com.yto.monitor.adapter.service.newDevice.IExpOperationTableService;
import com.yto.monitor.adapter.utils.SpringBeanUtil;
import com.yto.monitor.common.util.DateUtil;
import com.yto.monitor.common.util.GoogleJsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ServerEndpoint(value="/Yto_MonitorGateway/client/ws/{mac}/{gatewayType}")
public class ClientWebSocketServer {
    private static final Logger logger = LoggerFactory.getLogger(DwsAdapterController.class);
    private static final String monitorGateway = "3";
    private IExpOperationTableService opTableService = null;
    private static Map<String, List<ClientWebSocketServer>> clients = new ConcurrentHashMap();
    private static Map<String, OperateTableInfo> operateTableInfos = new ConcurrentHashMap();
    private static Map<String, String> session2MacMap = new ConcurrentHashMap();
    private Session session;
    private String gatewayType;
    private DeviceStatusService deviceStatusService = null;
    public static volatile ConcurrentHashMap<String, String> msgMap = new ConcurrentHashMap();

    public static Map<String, OperateTableInfo> getOperateTableInfos() {
        return operateTableInfos;
    }

    DeviceStatusService getBeanDeviceStatusService() {
        if (null == this.deviceStatusService) {
            this.deviceStatusService = (DeviceStatusService)SpringBeanUtil.getBean(DeviceStatusService.class);
        }
        return this.deviceStatusService;
    }

    IExpOperationTableService getOperateTableService() {
        if (null == this.opTableService) {
            this.opTableService = (IExpOperationTableService)SpringBeanUtil.getBean(IExpOperationTableService.class);
        }
        return this.opTableService;
    }

    @OnOpen
    public void onOpen(@PathParam(value="mac") String mac, @PathParam(value="gatewayType") String gatewayType, Session session) {
        this.session = session;
        this.gatewayType = gatewayType;
        this.populateClients(mac, gatewayType, session);
        session2MacMap.put(session.getId(), mac);
        logger.info("\u6709\u5ba2\u6237\u7aef\u63a5\u5165\uff0c\u5ba2\u6237\u7aefMac\u5730\u5740:" + mac + " \u5f53\u524d\u5728\u7ebf\u8fde\u63a5\u6570:" + session2MacMap.size());
    }

    private void populateClients(String mac, String gatewayType, Session session) {
        clients.compute(mac, (key, value) -> {
            if (value != null) {
                value.add(this);
            } else {
                value = new ArrayList<ClientWebSocketServer>();
                value.add(this);
            }
            return value;
        });
        SessionInfo sessionInfo = SessionInfo.builder().sessionId(session.getId()).createTime(DateUtil.formatYMDHMS((Date)new Date())).open(session.isOpen()).message("create").gatewayType(gatewayType).build();
        operateTableInfos.compute(mac, (key, value) -> {
            if (value != null) {
                List sessionInfos = value.getSessionInfos();
                if (sessionInfos.size() >= 5) {
                    sessionInfos.remove(0);
                }
                sessionInfos.add(sessionInfo);
            } else {
                ArrayList<SessionInfo> list = new ArrayList<SessionInfo>();
                list.add(sessionInfo);
                value = OperateTableInfo.builder().mac(mac).devName(Optional.ofNullable(this.opTableService).map(e -> e.getTableInCache(mac)).map(TExpOperationTable::getOperationName).orElse("")).sessionInfos(list).build();
            }
            return value;
        });
    }

    @OnError
    public void onError(Session session, Throwable error) {
        String mac = (String)session2MacMap.get(session.getId());
        logger.error("WebSocket\u670d\u52a1\u7aef\u53d1\u751f\u4e86\u9519\u8bef\uff01\u5ba2\u6237\u7aefmac:" + mac + ",error Message:" + error.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void onClose(Session session) {
        String mac = (String)session2MacMap.get(session.getId());
        try {
            if (Objects.nonNull(mac)) {
                String string = mac;
                synchronized (string) {
                    List clientWebSocketServers = (List)clients.get(mac);
                    if (!CollectionUtils.isEmpty((Collection)clientWebSocketServers)) {
                        Iterator iterator = clientWebSocketServers.iterator();
                        while (iterator.hasNext()) {
                            ClientWebSocketServer cs = (ClientWebSocketServer)iterator.next();
                            if (cs == null || !session.getId().equals(cs.session.getId())) continue;
                            iterator.remove();
                            break;
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)clientWebSocketServers)) {
                        clients.remove(mac);
                    }
                }
            }
            session2MacMap.remove(session.getId());
            OperateTableInfo tableInfo = (OperateTableInfo)operateTableInfos.get(mac);
            List sessionInfos = tableInfo.getSessionInfos();
            for (SessionInfo sessionInfo : sessionInfos) {
                if (!session.getId().equals(sessionInfo.getSessionId())) continue;
                sessionInfo.setCloseTime(DateUtil.formatYMDHMS((Date)new Date()));
                sessionInfo.setOpen(session.isOpen());
                sessionInfo.setMessage("close");
                break;
            }
            logger.info("\u6709\u5ba2\u6237\u7aef:{}\u6389\u7ebf,\u5f53\u524d\u5728\u7ebf\u8fde\u63a5\u6570:{},sessionId:{},\u5f53\u524dmac\u7684\u6240\u6709\u8fde\u63a5\u4fe1\u606f:{}", new Object[]{mac, session2MacMap.size(), session.getId(), GoogleJsonUtil.toJson(operateTableInfos.get(mac))});
        }
        catch (Exception e) {
            logger.error("WebSocket\u670d\u52a1\u7aef\u5728\u65ad\u5f00\u5ba2\u6237\u7aef:{},sessionId:{},\u5904\u7406\u65f6\u53d1\u73b0\u5f02\u5e38:{}", new Object[]{mac, session.getId(), e.getMessage()});
        }
    }

    @OnMessage
    public void onMessage(Session session, String msg) {
        logger.info("WebSocket Received Message\uff1a" + msg + "  Client SessionId\uff1a" + session.getId());
        JSONObject requestMsg = JSON.parseObject((String)msg);
        String mac = requestMsg.getString("mac");
        Integer type = requestMsg.getInteger("type");
        JSONObject responseMsg = new JSONObject();
        JSONObject data = new JSONObject();
        responseMsg.put("mac", (Object)mac);
        responseMsg.put("type", (Object)type);
        responseMsg.put("sessionId", (Object)session.getId());
        responseMsg.put("gatewayType", (Object)"3");
        if (!clients.containsKey(mac)) {
            this.populateClients(mac, this.gatewayType, session);
            logger.info("\u5ba2\u6237\u7aef\u6536\u5230\u4e86\u6d88\u606f,\u4f46\u6ca1\u6709\u627e\u5230\u8fde\u63a5,\u5c06\u8fde\u63a5\u518d\u6b21\u653e\u5165\u7f13\u5b58,\u5ba2\u6237\u7aefmac:" + mac);
        }
        if (type != null) {
            switch (type) {
                case 2: {
                    break;
                }
                case 3: {
                    msgMap.put(requestMsg.getString("uuid"), msg);
                    return;
                }
            }
        }
        responseMsg.put("data", (Object)data);
        session.getAsyncRemote().sendObject((Object)JSONObject.toJSONString((Object)responseMsg));
    }

    public static void sendMessageToClient(String mac, String respData) {
        if (StringUtils.isBlank((CharSequence)mac)) {
            logger.error("WebSocket\uff1aMac is not be null");
            return;
        }
        if (respData == null) {
            logger.error("WebSocket\uff1aRespData is not be null");
            return;
        }
        List clientWebSocketServers = (List)clients.get(mac);
        if (CollectionUtils.isEmpty((Collection)clientWebSocketServers)) {
            logger.info("WebSocket:Server-->Client Pushed Failed ,Mac:{},Reason:{}", (Object)mac, (Object)"\u5ba2\u6237\u7aef\u4e0d\u5728\u7ebf");
            return;
        }
        for (ClientWebSocketServer ws : clientWebSocketServers) {
            if (ws.session == null || !ws.session.isOpen()) continue;
            logger.info("WebSocket:Server-->Client Pushed Successful ,Mac:{},SessionID:{},Data:{}", new Object[]{mac, ws.session.getId(), respData});
            ws.session.getAsyncRemote().sendObject((Object)respData);
        }
    }

    public static void removeMsgMap(String uuid) {
        msgMap.remove(uuid);
        if (msgMap.size() >= 1000) {
            msgMap = new ConcurrentHashMap();
        }
    }
}

