/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.controller.ClientWebSocketServer;
import com.yto.monitor.adapter.entity.CodeVisionConfig;
import com.yto.monitor.adapter.service.CodeVisionConfigService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6761\u7801\u5a01\u89c6\u5ba2\u6237\u7aef\u914d\u7f6e\u63a5\u53e3"})
@RequestMapping(value={"/Yto_MonitorGateway/CodeVisionConfig"})
public class CodeVisionConfigController {
    private static final Logger logger = LoggerFactory.getLogger(CodeVisionConfigController.class);
    @Autowired
    private CodeVisionConfigService codeVisionConfigService;

    @PostMapping(value={"/testConnection"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6d4b\u8bd5\u8fde\u63a5", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse testConnection() {
        ClientHttpResponse resp = new ClientHttpResponse();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        resp.setData((Object)now.format(dateTimeFormatter));
        resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return resp;
    }

    @PostMapping(value={"/deleteCodeVisionConfig"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u914d\u7f6e\u5220\u9664", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse deleteCodeVisionConfig(@RequestBody CodeVisionConfig codeVisionConfig) {
        ClientHttpResponse resp = new ClientHttpResponse();
        try {
            int row = this.codeVisionConfigService.deleteConfig(codeVisionConfig);
            if (row < 1) {
                resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                resp.setRespMessage(ResponseTypeEnum.GENERAL_FAIL.getRespMessage());
            }
        }
        catch (Exception e) {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.GENERAL_FAIL.getRespMessage());
        }
        return resp;
    }

    @PostMapping(value={"/queryCodeVisionConfig"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u914d\u7f6e\u5217\u8868\u67e5\u8be2", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse queryCodeVisionConfig(@RequestBody(required=false) CodeVisionConfig codeVisionConfig) {
        ClientHttpResponse resp = new ClientHttpResponse();
        try {
            List list = this.codeVisionConfigService.queryCodeVisionConfig(codeVisionConfig);
            resp.setData((Object)((Serializable)((Object)list)));
        }
        catch (Exception e) {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.GENERAL_FAIL.getRespMessage());
        }
        return resp;
    }

    @PostMapping(value={"/saveCodeVisionConfig"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u914d\u7f6e\u4fdd\u5b58", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse saveCodeVisionConfigSync(@RequestBody CodeVisionConfig codeVisionConfig) throws Exception {
        ClientHttpResponse resp = new ClientHttpResponse();
        try {
            codeVisionConfig.setUpdateTime(new Date());
            this.codeVisionConfigService.saveCodeVisionConfig(codeVisionConfig);
            ClientWebSocketServer.sendMessageToClient((String)codeVisionConfig.getMac(), (String)JSON.toJSONString((Object)codeVisionConfig));
        }
        catch (Exception e) {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.GENERAL_FAIL.getRespMessage());
            return resp;
        }
        return resp;
    }

    @PostMapping(value={"/pushConfigDataToCodeVision"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u63a8\u9001\u914d\u7f6e\u5230\u6761\u7801\u5a01\u89c6", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse pushConfigDataToCodeVision(@RequestBody JSONObject jsonObject) {
        ClientHttpResponse resp;
        block4: {
            resp = new ClientHttpResponse();
            try {
                String uuid = UUID.randomUUID().toString();
                jsonObject.put("uuid", (Object)uuid);
                String mac = String.valueOf(jsonObject.get((Object)"mac"));
                ClientWebSocketServer.sendMessageToClient((String)mac, (String)jsonObject.toJSONString());
                CodeVisionConfig config = new CodeVisionConfig();
                config.setMac(mac);
                config.setSyncTime(new Date());
                this.codeVisionConfigService.update(config);
                int timeConsuming = 0;
                do {
                    String msg;
                    if ((msg = (String)ClientWebSocketServer.msgMap.get(uuid)) != null) {
                        resp.setData((Object)msg);
                        ClientWebSocketServer.removeMsgMap((String)uuid);
                        break block4;
                    }
                    Thread.sleep(20L);
                } while ((timeConsuming += 20) < 2000);
                resp.setData((Object)"");
            }
            catch (Exception e) {
                resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                resp.setRespMessage(ResponseTypeEnum.GENERAL_FAIL.getRespMessage());
                return resp;
            }
        }
        return resp;
    }
}

