/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.SendStatus;
import com.yto.monitor.adapter.entity.DeliveryWarehouse;
import com.yto.monitor.adapter.entity.request.ImportDeliveryWarehouseReq;
import com.yto.monitor.adapter.service.DeliveryWarehouseService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deliveryWarehouse"})
public class DeliveryWarehouseController {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryWarehouseController.class);
    @Autowired
    private DeliveryWarehouseService deliveryWarehouseService;

    @HeadTokenVerification
    @PostMapping(value={"/select"})
    public HttpBaseResponse<PageInfo<DeliveryWarehouse>> select(@RequestBody DeliveryWarehouse body) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            PageInfo pageInfo = this.deliveryWarehouseService.select(body, true);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setData((Object)pageInfo);
            return response;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e93\u623f\u914d\u7f6e\u5f02\u5e38 {}", (Object)JSONObject.toJSONString((Object)body), (Object)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/export"})
    public HttpBaseResponse<List<DeliveryWarehouse>> export(@RequestBody DeliveryWarehouse body) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            PageInfo pageInfo = this.deliveryWarehouseService.select(body, false);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setData((Object)pageInfo.getList());
            return response;
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38 {}", (Object)JSONObject.toJSONString((Object)body), (Object)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/batchDelete"})
    public HttpBaseResponse batchDelete(@RequestBody List<DeliveryWarehouse> body) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (CollectionUtils.isEmpty(body)) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u5220\u9664\u6570\u636e\u4e3a\u7a7a");
            return response;
        }
        this.deliveryWarehouseService.logicallyBatchDeleted(body);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage("\u5220\u9664\u6210\u529f");
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/add"})
    public HttpBaseResponse add(@RequestBody DeliveryWarehouse body) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (body == null || StringUtils.isBlank((String)body.getThreeCode()) || body.getStoreRoomNo() == null || body.getStoreRoomNo() == 0) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u6709\u5fc5\u586b\u6570\u636e\u4e3a\u7a7a");
            return response;
        }
        if (body.getThreeCode().length() > 3) {
            response.setRespCode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
            response.setRespMessage("\u4e00\u6bb5\u7801\uff1a" + body.getThreeCode() + "\u957f\u5ea6\u8d85\u8fc73\u4f4d\uff01");
            return response;
        }
        boolean allowDuplicateThreeCode = this.deliveryWarehouseService.allowDuplicateThreeCode();
        int count = this.deliveryWarehouseService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeliveryWarehouse::getDeleted, (Object)false)).eq(DeliveryWarehouse::getThreeCode, (Object)body.getThreeCode())).eq(allowDuplicateThreeCode, DeliveryWarehouse::getStoreRoomNo, (Object)body.getStoreRoomNo())).last("LIMIT 1"));
        if (count > 0) {
            response.setRespCode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
            String msg = allowDuplicateThreeCode ? "\u4e00\u6bb5\u7801+\u5e93\u623f\u53f7\uff1a\u3010" + body.getThreeCode() + "+" + body.getStoreRoomNo() + "\u3011\u5df2\u88ab\u914d\u7f6e\uff01" : "\u4e00\u6bb5\u7801" + body.getThreeCode() + "\u5df2\u88ab\u914d\u7f6e\uff01";
            response.setRespMessage(msg);
            return response;
        }
        try {
            body.setCreateTime(new Date());
            body.setSendStatus(Integer.valueOf(SendStatus.UNSENT.getStatus()));
            body.setOrgCode(SysPropertiesConfig.getOrgCode());
            body.setOrgName(SysPropertiesConfig.getOrgName());
            this.deliveryWarehouseService.save((Object)body);
            this.deliveryWarehouseService.diffUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u6dfb\u52a0\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u6dfb\u52a0\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/import"})
    public HttpBaseResponse<List<String>> importDeliveryWarehouse(@RequestBody List<ImportDeliveryWarehouseReq> body) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (CollectionUtils.isEmpty(body)) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u6570\u636e\u4e3a\u7a7a");
            return response;
        }
        List checkedMsgs = this.deliveryWarehouseService.checkImportDeliveryWarehouseData(body);
        if (!CollectionUtils.isEmpty((Collection)checkedMsgs)) {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setData((Object)checkedMsgs);
            return response;
        }
        try {
            this.deliveryWarehouseService.saveImportData(body);
            this.deliveryWarehouseService.fullUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u4ea4\u4ef6\u53e3\u4fdd\u5b58\u6570\u636e\u5f02\u5e38 {}", (Object)JSONObject.toJSONString(body), (Object)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u6570\u636e\u5931\u8d25");
            return response;
        }
    }
}

