/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.Property;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.constant.LatticeOptTypeEnum;
import com.yto.monitor.adapter.entity.deviceBind.ExpDeviceBind;
import com.yto.monitor.adapter.entity.deviceBind.ExpLatticeLineBind;
import com.yto.monitor.adapter.entity.newDevice.TExpAutoDevice;
import com.yto.monitor.adapter.entity.newDevice.TExpLattice;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.service.deviceBind.DeviceBindService;
import com.yto.monitor.adapter.service.deviceBind.ExpLatticeLineBindService;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.adapter.service.newDevice.IExpLatticeService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.util.ExpUtils;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Yto_MonitorServer"})
public class DeviceBindController {
    private static final Logger logger = LoggerFactory.getLogger(DeviceBindController.class);
    @Autowired
    private DeviceBindService deviceBindService;
    @Autowired
    private IExpAutoDeviceService autoDevice;
    @Autowired
    private IExpLatticeService latticeService;
    @Autowired
    private ExpLatticeLineBindService latticeLineBindService;

    @HeadTokenVerification
    @PostMapping(value={"/deviceBind/search"})
    public HttpBaseResponse search() {
        HttpBaseResponse httpResponse = new HttpBaseResponse();
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().isNotNull(ExpDeviceBind::getDeviceId);
        List list = this.deviceBindService.list((Wrapper)eq);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(e -> {
                TExpAutoDevice tExpAutoDevice = this.autoDevice.selectByDeviceIdInCache(e.getDeviceId());
                if (Objects.isNull(tExpAutoDevice)) {
                    logger.info("\u76d1\u63a7\u7f51\u5173\u672c\u5730\u65e0\u6b64\u8bbe\u5907\u4fe1\u606f,\u8bbe\u5907deviceId:{}", (Object)e.getDeviceId());
                } else {
                    e.setDevName(tExpAutoDevice.getDeviceName());
                    e.setKey(String.valueOf(e.getId()));
                }
            });
        }
        httpResponse.setData((Object)list);
        return httpResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/deviceBind/add"})
    public HttpBaseResponse add(@RequestBody ExpDeviceBind request) {
        HttpBaseResponse httpResponse = new HttpBaseResponse();
        if (ExpUtils.isBlank((String)request.getDeviceId())) {
            httpResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u8bbe\u5907deviceId\u4e0d\u80fd\u4e3a\u7a7a");
            return httpResponse;
        }
        if (ExpUtils.isBlank((String)request.getTotalPackageIp())) {
            httpResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u603b\u5305\u7f51\u5173ip\u3001port\u4e0d\u80fd\u4e3a\u7a7a");
            return httpResponse;
        }
        try {
            TExpAutoDevice tExpAutoDevice;
            LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StringUtils.isNotBlank((CharSequence)request.getDeviceId()), ExpDeviceBind::getDeviceId, (Object)request.getDeviceId());
            List list = this.deviceBindService.list((Wrapper)eq);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                httpResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                httpResponse.setRespMessage("\u8bbe\u5907deviceId:" + request.getDeviceId() + " \u5df2\u7ecf\u88ab\u7ed1\u5b9a\u8fc7");
                return httpResponse;
            }
            this.deviceBindService.save((Object)request);
            if (Objects.nonNull(request.getId())) {
                request.setKey(String.valueOf(request.getId()));
            }
            if (Objects.nonNull(tExpAutoDevice = this.autoDevice.selectByDeviceIdInCache(request.getDeviceId()))) {
                request.setDevName(tExpAutoDevice.getDeviceName());
            }
            httpResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            httpResponse.setRespMessage("\u6dfb\u52a0\u6210\u529f");
            httpResponse.setData((Object)request);
            return httpResponse;
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u8bbe\u5907\u7ed1\u5b9a\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            httpResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u6dfb\u52a0\u5931\u8d25");
            return httpResponse;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/deviceBind/edit"})
    public HttpBaseResponse edit(@RequestBody ExpDeviceBind request) {
        HttpBaseResponse httpResponse = new HttpBaseResponse();
        if (Objects.isNull(request.getId())) {
            httpResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u8bbe\u5907Id\u4e0d\u80fd\u4e3a\u7a7a");
            return httpResponse;
        }
        if (ExpUtils.isBlank((String)request.getDeviceId())) {
            httpResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u8bbe\u5907deviceId\u4e0d\u80fd\u4e3a\u7a7a");
            return httpResponse;
        }
        try {
            LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExpDeviceBind::getId, (Object)request.getId());
            List list = this.deviceBindService.list((Wrapper)eq);
            if (CollectionUtils.isEmpty((Collection)list)) {
                httpResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                httpResponse.setRespMessage("\u5f53\u524d\u8bb0\u5f55\u4e0d\u5b58\u5728,\u5237\u65b0\u540e\u91cd\u65b0\u7f16\u8f91");
                return httpResponse;
            }
            LambdaQueryWrapper deviceBindLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExpDeviceBind::getDeviceId, (Object)request.getDeviceId())).ne(ExpDeviceBind::getId, (Object)request.getId());
            List deviceBinds = this.deviceBindService.list((Wrapper)deviceBindLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)deviceBinds)) {
                httpResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                httpResponse.setRespMessage("\u8bbe\u5907deviceId:" + request.getDeviceId() + " \u5df2\u7ecf\u88ab\u7ed1\u5b9a\u8fc7");
                return httpResponse;
            }
            LambdaUpdateWrapper condition = (LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(ExpDeviceBind::getId, (Object)request.getId());
            this.deviceBindService.update((Object)request, (Wrapper)condition);
            httpResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            httpResponse.setRespMessage("\u4fee\u6539\u6210\u529f");
            return httpResponse;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u8bbe\u5907\u7ed1\u5b9a\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            httpResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            httpResponse.setRespMessage("\u4fee\u6539\u5931\u8d25");
            return httpResponse;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/deviceBind/del"})
    public HttpBaseResponse delete(@RequestBody ExpDeviceBind request) {
        logger.info("\u6536\u5230\u5220\u9664\u5931\u8d25\u7ed1\u5b9a\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        HttpBaseResponse response = new HttpBaseResponse();
        if (request.getId() == null) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("id\u4e3a\u7a7a");
            return response;
        }
        try {
            this.deviceBindService.remove((Wrapper)new LambdaQueryWrapper().eq(ExpDeviceBind::getId, (Object)request.getId()));
            this.latticeLineBindService.remove((Wrapper)new LambdaQueryWrapper().eq(ExpLatticeLineBind::getDeviceId, (Object)request.getDeviceId()));
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5220\u9664\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u8bbe\u5907\u7ed1\u5b9a\u5f02\u5e38\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5220\u9664\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/deviceBind/getDeviceName"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907\u540d\u79f0", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse getDeviceName(@RequestParam(required=false) String deviceType) {
        HttpBaseResponse httpResponse = new HttpBaseResponse();
        List deviceNameList = this.autoDevice.selectDeviceNameAndId(deviceType);
        httpResponse.setData((Object)deviceNameList);
        httpResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        return httpResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/latticeLineBind/autoGrouping"}, produces={"application/json"})
    @ApiOperation(value="\u81ea\u52a8\u5206\u7ec4", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse autoGrouping() {
        logger.info("\u6536\u5230\u81ea\u52a8\u5206\u7ec4\u4e0b\u5c42\u7ebf\u7ed1\u5b9a\u8bf7\u6c42");
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            BaseResp baseResp = this.latticeLineBindService.autoGrouping();
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5206\u7ec4\u5b8c\u6210");
            return response;
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u5206\u7ec4\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u81ea\u52a8\u5206\u7ec4\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/latticeLineBind/latticeLineBindGroupList"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u5c42\u7ebf\u7ed1\u5b9a(\u5206\u7ec4)", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse latticeLineBindGroupList() {
        HttpBaseResponse response = new HttpBaseResponse();
        List list = this.latticeLineBindService.list(null);
        ArrayList<ExpLatticeLineBind> res = new ArrayList<ExpLatticeLineBind>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Map<String, List<ExpLatticeLineBind>> mapByLineName = list.stream().collect(Collectors.groupingBy(ExpLatticeLineBind::getLineName));
            for (Map.Entry<String, List<ExpLatticeLineBind>> entry : mapByLineName.entrySet()) {
                ExpLatticeLineBind lineBind = new ExpLatticeLineBind();
                lineBind.setLineName(entry.getKey());
                lineBind.setOriginalLineName(entry.getKey());
                StringJoiner stringJoiner = new StringJoiner("");
                entry.getValue().forEach(e -> {
                    e.setKey(String.valueOf(e.getId()));
                    stringJoiner.add(e.getKey());
                    TExpAutoDevice tExpAutoDevice = this.autoDevice.selectByDeviceIdInCache(e.getDeviceId());
                    if (tExpAutoDevice != null) {
                        e.setDevName(tExpAutoDevice.getDeviceName());
                    }
                });
                lineBind.setKey(stringJoiner.toString());
                lineBind.setItemList(entry.getValue());
                res.add(lineBind);
            }
        }
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        response.setData(res);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/latticeLineBind/latticeLineBindList"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u5c42\u7ebf\u7ed1\u5b9a", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse latticeLineBindList() {
        HttpBaseResponse response = new HttpBaseResponse();
        List list = this.latticeLineBindService.list(null);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(e -> {
                TExpAutoDevice tExpAutoDevice = this.autoDevice.selectByDeviceIdInCache(e.getDeviceId());
                if (tExpAutoDevice != null) {
                    e.setDevName(tExpAutoDevice.getDeviceName());
                }
            });
        }
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setData((Object)list);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/latticeLineBind/lineNameUpdate"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u4e0b\u5c42\u7ebf\u540d\u79f0", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse lineNameUpdate(@RequestBody ExpLatticeLineBind request) {
        logger.info("\u6536\u5230\u4fee\u6539\u4e0b\u5c42\u7ebf\u540d\u79f0\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        HttpBaseResponse response = new HttpBaseResponse();
        if (StringUtils.isBlank((CharSequence)request.getLineName())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u8bf7\u8f93\u5165\u4e0b\u5c42\u7ebf\u540d\u79f0");
            return response;
        }
        if (request.getLineName().equals(request.getOriginalLineName())) {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fee\u6539\u6210\u529f");
            return response;
        }
        try {
            int count = this.latticeLineBindService.count((Wrapper)new LambdaQueryWrapper().eq(ExpLatticeLineBind::getLineName, (Object)request.getLineName()));
            if (count > 0) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u4e0b\u5c42\u7ebf\u540d\u79f0\u5df2\u5b58\u5728");
                return response;
            }
            ExpLatticeLineBind latticeLineBind = new ExpLatticeLineBind();
            latticeLineBind.setLineName(request.getLineName());
            this.latticeLineBindService.update((Object)latticeLineBind, (Wrapper)new LambdaQueryWrapper().eq(ExpLatticeLineBind::getLineName, (Object)request.getOriginalLineName()));
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fee\u6539\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u4e0b\u5c42\u7ebf\u540d\u79f0\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fee\u6539\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/latticeLineBind/delete"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u4e0b\u5c42\u7ebf", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse deleteLatticeLineBind(@RequestBody ExpLatticeLineBind request) {
        logger.info("\u6536\u5230\u5220\u9664\u4e0b\u5c42\u7ebf\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            this.latticeLineBindService.remove((Wrapper)new LambdaQueryWrapper().eq(ExpLatticeLineBind::getLineName, (Object)request.getOriginalLineName()));
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5220\u9664\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4e0b\u5c42\u7ebf\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5220\u9664\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/latticeLineBind/deleteDetail"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u4e0b\u5c42\u7ebf\u660e\u7ec6", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse deleteDetail(@RequestBody ExpLatticeLineBind request) {
        logger.info("\u6536\u5230\u5220\u9664\u4e0b\u5c42\u7ebf\u660e\u7ec6\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            this.latticeLineBindService.removeById((Serializable)request.getId());
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5220\u9664\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4e0b\u5c42\u7ebf\u660e\u7ec6\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5220\u9664\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/latticeLineBind/updateDetail"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u4e0b\u5c42\u7ebf\u660e\u7ec6", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse updateDetail(@RequestBody ExpLatticeLineBind request) {
        logger.info("\u6536\u5230\u4fee\u6539\u4e0b\u5c42\u7ebf\u660e\u7ec6\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            BaseResp baseResp = this.latticeLineBindService.checkLineDetail(request, false);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            this.latticeLineBindService.updateById((Object)request);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fee\u6539\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u4e0b\u5c42\u7ebf\u660e\u7ec6\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fee\u6539\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/latticeLineBind/addDetail"}, produces={"application/json"})
    @ApiOperation(value="\u65b0\u589e\u4e0b\u5c42\u7ebf\u660e\u7ec6", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse addDetail(@RequestBody ExpLatticeLineBind request) {
        logger.info("\u6536\u5230\u65b0\u589e\u4e0b\u5c42\u7ebf\u660e\u7ec6\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            BaseResp baseResp = this.latticeLineBindService.checkLineDetail(request, true);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            this.latticeLineBindService.save((Object)request);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u6dfb\u52a0\u6210\u529f");
            response.setData((Object)request);
            return response;
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4e0b\u5c42\u7ebf\u660e\u7ec6\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u6dfb\u52a0\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/latticeLineBind/changeableLatticeNoList"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u53ef\u4fee\u6539\u7684\u683c\u53e3\u5217\u8868", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse changeableLatticeNoList(@RequestParam String destOrgCode) {
        HttpBaseResponse response = new HttpBaseResponse();
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        List deviceBindList = this.deviceBindService.list(null);
        if (CollectionUtils.isEmpty((Collection)deviceBindList)) {
            return response;
        }
        ArrayList maps = new ArrayList();
        for (ExpDeviceBind deviceBind : deviceBindList) {
            List list = this.latticeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new Property[]{TExpLattice::getLatticeNo, TExpLattice::getDeviceName}).eq(TExpLattice::getDeviceId, (Object)deviceBind.getDeviceId())).eq(TExpLattice::getLatticeScheme, (Object)deviceBind.getLatticeSchemeNo())).eq(TExpLattice::getOptFlag, (Object)LatticeOptTypeEnum.UPLOAD.getType())).eq(TExpLattice::getDestOrgCode, (Object)destOrgCode));
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            Object[] latNoArr = list.stream().map(TExpLattice::getLatticeNo).flatMap(e -> Arrays.stream(e.split(","))).distinct().sorted().toArray();
            String latNos = StringUtils.join((Object[])latNoArr, (String)",");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("deviceName", ((TExpLattice)list.get(0)).getDeviceName());
            map.put("latticeNo", latNos);
            map.put("schemeNo", deviceBind.getLatticeSchemeNo());
            map.put("deviceId", deviceBind.getDeviceId());
            maps.add(map);
        }
        response.setData(maps);
        return response;
    }
}

