/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.service.DeviceLoginService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.Page;
import com.yto.monitor.common.entity.request.DeviceLoginRequest;
import com.yto.monitor.common.entity.request.OsdLoginRequest;
import com.yto.monitor.common.entity.routesmerge.RequestPage;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"Yto_MonitorGateway/backend"})
@RestController
@Api(value="app\u767b\u5f55\uff0c\u5347\u7ea7")
public class DeviceLoginController {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private DeviceLoginService deviceLoginService;

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ClientHttpResponse queryPage(@RequestBody RequestPage<DeviceLoginRequest> request) {
        ClientHttpResponse resp = new ClientHttpResponse();
        PageInfo pageInfo = this.deviceLoginService.queryDeviceLogin(request);
        Page page = new Page();
        page.setTotal(pageInfo.getTotal());
        page.setPageNo(pageInfo.getPageNum());
        page.setPageData(pageInfo.getList());
        resp.setRespcode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        resp.setData((Object)page);
        return resp;
    }

    @PostMapping(value={"/queryOsdPage"})
    @ApiOperation(value="osd\u660e\u7ec6\u5206\u9875\u67e5\u8be2")
    public ClientHttpResponse queryOsdPage(@RequestBody RequestPage<OsdLoginRequest> request) {
        ClientHttpResponse resp = new ClientHttpResponse();
        PageInfo pageInfo = this.deviceLoginService.queryOsdLogin(request);
        Page page = new Page();
        page.setTotal(pageInfo.getTotal());
        page.setPageNo(pageInfo.getPageNum());
        page.setPageData(pageInfo.getList());
        resp.setRespcode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        resp.setData((Object)page);
        return resp;
    }

    @PostMapping(value={"/exportOsdMap"}, produces={"application/json"})
    @ApiOperation(value="\u5bfc\u51fa\u6240\u6709OSD\u6570\u636e", httpMethod="POST", consumes="application/json")
    public List getAllOsdMap() {
        List itemList = this.deviceLoginService.exportAllData();
        return itemList;
    }

    @PostMapping(value={"delOsdInfo"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664OSD\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse delOsdInfo(@RequestParam(value="id") String id) {
        logger.info("\u6536\u5230\u5220\u9664OSD\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + id);
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            this.deviceLoginService.delOsdInfo(id);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664OSD\u4fe1\u606f\u5f02\u5e38\u3002", e.getCause());
            response.setRespcode(ResponseTypeEnum.APP_DEL_ERROR.getRespCode());
            response.setRespMessage(ResponseTypeEnum.APP_DEL_ERROR.getRespMessage());
        }
        logger.info("\u54cd\u5e94\u5220\u9664OSD\u4fe1\u606f\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }
}

