/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonSyntaxException;
import com.yto.monitor.adapter.config.AdapterServerConfig;
import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.SendStatus;
import com.yto.monitor.adapter.entity.CalibrateScaleImage;
import com.yto.monitor.adapter.entity.request.ImageInfoUploadRequestEntity;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.service.CalibrateScaleImageService;
import com.yto.monitor.adapter.service.IExpImageUploadService;
import com.yto.monitor.adapter.service.ImageRecordService;
import com.yto.monitor.adapter.service.impl.ExpImageUploadInfoService;
import com.yto.monitor.adapter.utils.CommonUtil;
import com.yto.monitor.adapter.utils.LockSupportUtil;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.DeviceStatusClientRequest;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.util.DateUtil;
import com.yto.monitor.common.util.ExpUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u56fe\u7247\u4e0a\u62a5"})
@RequestMapping(value={"/dws"})
public class DwsAdapterController {
    private static final Logger logger = CustomLoggerFactory.ImageLogger();
    @Autowired
    private AdapterServerConfig config;
    @Autowired
    private IExpImageUploadService expImageUploadService;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private CalibrateScaleImageService calibrateScaleImageService;
    private static ConcurrentHashMap<String, Long> requestCache = new ConcurrentHashMap();
    @Autowired
    private ImageRecordService imageRecordService;

    @PostMapping(value={"/transferImageInfo"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u56fe\u7247\u4e0a\u62a5\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    @ResponseBody
    public HttpBaseResponse transferImageInfo(@RequestParam(value="file") MultipartFile file, @RequestParam(name="signature") String signature, @RequestParam(name="param") String param) {
        return this.imageService(file, signature, param, false);
    }

    @PostMapping(value={"/transferImageInfoCustomize"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u56fe\u7247\u4e0a\u62a5\u63a5\u53e3\u81ea\u5b9a\u4e49\u7f51\u70b9\u4ee3\u7801", httpMethod="POST", produces="application/json;charset=UTF-8")
    @ResponseBody
    public HttpBaseResponse transferImageInfoCustomize(@RequestParam(value="file") MultipartFile file, @RequestParam(name="signature") String signature, @RequestParam(name="param") String param) {
        return this.imageService(file, signature, param, true);
    }

    HttpBaseResponse imageService(MultipartFile file, String signature, String param, boolean customOrgCode) {
        logger.info("\u56fe\u7247\u4e0a\u4f20\u53c2\u6570:" + param + " signature:" + signature + " customOrgCode:" + customOrgCode);
        if (StringUtils.isBlank((CharSequence)param)) {
            HttpBaseResponse response = new HttpBaseResponse();
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u53c2\u6570\u4e3a\u7a7a");
            return response;
        }
        ImageInfoUploadRequestEntity uploadEntity = (ImageInfoUploadRequestEntity)JSONObject.parseObject((String)param, ImageInfoUploadRequestEntity.class);
        String encryptSignature = this.validateSignature((Object)param);
        if ("2".equals(uploadEntity.getImageType())) {
            return this.uploadCalibrateScaleImage(file, signature, encryptSignature, uploadEntity, param);
        }
        return this.uploadOptImage(file, signature, encryptSignature, uploadEntity, param, customOrgCode);
    }

    private HttpBaseResponse uploadCalibrateScaleImage(MultipartFile file, String signature, String encryptSignature, ImageInfoUploadRequestEntity uploadEntity, String originMsg) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            if (file == null || file.isEmpty()) {
                logger.error("\u4e0a\u4f20\u56fe\u7247\u4e3a\u7a7a");
                response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
                response.setRespMessage("\u6587\u4ef6\u4e3a\u7a7a\uff01");
                response.setData((Object)originMsg);
                return response;
            }
            if (!signature.equals(encryptSignature)) {
                logger.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u76d1\u63a7\u7f51\u5173\u8ba1\u7b97\uff1a{}", (Object)encryptSignature);
                response.setRespCode(ResponseTypeEnum.SIGNATURE_FAIL.getRespCode());
                response.setRespMessage(ResponseTypeEnum.SIGNATURE_FAIL.getRespMessage());
                response.setData((Object)originMsg);
                return response;
            }
            if (StringUtils.isBlank((CharSequence)uploadEntity.getExpressNumber()) || StringUtils.isBlank((CharSequence)uploadEntity.getRequestId())) {
                response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
                response.setRespMessage("\u7f3a\u5c11\u5355\u53f7\u6216\u56fe\u7247\u552f\u4e00\u6807\u8bc6");
                response.setData((Object)originMsg);
                return response;
            }
            Date date = new Date();
            CalibrateScaleImage param = new CalibrateScaleImage();
            param.setCreateTime(date);
            param.setLockTime(DateUtil.addMinute((Date)date, (int)-1));
            param.setSendStatus(Integer.valueOf(SendStatus.UNSENT.getStatus()));
            param.setRequestId(uploadEntity.getRequestId());
            param.setWaybillNo(uploadEntity.getExpressNumber());
            param.setMachine(ExpImageUploadInfoService.machineId);
            param.setReTry(Integer.valueOf(0));
            ResponseTypeEnum responseTypeEnum = this.calibrateScaleImageService.uploadCalibrateScaleImage(param, file);
            response.setRespCode(responseTypeEnum.getRespCode());
            response.setRespMessage(responseTypeEnum.getRespMessage());
            response.setData((Object)originMsg);
            return response;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6821\u79e4\u56fe\u7247\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.GENERAL_FAIL.getRespMessage());
            response.setData((Object)originMsg);
            return response;
        }
    }

    private HttpBaseResponse uploadOptImage(MultipartFile file, String signature, String encryptSignature, ImageInfoUploadRequestEntity uploadEntity, String originMsg, boolean customOrgCode) {
        HttpBaseResponse response = new HttpBaseResponse();
        ResponseTypeEnum responseTypeEnum = null;
        if (this.commonConfig.getReceiveImageSwitch() == 0) {
            logger.warn("\u63a5\u6536\u56fe\u7247\u5f00\u5173-\u672a\u6253\u5f00\uff0c\u56fe\u7247\u4e0d\u4fdd\u5b58");
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            response.setData((Object)originMsg);
            return response;
        }
        if (file == null || file.isEmpty()) {
            logger.warn("\u4e0a\u4f20\u56fe\u7247\u4e3a\u7a7a");
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u6587\u4ef6\u4e3a\u7a7a\uff01");
            response.setData((Object)originMsg);
            return response;
        }
        try {
            if (!signature.equals(encryptSignature)) {
                logger.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u76d1\u63a7\u7f51\u5173\u8ba1\u7b97\uff1a{}", (Object)encryptSignature);
                response.setRespCode(ResponseTypeEnum.SIGNATURE_FAIL.getRespCode());
                response.setRespMessage(ResponseTypeEnum.SIGNATURE_FAIL.getRespMessage());
                response.setData((Object)originMsg);
                return response;
            }
            if (!customOrgCode) {
                uploadEntity.setNameNumber(SysPropertiesConfig.getOrgCode());
            }
            uploadEntity.setEncrypted(StringUtils.isBlank((CharSequence)uploadEntity.getEncrypted()) ? "1" : uploadEntity.getEncrypted());
            uploadEntity.setUploadChannel(Integer.valueOf(uploadEntity.getUploadChannel() == null ? 3 : uploadEntity.getUploadChannel()));
            BaseResp baseResp = this.checkImageParamOk(uploadEntity);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(baseResp.getCode());
                response.setRespMessage(baseResp.getMsg());
                response.setData((Object)originMsg);
                return response;
            }
            if (this.alwaysSuccess(uploadEntity, file)) {
                response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
                response.setData((Object)originMsg);
                return response;
            }
            responseTypeEnum = this.expImageUploadService.uploadImage(file, uploadEntity);
            if (responseTypeEnum == ResponseTypeEnum.SUCCESS) {
                this.imageRecordService.putRecord(uploadEntity, file.getSize());
            }
        }
        catch (JsonSyntaxException e) {
            logger.error("\u56fe\u7247\u4e0a\u4f20\u65f6\u63a5\u6536\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u6b63\u786e", (Throwable)e);
            responseTypeEnum = ResponseTypeEnum.PARAM_FAIL;
        }
        catch (Exception e) {
            logger.error("\u56fe\u7247\u4e0a\u4f20\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            responseTypeEnum = ResponseTypeEnum.GENERAL_FAIL;
        }
        response.setRespCode(responseTypeEnum.getRespCode());
        response.setRespMessage(responseTypeEnum.getRespMessage());
        response.setData((Object)originMsg);
        return response;
    }

    private boolean alwaysSuccess(ImageInfoUploadRequestEntity uploadEntity, MultipartFile file) {
        if (StringUtils.isNotBlank((CharSequence)uploadEntity.getExpressNumber()) && uploadEntity.getExpressNumber().contains("noread")) {
            return true;
        }
        return file != null && file.getName().contains("noread");
    }

    private <T> String validateSignature(T jsonBody) {
        String requestJson = jsonBody instanceof String ? (String)jsonBody : CommonUtil.toJsonString(jsonBody);
        String charset = StringUtils.isBlank((CharSequence)this.config.getCharset()) ? "GBK" : this.config.getCharset();
        return CommonUtil.encryptJsonToSignature((String)requestJson, (String)charset);
    }

    private BaseResp checkImageParamOk(ImageInfoUploadRequestEntity entity) {
        if (ExpUtils.isBlank((String)entity.getSnNumber())) {
            entity.setSnNumber("unknown");
        }
        if (StringUtils.isBlank((CharSequence)entity.getExpressNumber()) || StringUtils.isBlank((CharSequence)entity.getOpCode()) || StringUtils.isBlank((CharSequence)entity.getSnNumber()) || StringUtils.isBlank((CharSequence)entity.getNameNumber())) {
            return BaseResp.fail((String)ResponseTypeEnum.MISS_DATA_FAIL.getRespCode(), (String)ResponseTypeEnum.MISS_DATA_FAIL.getRespMessage(), null);
        }
        boolean flag = this.matchesExpressNumber(entity.getExpressNumber());
        if (!flag) {
            logger.warn("\u5355\u53f7\u5305\u542b\u7279\u6b8a\u5b57\u7b26 \u4e0d\u5408\u6cd5:{}", (Object)entity.getExpressNumber());
            return BaseResp.fail((String)ResponseTypeEnum.MISS_DATA_FAIL.getRespCode(), (String)ResponseTypeEnum.MISS_DATA_FAIL.getRespMessage(), null);
        }
        try {
            Integer.parseInt(entity.getOpCode());
        }
        catch (NumberFormatException e) {
            logger.info("\u64cd\u4f5c\u7801\u975e\u6cd5 \u5355\u53f7\uff1a{} opCode\uff1a{}", (Object)entity.getExpressNumber(), (Object)entity.getOpCode());
            return BaseResp.fail((String)ResponseTypeEnum.DATA_REPEAT.getRespCode(), (String)"opCode\u975e\u6cd5", null);
        }
        String noStr = entity.getExpressNumber().toUpperCase();
        if (noStr.startsWith("R02Z") || noStr.startsWith("R02T")) {
            entity.setExpressNumber(entity.getExpressNumber().substring(4, entity.getExpressNumber().length()));
        }
        return BaseResp.success(null);
    }

    private boolean matchesExpressNumber(String expressNumber) {
        String regex = "^[a-z0-9A-Z]+$";
        if (expressNumber.contains(",")) {
            String[] split;
            for (String s : split = expressNumber.split(",")) {
                boolean flag = s.matches(regex);
                if (flag) continue;
                return false;
            }
            return true;
        }
        return expressNumber.matches(regex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHighFrequencyAccess(DeviceStatusClientRequest dwsRequestInfo) {
        try {
            long diff;
            LockSupportUtil.getLock().lockInterruptibly();
            long currentTime = System.currentTimeMillis();
            if (requestCache.containsKey(dwsRequestInfo.getCompMac()) && (diff = DateUtil.getTimeDiffOnSecond((long)((Long)requestCache.get(dwsRequestInfo.getCompMac())), (long)currentTime)) < 30L) {
                boolean bl = true;
                return bl;
            }
            requestCache.put(dwsRequestInfo.getCompMac(), currentTime);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            if (LockSupportUtil.getLock().isHeldByCurrentThread()) {
                LockSupportUtil.getLock().unlock();
            }
        }
        return false;
    }
}

