/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.entity.LatticeBackupManage;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.service.LatticeBackupManageService;
import com.yto.monitor.adapter.service.newDevice.IExpLatticeSchemeService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/latticeBackup"})
public class LatticeBackupManageController {
    private static final Logger logger = LoggerFactory.getLogger(LatticeBackupManageController.class);
    @Autowired
    private LatticeBackupManageService latticeBackupManageService;
    @Autowired
    private IExpLatticeSchemeService latticeSchemeService;

    @HeadTokenVerification
    @PostMapping(value={"/list"})
    public HttpBaseResponse<List<LatticeBackupManage>> list(@RequestBody LatticeBackupManage body) {
        HttpBaseResponse response = new HttpBaseResponse();
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setData((Object)this.latticeBackupManageService.list(body));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/renameVersionNo"})
    public HttpBaseResponse renameVersionNo(@RequestBody LatticeBackupManage body) {
        logger.info("\u6536\u5230\u91cd\u547d\u540d\u7248\u672c\u53f7\u8bf7\u6c42 {}", (Object)JSONObject.toJSONString((Object)body));
        HttpBaseResponse response = new HttpBaseResponse();
        if (StringUtils.isBlank((String)body.getVersionNo())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u65b0\u7248\u672c\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
            return response;
        }
        BaseResp baseResp = this.latticeBackupManageService.duplicateVersionNoCheck(body.getVersionNo(), false, body.getId());
        if (!"000".equals(baseResp.getCode())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(baseResp.getMsg());
            return response;
        }
        body.setUpdateTime(new Date());
        this.latticeBackupManageService.updateById((Object)body);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/delete"})
    public HttpBaseResponse deleteById(@RequestBody LatticeBackupManage body) {
        logger.info("\u6536\u5230\u5220\u9664\u7248\u672c\u8bf7\u6c42 {}", (Object)JSONObject.toJSONString((Object)body));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            this.latticeBackupManageService.deleteBackup(body);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5220\u9664\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u683c\u53e3\u5907\u4efd\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5220\u9664\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/validate"})
    public HttpBaseResponse validate(@RequestBody LatticeBackupManage body) {
        HttpBaseResponse response = new HttpBaseResponse();
        int count = this.latticeBackupManageService.countByDeviceNameAndSchemeNo(body.getDeviceName(), body.getSchemeNo());
        if (count >= 5) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5f53\u524d\u8bbe\u5907\u65b9\u6848\u4e0b\uff0c\u5df2\u5b58\u57285\u4e2a\u7248\u672c");
            return response;
        }
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/create"})
    public HttpBaseResponse create(@RequestBody LatticeBackupManage body) {
        logger.info("\u6536\u5230\u521b\u5efa\u7248\u672c\u8bf7\u6c42 {}", (Object)JSONObject.toJSONString((Object)body));
        HttpBaseResponse response = new HttpBaseResponse();
        if (StringUtils.isBlank((String)body.getDeviceName()) || StringUtils.isBlank((String)body.getSchemeNo())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u7f3a\u5c11\u8bbe\u5907\u540d\u79f0\u6216\u65b9\u6848\u53f7");
            return response;
        }
        try {
            BaseResp baseResp;
            if (StringUtils.isNotBlank((String)body.getVersionNo()) && !"000".equals((baseResp = this.latticeBackupManageService.duplicateVersionNoCheck(body.getVersionNo(), true, null)).getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            baseResp = this.latticeBackupManageService.create(body, false);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5907\u4efd\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u5907\u4efd\u683c\u53e3\u6570\u636e\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5907\u4efd\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/restore"})
    public HttpBaseResponse restore(@RequestBody LatticeBackupManage body) {
        logger.info("\u6536\u5230\u6062\u590d\u7248\u672c\u8bf7\u6c42 {}", (Object)JSONObject.toJSONString((Object)body));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            this.latticeBackupManageService.restore(body, false);
            this.latticeSchemeService.schemeFullUpload(new String[]{body.getSchemeId()});
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u6062\u590d\u5230\u8be5\u7248\u672c\u6210\u529f\uff1a" + body.getVersionNo());
            return response;
        }
        catch (Exception e) {
            logger.error("\u6062\u590d\u683c\u53e3\u6570\u636e\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u6062\u590d\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/revoke"})
    public HttpBaseResponse revoke(@RequestBody LatticeBackupManage body) {
        logger.info("\u6536\u5230\u9000\u56de\u4e0a\u4e00\u7248\u672c\u8bf7\u6c42 {}", (Object)JSONObject.toJSONString((Object)body));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            BaseResp baseResp = this.latticeBackupManageService.revoke(body);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            this.latticeSchemeService.schemeFullUpload(new String[]{body.getSchemeId()});
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u9000\u56de\u4e0a\u4e00\u7248\u672c\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u9000\u56de\u4e0a\u4e00\u7248\u672c\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u9000\u56de\u5931\u8d25");
            return response;
        }
    }
}

