/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.OrgTypeEnum;
import com.yto.monitor.adapter.constant.SendStatus;
import com.yto.monitor.adapter.entity.excel.LatDetailCfg1ImportBody;
import com.yto.monitor.adapter.entity.excel.LatDetailCfg2ImportBody;
import com.yto.monitor.adapter.entity.excel.LatDetailCfg3ImportBody;
import com.yto.monitor.adapter.entity.excel.WeightSortingImportBody;
import com.yto.monitor.adapter.entity.newDevice.TExpLatticeExtend;
import com.yto.monitor.adapter.entity.request.LatDetailCfg1Req;
import com.yto.monitor.adapter.entity.request.LatDetailCfg2Req;
import com.yto.monitor.adapter.entity.request.LatDetailCfg3Req;
import com.yto.monitor.adapter.entity.request.ShopReq;
import com.yto.monitor.adapter.entity.request.WeightSortingBatchAddReq;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.entity.response.ShopResp;
import com.yto.monitor.adapter.service.ExpLatticeExtendService;
import com.yto.monitor.adapter.service.LatticeDetail1Service;
import com.yto.monitor.adapter.service.LatticeDetail2Service;
import com.yto.monitor.adapter.service.LatticeDetail3Service;
import com.yto.monitor.adapter.service.WeightSortingCfgService;
import com.yto.monitor.adapter.service.newDevice.IExpLatticeSchemeService;
import com.yto.monitor.adapter.utils.LatticeUtil;
import com.yto.monitor.adapter.utils.WebRequestUtil;
import com.yto.monitor.adapter.utils.excel.CustomizeReadListener;
import com.yto.monitor.adapter.utils.excel.ExcelUtil;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.exception.ImportExcelException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/Yto_MonitorGateway/laticeExtend"})
public class LatticeExtendController {
    private static final Logger logger = LoggerFactory.getLogger(LatticeExtendController.class);
    @Autowired
    private ExpLatticeExtendService latticeExtendService;
    @Autowired
    private LatticeDetail1Service latticeDetail1Service;
    @Autowired
    private LatticeDetail3Service latticeDetail3Service;
    @Autowired
    private LatticeDetail2Service latticeDetail2Service;
    @Autowired
    private IExpLatticeSchemeService latticeSchemeService;
    @Autowired
    private WeightSortingCfgService weightSortingCfgService;

    @GetMapping(value={"/selectShopList"})
    public HttpBaseResponse<List<ShopResp>> selectShopList(@RequestParam(value="kCode") String customerCode, @RequestParam(value="sCode", required=false) String shopCode) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (StringUtils.isBlank((String)customerCode)) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("k\u7801\u4e3a\u7a7a");
            return response;
        }
        ShopReq request = new ShopReq();
        request.setFuzzyMatchingType(Integer.valueOf(1));
        request.setCustomerCode(customerCode);
        request.setFuzzyMatchingKey(shopCode);
        request.setIncludingSubordinate(Integer.valueOf(0));
        request.setBelongToOrgCode(SysPropertiesConfig.getOrgCode());
        List shopResps = this.latticeExtendService.queryShopListByKCode(request);
        response.setData((Object)shopResps);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/countLatDetailCfg"})
    public HttpBaseResponse<Map<String, Integer>> countLatDetailCfg() {
        HttpBaseResponse httpBaseResponse = new HttpBaseResponse();
        httpBaseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        httpBaseResponse.setData((Object)this.latticeExtendService.countLatDetailCfg());
        return httpBaseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/latDetailCfg2PageList"})
    public HttpBaseResponse<PageInfo<TExpLatticeExtend>> latDetailCfg2PageList(@RequestBody TExpLatticeExtend param) {
        HttpBaseResponse httpBaseResponse = new HttpBaseResponse();
        httpBaseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        httpBaseResponse.setData((Object)this.latticeDetail2Service.selectLatDetail2List(param, true));
        return httpBaseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/latDetailCfg3PageList"})
    public HttpBaseResponse<PageInfo<TExpLatticeExtend>> latDetailCfg3PageList(@RequestBody TExpLatticeExtend param) {
        HttpBaseResponse httpBaseResponse = new HttpBaseResponse();
        httpBaseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        httpBaseResponse.setData((Object)this.latticeDetail3Service.selectLatDetail3List(param, true));
        return httpBaseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/exportLatDetailCfg3"})
    public void exportLatDetailCfg3(HttpServletResponse response, @RequestBody TExpLatticeExtend param) {
        this.latticeDetail3Service.exportLatDetailCfg3(response, param);
    }

    @HeadTokenVerification
    @PostMapping(value={"/saveBatchLatDetailCfg3"})
    public HttpBaseResponse saveBatchLatDetailCfg3(@RequestBody LatDetailCfg3Req body) {
        logger.info("\u6536\u5230\u7ec6\u5206\u914d\u7f6e3\u4fdd\u5b58 {}", (Object)JSONObject.toJSONString((Object)body));
        HttpBaseResponse response = new HttpBaseResponse();
        if (StringUtils.isBlank((String)body.getDeviceName()) || StringUtils.isBlank((String)body.getSchemeNo()) || CollectionUtils.isEmpty((Collection)body.getInterceptTypeList())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5fc5\u586b\u5b57\u6bb5\u7f3a\u5c11\u503c");
            return response;
        }
        try {
            List latList = body.getLatList();
            if (CollectionUtils.isEmpty((Collection)latList)) {
                response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
                response.setRespMessage("\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u6761\u6570\u636e");
                return response;
            }
            BaseResp baseResp = this.latticeDetail3Service.latDetailCfg3DataCheck(body, false);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            this.latticeDetail3Service.saveLatDetail3CfgData(body);
            this.latticeSchemeService.schemeUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u7ec6\u5206\u914d\u7f6e3\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/updateLatDetailCfg3"})
    public HttpBaseResponse updateBatchLatDetailCfg3(@RequestBody TExpLatticeExtend body) {
        logger.info("\u6536\u5230\u7ec6\u5206\u914d\u7f6e3\u66f4\u65b0 {}", (Object)JSONObject.toJSONString((Object)body));
        HttpBaseResponse response = new HttpBaseResponse();
        if (body == null || StringUtils.isBlank((String)body.getId())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u65e0\u6570\u636e");
            return response;
        }
        try {
            BaseResp baseResp = this.latticeDetail3Service.updateLatDetailCfg3Check(body);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            body.setModifyTime(new Date());
            body.setModifyUserCode(body.getModifyUserCode());
            body.setModifyUserName(body.getModifyUserName());
            body.setExtendSendStatus(Integer.valueOf(SendStatus.UPDATE.getStatus()));
            body.setConfigOptFlag("UPD");
            this.latticeExtendService.update((Object)body, (Wrapper)new UpdateWrapper().lambda().eq(TExpLatticeExtend::getId, (Object)body.getId()));
            this.latticeSchemeService.schemeUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fee\u6539\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7ec6\u5206\u914d\u7f6e3\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fee\u6539\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/latDetailCfg1PageList"})
    public HttpBaseResponse<PageInfo<TExpLatticeExtend>> latDetailCfg1PageList(@RequestBody TExpLatticeExtend param) {
        HttpBaseResponse httpBaseResponse = new HttpBaseResponse();
        httpBaseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        httpBaseResponse.setData((Object)this.latticeDetail1Service.selectLatDetail1List(param, true));
        return httpBaseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/updateLatDetailCfg1"})
    public HttpBaseResponse updateLatDetailCfg1(@RequestBody TExpLatticeExtend body) {
        logger.info("\u6536\u5230\u7ec6\u5206\u914d\u7f6e1\u66f4\u65b0 {}", (Object)JSONObject.toJSONString((Object)body));
        HttpBaseResponse response = new HttpBaseResponse();
        if (body == null || StringUtils.isBlank((String)body.getId())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u65e0\u6570\u636e");
            return response;
        }
        try {
            BaseResp baseResp = this.latticeDetail1Service.updateLatDetailCfg1Check(body);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            List objects = CollectionUtils.isEmpty((Collection)body.getInterceptTypeList()) ? Collections.emptyList() : body.getInterceptTypeList().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            body.setInterceptType(StringUtils.join(objects, (String)","));
            body.setLatticeNo(LatticeUtil.transferLatticeNo((String)body.getLatticeNo()));
            body.setModifyTime(new Date());
            body.setModifyUserCode(WebRequestUtil.getUserCode());
            body.setModifyUserName(WebRequestUtil.getUserName());
            body.setConfigOptFlag("UPD");
            body.setExtendSendStatus(Integer.valueOf(SendStatus.UPDATE.getStatus()));
            this.latticeExtendService.update((Object)body, (Wrapper)new UpdateWrapper().lambda().eq(TExpLatticeExtend::getId, (Object)body.getId()));
            this.latticeSchemeService.schemeUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u66f4\u65b0\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u7ec6\u5206\u914d\u7f6e1\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fee\u6539\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/deleteBatchLatDetailCfg"})
    public HttpBaseResponse deleteBatchLatDetailCfg(@RequestBody List<TExpLatticeExtend> list) {
        logger.info("\u6536\u5230\u7ec6\u5206\u914d\u7f6e\u5220\u9664 {}", (Object)JSONObject.toJSONString(list));
        HttpBaseResponse response = new HttpBaseResponse();
        if (CollectionUtils.isEmpty(list)) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u65e0\u6570\u636e");
            return response;
        }
        try {
            this.latticeExtendService.deleteBatchById(list);
            this.latticeSchemeService.schemeUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5220\u9664\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u7ec6\u5206\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5220\u9664\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/saveLatDetailCfg1"})
    public HttpBaseResponse saveLatDetailCfg1(@RequestBody LatDetailCfg1Req param) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            BaseResp inputDataCheckRes = this.latticeDetail1Service.latDetailCfg1InputDataCheck(param);
            if (!"000".equals(inputDataCheckRes.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(inputDataCheckRes.getMsg());
                return response;
            }
            List extendList = (List)inputDataCheckRes.getData();
            BaseResp inputDataWithDBCheckRes = this.latticeDetail1Service.latDetailCfg1DuplicateDbDataCheck(extendList);
            if (!"000".equals(inputDataWithDBCheckRes.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(inputDataWithDBCheckRes.getMsg());
                return response;
            }
            this.latticeExtendService.saveBatch((Collection)extendList);
            this.latticeSchemeService.schemeUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u7ec6\u5206\u914d\u7f6e1\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/exportLatDetailCfg1"})
    public void exportLatDetailCfg1(HttpServletResponse response, @RequestBody TExpLatticeExtend param) {
        this.latticeDetail1Service.exportLatDetailCfg1(response, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HeadTokenVerification
    @PostMapping(value={"/importLatDetailCfg1"})
    public HttpBaseResponse importLatDetailCfg1(@RequestParam(value="jsonData") String jsonData, @RequestParam(value="file") MultipartFile file) {
        HttpBaseResponse httpBaseResponse;
        logger.info("\u6536\u5230\u5bfc\u5165\u7ec6\u5206\u914d\u7f6e1\u8bf7\u6c42:{}", (Object)jsonData);
        ExcelReader excelReader = null;
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            LatDetailCfg1Req paramObj = (LatDetailCfg1Req)JSONObject.parseObject((String)jsonData, LatDetailCfg1Req.class);
            excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            CustomizeReadListener readListener = new CustomizeReadListener(LatDetailCfg1ImportBody.class, headMap -> {
                String sortingType = paramObj.getSortingType();
                BaseResp baseResp = ExcelUtil.latDetail1HeadCheck((String)sortingType, (Map)headMap);
                if (!"000".equals(baseResp.getCode())) {
                    throw new ImportExcelException(baseResp.getMsg());
                }
            }, ExcelUtil.BODY_VALIDATOR_LATTICE_DETAIL1);
            ReadSheet sheet = ((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)readListener)).build();
            excelReader.read(new ReadSheet[]{sheet});
            List excelData = readListener.getExcelData();
            if (CollectionUtils.isEmpty((Collection)excelData)) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("Excel\u4e2d\u65e0\u6570\u636e\uff01");
                HttpBaseResponse httpBaseResponse2 = response;
                return httpBaseResponse2;
            }
            if (CollectionUtils.isEmpty((Collection)(excelData = this.latticeDetail1Service.importDataFilter(excelData, paramObj.getSortingType())))) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("Excel\u4e2d\u65e0\u5bf9\u5e94\u5206\u62e3\u7ef4\u5ea6\u7684\u6570\u636e");
                HttpBaseResponse httpBaseResponse3 = response;
                return httpBaseResponse3;
            }
            paramObj.setList(excelData);
            BaseResp baseResp = this.latticeDetail1Service.latDetailCfg1InputDataCheck(paramObj);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                HttpBaseResponse httpBaseResponse4 = response;
                return httpBaseResponse4;
            }
            this.latticeDetail1Service.saveImportData((List)baseResp.getData());
            this.latticeSchemeService.schemeFullUpload(paramObj.getDeviceName(), paramObj.getLatticeScheme());
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6210\u529f");
            HttpBaseResponse httpBaseResponse5 = response;
            return httpBaseResponse5;
        }
        catch (ImportExcelException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getErrorMessage());
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u7ec6\u5206\u914d\u7f6e1\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u5931\u8d25");
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        finally {
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HeadTokenVerification
    @PostMapping(value={"/importLatDetailCfg3"})
    public HttpBaseResponse importLatDetailCfg3(@RequestParam(value="jsonData") String jsonData, @RequestParam(value="file") MultipartFile file) {
        HttpBaseResponse httpBaseResponse;
        logger.info("\u6536\u5230\u5bfc\u5165\u7ec6\u5206\u914d\u7f6e3\u8bf7\u6c42:{}", (Object)jsonData);
        ExcelReader excelReader = null;
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            LatDetailCfg3Req paramObj = (LatDetailCfg3Req)JSONObject.parseObject((String)jsonData, LatDetailCfg3Req.class);
            excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            CustomizeReadListener readListener = new CustomizeReadListener(LatDetailCfg3ImportBody.class, ExcelUtil.HEAD_VALIDATOR_LATTICE_DETAIL3);
            ReadSheet sheet = ((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)readListener)).build();
            excelReader.read(new ReadSheet[]{sheet});
            List excelData = readListener.getExcelData();
            paramObj.setLatList(excelData);
            BaseResp baseResp = this.latticeDetail3Service.latDetailCfg3DataCheck(paramObj, true);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                HttpBaseResponse httpBaseResponse2 = response;
                return httpBaseResponse2;
            }
            this.latticeDetail3Service.saveLatDetail3CfgData(paramObj);
            this.latticeSchemeService.schemeFullUpload(paramObj.getDeviceName(), paramObj.getSchemeNo());
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6210\u529f");
            HttpBaseResponse httpBaseResponse3 = response;
            return httpBaseResponse3;
        }
        catch (ImportExcelException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getErrorMessage());
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u7ec6\u5206\u914d\u7f6e3\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u5931\u8d25");
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        finally {
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/saveBatchLatDetailCfg2"})
    public HttpBaseResponse saveBatchLatDetailCfg2(@RequestBody LatDetailCfg2Req param) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (CollectionUtils.isEmpty((Collection)param.getList())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u65e0\u6570\u636e");
            return response;
        }
        try {
            BaseResp listBaseResp = this.latticeDetail2Service.batchAddInputDataCheck(param, false);
            if (!"000".equals(listBaseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(listBaseResp.getMsg());
                return response;
            }
            List inputData = (List)listBaseResp.getData();
            BaseResp baseResp = this.latticeDetail2Service.batchAddDbRepeatCheck(param, inputData);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            this.latticeExtendService.saveBatch((Collection)inputData);
            this.latticeSchemeService.schemeUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u6dfb\u52a0\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u6dfb\u52a0\u7ec6\u5206\u914d\u7f6e2\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u6dfb\u52a0\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/selectShopFromDetail2"})
    public HttpBaseResponse selectShopFromDetail2(@RequestBody Map<String, String> param) {
        HttpBaseResponse response = new HttpBaseResponse();
        String shopCode = param.get("shopCode");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TExpLatticeExtend::getExtendType, (Object)"3")).and(e -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.like(TExpLatticeExtend::getInterceptType, (Object)"-1013")).or()).like(TExpLatticeExtend::getInterceptType, (Object)"838"))).and(e -> (LambdaQueryWrapper)((LambdaQueryWrapper)e.isNotNull(TExpLatticeExtend::getShopCode)).ne(TExpLatticeExtend::getShopCode, (Object)""))).and(e -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.like(TExpLatticeExtend::getShopCode, (Object)shopCode)).or()).like(TExpLatticeExtend::getShopName, (Object)shopCode));
        List extendList = this.latticeExtendService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)extendList)) {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setData(Collections.emptyList());
            return response;
        }
        List collect = extendList.stream().map(e -> new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setData(collect);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/updateLatDetailCfg2"})
    public HttpBaseResponse updateLatDetailCfg2(@RequestBody TExpLatticeExtend param) {
        logger.info("\u6536\u5230\u4fee\u6539\u7ec6\u5206\u914d\u7f6e2\u8bf7\u6c42 {}", (Object)JSONObject.toJSONString((Object)param));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            BaseResp baseResp = this.latticeDetail2Service.updateLatDetailCfg2Check(param);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            List collect = CollectionUtils.isEmpty((Collection)param.getInterceptTypeList()) ? Collections.emptyList() : param.getInterceptTypeList().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            param.setInterceptType(StringUtils.join(collect, (String)","));
            param.setModifyUserCode(WebRequestUtil.getUserCode());
            param.setModifyUserName(WebRequestUtil.getUserName());
            param.setModifyTime(new Date());
            param.setExtendSendStatus(Integer.valueOf(SendStatus.UPDATE.getStatus()));
            param.setConfigOptFlag("UPD");
            param.setRetry(Integer.valueOf(0));
            this.latticeExtendService.updateById((Object)param);
            this.latticeSchemeService.schemeUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fee\u6539\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u7ec6\u5206\u914d\u7f6e2\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fee\u6539\u5931\u8d25");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HeadTokenVerification
    @PostMapping(value={"/importLatDetailCfg2"})
    public HttpBaseResponse importLatDetailCfg2(@RequestParam(value="jsonData") String jsonData, @RequestParam(value="file") MultipartFile file) {
        logger.info("\u6536\u5230\u5bfc\u5165\u7ec6\u5206\u914d\u7f6e2\u8bf7\u6c42:{}", (Object)jsonData);
        ExcelReader excelReader = null;
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            LatDetailCfg2Req paramObj = (LatDetailCfg2Req)JSONObject.parseObject((String)jsonData, LatDetailCfg2Req.class);
            boolean isCenter = OrgTypeEnum.TRANSFER_CENTER.getType().equals(SysPropertiesConfig.getOrgType());
            excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            CustomizeReadListener readListener = new CustomizeReadListener(LatDetailCfg2ImportBody.class, isCenter ? ExcelUtil.HEAD_VALIDATOR_LATTICE_DETAIL2_CENTER : ExcelUtil.HEAD_VALIDATOR_LATTICE_DETAIL2, isCenter ? ExcelUtil.BODY_VALIDATOR_LATTICE_DETAIL2_CENTER : ExcelUtil.BODY_VALIDATOR_LATTICE_DETAIL2);
            readListener.setHeadFullWordMatch(true);
            ReadSheet sheet = ((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)readListener)).build();
            excelReader.read(new ReadSheet[]{sheet});
            List excelData = readListener.getExcelData();
            if (CollectionUtils.isEmpty((Collection)excelData)) {
                response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
                response.setRespMessage("excel\u4e2d\u65e0\u6570\u636e\uff01");
                HttpBaseResponse httpBaseResponse = response;
                return httpBaseResponse;
            }
            paramObj.setList(excelData);
            BaseResp baseResp = this.latticeDetail2Service.batchAddInputDataCheck(paramObj, true);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                HttpBaseResponse httpBaseResponse = response;
                return httpBaseResponse;
            }
            List data = (List)baseResp.getData();
            this.latticeDetail2Service.saveImportData(data);
            this.latticeSchemeService.schemeFullUpload(paramObj.getDeviceName(), paramObj.getSchemeNo());
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6210\u529f");
            HttpBaseResponse httpBaseResponse = response;
            return httpBaseResponse;
        }
        catch (ImportExcelException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getErrorMessage());
            HttpBaseResponse httpBaseResponse = response;
            return httpBaseResponse;
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u7ec6\u5206\u914d\u7f6e2\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u5931\u8d25");
            HttpBaseResponse httpBaseResponse = response;
            return httpBaseResponse;
        }
        finally {
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/exportLatDetailCfg2"})
    public void exportLatDetailCfg2(HttpServletResponse response, @RequestBody TExpLatticeExtend param) {
        this.latticeDetail2Service.exportLatDetailCfg2(response, param);
    }

    @HeadTokenVerification
    @PostMapping(value={"/saveWeightSortingConfig"})
    public HttpBaseResponse saveWeightSortingConfig(@RequestBody WeightSortingBatchAddReq request) {
        HttpBaseResponse response = new HttpBaseResponse();
        logger.info("\u4fdd\u5b58\u91cd\u91cf\u5206\u62e3\u914d\u7f6e {}", (Object)JSONObject.toJSONString((Object)request));
        try {
            BaseResp baseResp = this.weightSortingCfgService.batchAddCheckConvert(request, false);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            List data = (List)baseResp.getData();
            this.latticeExtendService.saveBatch((Collection)data);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.info("\u4fdd\u5b58\u91cd\u91cf\u5206\u62e3\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.SAVE_FAIL.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/updateWeightSorting"})
    public HttpBaseResponse updateWeightSorting(@RequestBody TExpLatticeExtend request) {
        HttpBaseResponse response = new HttpBaseResponse();
        logger.info("\u4fee\u6539\u91cd\u91cf\u5206\u62e3\u914d\u7f6e {}", (Object)JSONObject.toJSONString((Object)request));
        try {
            BaseResp baseResp = this.weightSortingCfgService.updateWeightSortingCheck(request);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            request.setExtendSendStatus(Integer.valueOf(SendStatus.UPDATE.getStatus()));
            request.setModifyTime(new Date());
            request.setModifyUserCode(WebRequestUtil.getUserCode());
            request.setModifyUserName(WebRequestUtil.getUserName());
            request.setConfigOptFlag("UPD");
            this.latticeExtendService.updateById((Object)request);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fee\u6539\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.info("\u4fee\u6539\u91cd\u91cf\u5206\u62e3\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.SAVE_FAIL.getRespCode());
            response.setRespMessage("\u4fee\u6539\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/selectWeightSortingConfig"})
    public HttpBaseResponse<PageInfo<TExpLatticeExtend>> selectWeightSortingConfig(@RequestBody TExpLatticeExtend request) {
        HttpBaseResponse response = new HttpBaseResponse();
        PageInfo pageInfo = this.weightSortingCfgService.selectWeightSortingCfgList(request, true);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setData((Object)pageInfo);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/importWeightSorting"})
    public HttpBaseResponse importWeightSorting(@RequestParam(value="jsonData") String jsonData, @RequestParam(value="file") MultipartFile file) {
        logger.info("\u6536\u5230\u5bfc\u5165\u91cd\u91cf\u5206\u62e3\u8bf7\u6c42:{}", (Object)jsonData);
        ExcelReader excelReader = null;
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            CustomizeReadListener readListener = new CustomizeReadListener(WeightSortingImportBody.class, ExcelUtil.HEAD_VALIDATOR_WEIGHT_SORTING);
            ReadSheet sheet = ((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)readListener)).build();
            excelReader.read(new ReadSheet[]{sheet});
            List excelData = readListener.getExcelData();
            if (CollectionUtils.isEmpty((Collection)excelData)) {
                response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
                response.setRespMessage("excel\u4e2d\u65e0\u6570\u636e\uff01");
                return response;
            }
            WeightSortingBatchAddReq paramObj = (WeightSortingBatchAddReq)JSONObject.parseObject((String)jsonData, WeightSortingBatchAddReq.class);
            paramObj.setList(excelData);
            BaseResp baseResp = this.weightSortingCfgService.batchAddCheckConvert(paramObj, true);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            this.weightSortingCfgService.saveImportData((List)baseResp.getData());
            this.latticeSchemeService.schemeFullUpload(paramObj.getDeviceName(), paramObj.getSchemeNo());
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6210\u529f");
            return response;
        }
        catch (ImportExcelException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getErrorMessage());
            return response;
        }
        catch (Exception e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u5931\u8d25");
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/exportWeightSorting"})
    public void exportWeightSorting(HttpServletResponse response, @RequestBody TExpLatticeExtend param) {
        this.weightSortingCfgService.exportData(response, param);
    }
}

