/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.config.AdapterServerConfig;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.LoginTypeEnum;
import com.yto.monitor.adapter.constant.OrgTypeEnum;
import com.yto.monitor.adapter.entity.ExpUserLogin;
import com.yto.monitor.adapter.service.CheckWhiteListService;
import com.yto.monitor.adapter.service.IAppInfoService;
import com.yto.monitor.adapter.service.download.OrgInfoService;
import com.yto.monitor.adapter.service.login.ExpUserLoginService;
import com.yto.monitor.adapter.service.login.LoginWhiteService;
import com.yto.monitor.adapter.service.security.SecurityService;
import com.yto.monitor.adapter.utils.CommonUtil;
import com.yto.monitor.adapter.utils.CommonUtils;
import com.yto.monitor.adapter.utils.DateTimeSynchronizeUtil;
import com.yto.monitor.adapter.utils.WebRequestUtil;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.base.OrgInfoEntity;
import com.yto.monitor.common.entity.response.ExpUserLoginItem;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.entity.response.LoginResp;
import com.yto.monitor.common.entity.response.LoginUser;
import com.yto.monitor.common.entity.response.newserver.domain.NewServerResp;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.GoogleJsonUtil;
import com.yto.monitor.common.util.HttpClientConnectionStatusUtil;
import com.yto.monitor.common.util.YjAESUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u767b\u5f55\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mangeBackstage"})
public class LoginController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    @Value(value="${server.port}")
    private String serverPort;
    @Autowired
    private AdapterServerConfig adapterServerConfig;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginWhiteService loginWhiteService;
    @Autowired
    private ExpUserLoginService expUserLoginService;
    @Autowired
    private IAppInfoService appInfoService;
    @Autowired
    private CheckWhiteListService checkWhiteListService;
    @Autowired
    private SecurityService securityService;
    public static final String LOGIN_DEVICE_WEB = "0";
    public static final String LOGIN_DEVICE_PCCV = "1";

    @PostMapping(value={"/login"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse login(@RequestParam(value="signature", required=true) String signature, @RequestBody LoginUser requestUser) {
        LoginResp loginResp;
        ClientHttpResponse response = new ClientHttpResponse();
        String strJson = GoogleJsonUtil.toJson((Object)requestUser);
        if (!this.checkWhiteListService.allowPasswordLogin()) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4f7f\u7528\u3010\u5de5\u53f7+\u5bc6\u7801\u3011\u65b9\u5f0f\u767b\u5165\uff0c\u8bf7\u9009\u62e9\u9489\u9489\u626b\u7801\u6216\u77ed\u4fe1\u9a8c\u8bc1\u7801\u767b\u5f55\uff01");
            this.printLoginResponse(response);
            return response;
        }
        String encryptSig = CommonUtil.encryptJsonToSignature((String)strJson, (String)this.adapterServerConfig.getCharset());
        if (!encryptSig.equals(signature)) {
            logger.error("\u7b7e\u540d\u4e0d\u6b63\u786e");
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u7b7e\u540d\u4e0d\u6b63\u786e");
            this.printLoginResponse(response);
            return response;
        }
        boolean onLineLogin = false;
        if (HttpClientConnectionStatusUtil.isOnLine()) {
            AtomicBoolean exception = new AtomicBoolean(false);
            loginResp = this.expUserLoginService.onLineLogin(requestUser.getUsername(), requestUser.getPassword(), false, exception);
            if (exception.get()) {
                loginResp = this.expUserLoginService.offLineLogin(requestUser.getUsername(), requestUser.getPassword());
            } else {
                onLineLogin = true;
            }
        } else {
            loginResp = this.expUserLoginService.offLineLogin(requestUser.getUsername(), requestUser.getPassword());
        }
        if (loginResp == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
            this.printLoginResponse(response);
            return response;
        }
        OrgInfoEntity currentOrgInfo = this.orgInfoService.getOrgInfoByCode(SysPropertiesConfig.getOrgCode(), true);
        if (currentOrgInfo == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u672c\u5730\u7ec4\u7ec7\u57fa\u7840\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u7ec4\u7ec7\u6570\u636e");
            this.printLoginResponse(response);
            return response;
        }
        if (this.needCheckSameOrg(loginResp.getOrgCode(), currentOrgInfo) && !this.expUserLoginService.checkSameOrg(loginResp.getOrgCode())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u767b\u5f55\u4eba\u7ec4\u7ec7\u4e0e\u5f53\u524d\u7ec4\u7ec7\u4e0d\u4e00\u81f4");
            this.printLoginResponse(response);
            return response;
        }
        loginResp.setOrgType(currentOrgInfo.getType());
        ExpUserLoginItem respUser = new ExpUserLoginItem();
        respUser.setUserCode(loginResp.getUserCode());
        respUser.setEmployeeName(loginResp.getUserName());
        if ((OrgTypeEnum.TRANSFER_CENTER.getType().equals(currentOrgInfo.getType()) || OrgTypeEnum.BRANCH.getType().equals(currentOrgInfo.getType()) || OrgTypeEnum.SUB_DEPARTMENT.getType().equals(currentOrgInfo.getType())) && !this.loginWhiteService.checkWhite(requestUser.getUsername(), currentOrgInfo.getType())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u8bf7\u5148\u5f00\u901a\u767b\u5f55\u6743\u9650\u624d\u80fd\u767b\u5f55\u7cfb\u7edf\uff01");
            this.printLoginResponse(response);
            return response;
        }
        this.loginSuccess(response, respUser, loginResp, requestUser, onLineLogin);
        this.printLoginResponse(response);
        return response;
    }

    private boolean needCheckSameOrg(String userOrgCode, OrgInfoEntity currentOrgInfo) {
        OrgInfoEntity userOrgInfo = null;
        if (currentOrgInfo != null) {
            if (!OrgTypeEnum.TRANSFER_CENTER.getType().equals(currentOrgInfo.getType())) {
                logger.info("\u5f53\u524d\u7ec4\u7ec7\u975e\u4e2d\u5fc3 \u9700\u8981\u6821\u9a8c\u7ec4\u7ec7\u4e00\u81f4\u6027");
                return true;
            }
            userOrgInfo = this.orgInfoService.getOrgInfoByCode(userOrgCode, true);
            if (userOrgInfo != null && OrgTypeEnum.REGION_MANAGE.getType().equals(userOrgInfo.getType())) {
                logger.info("\u672c\u6b21\u767b\u5f55\u4e0d\u9700\u8981\u6821\u9a8c\u7ec4\u7ec7\u4e00\u81f4\u6027");
                return false;
            }
        }
        return true;
    }

    private void loginSuccess(ClientHttpResponse response, ExpUserLoginItem respUser, LoginResp loginResp, LoginUser requestUser, boolean onLineLogin) {
        response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        Date loginTime = new Date();
        respUser.setExpiresToken(this.securityService.generateWebToken(loginResp.getUserCode(), true));
        respUser.setLoginTimeStamp(Long.valueOf(loginTime.getTime()));
        respUser.setOrgCode(SysPropertiesConfig.getOrgCode());
        respUser.setOrgName(SysPropertiesConfig.getOrgName());
        respUser.setSysOrgType(SysPropertiesConfig.getOrgType());
        respUser.setUserOrgCode(loginResp.getOrgCode());
        respUser.setUserOrgName(loginResp.getOrgName());
        response.setData((Object)respUser);
        InetAddress hostLANAddress = CommonUtils.getLocalHostLANAddress();
        this.appInfoService.updateMonitorLoginTime(hostLANAddress == null ? null : hostLANAddress.getHostAddress(), this.serverPort, loginTime);
        if (onLineLogin) {
            loginResp.setPassword(requestUser.getPassword());
            loginResp.setLoginType(Integer.valueOf(LoginTypeEnum.PASSWORD.getValue()));
            this.expUserLoginService.saveLoginUser(loginResp);
        }
    }

    @GetMapping(value={"/sendSmsCode"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u53d1\u9001\u9a8c\u8bc1\u7801", httpMethod="GET", produces="application/json;charset=UTF-8")
    public ClientHttpResponse sendSmsCode(@RequestParam(value="userCode") String userCode, @RequestParam(value="mobile") String mobile, @RequestParam(value="deviceType") String deviceType) {
        logger.info("\u6536\u5230\u53d1\u9001\u9a8c\u8bc1\u7801\u8bf7\u6c42,deviceType:{},userCode:{},mobile:{}", new Object[]{deviceType, userCode, mobile});
        ClientHttpResponse response = new ClientHttpResponse();
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)mobile)) {
            response.setRespcode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u5de5\u53f7\u6216\u624b\u673a\u53f7\u4e3a\u7a7a!");
            this.printLoginResponse(response);
            return response;
        }
        if (!HttpClientConnectionStatusUtil.isOnLine()) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5f53\u524d\u65e0\u7f51\u7edc(\u79bb\u7ebf),\u65e0\u6cd5\u767b\u5f55!");
            this.printLoginResponse(response);
            return response;
        }
        OrgInfoEntity orgInfoByCode = this.orgInfoService.getOrgInfoByCode(SysPropertiesConfig.getOrgCode(), true);
        if (!LOGIN_DEVICE_PCCV.equals(deviceType) && orgInfoByCode != null && (OrgTypeEnum.TRANSFER_CENTER.getType().equals(orgInfoByCode.getType()) || OrgTypeEnum.BRANCH.getType().equals(orgInfoByCode.getType()) || OrgTypeEnum.SUB_DEPARTMENT.getType().equals(orgInfoByCode.getType())) && !this.loginWhiteService.checkWhite(userCode, orgInfoByCode.getType())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u8bf7\u5148\u5f00\u901a\u767b\u5f55\u6743\u9650\u624d\u80fd\u767b\u5f55\u7cfb\u7edf\uff01");
            this.printLoginResponse(response);
            return response;
        }
        NewServerResp resp = this.expUserLoginService.sendSmsCode(userCode, mobile);
        logger.info("\u8fdc\u7a0b\u53d1\u9001\u9a8c\u8bc1\u7801\u63a5\u53e3\u54cd\u5e94:{}", (Object)JSONObject.toJSONString((Object)resp));
        if (resp == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u53d1\u9001\u5931\u8d25,\u8fdc\u7a0b\u54cd\u5e94\u4e3a\u7a7a");
            this.printLoginResponse(response);
            return response;
        }
        if (!"200".equals(resp.getCode())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(resp.getMessage());
            this.printLoginResponse(response);
            return response;
        }
        response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(resp.getMessage());
        this.printLoginResponse(response);
        return response;
    }

    @PostMapping(value={"/smsLogin"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u77ed\u4fe1\u767b\u5f55\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse smsLogin(@RequestBody JSONObject request) {
        logger.info("\u6536\u5230\u77ed\u4fe1\u767b\u5f55\u8bf7\u6c42:{}", (Object)request);
        String code = request.getString("code");
        String mobile = request.getString("mobile");
        String userCode = request.getString("userCode");
        ClientHttpResponse response = new ClientHttpResponse();
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)mobile) || StringUtils.isBlank((String)userCode)) {
            response.setRespcode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u8bf7\u8f93\u5165\u5b8c\u6574\u4fe1\u606f");
            this.printLoginResponse(response);
            return response;
        }
        if (!HttpClientConnectionStatusUtil.isOnLine()) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5f53\u524d\u65e0\u7f51\u7edc(\u79bb\u7ebf),\u65e0\u6cd5\u767b\u5f55!");
            this.printLoginResponse(response);
            return response;
        }
        NewServerResp resp = this.expUserLoginService.smsLogin(userCode, mobile, code);
        logger.info("\u77ed\u4fe1\u767b\u5f55\u8fdc\u7a0b\u63a5\u53e3\u54cd\u5e94:{}", (Object)JSONObject.toJSONString((Object)resp));
        if (resp == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u767b\u5f55\u5931\u8d25,\u8fdc\u7a0b\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
            this.printLoginResponse(response);
            return response;
        }
        if (!"200".equals(resp.getCode())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(resp.getMessage());
            this.printLoginResponse(response);
            return response;
        }
        DateTimeSynchronizeUtil.dateTimeSynchronize((String)resp.getCurrentDateStr());
        LoginResp userInfo = (LoginResp)resp.getData();
        if (userInfo == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u767b\u5f55\u5931\u8d25,\u8fdc\u7a0b\u54cd\u5e94\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            this.printLoginResponse(response);
            return response;
        }
        OrgInfoEntity currentOrgInfo = this.orgInfoService.getOrgInfoByCode(SysPropertiesConfig.getOrgCode(), true);
        if (currentOrgInfo == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u672c\u5730\u7ec4\u7ec7\u57fa\u7840\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u7ec4\u7ec7\u6570\u636e");
            this.printLoginResponse(response);
            return response;
        }
        if (this.needCheckSameOrg(userInfo.getOrgCode(), currentOrgInfo) && !this.expUserLoginService.checkSameOrg(userInfo.getOrgCode())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u767b\u5f55\u4eba\u7ec4\u7ec7\u4e0e\u5f53\u524d\u7ec4\u7ec7\u4e0d\u4e00\u81f4");
            this.printLoginResponse(response);
            return response;
        }
        userInfo.setOrgType(currentOrgInfo.getType());
        this.loginSuccess(response, userInfo, LoginTypeEnum.SMS);
        this.printLoginResponse(response);
        return response;
    }

    private void loginSuccess(ClientHttpResponse response, LoginResp userInfo, LoginTypeEnum loginTypeEnum) {
        ExpUserLoginItem respUser = new ExpUserLoginItem();
        Date loginTime = new Date();
        respUser.setLoginTimeStamp(Long.valueOf(loginTime.getTime()));
        respUser.setExpiresToken(this.securityService.generateWebToken(userInfo.getUserCode(), true));
        respUser.setOrgCode(SysPropertiesConfig.getOrgCode());
        respUser.setOrgName(SysPropertiesConfig.getOrgName());
        respUser.setSysOrgType(SysPropertiesConfig.getOrgType());
        respUser.setUserOrgCode(userInfo.getOrgCode());
        respUser.setUserOrgName(userInfo.getOrgName());
        respUser.setUserCode(userInfo.getUserCode());
        respUser.setUserName(userInfo.getUserName());
        respUser.setEmployeeName(userInfo.getUserName() == null ? "" : userInfo.getUserName());
        response.setData((Object)respUser);
        InetAddress hostLANAddress = CommonUtils.getLocalHostLANAddress();
        this.appInfoService.updateMonitorLoginTime(hostLANAddress == null ? null : hostLANAddress.getHostAddress(), this.serverPort, loginTime);
        userInfo.setLoginType(Integer.valueOf(loginTypeEnum.getValue()));
        this.expUserLoginService.saveLoginUser(userInfo);
    }

    private void printLoginResponse(ClientHttpResponse response) {
        logger.info("\u767b\u5f55\u63a7\u5236\u5668\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)response));
    }

    @GetMapping(value={"/checkMonitorPermissions"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u68c0\u67e5\u5f53\u524d\u7ec4\u7ec7\u662f\u5426\u5141\u8bb8\u4f7f\u7528\u5bc6\u7801\u767b\u5f55", httpMethod="GET", produces="application/json;charset=UTF-8")
    public ClientHttpResponse<Boolean> checkMonitorPermissions() {
        ClientHttpResponse response = new ClientHttpResponse();
        response.setData((Object)this.checkWhiteListService.allowPasswordLogin());
        return response;
    }

    @PostMapping(value={"/tgcLogin"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="tgc\u767b\u5f55(\u626b\u7801\u767b\u5f55)", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse tgcLogin(@RequestParam(value="tgc") String tgc, @RequestParam(value="deviceType") String deviceType) {
        logger.info("\u6536\u5230\u626b\u7801\u767b\u5f55\u8bf7\u6c42,deviceType:{},tgc:{}", (Object)deviceType, (Object)tgc);
        ClientHttpResponse response = new ClientHttpResponse();
        if (StringUtils.isBlank((String)tgc)) {
            response.setRespcode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.PARAM_FAIL.getRespMessage());
            this.printLoginResponse(response);
            return response;
        }
        if (!HttpClientConnectionStatusUtil.isOnLine()) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5f53\u524d\u65e0\u7f51\u7edc(\u79bb\u7ebf),\u65e0\u6cd5\u767b\u5f55!");
            this.printLoginResponse(response);
            return response;
        }
        NewServerResp newServerResp = this.expUserLoginService.tgcLogin(tgc);
        logger.info("\u626b\u7801\u767b\u5f55\u63a5\u53e3\u54cd\u5e94:{}", (Object)JSONObject.toJSONString((Object)newServerResp));
        if (newServerResp == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u626b\u7801\u767b\u5f55\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
            this.printLoginResponse(response);
            return response;
        }
        if (!"200".equals(newServerResp.getCode())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(newServerResp.getMessage());
            this.printLoginResponse(response);
            return response;
        }
        DateTimeSynchronizeUtil.dateTimeSynchronize((String)newServerResp.getCurrentDateStr());
        LoginResp userInfo = (LoginResp)newServerResp.getData();
        if (userInfo == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u767b\u5f55\u5931\u8d25,\u8fdc\u7a0b\u54cd\u5e94\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            this.printLoginResponse(response);
            return response;
        }
        OrgInfoEntity currentOrgInfo = this.orgInfoService.getOrgInfoByCode(SysPropertiesConfig.getOrgCode(), true);
        if (currentOrgInfo == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u672c\u5730\u7ec4\u7ec7\u57fa\u7840\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u7ec4\u7ec7\u6570\u636e");
            this.printLoginResponse(response);
            return response;
        }
        if (this.needCheckSameOrg(userInfo.getOrgCode(), currentOrgInfo) && !this.expUserLoginService.checkSameOrg(userInfo.getOrgCode())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u767b\u5f55\u4eba\u7ec4\u7ec7\u4e0e\u5f53\u524d\u7ec4\u7ec7\u4e0d\u4e00\u81f4");
            this.printLoginResponse(response);
            return response;
        }
        if (!LOGIN_DEVICE_PCCV.equals(deviceType) && (OrgTypeEnum.TRANSFER_CENTER.getType().equals(currentOrgInfo.getType()) || OrgTypeEnum.BRANCH.getType().equals(currentOrgInfo.getType()) || OrgTypeEnum.SUB_DEPARTMENT.getType().equals(currentOrgInfo.getType())) && !this.loginWhiteService.checkWhite(userInfo.getUserCode(), currentOrgInfo.getType())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u8bf7\u5148\u5f00\u901a\u767b\u5f55\u6743\u9650\u624d\u80fd\u767b\u5f55\u7cfb\u7edf\uff01");
            this.printLoginResponse(response);
            return response;
        }
        userInfo.setOrgType(currentOrgInfo.getType());
        this.loginSuccess(response, userInfo, LoginTypeEnum.SCANNING);
        this.printLoginResponse(response);
        return response;
    }

    @PostMapping(value={"/logout"})
    @ApiOperation(value="web\u9875\u9762\u767b\u51fa\u64cd\u4f5c", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse logout() {
        String token = WebRequestUtil.getAuthorization();
        this.securityService.invalidateWebToken(token);
        return new ClientHttpResponse();
    }

    @PostMapping(value={"/exchangeTgcByToken"})
    @ApiOperation(value="\u6839\u636eTOKEN\u83b7\u53d6TGC", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse exchangeTgcByToken() {
        String userCode = WebRequestUtil.getUserCode();
        ExpUserLogin loginInfo = null;
        if (StringUtils.isNotBlank((String)userCode)) {
            loginInfo = this.expUserLoginService.getByUserCode(userCode);
        }
        ClientHttpResponse response = new ClientHttpResponse();
        if (loginInfo == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7528\u6237\u4fe1\u606f");
            return response;
        }
        NewServerResp resp = this.expUserLoginService.exchangeTgcByToken(loginInfo.getToken());
        if (resp == null) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u670d\u52a1\u5668\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            return response;
        }
        if (!"200".equals(resp.getCode())) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(resp.getMessage());
            return response;
        }
        response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        response.setData(resp.getData());
        return response;
    }

    @PostMapping(value={"/yjSign"})
    @HeadTokenVerification
    @ApiOperation(value="\u83b7\u53d6\u5706\u6377\u7b7e\u540d\uff0c\u7528\u4e8e\u5d4c\u5165IT\u652f\u6301\u9875\u9762", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse<String> yjSign(@RequestParam String evn, @RequestParam String mode) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            List<String> modeList = Arrays.asList("production", "wcs");
            String userCode = WebRequestUtil.getUserCode();
            ExpUserLogin user = this.expUserLoginService.getByUserCode(userCode);
            JSONObject signParam = new JSONObject();
            signParam.put("userId", (Object)user.getUserCode());
            signParam.put("accId", (Object)user.getUserCode());
            signParam.put("userName", (Object)user.getEmployeeName());
            signParam.put("stationCode", (Object)user.getOrgCode());
            signParam.put("stationName", (Object)user.getOrgName());
            signParam.put("timestamp", (Object)System.currentTimeMillis());
            signParam.put("channel", (Object)"CV-MONITOR");
            String sign = YjAESUtil.encrypt((String)signParam.toJSONString(), (String)("production".equals(evn) && modeList.contains(mode) ? "02763108slhytyjs" : "0123456789abcdef"));
            String encode = URLEncoder.encode(sign, "UTF-8");
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            response.setData((Object)encode);
            return response;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u5706\u6377\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.GENERAL_FAIL.getRespMessage());
            return response;
        }
    }
}

