/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.mqtt.client.EmqTemplate;
import com.yto.monitor.adapter.mqtt.enums.QoSEnum;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"Yto_MonitorGateway/mqtt"})
@RestController
@Api(value="MQTT\u6d4b\u8bd5")
public class MQTTTestController {
    private static final Logger log = LoggerFactory.getLogger(MQTTTestController.class);
    @Autowired
    private EmqTemplate emqTemplate;

    @PostMapping(value={"/publish/msg"})
    public ClientHttpResponse<Boolean> publishMsg(@RequestParam String topic, @RequestParam(required=false, defaultValue="0") int qos, @RequestParam(required=false) boolean retain, @RequestBody JSONObject msg) {
        ClientHttpResponse resp = new ClientHttpResponse();
        boolean publish = this.emqTemplate.publish(topic, msg.toJSONString(), QoSEnum.fromValue((int)qos), retain);
        if (publish) {
            resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            resp.setData((Object)true);
        } else {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage("send msg failure");
            resp.setData((Object)false);
        }
        return resp;
    }

    @PostMapping(value={"/topic/subscribe"})
    public ClientHttpResponse<String> subcribeTopic(@RequestParam String topic, @RequestParam(required=false, defaultValue="0") int qos) {
        ClientHttpResponse resp = new ClientHttpResponse();
        boolean subscribe = this.emqTemplate.subscribe(topic, QoSEnum.fromValue((int)qos));
        if (subscribe) {
            resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            resp.setData((Object)topic);
        } else {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage("subcribe topic:" + topic + " failure");
        }
        return resp;
    }

    @PostMapping(value={"/topic/unsubscribe"})
    public ClientHttpResponse<String> subcribeTopic(@RequestParam String topic) {
        ClientHttpResponse resp = new ClientHttpResponse();
        boolean unsubscribe = this.emqTemplate.unsubscribe(topic);
        if (unsubscribe) {
            resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            resp.setData((Object)topic);
        } else {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage("subcribe topic:" + topic + " failure");
        }
        return resp;
    }
}

