/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.service.delayDiapatch.IDelayDispatchService;
import com.yto.monitor.adapter.service.dictionary.TExpDictionaryService;
import com.yto.monitor.adapter.utils.HttpRequestUtil;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.Page;
import com.yto.monitor.common.entity.request.DelayDispatchRequest;
import com.yto.monitor.common.entity.request.DelayDispatchUploadRequest;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.entity.routesmerge.RequestPage;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ef6\u8fdf\u6d3e\u4ef6"})
@RequestMapping(value={"/Yto_MonitorGateway/backend/uploadDispatch"})
@ConditionalOnProperty(name={"spring.datasource.dynamic.datasource.gateway.dbName"})
public class ManualUploadDelayDispatchController {
    private static final Logger logger = LoggerFactory.getLogger(ManualUploadDelayDispatchController.class);
    private static final String url = "Yto_BusiGateway/client/utils/manualUpload";
    @Autowired
    private IDelayDispatchService delayDispatchService;
    @Autowired
    private HttpRequestUtil httpRequestUtil;
    @Autowired
    private TExpDictionaryService tExpDictionaryService;

    @PostMapping(value={"/queryDelayDispatch"})
    @ApiOperation(value="\u67e5\u8be2\u5ef6\u8fdf\u4e0a\u4f20\u6570\u636e")
    public ClientHttpResponse queryDelayDispatch(@RequestBody @Valid RequestPage<DelayDispatchRequest> request) {
        ClientHttpResponse resp = new ClientHttpResponse();
        DelayDispatchRequest condition = (DelayDispatchRequest)request.getCondition();
        PageInfo pageInfo = this.delayDispatchService.getDelayDispatchList(condition, request.getPage());
        Page page = new Page();
        page.setPageData(pageInfo.getList());
        page.setTotal(pageInfo.getTotal());
        page.setPageNo(pageInfo.getPageNum());
        resp.setRespcode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        resp.setData((Object)page);
        return resp;
    }

    @PostMapping(value={"/uploadDelayData"})
    @ApiOperation(value="\u4e00\u952e\u4e0a\u4f20\u5ef6\u8fdf\u6570\u636e")
    public HttpBaseResponse uploadDelayData(@RequestBody DelayDispatchUploadRequest request) {
        String ip = request.getIp().trim();
        String port = request.getPort().trim();
        String ipAndPort = ip + ":" + port;
        HttpBaseResponse response = this.httpRequestUtil.doPost("http://".concat(ipAndPort).concat("/").concat(url), (Object)request, null);
        if (response.getRespCode().equals(ResponseTypeEnum.SUCCESS.getRespCode())) {
            this.tExpDictionaryService.putDic(TExpDictionaryService.KeyEnum.EXP_DELAY_DISPATCH_UPLOAD.getName(), ipAndPort);
            return HttpBaseResponse.success();
        }
        return HttpBaseResponse.fail((ResponseTypeEnum)ResponseTypeEnum.GENERAL_FAIL);
    }

    @PostMapping(value={"/getHistory"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u7f51\u5173\u5386\u53f2ip", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse getHistory(@RequestParam String key) {
        return HttpBaseResponse.success((Object)this.tExpDictionaryService.getDic(key));
    }
}

