/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.entity.request.ExpClientQueryInfo;
import com.yto.monitor.adapter.service.MessageRemindService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpRequest;
import com.yto.monitor.common.http.ClientHttpResponse;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"Yto_MonitorGateway/mqtt"})
@RestController
public class MessageRemindController {
    @Autowired
    private MessageRemindService remindService;
    private static final Logger logger = LoggerFactory.getLogger(MessageRemindController.class);

    @HeadTokenVerification
    @GetMapping(value={"/messageRemind/monitorMsgRead"})
    public ClientHttpResponse handReadMessage(@RequestParam Long id, @RequestParam String userId) {
        logger.info("\u6536\u5230userId:{} \u8bf7\u6c42\u5df2\u8bfb\u6d88\u606fmessageId:{}", (Object)userId, (Object)id);
        ClientHttpResponse httpResponse = new ClientHttpResponse();
        httpResponse.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        httpResponse.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        int i = this.remindService.updateMsgByUserId(id, userId);
        httpResponse.setData((Object)i);
        return httpResponse;
    }

    @HeadTokenVerification
    @GetMapping(value={"/messageRemind/monitorMsgUnRead"})
    public ClientHttpResponse handUnReadMessage(@RequestParam(name="userId") String userId) {
        logger.info("\u6536\u5230userId:{} \u8bf7\u6c42\u672a\u8bfb\u6d88\u606f", (Object)userId);
        ClientHttpResponse httpResponse = new ClientHttpResponse();
        List messageRemindEntities = this.remindService.selectMsgByUserId(userId);
        httpResponse.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        httpResponse.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        httpResponse.setData((Object)messageRemindEntities);
        return httpResponse;
    }

    @PostMapping(value={"/messageRemind/clientMsgRead"})
    public ClientHttpResponse clientMsgRead(@RequestBody ClientHttpRequest<ExpClientQueryInfo> baseInfo) {
        logger.info("\u5ba2\u6237\u7aef\u5df2\u8bfb\u5efa\u5305\u89c4\u5219\u4fee\u6539\u901a\u77e5\uff01\u8bf7\u6c42\u6d88\u606f\uff1a{}", (Object)JSONObject.toJSONString(baseInfo));
        ClientHttpResponse httpResponse = new ClientHttpResponse();
        String mac = ((ExpClientQueryInfo)baseInfo.getBody()).getMac();
        String id = ((ExpClientQueryInfo)baseInfo.getBody()).getId();
        if (StringUtils.isBlank((String)mac) || StringUtils.isBlank((String)id)) {
            httpResponse.setRespcode(ResponseTypeEnum.PARAM_ERROR.getRespCode());
            httpResponse.setRespMessage(ResponseTypeEnum.PARAM_ERROR.getRespMessage());
            return httpResponse;
        }
        this.remindService.updateMsgByUserId(Long.valueOf(id), mac);
        httpResponse.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        httpResponse.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return httpResponse;
    }

    @PostMapping(value={"/messageRemind/clientMsgUnRead"})
    public ClientHttpResponse clientMsgUnRead(@RequestBody ClientHttpRequest<ExpClientQueryInfo> baseInfo) {
        logger.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5efa\u5305\u89c4\u5219\u4fee\u6539\u901a\u77e5\uff01\u8bf7\u6c42\u6d88\u606f\uff1a{}", (Object)JSONObject.toJSONString(baseInfo));
        ClientHttpResponse httpResponse = new ClientHttpResponse();
        if (StringUtils.isBlank((String)((ExpClientQueryInfo)baseInfo.getBody()).getMac())) {
            httpResponse.setRespcode(ResponseTypeEnum.PARAM_ERROR.getRespCode());
            httpResponse.setRespMessage(ResponseTypeEnum.PARAM_ERROR.getRespMessage());
            return httpResponse;
        }
        List messageRemindEntities = this.remindService.selectMsg(((ExpClientQueryInfo)baseInfo.getBody()).getMac());
        httpResponse.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        httpResponse.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        httpResponse.setData((Object)messageRemindEntities);
        return httpResponse;
    }
}

