/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.service.GeneralMtyService;
import com.yto.monitor.adapter.service.SsiService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.MtyEnum;
import com.yto.monitor.common.entity.response.MtyTcpBaseResponse;
import com.yto.monitor.common.util.BaseResponseUtil;
import com.yto.monitor.common.util.ExpUtils;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mty"})
public class MtyProcController {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private GeneralMtyService generalMtyService;
    @Autowired
    private SsiService ssiService;

    @ApiOperation(value="MTY\u5904\u7406\u8bf7\u6c42", httpMethod="POST", produces="application/json")
    @PostMapping(value={"/process"}, produces={"application/json"})
    public MtyTcpBaseResponse handleMty(@RequestBody JSONObject jObject) {
        MtyTcpBaseResponse resp = new MtyTcpBaseResponse(BaseResponseUtil.SUCCESS.getCode(), BaseResponseUtil.SUCCESS.getMessage());
        logger.info("\u6536\u5230MTY\u5904\u7406\u8bf7\u6c42:{}", (Object)jObject.toJSONString());
        String mty = jObject.getString("mty");
        String txId = jObject.getString("txId");
        if (ExpUtils.isNotBlank((String)txId)) {
            resp.setTxId(txId);
        }
        if (ExpUtils.isBlank((String)mty)) {
            resp.setCode(BaseResponseUtil.GENERAL_FAIL.getCode());
            resp.setMessage("mty\u4e0d\u80fd\u4e3a\u7a7a");
            return resp;
        }
        String createTime = jObject.getString("createTime");
        if (ExpUtils.isBlank((String)createTime)) {
            resp.setCode(BaseResponseUtil.GENERAL_FAIL.getCode());
            resp.setMessage("createTime\u4e0d\u80fd\u4e3a\u7a7a");
            return resp;
        }
        String tcpStr = "";
        if (MtyEnum.supportGeneral((String)mty)) {
            tcpStr = this.generalMtyService.procGeneralMtyReq(jObject, null);
        } else if (MtyEnum.supportSsi((String)mty)) {
            tcpStr = this.ssiService.proSsiReq(jObject);
        } else {
            resp.setCode(BaseResponseUtil.GENERAL_FAIL.getCode());
            resp.setMessage("\u6682\u4e0d\u652f\u6301\u7684MTY\u7801");
            return resp;
        }
        if (ExpUtils.isNotBlank((String)tcpStr)) {
            resp = (MtyTcpBaseResponse)JSONObject.parseObject((String)tcpStr.substring(8), MtyTcpBaseResponse.class);
        }
        return resp;
    }
}

