/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.service.IMultiOrgRutShareService;
import com.yto.monitor.adapter.service.IOptShareConfigService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.Page;
import com.yto.monitor.common.entity.request.OptShareConfigRequest;
import com.yto.monitor.common.entity.response.HttpBasePageResponse;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.entity.response.MultiOrgEntity;
import com.yto.monitor.common.entity.routesmerge.RequestPage;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5171\u4eab\u4ea4\u53c9\u5e26\u914d\u7f6e"})
@RequestMapping(value={"/Yto_MonitorGateway/multiOrgConfig"})
public class MultiOrgShareController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiOrgShareController.class);
    @Autowired
    private IMultiOrgRutShareService iMultiOrgRutShareService;
    @Autowired
    private IOptShareConfigService optShareConfigService;

    @PostMapping(value={"orgRutConfig"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u65b0\u589e\u7f51\u70b9\u4fe1\u606f", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse mulOrgConfig(@Validated @RequestBody MultiOrgEntity multiOrgEntity, BindingResult bindingResult) {
        HttpBaseResponse resp = new HttpBaseResponse();
        if (bindingResult.hasErrors()) {
            String errorResult = bindingResult.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).reduce((o, t) -> o + ";" + t).orElse("\u53c2\u6570\u6709\u8bef");
            resp.setRespMessage(errorResult);
            resp.setRespCode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
            return resp;
        }
        try {
            multiOrgEntity.setCreateTime(new Date());
            boolean existed = this.iMultiOrgRutShareService.existOrgInfo(multiOrgEntity);
            if (existed) {
                resp.setRespCode("205");
                resp.setRespMessage("\u8be5\u7f51\u70b9\u5df2\u7ecf\u5b58\u5728");
            } else {
                this.iMultiOrgRutShareService.insertMultiOrg(multiOrgEntity);
                resp.setRespCode("000");
                resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u5931\u8d25\uff1a[{}]", (Object)e.getMessage(), (Object)e);
            resp.setRespCode("100");
            resp.setRespMessage("\u64cd\u4f5c\u901a\u7528\u5931\u8d25");
        }
        return resp;
    }

    @PostMapping(value={"queryOrgInfoByPage"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u67e5\u8be2\u7f51\u70b9\u4fe1\u606f", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBasePageResponse queryAllOrgItem(@RequestBody MultiOrgEntity multiOrgEntity) {
        HttpBasePageResponse resp = new HttpBasePageResponse();
        PageInfo pageInfo = this.iMultiOrgRutShareService.queryMultiOrgEntityByPage(multiOrgEntity);
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        resp.setRespCode("000");
        resp.setData((Object)pageInfo.getList());
        resp.setTotal(Integer.valueOf((int)pageInfo.getTotal()));
        return resp;
    }

    @PostMapping(value={"deleteOrg"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u5220\u9664\u7f51\u70b9", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse deleteOrgItem(@RequestBody MultiOrgEntity multiOrgEntity) {
        HttpBaseResponse resp = new HttpBaseResponse();
        try {
            this.iMultiOrgRutShareService.deleteMultiOrgEntity(multiOrgEntity);
            resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
            resp.setRespCode("000");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5931\u8d25\uff1a[{}]", (Object)e.getMessage());
            resp.setRespCode("100");
            resp.setRespMessage("\u64cd\u4f5c\u901a\u7528\u5931\u8d25");
        }
        return resp;
    }

    @PostMapping(value={"batchDeleteOrg/{ids}"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7f51\u70b9", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse batchDeleteOrgItem(@PathVariable String ids) {
        HttpBaseResponse resp = new HttpBaseResponse();
        try {
            this.iMultiOrgRutShareService.batchDeleteMultiOrgEntity(ids);
            resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
            resp.setRespCode("000");
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u5220\u9664\u5931\u8d25\uff1a[{}]", (Object)e.getMessage());
            resp.setRespCode("100");
            resp.setRespMessage("\u64cd\u4f5c\u901a\u7528\u5931\u8d25");
        }
        return resp;
    }

    @PostMapping(value={"updateOrgInfo"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u66f4\u65b0\u7f51\u70b9\u4fe1\u606f", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse updateOrgItem(@Validated @RequestBody MultiOrgEntity multiOrgEntity, BindingResult bindingResult) {
        HttpBaseResponse resp = new HttpBaseResponse();
        if (bindingResult.hasErrors()) {
            String errorResult = bindingResult.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).reduce((o, t) -> o + ";" + t).orElse("\u53c2\u6570\u6709\u8bef");
            resp.setRespMessage(errorResult);
            resp.setRespCode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
            return resp;
        }
        try {
            multiOrgEntity.setModifyTime(new Date());
            this.iMultiOrgRutShareService.updateOrgEntity(multiOrgEntity);
            resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
            resp.setRespCode("000");
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5931\u8d25\uff1a[{}]", (Object)e.getMessage());
            resp.setRespCode("100");
            resp.setRespMessage("\u64cd\u4f5c\u901a\u7528\u5931\u8d25");
        }
        return resp;
    }

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u64cd\u4f5c\u5408\u5e76\u914d\u7f6e")
    public ClientHttpResponse queryPage(@RequestBody RequestPage<OptShareConfigRequest> pageRequest) {
        ClientHttpResponse resp = new ClientHttpResponse();
        try {
            PageInfo pageInfo = this.optShareConfigService.queryPage(pageRequest);
            Page page = new Page();
            page.setPageData(pageInfo.getList());
            page.setTotal(pageInfo.getTotal());
            page.setPageNo(pageInfo.getPageNum());
            resp.setRespcode("000");
            resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
            resp.setData((Object)page);
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u64cd\u4f5c\u5408\u5e76\u914d\u7f6e\u5931\u8d25\uff1a{}", (Throwable)e);
            resp.setRespcode("100");
            resp.setRespMessage("\u64cd\u4f5c\u901a\u7528\u5931\u8d25");
        }
        return resp;
    }
}

