/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.yto.monitor.adapter.entity.NetworkConnReq;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"Yto_MonitorGateway/network"})
@RestController
@Api(value="\u7f51\u7edc\u6d4b\u8bd5")
public class NetWorkConnController {
    private static final Logger log = LoggerFactory.getLogger(NetWorkConnController.class);
    private static final Logger logger = LoggerFactory.getLogger(NetWorkConnController.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/connTest"})
    public ClientHttpResponse<Long> testNetworkConn(@RequestBody NetworkConnReq req) {
        ClientHttpResponse result = new ClientHttpResponse();
        Socket socket = new Socket();
        StopWatch stopWatch = new StopWatch();
        try {
            stopWatch.start();
            if (req.getPort() == null || req.getPort() == 0) {
                req.setPort(Integer.valueOf(443));
            }
            if (req.getTimeOut() == null) {
                req.setTimeOut(Integer.valueOf(1000));
            }
            socket.connect(new InetSocketAddress(req.getHost(), (int)req.getPort()), req.getTimeOut());
            stopWatch.stop();
            result.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            result.setRespMessage("\u8fde\u63a5 " + req.getIpPort(req.getHost(), req.getPort()) + " \u6210\u529f");
            result.setData((Object)stopWatch.getTotalTimeMillis());
        }
        catch (IOException e) {
            stopWatch.stop();
            logger.error("\u8fde\u63a5 {}\u65f6,\u51fa\u73b0\u5f02\u5e38:{}", (Object)req.getIpPort(req.getHost(), req.getPort()), (Object)e.getMessage());
            if (e instanceof UnknownHostException) {
                result.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                result.setRespMessage(req.getHost() + " \u89e3\u6790\u5f02\u5e38,\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u6216\u8005DNS\u8bbe\u7f6e");
            } else {
                result.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                result.setRespMessage("\u8fde\u63a5 " + req.getIpPort(req.getHost(), req.getPort()) + "\u5931\u8d25");
            }
            result.setData((Object)stopWatch.getTotalTimeMillis());
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed {}\u7684\u8fde\u63a5\u65f6,\u51fa\u73b0\u5f02\u5e38:{}", (Object)req.getIpPort(req.getHost(), req.getPort()), (Object)e.getMessage());
            }
        }
        return result;
    }
}

