/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.yto.monitor.adapter.service.INoUploadDataService;
import com.yto.monitor.adapter.service.dictionary.TExpDictionaryService;
import com.yto.monitor.adapter.utils.HttpRequestUtil;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.entity.response.RequestItem;
import com.yto.monitor.common.entity.response.ResponseItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u672a\u4e0a\u4f20\u6570\u636e\u67e5\u8be2"})
@RequestMapping(value={"/Yto_MonitorGateway/backend/NoUpload"})
@ConditionalOnProperty(name={"spring.datasource.dynamic.datasource.gateway.dbName"})
public class NoUploadDataController {
    private static final Logger logger = LoggerFactory.getLogger(NoUploadDataController.class);
    @Autowired
    private INoUploadDataService iNoUploadDataService;
    @Autowired
    private TExpDictionaryService tExpDictionaryService;
    @Autowired
    private HttpRequestUtil httpRequestUtil;
    private static final String url = "Yto_BusiGateway/client/utils/handLockLeaveTask";

    @PostMapping(value={"/oneClickUpload"}, produces={"application/json"})
    @ApiOperation(value="\u4e00\u952e\u4e0a\u4f20", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse oneClickUpload(@RequestParam String ipAndPort) {
        HttpBaseResponse response = this.httpRequestUtil.doPost("http://".concat(ipAndPort).concat("/").concat(url), null, null);
        if (response.getRespCode().equals(ResponseTypeEnum.SUCCESS.getRespCode())) {
            this.tExpDictionaryService.putDic(TExpDictionaryService.KeyEnum.YTODB_CHECK_NOT_UPLOAD.getName(), ipAndPort);
            return HttpBaseResponse.success();
        }
        return HttpBaseResponse.fail((ResponseTypeEnum)ResponseTypeEnum.GENERAL_FAIL);
    }

    @PostMapping(value={"/getHistory"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u5386\u53f2", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse getHistory() {
        return HttpBaseResponse.success((Object)this.tExpDictionaryService.getDic(TExpDictionaryService.KeyEnum.YTODB_CHECK_NOT_UPLOAD.getName()));
    }

    @PostMapping(value={"/checkImageExist"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u56fe\u7247\u662f\u5426\u5b58\u5728", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse checkImageExist(@RequestParam(value="imgUrl") String imgUrl) {
        File file = new File(imgUrl);
        if (file != null) {
            return HttpBaseResponse.success((Object)("\u56fe\u7247\u662f\u5426\u5b58\u5728\uff1a" + file.exists() + ",\u6587\u4ef6\u540d\uff1a" + file.getName()));
        }
        return HttpBaseResponse.fail((String)("\u56fe\u7247\u672a\u627e\u5230\uff01" + imgUrl));
    }

    @PostMapping(value={"/selectNoUploadData"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u672a\u4e0a\u4f20\u6570\u636e", httpMethod="POST", consumes="application/json")
    public List<ResponseItem> selectData(@RequestBody RequestItem requestItem) {
        logger.info("\u5f00\u59cb\u67e5\u8be2");
        List resultList = this.iNoUploadDataService.selectNoUploadData(requestItem);
        logger.info("\u7ed3\u675f\u67e5\u8be2");
        return resultList;
    }

    @PostMapping(value={"/getAllData"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u672a\u4e0a\u4f20\u6570\u636e", httpMethod="POST", consumes="application/json")
    public List<ResponseItem> getAllData(@RequestBody RequestItem requestItem) {
        logger.info("\u5f00\u59cb\u67e5\u8be2\u672a\u4e0a\u4f20\u6570\u636e");
        List resultList = this.iNoUploadDataService.selectAllData(requestItem);
        logger.info("\u7ed3\u675f\u67e5\u8be2\u672a\u4e0a\u4f20\u6570\u636e");
        return resultList;
    }

    @PostMapping(value={"/getTotal"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u6570\u636e\u6761\u6570", httpMethod="POST", consumes="application/json")
    public int getTotal() {
        logger.info("\u5f00\u59cb\u67e5\u8be2\u6570\u636e\u6761\u6570");
        int total = this.iNoUploadDataService.getTotal();
        logger.info("\u7ed3\u675f\u67e5\u8be2\u6570\u636e\u6761\u6570");
        return total;
    }

    @PostMapping(value={"/getQueryTotal"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u67e5\u8be2\u6570\u636e\u6761\u6570", httpMethod="POST", consumes="application/json")
    public int getQueryTotal(@RequestBody RequestItem requestItem) {
        logger.info("\u5f00\u59cb\u67e5\u8be2\u6570\u636e\u6761\u6570");
        int total = this.iNoUploadDataService.getQueryTotal(requestItem);
        logger.info("\u7ed3\u675f\u67e5\u8be2\u6570\u636e\u6761\u6570");
        return total;
    }

    @PostMapping(value={"/outputAllData"}, produces={"application/json"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="POST", consumes="application/json")
    public void outputAllDate(HttpServletRequest request, HttpServletResponse response) {
        logger.info("\u5f00\u59cb\u5bfc\u51fa\u6570\u636e");
        List item = this.iNoUploadDataService.outputAllData();
        Workbook workbook = this.workbook(item);
        try {
            response.setCharacterEncoding("UTF-8");
            response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-type", "application/vnd.ms-excel");
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u4e0a\u4f20\u5931\u8d25\u6570\u636e", "UTF-8") + ".xlsx");
            workbook.write((OutputStream)response.getOutputStream());
            workbook.close();
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51fa\u6570\u636e\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
    }

    private Workbook workbook(List<ResponseItem> item) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet("\u4e0a\u4f20\u5931\u8d25\u7684\u6570\u636e");
        sheet.setColumnWidth(0, 5632);
        sheet.setColumnWidth(1, 2560);
        sheet.setColumnWidth(2, 2560);
        sheet.setColumnWidth(3, 5120);
        sheet.setColumnWidth(4, 3840);
        CellStyle cellStyle = workbook.createCellStyle();
        DataFormat dataFormat = workbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("yyyy-MM-dd HH:mm:ss"));
        Row row = sheet.createRow(0);
        row.createCell(0).setCellValue("\u8fd0\u5355\u53f7");
        row.createCell(1).setCellValue("\u64cd\u4f5c\u7801");
        row.createCell(2).setCellValue("\u64cd\u4f5c\u5458");
        row.createCell(3).setCellValue("\u626b\u63cf\u65f6\u95f4");
        row.createCell(4).setCellValue("\u5931\u8d25\u539f\u56e0");
        int rowNumber = 1;
        if (!CollectionUtils.isEmpty(item)) {
            for (ResponseItem responseItem : item) {
                row = sheet.createRow(rowNumber);
                row.createCell(0).setCellValue(responseItem.getWayBillNo());
                row.createCell(1).setCellValue(responseItem.getOpRecord());
                row.createCell(2).setCellValue(responseItem.getOperator());
                Cell cell = row.createCell(3);
                cell.setCellStyle(cellStyle);
                cell.setCellValue(responseItem.getScanTime());
                row.createCell(4).setCellValue(responseItem.getReason());
                ++rowNumber;
            }
        }
        return workbook;
    }
}

