/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.yto.monitor.adapter.config.AdapterServerConfig;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.OpCodeEnum;
import com.yto.monitor.adapter.entity.ExpWayBillCheckItem;
import com.yto.monitor.adapter.entity.request.ExpOperationTotalRequest;
import com.yto.monitor.adapter.service.NewExpOperationService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.DeviceTypeEnum;
import com.yto.monitor.common.constant.ExpTypeEnum;
import com.yto.monitor.common.constant.IoTypeEnum;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u64cd\u4f5c\u91cf\u4e0a\u62a5"})
@RequestMapping(value={"/Yto_Monitor/Adapter"})
public class OperationController {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    @Autowired
    private AdapterServerConfig config;
    @Autowired
    private NewExpOperationService newExpOperationService;
    private static final String HB_PREFIX = "HBS";

    @PostMapping(value={"/operationTotals"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u65b0\u64cd\u4f5c\u91cf\u4e0a\u62a5\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse operationTotals(@RequestParam(value="signature") String signature, @RequestBody ExpOperationTotalRequest entity) {
        logger.info("\u8001\u7684\u64cd\u4f5c\u91cf\u6570\u636e\uff0c\u6570\u636e\u4e0d\u505a\u5904\u7406....");
        ClientHttpResponse resp = new ClientHttpResponse();
        resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return resp;
    }

    @PostMapping(value={"/newOperationTotal"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u65b0\u64cd\u4f5c\u91cf\u4e0a\u62a5\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse newOperationTotal(@RequestParam(value="signature") String signature, @RequestBody ExpOperationTotalRequest entity) {
        ClientHttpResponse resp = new ClientHttpResponse();
        String jsonStr = GoogleJsonUtil.toJson((Object)entity);
        logger.info("\u5ba2\u6237\u7aef\u64cd\u4f5c\u91cf\u4e0a\u62a5>>>" + jsonStr);
        String msg = null;
        msg = entity.getOpCode().intValue() == OpCodeEnum.OPCODE_334.getCode() ? this.validateData334(entity) : this.validateData(entity);
        if (msg != null) {
            resp.setRespcode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            resp.setRespMessage(msg);
            return resp;
        }
        try {
            int result;
            ExpWayBillCheckItem item = new ExpWayBillCheckItem();
            BeanUtils.copyProperties((Object)entity, (Object)item);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
            String timeText = format.format(entity.getOptTime());
            item.setOptTime(timeText);
            if (null != item.getLatticeNo() && item.getLatticeNo().length() >= 20) {
                item.setLatticeNo(item.getLatticeNo().substring(0, 18));
            }
            if (entity.getWaybillNo().toUpperCase().startsWith("R02T") || entity.getWaybillNo().toUpperCase().startsWith("R02Z")) {
                entity.setWaybillNo(entity.getWaybillNo().substring(4, entity.getWaybillNo().length()));
            }
            if (OpCodeEnum.OPCODE_171.getCode() == item.getOpCode().intValue()) {
                StringBuilder prevOrgCode = new StringBuilder();
                if (ExpUtils.isNotBlank((String)entity.getLatticeOrgCode())) {
                    prevOrgCode.append(entity.getLatticeOrgCode());
                }
                prevOrgCode.append(";");
                if (ExpUtils.isNotBlank((String)entity.getDatoubi())) {
                    prevOrgCode.append(entity.getDatoubi());
                }
                prevOrgCode.append(";");
                if (ExpUtils.isNotBlank((String)entity.getLatticeThreeCode())) {
                    prevOrgCode.append(entity.getLatticeThreeCode());
                }
                prevOrgCode.append(";");
                if (ExpUtils.isNotBlank((String)entity.getLatticeOrgName())) {
                    prevOrgCode.append(entity.getLatticeOrgName());
                }
                if (!";;;".equals(prevOrgCode.toString())) {
                    String pervOrgCodeStr = prevOrgCode.toString();
                    if (prevOrgCode.length() > 85) {
                        item.setPrevOrgCode(pervOrgCodeStr.substring(0, 85));
                        String extend3 = ExpUtils.isBlank((String)item.getExtend3()) ? "###" + pervOrgCodeStr.substring(85) : item.getExtend3() + "###" + pervOrgCodeStr.substring(85);
                        item.setExtend3(extend3);
                    } else {
                        item.setPrevOrgCode(pervOrgCodeStr);
                    }
                }
            }
            if ((result = this.newExpOperationService.insertDB(item)) == -1) {
                resp.setRespcode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
                resp.setRespMessage(ResponseTypeEnum.DATA_REPEAT.getRespMessage());
            } else if (result == 1) {
                resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
                resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            } else {
                resp.setRespcode(ResponseTypeEnum.SAVE_FAIL.getRespCode());
                resp.setRespMessage(ResponseTypeEnum.SAVE_FAIL.getRespMessage());
            }
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u91cf\u4e0a\u62a5\u51fa\u9519\u4e86.", (Throwable)e);
            resp.setRespcode(ResponseTypeEnum.SAVE_FAIL.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.SAVE_FAIL.getRespMessage());
        }
        return resp;
    }

    String validateData(ExpOperationTotalRequest entity) {
        if (StringUtils.isBlank((CharSequence)entity.getCompIP())) {
            return "ip\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getCompMac())) {
            return "mac\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getDevType())) {
            return "\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == entity.getOpCode()) {
            return "\u64cd\u4f5c\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getWaybillNo())) {
            return "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (entity.getOptTime() == null) {
            return "\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getUserCode())) {
            return "\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getOrgCode())) {
            return "\u7f51\u70b9\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getIoType())) {
            return "ioType\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!ExpTypeEnum.checkTypeOk((Integer)entity.getExpType())) {
            return "\u8fd0\u5355\u7c7b\u578b\u4e0d\u5b58\u5728";
        }
        if (!DeviceTypeEnum.checkExistByTypeIndex((String)entity.getDevType())) {
            return "\u8bbe\u5907\u7c7b\u578b\u4e0d\u5b58\u5728";
        }
        if (!IoTypeEnum.checkTypeOk((String)entity.getIoType())) {
            return "ioType\u7c7b\u578b\u4e0d\u5b58\u5728";
        }
        if (OpCodeEnum.OPCODE_171.getCode() == entity.getOpCode().intValue() && entity.getWaybillNo().startsWith(HB_PREFIX)) {
            String orgCode = SysPropertiesConfig.getOrgCode();
            entity.setOrgCode(orgCode);
            entity.setOrgName(SysPropertiesConfig.getOrgName());
            entity.setDestOrgCode(orgCode);
            entity.setNextOrgCode(orgCode);
        }
        if (!entity.getOrgCode().equals(SysPropertiesConfig.getOrgCode())) {
            return "\u7f51\u70b9\u4ee3\u7801\u4e0d\u5339\u914d";
        }
        entity.setCompMac(entity.getCompMac().toUpperCase());
        return null;
    }

    String validateData334(ExpOperationTotalRequest entity) {
        entity.setIoType("01");
        if (StringUtils.isBlank((CharSequence)entity.getCompIP())) {
            return "ip\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getCompMac())) {
            return "mac\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getDevType())) {
            return "\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == entity.getOpCode()) {
            return "\u64cd\u4f5c\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getWaybillNo())) {
            return "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (entity.getOptTime() == null) {
            return "\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getUserCode())) {
            return "\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)entity.getOrgCode())) {
            return "\u7f51\u70b9\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!DeviceTypeEnum.checkExistByTypeIndex((String)entity.getDevType())) {
            return "\u8bbe\u5907\u7c7b\u578b\u4e0d\u5b58\u5728";
        }
        if (!entity.getOrgCode().equals(SysPropertiesConfig.getOrgCode())) {
            return "\u7f51\u70b9\u4ee3\u7801\u4e0d\u5339\u914d";
        }
        if (entity.getExtend2() != null) {
            String str = "0##" + entity.getExtend2();
            entity.setExtend2(str);
        }
        entity.setCompMac(entity.getCompMac().toUpperCase());
        return null;
    }
}

