/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.yto.monitor.adapter.controller.ClientWebSocketServer;
import com.yto.monitor.adapter.entity.electronicScreen.ElectronicScreenResponse;
import com.yto.monitor.adapter.service.BackUpDataBaseManager;
import com.yto.monitor.adapter.service.ElectronicScreenService;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8001\u64cd\u4f5c\u91cf\u4e0a\u62a5"})
@RequestMapping(value={"/Yto_Monitor/automation"})
public class OperationOldController {
    private static final Logger logger = LoggerFactory.getLogger(OperationOldController.class);
    @Autowired
    private BackUpDataBaseManager backUpDataBaseManager;
    @Autowired
    private ElectronicScreenService electronicScreenService;
    @Autowired
    private IExpAutoDeviceService iExpAutoDeviceService;

    @PostMapping(value={"/Test001"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="Test001", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse Test001(String clientMac) {
        ClientHttpResponse resp = new ClientHttpResponse();
        resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        resp.setData((Object)this.iExpAutoDeviceService.selectByDeviceIdInCache(clientMac));
        return resp;
    }

    @GetMapping(value={"/testPushDCT"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="testPushDCT", httpMethod="GET", produces="application/json;charset=UTF-8")
    public ClientHttpResponse testPushDCT(String clientMac) {
        ClientHttpResponse resp = new ClientHttpResponse();
        resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        ArrayList<ElectronicScreenResponse> list = new ArrayList<ElectronicScreenResponse>();
        ElectronicScreenResponse ele = new ElectronicScreenResponse();
        ele.setAvgEfficiency(12);
        ele.setLastHourAvgEfficiency(120);
        ele.setFrequencyRank(22);
        ele.setWholeTopEfficiency(54);
        ele.setAvgEfficiencyRank(133);
        ele.setDeviceMac("6C:B3:11:52:72:76");
        list.add(ele);
        ElectronicScreenResponse ele2 = new ElectronicScreenResponse();
        ele2.setAvgEfficiency(123);
        ele2.setLastHourAvgEfficiency(34);
        ele2.setFrequencyRank(45);
        ele2.setWholeTopEfficiency(56);
        ele2.setAvgEfficiencyRank(77);
        ele2.setDeviceMac("6C:B3:11:52:6D:A6");
        list.add(ele2);
        this.electronicScreenService.pushDataToClient(list);
        return resp;
    }

    @PostMapping(value={"/operationStatistic"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u64cd\u4f5c\u91cf\u4e0a\u62a5\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse operationStatistic() {
        logger.info("\u8001\u7684\u64cd\u4f5c\u91cf\u6570\u636e[operationStatistic]\uff0c\u6570\u636e\u4e0d\u505a\u5904\u7406....");
        ClientHttpResponse resp = new ClientHttpResponse();
        resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return resp;
    }

    @PostMapping(value={"/dumpSql"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u5bfc\u51fasql", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse dumpSql() {
        ClientHttpResponse resp = new ClientHttpResponse();
        resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return resp;
    }

    @PostMapping(value={"/executeSql"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6267\u884csql", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse executeSql() {
        ClientHttpResponse resp = new ClientHttpResponse();
        resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return resp;
    }

    @GetMapping(value={"/sendMessageToClient"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="sendMessageToClient", httpMethod="GET", produces="application/json;charset=UTF-8")
    public ClientHttpResponse executeSql(String clientMac, String respData) {
        ClientWebSocketServer.sendMessageToClient((String)clientMac, (String)respData);
        ClientHttpResponse resp = new ClientHttpResponse();
        resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
        resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return resp;
    }
}

