/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.constant.SendStatus;
import com.yto.monitor.adapter.entity.RutBranchMerge;
import com.yto.monitor.adapter.mapper.OrgInfoMapper;
import com.yto.monitor.adapter.mapper.RutBranchMergeMapper;
import com.yto.monitor.common.entity.Page;
import com.yto.monitor.common.entity.base.OrgInfoEntity;
import com.yto.monitor.common.entity.routesmerge.RequestPage;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5206\u516c\u53f8\u8def\u7531\u5408\u5e76"})
@RequestMapping(value={"/Yto_MonitorGateway/backend/routesMerge"})
public class RoutesMegeController {
    private static final Logger logger = LoggerFactory.getLogger(RoutesMegeController.class);
    @Autowired
    private RutBranchMergeMapper rutBranchMergeMapper;
    @Autowired
    OrgInfoMapper orgInfoMapper;

    @HeadTokenVerification
    @PostMapping(value={"/routesMerges"}, produces={"application/json"})
    @ApiOperation(value="\u5206\u516c\u53f8\u8def\u7531\u914d\u7f6e\u5217\u8868", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse routesMerges(@RequestBody RequestPage<RutBranchMerge> r) {
        logger.info("\u5206\u516c\u53f8\u8def\u7531\u914d\u7f6e\u5217\u8868\u67e5\u8be2");
        ClientHttpResponse resp = new ClientHttpResponse();
        QueryWrapper q = new QueryWrapper();
        q.orderByAsc((Object[])new String[]{"center_org_code"});
        q.orderByDesc((Object[])new String[]{"modify_time"});
        ((QueryWrapper)((QueryWrapper)q.eq((Object)"status", (Object)"VALID")).and(!StringUtils.isBlank((String)((RutBranchMerge)r.getCondition()).getCenterOrgCode()), i -> (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"center_org_code", (Object)((RutBranchMerge)r.getCondition()).getCenterOrgCode())).or()).like((Object)"center_org_name", (Object)((RutBranchMerge)r.getCondition()).getCenterOrgCode()))).and(!StringUtils.isBlank((String)((RutBranchMerge)r.getCondition()).getMergeOrgCodes()), i -> (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"merge_org_codes", (Object)((RutBranchMerge)r.getCondition()).getMergeOrgCodes())).or()).like((Object)"merge_org_names", (Object)((RutBranchMerge)r.getCondition()).getMergeOrgCodes()));
        PageInfo dataByPage = PageHelper.startPage((int)((int)r.getPage().getCurrent()), (int)((int)r.getPage().getSize())).doSelectPageInfo(() -> this.rutBranchMergeMapper.selectPage((IPage)r.getPage(), (Wrapper)q));
        Page page = new Page();
        page.setPageData(dataByPage.getList());
        page.setTotal(dataByPage.getTotal());
        page.setPageNo(dataByPage.getPageNum());
        resp.setRespcode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        resp.setData((Object)page);
        return resp;
    }

    @HeadTokenVerification
    @PostMapping(value={"/addRoutesMerges"}, produces={"application/json"})
    @ApiOperation(value="\u589e\u52a0\u5206\u516c\u53f8\u8def\u7531\u914d\u7f6e", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse addRoutesMerges(@RequestParam(value="addMode") String addMode, @RequestBody RutBranchMerge r) {
        logger.info("\u589e\u52a0\u5206\u516c\u53f8\u8def\u7531\u914d\u7f6e");
        ClientHttpResponse resp = new ClientHttpResponse();
        if (StringUtils.isBlank((String)addMode) || !addMode.equals("add") && !addMode.equals("edit")) {
            resp.setRespcode("100");
            resp.setRespMessage("\u53c2\u6570\u4e0d\u5408\u6cd5");
            return resp;
        }
        if (!this.checkData(r, resp)) {
            return resp;
        }
        Date now = new Date();
        RutBranchMerge save = null;
        if (addMode.equals("add")) {
            save = r;
            save.setId(UUID.randomUUID().toString());
            save.setCreateTime(now);
        } else {
            if (StringUtils.isBlank((String)r.getId())) {
                resp.setRespcode("100");
                resp.setRespMessage("\u53c2\u6570\u4e0d\u5408\u6cd5");
                return resp;
            }
            save = r;
        }
        save.setModifyTime(now);
        save.setStatus("VALID");
        if (addMode.equals("add")) {
            this.rutBranchMergeMapper.insert((Object)save);
        } else {
            save.setSendStatus(SendStatus.UPDATE.status);
            this.rutBranchMergeMapper.updateById((Object)save);
        }
        resp.setRespcode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        resp.setData((Object)save);
        return resp;
    }

    private boolean checkData(RutBranchMerge r, ClientHttpResponse resp) {
        String msg = "";
        int count = 0;
        ArrayList mergeOrgCode = Lists.newArrayList((Object[])r.getMergeOrgCodes().split(","));
        ArrayList<String> mergeOrgName = new ArrayList<String>();
        for (String orgCode : mergeOrgCode) {
            OrgInfoEntity orgInfoEntity = this.orgInfoMapper.getOrgInfoByCode(orgCode);
            if (null == orgInfoEntity) {
                msg = count != 0 && count % 5 == 0 ? msg + orgCode + ",<br/>" : msg + orgCode + ",";
                ++count;
                continue;
            }
            mergeOrgName.add(orgInfoEntity.getName());
        }
        r.setMergeOrgNames(mergeOrgName.toString().replace("[", "").replace("]", ""));
        if (msg.length() > 0) {
            resp.setRespcode("100");
            resp.setRespMessage("\u4ee5\u4e0b\u7ec4\u7ec7\u4ee3\u7801\u4e0d\u5408\u6cd5:" + msg);
            return false;
        }
        return true;
    }

    @HeadTokenVerification
    @PostMapping(value={"/delRoutesMerges"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u5206\u516c\u53f8\u8def\u7531\u914d\u7f6e", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse delRoutesMerges(@RequestParam(value="id") String id) {
        logger.info("\u5220\u9664\u5206\u516c\u53f8\u8def\u7531\u914d\u7f6e");
        ClientHttpResponse resp = new ClientHttpResponse();
        if (StringUtils.isBlank((String)id)) {
            resp.setRespcode("100");
            resp.setRespMessage("\u53c2\u6570\u4e0d\u5408\u6cd5");
            return resp;
        }
        RutBranchMerge save = (RutBranchMerge)this.rutBranchMergeMapper.selectById((Serializable)((Object)id));
        if (save == null) {
            resp.setRespcode("100");
            resp.setRespMessage("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return resp;
        }
        save.setModifyTime(new Date());
        save.setStatus("INVALID");
        save.setSendStatus(SendStatus.UPDATE.status);
        this.rutBranchMergeMapper.updateById((Object)save);
        resp.setRespcode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        return resp;
    }
}

