/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.google.common.collect.Sets;
import com.yto.monitor.adapter.entity.response.ParcelInforResponse;
import com.yto.monitor.adapter.service.IScanLatticeService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5feb\u4ef6\u626b\u63cf\u683c\u53e3\u6d41\u5411\u67e5\u8be2"})
@RestController
@RequestMapping(value={"/Yto_MonitorGateway/scanLattice/"})
public class ScanLatticeController {
    private static final Logger logger = LoggerFactory.getLogger(ScanLatticeController.class);
    @Autowired
    private IScanLatticeService service;

    @PostMapping(value={"queryByWaybillNo"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u5feb\u4ef6\u683c\u53e3\u6d41\u5411\u67e5\u8be2", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse<List<ParcelInforResponse>> queryByWaybillNo(@RequestParam(value="wayBillNos") String wayBillNos) {
        HttpBaseResponse response = HttpBaseResponse.success();
        logger.info("\u901a\u8fc7\u5355\u53f7\u67e5\u8be2\u5feb\u4ef6\u626b\u63cf\u683c\u53e3\u6d41\u5411\u7684\u8bf7\u6c42\u53c2\u6570:{}", (Object)wayBillNos);
        try {
            Object[] waybillNoArr = wayBillNos.split(",");
            HashSet waybillNoSet = Sets.newHashSet((Object[])waybillNoArr);
            List responseList = this.service.queryByWaybillNo((Set)waybillNoSet);
            response.setData((Object)responseList);
        }
        catch (Exception e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u670d\u52a1\u7aef\u5f02\u5e38,\u67e5\u770b\u670d\u52a1\u7aef\u65e5\u5fd7");
            logger.error("\u67e5\u8be2\u5355\u53f7\u626b\u63cf\u683c\u53e3\u6d41\u5411\u5f02\u5e38", (Throwable)e);
        }
        return response;
    }
}

