/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.config.SystemConfig;
import com.yto.monitor.adapter.service.SchemePermissionAssignmentService;
import com.yto.monitor.adapter.utils.WebRequestUtil;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.entity.response.SchemePermissionResp;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/schemePermission"})
public class SchemePermissionAssignmentController {
    @Autowired
    private SchemePermissionAssignmentService schemePermissionAssignmentService;
    @Autowired
    private SystemConfig systemConfig;

    @HeadTokenVerification
    @PostMapping(value={"/userSchemePermission"})
    public HttpBaseResponse<SchemePermissionResp> userSchemePermission() {
        SchemePermissionResp permissionResp = new SchemePermissionResp();
        HttpBaseResponse response = new HttpBaseResponse();
        int count = this.schemePermissionAssignmentService.countByEmpCode(WebRequestUtil.getUserCode());
        permissionResp.setRestricted(Boolean.valueOf(count > 0));
        permissionResp.setHasWcsMonitorMenu(Boolean.valueOf(StringUtils.isNotBlank((String)this.systemConfig.getWcsMonitorUrl())));
        if (count > 0) {
            permissionResp.setDeviceTypes(this.schemePermissionAssignmentService.selectDeviceTypes(WebRequestUtil.getUserCode()));
        }
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setData((Object)permissionResp);
        return response;
    }
}

