/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.entity.request.SsiImageParam;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.entity.response.SsiBaseResp;
import com.yto.monitor.adapter.service.SecurityInspectionService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/ssi"})
public class SecurityInspectionController {
    private static final Logger logger = CustomLoggerFactory.SsiLogger();
    @Autowired
    private SecurityInspectionService securityInspectionService;

    @PostMapping(value={"/uploadImage"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u4e0a\u4f20\u5b89\u68c0\u56fe\u7247", httpMethod="POST", produces="application/json;charset=UTF-8")
    public SsiBaseResp uploadImage(@RequestParam(name="signature", required=false) String signature, @RequestParam(name="token", required=false) String token, @RequestParam(name="createTime") String createTime, @RequestParam(name="createUserCode", required=false) String createUserCode, @RequestParam(name="createUserName", required=false) String createUserName, @RequestParam(name="channel") String channel, @RequestParam(name="deviceNo") String deviceNo, @RequestParam(name="deviceType") String deviceType, @RequestParam(name="checkResultGuid") String checkResultGuid, @RequestParam(name="imageName") String imageName, @RequestParam(name="imageWidth") String imageWidth, @RequestParam(name="imageHeight") String imageHeight, @RequestParam(name="handledByAI") String handledByAI, @RequestParam(name="contraband") String contraband, @RequestParam(name="file") MultipartFile file, @RequestParam(name="extend1", required=false) String extend1, @RequestParam(name="extend2", required=false) String extend2, @RequestParam(name="extend3", required=false) String extend3, @RequestParam(name="deviceName", required=false) String deviceName, @RequestParam(name="waybillNo", required=false) String waybillNo, @RequestParam(name="categoryList", required=false) String categoryListStr) {
        try {
            SsiImageParam imageParam = SsiImageParam.build((String)createTime, (String)createUserCode, (String)createUserName, (String)channel, (String)deviceNo, (String)deviceType, (String)checkResultGuid, (String)imageName, (String)imageWidth, (String)imageHeight, (String)handledByAI, (String)contraband, (String)deviceName, (String)waybillNo, (String)categoryListStr, (String)extend1, (String)extend2, (String)extend3);
            boolean isFileEmpty = file == null || file.isEmpty();
            logger.info("\u6536\u5230\u5b89\u68c0\u56fe\u7247\u4e0a\u4f20 signature:{} token:{} filesize:{} param:{} ", new Object[]{signature, token, isFileEmpty ? Integer.valueOf(0) : String.format("%.3f", (double)file.getSize() / 1024.0), JSONObject.toJSONString((Object)imageParam)});
            if (isFileEmpty) {
                return SsiBaseResp.fail((String)"\u56fe\u7247\u4e3a\u7a7a\u6216\u5927\u5c0f\u4e3a0");
            }
            BaseResp baseResp = this.securityInspectionService.uploadImageToSSO(imageParam, file);
            if (!"000".equals(baseResp.getCode())) {
                return SsiBaseResp.fail((String)baseResp.getMsg());
            }
            return SsiBaseResp.success(null);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5b89\u68c0\u56fe\u7247\u5f02\u5e38", (Throwable)e);
            return SsiBaseResp.fail((String)"\u670d\u52a1\u5185\u90e8\u5f02\u5e38");
        }
    }
}

