/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.entity.SpeedTestReq;
import com.yto.monitor.adapter.entity.SpeedTestResp;
import com.yto.monitor.adapter.service.SpeedTestService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"Yto_MonitorGateway/speed"})
@RestController
@Api(value="\u7f51\u7edc\u6d4b\u8bd5")
public class SpeedTestController {
    private static final Logger log = LoggerFactory.getLogger(SpeedTestController.class);
    public static final String MINTOR_GATEWAY_TYPE = "2";
    public static final String HEALTH_CHECK = "21";
    @Autowired
    private SpeedTestService speedTestService;

    @HeadTokenVerification
    @PostMapping(value={"/test"})
    public ClientHttpResponse checkVersion(@RequestBody SpeedTestReq req) {
        log.info("\u6536\u5230\u6570\u636e\u6e05\u7406\u8bf7\u6c42" + GoogleJsonUtil.toJson((Object)req));
        ClientHttpResponse resp = new ClientHttpResponse();
        if (!MINTOR_GATEWAY_TYPE.equals(req.getGateWayType())) {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage("\u4f20\u5165\u7684\u7f51\u5173\u7c7b\u578b\u975e\u6cd5");
            log.info("\u7f51\u7edc\u6d4b\u8bd5\u54cd\u5e94" + GoogleJsonUtil.toJson((Object)resp));
            return resp;
        }
        if (!HEALTH_CHECK.equals(req.getServiceType())) {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage("\u4f20\u5165\u7684\u4e1a\u52a1\u7c7b\u578b\u975e\u6cd5");
            log.info("\u7f51\u7edc\u6d4b\u8bd5\u54cd\u5e94" + GoogleJsonUtil.toJson((Object)resp));
            return resp;
        }
        SpeedTestResp data = this.speedTestService.test(req);
        if (Objects.nonNull(data)) {
            resp.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            resp.setData((Object)data);
        } else {
            resp.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            resp.setRespMessage("\u7f51\u7edc\u6d4b\u8bd5\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        log.info("\u7f51\u7edc\u6d4b\u8bd5\u54cd\u5e94" + GoogleJsonUtil.toJson((Object)resp));
        return resp;
    }
}

