/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.entity.detection.vo.FallingLatticeDetectionVO;
import com.yto.monitor.adapter.entity.newDevice.TExpOperationTable;
import com.yto.monitor.adapter.mapper.ExpSsiContrabandMapper;
import com.yto.monitor.adapter.netty.server.framework.GateWay;
import com.yto.monitor.adapter.netty.server.framework.business.datastruct.SocketClientObj;
import com.yto.monitor.adapter.netty.server.light.LightGateWay;
import com.yto.monitor.adapter.netty.server.light.LightGatewayDataDecoder;
import com.yto.monitor.adapter.netty.server.light.PlcHexUtils;
import com.yto.monitor.adapter.service.FallingLatticeService;
import com.yto.monitor.adapter.service.newDevice.IExpOperationTableService;
import com.yto.monitor.adapter.service.ssi.SsiCmdPushService;
import com.yto.monitor.adapter.utils.CommonUtil;
import com.yto.monitor.common.constant.MtyEnum;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.util.ExpUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Api(tags={"Test\u6d4b\u8bd5"})
@RestController
@RequestMapping(value={"/test"})
public class TestController {
    private static final Logger logger = LoggerFactory.getLogger(TestController.class);
    @Autowired
    LightGateWay lightGateWay;
    @Autowired
    @Lazy
    private FallingLatticeService fallingLatticeService;
    @Autowired
    SsiCmdPushService ssiCmdPushService;
    @Autowired
    private ExpSsiContrabandMapper contrabandMapper;
    @Autowired
    private IExpOperationTableService expOperationTableService;

    @PostMapping(value={"/fileUpload"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="fileUpload", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse fileUpload(@RequestParam(value="port", required=true) String port, @RequestParam(value="file", required=true) String filePath) {
        RestTemplate restTemplate = CommonUtil.getRestTemplate((int)500);
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"multipart/form-data");
        headers.setContentType(type);
        FileSystemResource fileSystemResource = new FileSystemResource(filePath);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"file", (Object)fileSystemResource);
        form.add((Object)"filename", (Object)"abc.jpg");
        HttpEntity files = new HttpEntity((Object)form, (MultiValueMap)headers);
        try {
            fileSystemResource.getInputStream().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String url = "http://localhost:" + port + "/dws/transferImageInfo?signature=d0acb0a6707ded3f464e9b136e2f1744&param=%7B%22expressNumber%22:%22YT9120343266200%22,%22nameNumber%22:%22791901%22,%22opCode%22:%22171%22,%22snNumber%22:%2200:0A:C4:5E:18:16%22,%22imgSource%22:%22tmws%20_hik%22,%22extend%22:null%7D";
        String s = (String)restTemplate.postForObject(url, (Object)files, String.class, new Object[0]);
        System.out.println(s);
        logger.info("\u4e0a\u4f20\u7ed3\u679c\uff1a" + s);
        return HttpBaseResponse.success((Object)s);
    }

    @GetMapping(value={"/sendMsg"}, produces={"application/json;charset=UTF-8"})
    public HttpBaseResponse<String> send(@RequestParam String ip, @RequestParam String devNo, @RequestParam String func, @RequestParam String beginAddr, @RequestParam(required=false) String dataNum, @RequestParam(required=false) List<String> params) {
        logger.info("\u6536\u5230\u8bf7\u6c42,\u53c2\u6570ip:{}, devNo:{}, func:{}, beginAddr:{}, dataNum:{}, params:{}", new Object[]{ip, devNo, func, beginAddr, dataNum, params == null ? "" : params.toArray(new String[0])});
        LightGatewayDataDecoder.DEV_NO = devNo;
        HttpBaseResponse response = HttpBaseResponse.success();
        String sendMsg = "";
        sendMsg = Objects.isNull(params) ? PlcHexUtils.genModbusMsg((String)devNo, (String)func, (String)beginAddr, (String)dataNum, (String[])new String[0]) : PlcHexUtils.genModbusMsg((String)devNo, (String)func, (String)beginAddr, (String)dataNum, (String[])params.toArray(new String[0]));
        SocketClientObj socketClientObj = this.lightGateWay.getSocketClientObj(ip);
        if (Objects.isNull(socketClientObj) || !socketClientObj.channel.isOpen()) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u6839\u636e" + ip + "\u672a\u627e\u5230\u53ef\u7528\u7684socket \u8fde\u63a5");
            return response;
        }
        if (ExpUtils.isNotBlank((String)sendMsg)) {
            socketClientObj.sendHexData(sendMsg, logger);
            response.setData((Object)sendMsg);
        }
        return response;
    }

    @GetMapping(value={"/tmws/mac"}, produces={"application/json;charset=UTF-8"})
    public HttpBaseResponse obtainTmwsMac() {
        ArrayList<TExpOperationTable> tExpOperationTableList = new ArrayList<TExpOperationTable>();
        HttpBaseResponse httpBaseResponse = HttpBaseResponse.success();
        for (Map.Entry entry : GateWay.tmwsMacMap.entrySet()) {
            String mac = (String)entry.getValue();
            Integer channelId = (Integer)entry.getKey();
            if (Objects.isNull(channelId)) continue;
            TExpOperationTable tableInCache = this.expOperationTableService.getTableInCache(mac);
            tExpOperationTableList.add(tableInCache);
        }
        httpBaseResponse.setData(tExpOperationTableList);
        return httpBaseResponse;
    }

    @ApiOperation(value="\u8ba1\u5212\u843d\u683c", httpMethod="GET")
    @PostMapping(value={"/intend"}, produces={"application/json;charset=UTF-8"})
    public HttpBaseResponse<Boolean> intend(@RequestBody FallingLatticeDetectionVO vo) {
        return HttpBaseResponse.ok((Object)this.fallingLatticeService.intend(vo));
    }

    @GetMapping(value={"/push"}, produces={"application/json;charset=UTF-8"})
    public HttpBaseResponse test(@RequestParam(required=false, value="type") String type, @RequestParam(required=false, value="deviceNos") String deviceNos) {
        List<String> deviceNoList;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("mty", (Object)MtyEnum.MTY_SSI_PUSH_CMD.getMty());
        List<String> list = deviceNoList = StringUtils.isBlank((CharSequence)deviceNos) ? null : Arrays.asList(deviceNos.split(","));
        if (StringUtils.isBlank((CharSequence)type) || "1".equals(type)) {
            List contrabandList = this.contrabandMapper.getContrabandList();
            jsonObject.put("categoryList", (Object)contrabandList);
        } else if ("2".equals(type)) {
            jsonObject.put("extend1", (Object)"1");
        }
        this.ssiCmdPushService.cmdPush(jsonObject, deviceNoList);
        return HttpBaseResponse.success();
    }
}

