/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.entity.excel.UnloadWithDispatchImportBody;
import com.yto.monitor.adapter.entity.newDevice.TExpLatticeExtend;
import com.yto.monitor.adapter.entity.request.CopyLatticeRequest;
import com.yto.monitor.adapter.entity.request.UnloadWithDispatchDelayConfigReq;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.service.ExpLatticeExtendService;
import com.yto.monitor.adapter.service.UnloadWithDispatchService;
import com.yto.monitor.adapter.utils.excel.CustomizeReadListener;
import com.yto.monitor.adapter.utils.excel.ExcelUtil;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.exception.ImportExcelException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/unloadWithDispatch"})
public class UnloadWithDispatchController {
    private static final Logger logger = LoggerFactory.getLogger(UnloadWithDispatchController.class);
    @Autowired
    private UnloadWithDispatchService unloadWithDispatchService;
    @Autowired
    private ExpLatticeExtendService latticeExtendService;

    @HeadTokenVerification
    @PostMapping(value={"/pageList"})
    public HttpBaseResponse<PageInfo<TExpLatticeExtend>> pageList(@RequestBody TExpLatticeExtend body) {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        PageInfo pageInfo = this.unloadWithDispatchService.selectList(body, true);
        baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        baseResponse.setData((Object)pageInfo);
        return baseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/add"})
    public HttpBaseResponse<String> add(@RequestBody TExpLatticeExtend body) {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        this.unloadWithDispatchService.setDefaultParam(body, true);
        BaseResp baseResp = this.unloadWithDispatchService.inputDataCheck(body, true);
        if (!"000".equals(baseResp.getCode())) {
            baseResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            baseResponse.setRespMessage(baseResp.getMsg());
            return baseResponse;
        }
        TExpLatticeExtend data = (TExpLatticeExtend)baseResp.getData();
        this.latticeExtendService.save((Object)data);
        baseResponse.setRespMessage("\u65b0\u589e\u6210\u529f");
        baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        return baseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/edit"})
    public HttpBaseResponse<String> edit(@RequestBody TExpLatticeExtend body) {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        this.unloadWithDispatchService.setDefaultParam(body, false);
        BaseResp baseResp = this.unloadWithDispatchService.inputDataCheck(body, false);
        if (!"000".equals(baseResp.getCode())) {
            baseResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            baseResponse.setRespMessage(baseResp.getMsg());
            return baseResponse;
        }
        TExpLatticeExtend data = (TExpLatticeExtend)baseResp.getData();
        this.latticeExtendService.updateById((Object)data);
        baseResponse.setRespMessage("\u4fee\u6539\u6210\u529f");
        baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        return baseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/setDelayConfig"})
    public HttpBaseResponse<String> setDelayConfig(@RequestBody UnloadWithDispatchDelayConfigReq request) {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        BaseResp baseResp = this.unloadWithDispatchService.delayConfigCheck(request);
        if (!"000".equals(baseResp.getCode())) {
            baseResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            baseResponse.setRespMessage(baseResp.getMsg());
            return baseResponse;
        }
        List data = (List)baseResp.getData();
        this.latticeExtendService.updateBatchById((Collection)data);
        baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        baseResponse.setRespMessage("\u4fdd\u5b58\u6210\u529f");
        return baseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/export"})
    public void export(@RequestBody TExpLatticeExtend request, HttpServletResponse response) {
        this.unloadWithDispatchService.exportExcel(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HeadTokenVerification
    @PostMapping(value={"/import"})
    public HttpBaseResponse importExcel(@RequestParam(value="file") MultipartFile file) {
        HttpBaseResponse httpBaseResponse;
        logger.info("\u6536\u5230\u4e0b\u8f66\u5e26\u6d3e\u4ef6\u5bfc\u5165\u8bf7\u6c42 fileName\uff1a{}", (Object)file.getOriginalFilename());
        HttpBaseResponse response = new HttpBaseResponse();
        ExcelReader excelReader = null;
        try {
            excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            CustomizeReadListener latticeReadListener = new CustomizeReadListener(UnloadWithDispatchImportBody.class, ExcelUtil.HEAD_VALIDATOR_UNLOAD_WITH_DISPATCH, ExcelUtil.BODY_VALIDATOR_UNLOAD_WITH_DISPATCH);
            ReadSheet sheet = ((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)latticeReadListener)).build();
            excelReader.read(new ReadSheet[]{sheet});
            List excelData = latticeReadListener.getExcelData();
            if (CollectionUtils.isEmpty((Collection)excelData)) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("Excel\u4e2d\u65e0\u6570\u636e");
                HttpBaseResponse httpBaseResponse2 = response;
                return httpBaseResponse2;
            }
            BaseResp baseResp = this.unloadWithDispatchService.importDataCheck(excelData);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                HttpBaseResponse httpBaseResponse3 = response;
                return httpBaseResponse3;
            }
            List data = (List)baseResp.getData();
            this.unloadWithDispatchService.setDefaultParam(data, true);
            this.unloadWithDispatchService.saveImportData(data);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6210\u529f");
            HttpBaseResponse httpBaseResponse4 = response;
            return httpBaseResponse4;
        }
        catch (ImportExcelException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getErrorMessage());
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u4e0b\u8f66\u5e26\u6d3e\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25");
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        finally {
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/copyLattice"})
    public HttpBaseResponse copyLattice(@RequestBody CopyLatticeRequest request) {
        logger.info("\u540c\u6b65\u4ea4\u53c9\u5e26\u683c\u53e3\u8bf7\u6c42 {}", (Object)JSONObject.toJSONString((Object)request));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            BaseResp baseResp = this.unloadWithDispatchService.copyCrossBeltLattice(request.getSchemeId(), request.getOptFlagList());
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(baseResp.getCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u540c\u6b65\u5b8c\u6210");
            return response;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4ea4\u53c9\u5e26\u683c\u53e3\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u540c\u6b65\u5931\u8d25");
            return response;
        }
    }
}

