/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.entity.UnloadWithDispatchExclude;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.service.CheckWhiteListService;
import com.yto.monitor.adapter.service.UnloadWithDispatchExcludeService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/unloadWithDispatchExclude"})
public class UnloadWithDispatchExcludeController {
    private static final Logger logger = LoggerFactory.getLogger(UnloadWithDispatchExcludeController.class);
    @Autowired
    private UnloadWithDispatchExcludeService unloadWithDispatchExcludeService;
    @Autowired
    private CheckWhiteListService checkWhiteListService;

    @HeadTokenVerification
    @PostMapping(value={"/pageList"})
    public HttpBaseResponse<PageInfo<UnloadWithDispatchExclude>> pageList(@RequestBody UnloadWithDispatchExclude body) {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        PageInfo pageInfo = this.unloadWithDispatchExcludeService.selectList(body, true);
        baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        baseResponse.setData((Object)pageInfo);
        return baseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/add"})
    public HttpBaseResponse add(@RequestBody UnloadWithDispatchExclude body) {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        if (StringUtils.isBlank((String)body.getThreeCode())) {
            baseResponse.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            baseResponse.setRespMessage("\u4e09\u6bb5\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return baseResponse;
        }
        try {
            BaseResp baseResp = this.unloadWithDispatchExcludeService.inputDataCheck(body);
            if (!"000".equals(baseResp.getCode())) {
                baseResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                baseResponse.setRespMessage(baseResp.getMsg());
                return baseResponse;
            }
            body.setModifyTime(new Date());
            body.setCreateTime(new Date());
            this.unloadWithDispatchExcludeService.save((Object)body);
            baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            baseResponse.setRespMessage("\u4fdd\u5b58\u6210\u529f");
            return baseResponse;
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4e0b\u8f66\u5e26\u6d3e\u4ef6\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            baseResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            baseResponse.setRespMessage("\u4fdd\u5b58\u5931\u8d25");
            return baseResponse;
        }
    }

    @HeadTokenVerification
    @RequestMapping(value={"/deleteBatch"})
    public HttpBaseResponse deleteBatch(@RequestBody List<UnloadWithDispatchExclude> list) {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        if (CollectionUtils.isEmpty(list)) {
            baseResponse.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            baseResponse.setRespMessage("\u65e0\u6570\u636e");
            return baseResponse;
        }
        try {
            List ids = list.stream().map(UnloadWithDispatchExclude::getId).collect(Collectors.toList());
            this.unloadWithDispatchExcludeService.removeByIds(ids);
            baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            baseResponse.setRespMessage("\u5220\u9664\u6210\u529f");
            return baseResponse;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5220\u9664\u4e0b\u8f66\u5e26\u6d3e\u4ef6\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            baseResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            baseResponse.setRespMessage("\u5220\u9664\u5931\u8d25");
            return baseResponse;
        }
    }

    @HeadTokenVerification
    @RequestMapping(value={"/status"})
    public HttpBaseResponse status() {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        MutablePair status = this.checkWhiteListService.unloadWithDispatchEnableStatus();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("enableStatus", status.getRight());
        res.put("disabled", status.getLeft());
        baseResponse.setData(res);
        baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        baseResponse.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return baseResponse;
    }

    @HeadTokenVerification
    @RequestMapping(value={"/changeStatus"})
    public HttpBaseResponse changeStatus() {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        boolean b = this.checkWhiteListService.allowUnloadWithDispatch();
        if (!b) {
            baseResponse.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            baseResponse.setRespMessage("\u5f53\u524d\u65e0\u6743\u9650\u6539\u53d8\u72b6\u6001");
            return baseResponse;
        }
        String newStatus = this.unloadWithDispatchExcludeService.changeStatus();
        baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        baseResponse.setRespMessage("1".equals(newStatus) ? "\u5df2\u5f00\u542f\u4e0b\u8f66\u5e26\u6d3e\u4ef6" : "\u5df2\u5173\u95ed\u4e0b\u8f66\u5e26\u6d3e\u4ef6");
        baseResponse.setData((Object)newStatus);
        return baseResponse;
    }
}

