/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.yto.monitor.adapter.entity.request.UnusualExpressRequestEntity;
import com.yto.monitor.adapter.service.exceptionDetail.ExpUnusualExpressRecordService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpRequest;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u81ea\u52a8\u5316\u5206\u62e3\u5f02\u5e38\u4ef6\u7edf\u8ba1"})
@RequestMapping(value={"/Yto_Monitor/automation"})
public class UnusualExpressController {
    private static final Logger logger = LoggerFactory.getLogger(UnusualExpressController.class);
    @Autowired
    private ExpUnusualExpressRecordService expUnusualExpressRecordService;

    @PostMapping(value={"/unusualExpress"}, produces={"application/json"})
    @ApiOperation(value="\u5f02\u5e38\u4ef6\u4e0a\u62a5\u63a5\u53e3", httpMethod="POST", produces="application/json")
    public ClientHttpResponse unusualExpress(@RequestParam(value="token") String token, @RequestParam(value="signature") String signature, @RequestBody ClientHttpRequest<UnusualExpressRequestEntity> baseInfo) {
        String msg;
        logger.info("\u6536\u5230\u5f02\u5e38\u4ef6\u4e0a\u62a5\u8bf7\u6c42\uff0c\u8bf7\u6c42\u62a5\u6587\uff1a" + GoogleJsonUtil.toJson(baseInfo));
        ClientHttpResponse resp = new ClientHttpResponse();
        resp.setData((Object)((UnusualExpressRequestEntity)baseInfo.getBody()).getWaybillNo());
        if (baseInfo.getBody() != null && (((UnusualExpressRequestEntity)baseInfo.getBody()).getOptTime() == null || ((UnusualExpressRequestEntity)baseInfo.getBody()).getOptTime() == 0L)) {
            ((UnusualExpressRequestEntity)baseInfo.getBody()).setOptTime(Long.valueOf(System.currentTimeMillis()));
        }
        if ((msg = this.checkIsOK(baseInfo)) != null) {
            resp.setRespcode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            resp.setRespMessage(msg);
            return resp;
        }
        this.expUnusualExpressRecordService.add(baseInfo);
        return resp;
    }

    String checkIsOK(ClientHttpRequest<UnusualExpressRequestEntity> baseInfo) {
        if (ExpUtils.isBlank((String)baseInfo.getDevMac())) {
            return "mac\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ExpUtils.isBlank((String)baseInfo.getDevType())) {
            return "\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (baseInfo.getBody() == null) {
            return "body\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (((UnusualExpressRequestEntity)baseInfo.getBody()).getOptTime() == null) {
            return "\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

