/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.entity.log.LogNamesReq;
import com.yto.monitor.adapter.service.UploadLogService;
import com.yto.monitor.adapter.utils.AppNameUtil;
import com.yto.monitor.adapter.utils.FileUtil;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.http.ClientHttpResponse;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/Yto_MonitorServer"})
public class UploadLogController {
    static final Logger logger = CustomLoggerFactory.MpushLogger();
    @Autowired
    private UploadLogService uploadLogService;

    @PostMapping(value={"/log/uploadNames"})
    public ClientHttpResponse uploadLogNames(@RequestBody LogNamesReq request) {
        logger.info("\u6536\u5230\u65e5\u5fd7\u5217\u8868\u4e0a\u4f20\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        ClientHttpResponse response = new ClientHttpResponse();
        if (request == null || StringUtils.isBlank((String)request.getDeviceId()) || request.getDeviceType() == 0 || StringUtils.isBlank((String)request.getFileNames())) {
            response.setRespcode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.MISS_DATA_FAIL.getRespMessage());
            return response;
        }
        String appName = null;
        try {
            appName = AppNameUtil.getNameByType((int)request.getDeviceType());
            this.uploadLogService.requestUploadNames(request.getDeviceId(), request.getPort(), appName, request.getFileNames());
            response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u65e5\u5fd7\u5217\u8868\u5f02\u5e38 {}", appName, (Object)e);
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4e0a\u4f20\u540d\u79f0\u5217\u8868\u5f02\u5e38");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/log/uploadZip"})
    public ClientHttpResponse uploadLogZip(@RequestParam(value="file") MultipartFile file, @RequestParam(value="deviceType") int deviceType, @RequestParam(value="deviceId") String deviceId, @RequestParam(required=false, value="port") Integer port) {
        logger.info("\u6536\u5230\u65e5\u5fd7zip\u4e0a\u4f20 deviceType:{} deviceId:{} port:{}", new Object[]{deviceType, deviceId, port});
        ClientHttpResponse response = new ClientHttpResponse();
        if (StringUtils.isBlank((String)deviceId)) {
            response.setRespcode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("ip\u6216\u7aef\u53e3\u4e3a\u7a7a");
            return response;
        }
        if (file == null || file.isEmpty()) {
            response.setRespcode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u6587\u4ef6\u4e3a\u7a7a");
            return response;
        }
        String appName = null;
        File tempZipFile = null;
        try {
            String fileName = "c_" + System.currentTimeMillis() + "_" + file.getOriginalFilename();
            tempZipFile = new File(FileUtil.getAppTempDir() + File.separator + fileName);
            FileUtils.writeByteArrayToFile((File)tempZipFile, (byte[])file.getBytes());
            port = port == null ? 0 : port;
            appName = AppNameUtil.getNameByType((int)deviceType);
            this.uploadLogService.requestUploadZip(deviceId, port.intValue(), appName, tempZipFile);
            response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        catch (Exception e) {
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4e0a\u4f20\u5931\u8d25");
            logger.error("\u4e0a\u4f20\u65e5\u5fd7zip\u5f02\u5e38 {}", appName, (Object)e);
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        finally {
            if (tempZipFile != null) {
                tempZipFile.delete();
            }
        }
    }
}

