/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller;

import com.yto.monitor.adapter.entity.request.VersionCheckRequest;
import com.yto.monitor.adapter.entity.response.ServerResp;
import com.yto.monitor.adapter.entity.response.VersionData;
import com.yto.monitor.adapter.service.VersionService;
import com.yto.monitor.common.http.ClientHttpRequest;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"Yto_MonitorGateway/version"})
@RestController
@Api(value="\u7248\u672c\u6821\u9a8c")
public class VersionController {
    private static final Logger log = LoggerFactory.getLogger(VersionController.class);
    @Autowired
    private VersionService versionService;

    @PostMapping(value={"/checkVersion"})
    public ClientHttpResponse checkVersion(@RequestBody ClientHttpRequest<VersionCheckRequest> request) {
        log.info("\u6536\u5230\u6761\u7801\u5a01\u89c6\u5ba2\u6237\u7aef\u68c0\u67e5\u7248\u672c\u8bf7\u6c42");
        ClientHttpResponse resp = new ClientHttpResponse();
        try {
            String clientType = ((VersionCheckRequest)request.getBody()).getClientType();
            if (StringUtils.isBlank((String)clientType)) {
                clientType = "1";
            }
            ServerResp checkResp = this.versionService.check(((VersionCheckRequest)request.getBody()).getVersion(), clientType);
            resp.setData(checkResp.getData());
            resp.setRespcode(checkResp.getCode());
            resp.setRespMessage(checkResp.getMessage());
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u7248\u672c\u5f02\u5e38," + e.getMessage(), (Throwable)e);
            VersionData data = new VersionData();
            resp.setData((Object)data);
            resp.setRespcode("100");
            resp.setRespMessage("\u68c0\u67e5\u7248\u672c\u5f02\u5e38," + e.getMessage());
        }
        return resp;
    }
}

