/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.baseDataOperate;

import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.service.BaseDataOperateService;
import com.yto.monitor.adapter.service.TableService;
import com.yto.monitor.adapter.service.download.OrgPackageRuleV1Service;
import com.yto.monitor.adapter.service.download.OsdCameraService;
import com.yto.monitor.adapter.service.newDevice.IExpOperationTableService;
import com.yto.monitor.adapter.service.query.BagRulesQueryService;
import com.yto.monitor.adapter.service.query.RouteDownloadQueryService;
import com.yto.monitor.common.constant.BaseDataTypeEnum;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e\u76f8\u5173\u64cd\u4f5c\u63a5\u53e3"})
@RequestMapping(value={"/Yto_MonitorGateway/baseDataOperate"})
public class BaseDataOperateController {
    private static final Logger logger = LoggerFactory.getLogger(BaseDataOperateController.class);
    public static final String T_EXP_BAG_RULE = "T_EXP_BAG_RULE";
    public static final String T_EXP_BAG_RULE_V1 = "T_EXP_BAG_RULE_V1";
    public static final String T_EXP_CAMERA = "t_exp_camera";
    private final AtomicBoolean bagRuleLock = new AtomicBoolean(false);
    private final AtomicBoolean routeLock = new AtomicBoolean(false);
    private final AtomicBoolean downloadBaseDataLock = new AtomicBoolean(false);
    private final AtomicBoolean osdCameraLock = new AtomicBoolean(false);
    private final AtomicBoolean migrateCameraDataLock = new AtomicBoolean(false);
    @Autowired
    private BagRulesQueryService bagRulesQueryService;
    @Autowired
    private OrgPackageRuleV1Service orgPackageRulV1eService;
    @Autowired
    private RouteDownloadQueryService routeDownloadQueryService;
    @Autowired
    private TableService tableService;
    @Autowired
    private OsdCameraService osdCameraService;
    @Autowired
    private IExpOperationTableService operationTableService;
    @Autowired
    private BaseDataOperateService baseDataOperateService;

    @HeadTokenVerification
    @PostMapping(value={"/queryBagRules"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u67e5\u8be2\u5efa\u5305\u89c4\u5219\u6570\u636e", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse queryBagRules() {
        long startTime = System.currentTimeMillis();
        HashMap<String, Long> map = new HashMap<String, Long>();
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            Integer bagRuleLocalV1 = this.bagRulesQueryService.countLocalBagRuleV1();
            Integer bagRuleOnlineV1 = this.bagRulesQueryService.countOnlineBagRuleV1();
            map.put("bagRuleOnline", bagRuleOnlineV1 == null ? 0L : bagRuleOnlineV1.longValue());
            map.put("bagRuleLocal", bagRuleLocalV1 == null ? 0L : bagRuleLocalV1.longValue());
            map.put("queryTime", System.currentTimeMillis() - startTime);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setData(map);
            logger.info("\u5728\u7ebf\u67e5\u8be2\u6570\u636e:[{}],\u672c\u5730\u67e5\u8be2\u6570\u636e:[{}]", (Object)bagRuleOnlineV1, (Object)bagRuleLocalV1);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5efa\u5305\u89c4\u5219\u6570\u91cf\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u5efa\u5305\u89c4\u5219\u51fa\u9519!");
        }
        return response;
    }

    @PostMapping(value={"/opBagRules"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u540c\u6b65\u5efa\u5305\u89c4\u5219\u6570\u636e", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse opBagRules() {
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            if (!this.bagRuleLock.compareAndSet(false, true)) {
                logger.info("\u540c\u6b65\u5efa\u5305\u89c4\u5219\u6570\u636e\u6b63\u5728\u8fdb\u884c\uff01");
                response.setRespcode("500");
                response.setRespMessage("\u540c\u6b65\u5efa\u5305\u89c4\u5219\u6570\u636e\u6b63\u5728\u8fdb\u884c\uff01");
                return response;
            }
            HashMap<String, Long> map = new HashMap<String, Long>();
            long startTime = System.currentTimeMillis();
            this.orgPackageRulV1eService.sync();
            int countV1 = this.tableService.sqlTableCount(T_EXP_BAG_RULE_V1);
            map.put("syncTime", System.currentTimeMillis() - startTime);
            map.put("count", Long.valueOf(countV1));
            response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u540c\u6b65\u6210\u529f");
            response.setData(map);
            this.bagRuleLock.set(false);
            logger.info("\u540c\u6b65\u5efa\u5305\u89c4\u5219\u6570\u636e\u6b63\u5e38\uff01");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5efa\u5305\u89c4\u5219\u51fa\u9519\uff1a", (Throwable)e);
            this.bagRuleLock.set(false);
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u540c\u6b65\u5efa\u5305\u89c4\u5219\u51fa\u9519!");
        }
        return response;
    }

    @PostMapping(value={"/opOsdCamera"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u540c\u6b65OSD\u6444\u50cf\u5934\u6570\u636e", httpMethod="POST", produces="application/json;charset=UTF-8")
    public ClientHttpResponse opOsdCameraBindings() {
        ClientHttpResponse response = new ClientHttpResponse();
        try {
            if (!this.osdCameraLock.compareAndSet(false, true)) {
                logger.info("\u540c\u6b65OSD\u6444\u50cf\u5934\u6570\u636e\u6b63\u5728\u8fdb\u884c\uff01");
                response.setRespcode("500");
                response.setRespMessage("\u540c\u6b65OSD\u6444\u50cf\u5934\u6570\u636e\u6b63\u5728\u8fdb\u884c\uff01");
                return response;
            }
            HashMap<String, Long> map = new HashMap<String, Long>();
            long startTime = System.currentTimeMillis();
            this.osdCameraService.sync();
            int count = this.tableService.sqlTableCount(T_EXP_CAMERA);
            map.put("syncTime", System.currentTimeMillis() - startTime);
            map.put("count", Long.valueOf(count));
            response.setRespcode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setData(map);
            this.osdCameraLock.set(false);
            logger.info("\u540c\u6b65OSD\u6444\u50cf\u5934\u6570\u636e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65OSD\u6444\u50cf\u5934\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
            this.osdCameraLock.set(false);
            response.setRespcode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u540c\u6b65OSD\u6444\u50cf\u5934\u6570\u636e\u51fa\u9519!");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getRoutesCountsByDay"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u65e5\u671f\u67e5\u8be2\u8def\u7531\u6570\u636e", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse getRoutesCountsByDay(@RequestBody String request) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (StringUtils.isBlank((String)request)) {
            response.setRespCode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.PARAM_FAIL.getRespMessage());
            return response;
        }
        try {
            if (!this.routeLock.compareAndSet(false, true)) {
                logger.info("\u6b63\u5728\u67e5\u8be2\u8def\u7531\u6570\u636e\uff01");
                response.setRespCode("500");
                response.setRespMessage("\u6b63\u5728\u67e5\u8be2\u8def\u7531\u6570\u636e\uff01");
                return response;
            }
            HashMap<String, Long> map = new HashMap<String, Long>();
            long startTime = System.currentTimeMillis();
            long routeCountsOnline = this.routeDownloadQueryService.queryRouteDownloadBetween(request);
            long routeCountsLocal = this.routeDownloadQueryService.getRouteCountsLocal(request);
            this.routeLock.set(false);
            logger.info("\u67e5\u8be2\u8def\u7531\u6570\u636e\u6b63\u5e38\uff01");
            map.put("routeCountsLocal", routeCountsLocal);
            map.put("routeCountsOnline", routeCountsOnline);
            map.put("queryTime", System.currentTimeMillis() - startTime);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setData(map);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8def\u7531\u6570\u636e\u62a5\u9519\uff1a", (Throwable)e);
            this.routeLock.set(false);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u8def\u7531\u6570\u636e\u62a5\u9519!");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/queryRouteDownloadRemain"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u8def\u7531\u672a\u4e0b\u8f7d\u6761\u6570\u67e5\u8be2", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse queryRouteDownloadRemain() {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            HashMap<String, Long> map = new HashMap<String, Long>();
            long startTime = System.currentTimeMillis();
            Long routeCountsRemain = this.routeDownloadQueryService.queryRouteDownloadRemain();
            if (routeCountsRemain == null) {
                logger.error("\u8def\u7531\u672a\u4e0b\u8f7d\u6761\u6570\u67e5\u8be2\u7ed3\u679c\u4e3anull");
                response.setRespCode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
                response.setRespMessage("\u8def\u7531\u672a\u4e0b\u8f7d\u6761\u6570\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            } else {
                logger.info("\u8def\u7531\u672a\u4e0b\u8f7d\u6761\u6570\u67e5\u8be2\u6b63\u5e38\uff01");
                map.put("routeCountsRemain", routeCountsRemain);
                map.put("queryTime", System.currentTimeMillis() - startTime);
                response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                response.setData(map);
            }
        }
        catch (Exception e) {
            logger.error("\u8def\u7531\u672a\u4e0b\u8f7d\u6761\u6570\u67e5\u8be2\u62a5\u9519\uff1a", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u8def\u7531\u672a\u4e0b\u8f7d\u6761\u6570\u67e5\u8be2\u62a5\u9519!");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HeadTokenVerification
    @PostMapping(value={"/downloadBaseData"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u89e6\u53d1\u57fa\u7840\u6570\u636e\u4e0b\u8f7d", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse downloadBaseData(@RequestParam(value="fullDownload", required=false) Boolean fullDownload, @RequestParam(value="type", required=false) Integer type) {
        logger.info("\u6536\u5230\u9875\u9762\u89e6\u53d1\u57fa\u7840\u6570\u636e\u4e0b\u8f7d\u8bf7\u6c42 fullDownload:{} type:{}", (Object)fullDownload, (Object)type);
        HttpBaseResponse response = new HttpBaseResponse();
        if (this.downloadBaseDataLock.get()) {
            response.setRespCode(ResponseTypeEnum.HIGH_FREQUENCY.getRespCode());
            response.setRespMessage("\u57fa\u7840\u6570\u636e\u6b63\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u8f7d");
            return response;
        }
        this.downloadBaseDataLock.set(true);
        try {
            long l = System.currentTimeMillis();
            this.baseDataOperateService.download(fullDownload != null && fullDownload != false, type == null ? BaseDataTypeEnum.ALL.getCode() : type.intValue());
            long cost = System.currentTimeMillis() - l;
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4e0b\u8f7d\u5b8c\u6210,\u8017\u65f6\uff1a" + cost + "ms");
            logger.info("\u9875\u9762\u89e6\u53d1\u57fa\u7840\u6570\u636e\u4e0b\u8f7d\u5b8c\u6210 \u8017\u65f6\uff1a{}", (Object)cost);
            HttpBaseResponse httpBaseResponse = response;
            return httpBaseResponse;
        }
        catch (Exception e) {
            logger.error("\u9875\u9762\u89e6\u53d1\u57fa\u7840\u6570\u636e\u4e0b\u8f7d\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u57fa\u7840\u6570\u636e\u4e0b\u8f7d\u5f02\u5e38");
            HttpBaseResponse httpBaseResponse = response;
            return httpBaseResponse;
        }
        finally {
            this.downloadBaseDataLock.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HeadTokenVerification
    @PostMapping(value={"/migrateCameraData"})
    @ApiOperation(value="\u8fc1\u79fb\u76d1\u63a7\u70b9\u4f4d\u5230\u65b0\u5e73\u53f0", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse migrateCameraData() {
        logger.info("\u6536\u5230\u9875\u9762\u89e6\u53d1\u8fc1\u79fb\u76d1\u63a7\u70b9\u4f4d\u5230\u65b0\u5e73\u53f0\u8bf7\u6c42");
        HttpBaseResponse response = new HttpBaseResponse();
        if (!this.migrateCameraDataLock.compareAndSet(false, true)) {
            response.setRespCode(ResponseTypeEnum.HIGH_FREQUENCY.getRespCode());
            response.setRespMessage("\u6b63\u5728\u8fc1\u79fb\u4e2d\u3002\u3002\u3002");
            return response;
        }
        try {
            long l = System.currentTimeMillis();
            if (this.operationTableService.migrateCameraData()) {
                this.operationTableService.unUploadDataToSend();
            }
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u8fc1\u79fb\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - l) + "ms");
            HttpBaseResponse httpBaseResponse = response;
            return httpBaseResponse;
        }
        catch (Exception e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u8fc1\u79fb\u76d1\u63a7\u70b9\u4f4d\u5931\u8d25");
            logger.error("\u8fc1\u79fb\u76d1\u63a7\u70b9\u4f4d\u5f02\u5e38", (Throwable)e);
            HttpBaseResponse httpBaseResponse = response;
            return httpBaseResponse;
        }
        finally {
            this.migrateCameraDataLock.set(false);
        }
    }
}

