/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.deviceManager;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.OperationTableAttrEnum;
import com.yto.monitor.adapter.constant.OrgTypeEnum;
import com.yto.monitor.adapter.entity.CalibrateScaleRecord;
import com.yto.monitor.adapter.entity.ExpMonitorCodeVison;
import com.yto.monitor.adapter.entity.newDevice.TExpAutoDevice;
import com.yto.monitor.adapter.entity.newDevice.TExpOperationTable;
import com.yto.monitor.adapter.entity.request.ClientDeviceCompNameRequest;
import com.yto.monitor.adapter.entity.request.ClientDeviceRequest;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.mapper.newDevice.ExpOperationTableMapper;
import com.yto.monitor.adapter.service.CalibrateScaleRecordService;
import com.yto.monitor.adapter.service.DeviceBaseInfoService;
import com.yto.monitor.adapter.service.IAppInfoService;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.adapter.service.newDevice.IExpOperationTableService;
import com.yto.monitor.adapter.utils.DevTypeCalcUtils;
import com.yto.monitor.common.constant.DeviceTypeEnum;
import com.yto.monitor.common.constant.InOutFlagEnum;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.exception.ServiceException;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u7aef\u64cd\u4f5c\u53f0\u57fa\u7840\u4fe1\u606f\u4e0a\u62a5"})
@RequestMapping(value={"Yto_MonitorGateway/device"})
public class ClientDeviceController {
    private static final Logger logger = LoggerFactory.getLogger(ClientDeviceController.class);
    @Autowired
    private DeviceBaseInfoService deviceBaseInfoService;
    @Autowired
    private IExpOperationTableService iExpOperationTableService;
    @Autowired
    private ExpOperationTableMapper expOperationTableMapper;
    @Autowired
    private IExpAutoDeviceService iExpAutoDeviceService;
    @Autowired
    private CalibrateScaleRecordService calibrateScaleRecordService;
    @Autowired
    private IAppInfoService appInfoService;

    @PostMapping(value={"/deviceBaseInfo"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u5ba2\u6237\u7aef\u8c03\u7528\u8bbe\u5907\u57fa\u7840\u4fe1\u606f\u4e0a\u62a5\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse deviceBaseInfo(@RequestParam(name="signature") String signature, @RequestBody ClientDeviceRequest request) {
        String operationJson = GoogleJsonUtil.toJson((Object)request);
        logger.info("\u5ba2\u6237\u7aef\u8c03\u7528\u8bbe\u5907\u64cd\u4f5c\u53f0\u4e0a\u62a5>>>" + operationJson);
        String msg = this.validate(request);
        if (msg != null) {
            return HttpBaseResponse.fail((String)ResponseTypeEnum.MISS_DATA_FAIL.getRespCode(), (String)msg);
        }
        try {
            Integer deviceType = DevTypeCalcUtils.calculateDeviceType((Integer)request.getScanDeviceType(), (Integer)request.getAdapterDeviceType(), (String)request.getAdditional(), (Integer)Integer.parseInt(request.getDevType()));
            request.setDevType(String.valueOf(deviceType));
            this.deviceBaseInfoService.updateBaseInfo(request);
            Date date = new Date();
            ExpMonitorCodeVison codeVison = new ExpMonitorCodeVison();
            codeVison.setAppName("\u6761\u7801\u5a01\u89c6");
            codeVison.setMac(request.getCompMac());
            codeVison.setAppStatus(1);
            codeVison.setLateLoginTime(date);
            codeVison.setUpdateTime(date);
            codeVison.setSendStatus(Integer.valueOf(0));
            codeVison.setExtend1(request.getBaseServerSupplier());
            codeVison.setExtend2(request.getExtend1());
            this.appInfoService.saveCodeVisonInfo(codeVison);
            return HttpBaseResponse.success();
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165\u8bb0\u5f55\u65f6T_EXP_OPERATION_TABLE\u8868\u51fa\u9519", (Throwable)e);
            return HttpBaseResponse.generalFail();
        }
    }

    String validate(ClientDeviceRequest request) {
        if (ExpUtils.isBlank((String)request.getCompMac())) {
            return "mac\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ExpUtils.isBlank((String)request.getCompIp())) {
            return "ip\u4e0d\u80fd\u4e3a\u7a7a";
        }
        BaseResp resp = this.deviceBaseInfoService.inoutFlagCheck(request.getInOutFlag(), true);
        if (!"000".equals(resp.getCode())) {
            return resp.getMsg();
        }
        request.setInOutFlag((String)resp.getData());
        TExpOperationTable table = this.iExpOperationTableService.getByMac(request.getCompMac().toUpperCase());
        if (table == null) {
            return "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u64cd\u4f5c\u53f0\u4fe1\u606f";
        }
        return null;
    }

    private String checkStoreRoom(String storeRoom) {
        if (StringUtils.isBlank((String)storeRoom)) {
            return "\u5e93\u623f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            int storeRoomInt = Integer.parseInt(storeRoom);
            if (storeRoomInt < 1 || storeRoomInt > 9) {
                return "\u9519\u8bef\u7684\u5e93\u623f\u53f7\uff1a\u3010" + storeRoomInt + "\u3011\uff0c\u5e93\u623f\u53f7\u8303\u56f4\u53ea\u80fd\u4e3a1-9\u4e4b\u95f4";
            }
        }
        catch (NumberFormatException e) {
            return "\u9519\u8bef\u7684\u5e93\u623f\u53f7\uff1a\u3010" + storeRoom + "\u3011\uff0c\u5e93\u623f\u53f7\u53ea\u80fd\u4e3a\u7eaf\u6570\u5b57";
        }
        return null;
    }

    private String validateCompName(ClientDeviceCompNameRequest request) {
        BaseResp result;
        if (ExpUtils.isBlank((String)request.getCompMac())) {
            return "mac\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ExpUtils.isBlank((String)request.getCompName())) {
            return "\u64cd\u4f5c\u53f0\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String checkStoreRoomMsg = this.checkStoreRoom(request.getStoreRoom());
        if (ExpUtils.isNotBlank((String)checkStoreRoomMsg)) {
            return checkStoreRoomMsg;
        }
        if (ExpUtils.isBlank((String)request.getOperationNum())) {
            return "\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ExpUtils.isBlank((String)request.getDevType())) {
            return "\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!DeviceTypeEnum.checkExistByTypeIndex((String)request.getDevType())) {
            return "\u8bbe\u5907\u7c7b\u578b\u4e0d\u5b58\u5728";
        }
        request.setCompMac(request.getCompMac().toUpperCase());
        int deviceType = Integer.parseInt(request.getDevType());
        if (!this.deviceBaseInfoService.isAdapterDevice(deviceType)) {
            BaseResp baseResp = this.deviceBaseInfoService.inoutFlagCheck(request.getInOutFlag(), true);
            if (!"000".equals(baseResp.getCode())) {
                return baseResp.getMsg();
            }
            request.setInOutFlag((String)baseResp.getData());
        }
        if (!ExpUtils.isBlank((String)request.getCompIp())) {
            TExpOperationTable item = new TExpOperationTable();
            item.setOperationIp(request.getCompIp());
            item.setStoreRoom(request.getStoreRoom());
            TExpOperationTable tExpOperationTable = null;
            try {
                tExpOperationTable = this.iExpOperationTableService.selectByIpRoom(item);
            }
            catch (ServiceException e) {
                return e.getErrorMessage();
            }
            if (tExpOperationTable != null && !tExpOperationTable.getOperationMac().equals(request.getCompMac())) {
                return "\u5e93\u623f\uff1a".concat(request.getStoreRoom()).concat(",\u5df2\u7ecf\u5b58\u5728IP\uff1a").concat(request.getCompIp());
            }
        }
        if (!"000".equals((result = this.deviceBaseInfoService.validate(request)).getCode())) {
            return result.getMsg();
        }
        TExpAutoDevice data = (TExpAutoDevice)result.getData();
        TExpOperationTable expOperationTable = new TExpOperationTable();
        expOperationTable.setOperationName(request.getCompName());
        expOperationTable.setStoreRoom(request.getStoreRoom());
        expOperationTable.setOperationNum(request.getOperationNum());
        expOperationTable.setDeviceType(Integer.valueOf(request.getDevType()));
        String operationTableName = this.deviceBaseInfoService.comboOperationTableName(expOperationTable, data);
        request.setCompName(operationTableName);
        return null;
    }

    @PostMapping(value={"/saveCompName"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u4fdd\u5b58\u64cd\u4f5c\u53f0\u540d\u79f0", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse saveCompName(@RequestBody ClientDeviceCompNameRequest request) {
        String operationJson = GoogleJsonUtil.toJson((Object)request);
        logger.info("\u5ba2\u6237\u7aef\u8c03\u7528\u4fdd\u5b58\u64cd\u4f5c\u53f0\u540d\u79f0>>>" + operationJson);
        Integer devType = DevTypeCalcUtils.calculateDeviceType((Integer)request.getScanDeviceType(), (Integer)request.getAdapterDeviceType(), (String)request.getAdditional(), (Integer)Integer.parseInt(request.getDevType()));
        request.setDevType(String.valueOf(devType));
        String msg = this.validateCompName(request);
        if (msg != null) {
            return HttpBaseResponse.fail((String)ResponseTypeEnum.MISS_DATA_FAIL.getRespCode(), (String)msg);
        }
        TExpAutoDevice tExpAutoDevice = null;
        String extend1 = null;
        String extend2 = "1";
        int deviceType = Integer.parseInt(request.getDevType());
        String inOutFlag = request.getInOutFlag();
        if (request.getWcsIPAndPortFlag().booleanValue()) {
            extend1 = request.getWcsIP() + ":" + request.getWcsPort();
            String str = request.getWcsIP().concat(":").concat(request.getWcsPort());
            tExpAutoDevice = this.iExpAutoDeviceService.queryByWcsIPAndPort(str);
            if (this.deviceBaseInfoService.isAdapterDevice(deviceType)) {
                inOutFlag = InOutFlagEnum.INANDOUT.codeStr().equals(tExpAutoDevice.getInOutFlag()) && ExpUtils.isNotBlank((String)request.getInOutFlag()) ? request.getInOutFlag() : tExpAutoDevice.getInOutFlag();
            }
        }
        String oldDeviceId = null;
        String oldInOutFlag = null;
        TExpOperationTable oldTable = this.iExpOperationTableService.getByMac(request.getCompMac());
        if (oldTable != null) {
            oldInOutFlag = oldTable.getInOutFlag();
            oldDeviceId = oldTable.getAdapterDeviceId();
            oldTable.setOperationName(request.getCompName() == null ? "" : request.getCompName());
            oldTable.setOperationIp(request.getCompIp());
            oldTable.setStoreRoom(request.getStoreRoom());
            oldTable.setOperationNum(request.getOperationNum());
            oldTable.setMaxWeight(request.getMaxWeight());
            oldTable.setMaxLength(request.getMaxLength());
            oldTable.setMonitorHost(request.getMonitorHost());
            oldTable.setMonitorNo(request.getMonitorNo());
            oldTable.setInOutFlag(inOutFlag);
            oldTable.setSendStatus(Integer.valueOf(-1));
            oldTable.setExtend1(extend1);
            oldTable.setExtend2(extend2);
            oldTable.setExtend4("TMWS");
            oldTable.setScanDeviceType(request.getScanDeviceType());
            oldTable.setAdapterDeviceType(request.getAdapterDeviceType());
            oldTable.setAdditional(request.getAdditional());
            oldTable.setOperationType(Integer.valueOf(0));
            if (this.deviceBaseInfoService.isAdapterDevice(deviceType) && null != tExpAutoDevice) {
                oldTable.setAdapterDevice(tExpAutoDevice.getDeviceName());
                oldTable.setAdapterDeviceId(tExpAutoDevice.getDeviceId());
            }
            oldTable.setModifyTime(new Date());
            oldTable.setDeviceType(Integer.valueOf(deviceType));
            oldTable.setRetry(Integer.valueOf(0));
            this.expOperationTableMapper.updateById((Object)oldTable);
            this.iExpOperationTableService.flushData(oldTable);
        } else {
            Date date = new Date();
            TExpOperationTable newTable = new TExpOperationTable();
            newTable.setId(UUID.randomUUID().toString());
            newTable.setOperationMac(request.getCompMac());
            newTable.setOperationIp(request.getCompIp());
            newTable.setOperationName(request.getCompName());
            newTable.setStoreRoom(request.getStoreRoom());
            newTable.setOperationNum(request.getOperationNum());
            newTable.setMaxWeight(request.getMaxWeight());
            newTable.setMaxLength(request.getMaxLength());
            newTable.setMonitorHost(request.getMonitorHost());
            newTable.setMonitorNo(request.getMonitorNo());
            newTable.setSendStatus(Integer.valueOf(-1));
            newTable.setInOutFlag(inOutFlag);
            newTable.setCreateTime(date);
            newTable.setModifyTime(date);
            newTable.setOrgCode(SysPropertiesConfig.getOrgCode());
            newTable.setProductionTime(date);
            newTable.setExtend1(extend1);
            newTable.setExtend2(extend2);
            newTable.setExtend4("TMWS");
            newTable.setCreateUserCode("\u5ba2\u6237\u7aef\u4e0a\u4f20");
            newTable.setCreateUserName("\u5ba2\u6237\u7aef\u4e0a\u4f20");
            newTable.setScanDeviceType(request.getScanDeviceType());
            newTable.setAdapterDeviceType(request.getAdapterDeviceType());
            newTable.setAdditional(request.getAdditional());
            newTable.setOperationType(Integer.valueOf(0));
            if (this.deviceBaseInfoService.isAdapterDevice(deviceType) && null != tExpAutoDevice) {
                newTable.setAdapterDevice(tExpAutoDevice.getDeviceName());
                newTable.setAdapterDeviceId(tExpAutoDevice.getDeviceId());
            }
            newTable.setDeviceType(Integer.valueOf(deviceType));
            newTable.setDisplay("0");
            newTable.setRetry(Integer.valueOf(0));
            this.expOperationTableMapper.insert((Object)newTable);
            this.iExpOperationTableService.flushData(newTable);
        }
        if (null != tExpAutoDevice) {
            this.iExpAutoDeviceService.addSupplyCount(oldDeviceId, tExpAutoDevice.getDeviceId());
        }
        this.iExpOperationTableService.unUploadDataToSend_simple();
        return HttpBaseResponse.success();
    }

    @RequestMapping(value={"/getOperationNameByMac"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636eMAC\u67e5\u8be2\u64cd\u4f5c\u53f0\u540d\u79f0", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse getOperationNameByMac(@RequestParam(value="mac") String mac) {
        logger.info("\u6536\u5230\u67e5\u8be2\u64cd\u4f5c\u53f0\u8bf7\u6c42\uff1a" + mac);
        if (ExpUtils.isBlank((String)mac)) {
            return HttpBaseResponse.requestParamFail((String)"mac\u5730\u5740\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TExpOperationTable operationTable = this.iExpOperationTableService.getTableInCache(mac);
        logger.info("\u64cd\u4f5c\u53f0\uff1a{}", (Object)JSONObject.toJSONString((Object)operationTable));
        if (operationTable != null) {
            ClientDeviceCompNameRequest responseData = new ClientDeviceCompNameRequest();
            responseData.setCompMac(operationTable.getOperationMac());
            responseData.setCompName(operationTable.getOperationName());
            responseData.setOperationNum(operationTable.getOperationNum());
            responseData.setStoreRoom(operationTable.getStoreRoom());
            responseData.setInOutFlag(operationTable.getInOutFlag());
            responseData.setDevType(operationTable.getDeviceType() + "");
            responseData.setCompIp(operationTable.getOperationIp());
            responseData.setAdapterDevice(operationTable.getAdapterDevice());
            responseData.setNeedToWeigh(operationTable.getNeedToWeigh());
            responseData.setSsiLedgerPrimaryId(operationTable.getSsiLedgerPrimaryId());
            responseData.setPhysicalDirect(Integer.valueOf(0));
            responseData.setOnePortMultiTruck(operationTable.getOnePortMultiTruck());
            if (operationTable.getPhysicalDirect() != null) {
                responseData.setPhysicalDirect(operationTable.getPhysicalDirect());
            }
            responseData.setMaxLength(Double.valueOf(0.0));
            if (operationTable.getMaxLength() != null) {
                responseData.setMaxLength(operationTable.getMaxLength());
            }
            responseData.setMaxWeight(Double.valueOf(0.0));
            if (operationTable.getMaxWeight() != null) {
                responseData.setMaxWeight(operationTable.getMaxWeight());
            }
            responseData.setRequiredWeight(operationTable.getRequiredWeight());
            responseData.setMatrixLatticeNo(operationTable.getMatrixLatticeNo());
            responseData.setDeviceAttribute(operationTable.getDeviceAttribute());
            if (operationTable.getDeviceAttribute() != null && operationTable.getDeviceAttribute().intValue() == OperationTableAttrEnum.BACK_PACKAGE_LINE.getValue()) {
                responseData.setIsBackLine("1");
                if (responseData.getRequiredWeight() == null) {
                    responseData.setRequiredWeight(Integer.valueOf(1));
                }
            }
            if (OrgTypeEnum.TRANSFER_CENTER.getType().equals(SysPropertiesConfig.getOrgType())) {
                if (responseData.getNeedToWeigh() == null) {
                    responseData.setNeedToWeigh(this.deviceBaseInfoService.calculateNeedToWeigh(responseData.getInOutFlag(), responseData.getDevType()).getValue());
                }
            } else {
                responseData.setNeedToWeigh(null);
            }
            return HttpBaseResponse.success((Object)responseData);
        }
        return HttpBaseResponse.success();
    }

    @PostMapping(value={"/getCalibrateScaleDeviationValue"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u83b7\u53d6\u6821\u79e4\u504f\u5dee\u503c", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse getCalibrateScaleDeviationValue() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("weightDeviation", 0.05);
        map.put("dimensionDeviation", 2.0);
        return HttpBaseResponse.success(map);
    }

    @PostMapping(value={"/saveCalibrateScaleRecord"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6dfb\u52a0\u6821\u79e4\u8bb0\u5f55", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse saveCalibrateScaleRecord(@RequestBody CalibrateScaleRecord record) {
        logger.info("\u6536\u5230\u4fdd\u5b58\u6821\u79e4\u8bb0\u5f55\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)record));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            if (record == null || record.requestParamIsEmpty()) {
                response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
                response.setRespMessage("\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570");
                return response;
            }
            this.calibrateScaleRecordService.addRecord(record);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4ea4\u79e4\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.SAVE_FAIL.getRespCode());
            response.setRespMessage("\u5931\u8d25");
            return response;
        }
    }
}

