/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.employee;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.service.IExpEmployeeService;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5458\u5de5\u4fe1\u606f"})
@RequestMapping(value={"/Yto_MonitorGateway/employee"})
public class EmployeeController {
    @Autowired
    private IExpEmployeeService expEmployeeService;

    @HeadTokenVerification
    @PostMapping(value={"/getEmployee"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636ecode\u6a21\u7cca\u67e5\u8be2", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse getEmployee(String code) {
        if (StringUtils.isBlank((String)code)) {
            return HttpBaseResponse.requestParamFail((String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList mapList = new ArrayList();
        List list = this.expEmployeeService.getEmployeeList(code);
        list.forEach(e -> {
            HashMap map = Maps.newHashMap();
            map.put(e.getCode(), e.getName());
            mapList.add(map);
        });
        return HttpBaseResponse.success(mapList);
    }

    @PostMapping(value={"/downloadEmployeePage"}, produces={"application/json"})
    @ApiOperation(value="\u5458\u5de5\u5206\u9875\u4e0b\u8f7d", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse downloadEmployeePage(@RequestBody Page page) {
        IPage pages = this.expEmployeeService.pageEmployee(page);
        return HttpBaseResponse.success((Object)pages);
    }
}

