/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.inkJetPrinter;

import cn.com.yto56.basic.framework.core.collection.CollectionUtil;
import com.yto.monitor.adapter.constant.AlertEnum;
import com.yto.monitor.adapter.entity.inkJetPrinter.request.ExpInkJetFaultCodeRequest;
import com.yto.monitor.adapter.entity.inkJetPrinter.request.ExpInkJetPrinterRequest;
import com.yto.monitor.adapter.entity.inkJetPrinter.request.ExpInkJetSolutionRequest;
import com.yto.monitor.adapter.entity.request.AlertCommonReq;
import com.yto.monitor.adapter.service.AlertUploadService;
import com.yto.monitor.adapter.service.inkJetPrinter.ExpInkJetConsumablesService;
import com.yto.monitor.adapter.service.inkJetPrinter.ExpInkJetFaultCodeService;
import com.yto.monitor.adapter.service.inkJetPrinter.ExpInkJetPrinterService;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u55b7\u7801\u673a\u63a5\u53e3"})
@RequestMapping(value={"/Yto_MonitorGateway/inkJetPrinter"})
public class ExpInkJetPrinterController {
    private static final Logger logger = LoggerFactory.getLogger(ExpInkJetPrinterController.class);
    @Autowired
    private ExpInkJetPrinterService expInkJetPrinterService;
    @Autowired
    private ExpInkJetConsumablesService expInkJetConsumablesService;
    @Autowired
    private ExpInkJetFaultCodeService expInkJetFaultCodeService;
    @Autowired
    private AlertUploadService alertUploadService;
    public static final String PC_WARNING = "2";

    @PostMapping(value={"/addPrinter"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u55b7\u7801\u673a\u4e0a\u62a5\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse addPrinter(@RequestBody List<ExpInkJetPrinterRequest> list) {
        logger.info("\u55b7\u7801\u673a\u4e0a\u62a5\u63a5\u53e3:" + GoogleJsonUtil.toJson(list));
        String msg = this.validateData(list);
        if (msg != null) {
            return HttpBaseResponse.requestParamFail((String)msg);
        }
        this.expInkJetPrinterService.add(list);
        return HttpBaseResponse.success();
    }

    String validateData(List<ExpInkJetPrinterRequest> list) {
        if (CollectionUtil.isEmpty(list)) {
            return "\u6570\u636e\u4e3a\u7a7a";
        }
        for (ExpInkJetPrinterRequest request : list) {
            if (request.getSendTime() == null) {
                return "\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (ExpUtils.isBlank((String)request.getPrintStatus())) {
                return "\u6700\u7ec8\u6253\u5370\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (ExpUtils.isBlank((String)request.getWaybillNo())) {
                return "\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (!ExpUtils.isBlank((String)request.getCompMac())) continue;
            return "Mac\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    @PostMapping(value={"/addConsumables"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u55b7\u7801\u673a\u8017\u6750\u4e0a\u62a5\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse addConsumables(@RequestBody List<ExpInkJetSolutionRequest> list) {
        logger.info("\u55b7\u7801\u673a\u8017\u6750\u4e0a\u62a5\u63a5\u53e3:" + GoogleJsonUtil.toJson(list));
        this.expInkJetConsumablesService.add(list);
        return HttpBaseResponse.success();
    }

    @PostMapping(value={"/addFaultCode"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u55b7\u7801\u673a\u6545\u969c\u4e0a\u62a5\u63a5\u53e3", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse addFaultCode(@RequestBody List<ExpInkJetFaultCodeRequest> list) {
        List expInkJetFaultCodeList;
        logger.info("\u55b7\u7801\u673a\u6545\u969c\u4e0a\u62a5\u63a5\u53e3:" + GoogleJsonUtil.toJson(list));
        if (CollectionUtil.isEmpty(list)) {
            return HttpBaseResponse.success();
        }
        List<ExpInkJetFaultCodeRequest> pcWarningList = list.stream().filter(item -> PC_WARNING.equals(item.getType()) && ExpUtils.isNotBlank((String)item.getMessage())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(pcWarningList)) {
            pcWarningList.forEach(pcWarning -> {
                AlertCommonReq req = this.alertUploadService.buildRequestBody();
                req.setWarningType(Integer.valueOf(AlertEnum.PC_WARNING_NOTIFY.getKey()));
                req.setWarningContent(pcWarning.getMessage());
                this.alertUploadService.upload(req);
            });
        }
        if (CollectionUtil.isNotEmpty(expInkJetFaultCodeList = list.stream().filter(item -> !PC_WARNING.equals(item.getType())).collect(Collectors.toList()))) {
            this.expInkJetFaultCodeService.add(expInkJetFaultCodeList);
        }
        return HttpBaseResponse.success();
    }
}

