/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.newDevice;

import cn.com.yto56.basic.framework.core.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.AutoDeviceTypeEnum;
import com.yto.monitor.adapter.constant.EndLineSortingTypeEnum;
import com.yto.monitor.adapter.entity.PageInfoEntity;
import com.yto.monitor.adapter.entity.newDevice.TExpAutoDevice;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.entity.response.SqlBackupResponse;
import com.yto.monitor.adapter.mapper.newDevice.ExpLatticeSchemeMapper;
import com.yto.monitor.adapter.service.BackUpDataBaseManager;
import com.yto.monitor.adapter.service.CheckWhiteListService;
import com.yto.monitor.adapter.service.DeviceActiveService;
import com.yto.monitor.adapter.service.IAppInfoService;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.adapter.service.newDevice.IExpLatticeSchemeService;
import com.yto.monitor.adapter.service.newDevice.IExpLatticeService;
import com.yto.monitor.adapter.service.newDevice.IExpOperationTableService;
import com.yto.monitor.adapter.service.newDevice.IExpPrintDeviceService;
import com.yto.monitor.adapter.utils.LatticeUtil;
import com.yto.monitor.common.constant.InOutFlagEnum;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.AppInfoEntity;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.ResourceAccessException;

@RestController
@Api(tags={"\u8bbe\u5907\u57fa\u7840\u4fe1\u606f\u7ba1\u7406\u9875\u9762"})
@RequestMapping(value={"/Yto_MonitorGateway/autoDevice"})
public class ExpAutoDeviceController {
    private static final Logger logger = LoggerFactory.getLogger(ExpAutoDeviceController.class);
    @Autowired
    private IExpAutoDeviceService deviceService;
    @Autowired
    private IExpOperationTableService operationTableService;
    @Autowired
    private IExpLatticeService latticeService;
    @Autowired
    private IExpPrintDeviceService printDeviceService;
    @Autowired
    private IExpLatticeSchemeService schemeService;
    @Autowired
    private BackUpDataBaseManager backUpDataBaseManager;
    @Autowired
    private ExpLatticeSchemeMapper latticeSchemeMapper;
    @Autowired
    private DeviceActiveService deviceActiveService;
    @Autowired
    private IAppInfoService appInfoService;
    @Autowired
    private CheckWhiteListService checkWhiteListService;

    @HeadTokenVerification
    @PostMapping(value={"/del"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u8bbe\u5907\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse deleteById(@RequestParam(value="ids") String ids, @RequestParam(value="sign") String sign) {
        logger.info("\u6536\u5230\u5206\u62e3\u8bbe\u5907\u5220\u9664\u8bf7\u6c42 {}", (Object)ids);
        HttpBaseResponse response = new HttpBaseResponse();
        boolean ok = false;
        try {
            String msg = this.deviceService.selectRelationInfo(ids);
            if (msg != null) {
                response.setRespCode("111");
                response.setRespMessage(msg + ",\u4e0d\u80fd\u5220\u9664!");
            } else {
                ok = this.deviceService.deleteById(ids, sign);
                response.setRespCode("000");
                response.setRespMessage("\u5220\u9664\u6210\u529f");
            }
        }
        catch (Exception e) {
            response.setRespCode("111");
            response.setRespMessage("\u5220\u9664\u5931\u8d25");
            logger.error("\u5220\u9664\u8bbe\u5907\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        response.setData((Object)ok);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/add"}, produces={"application/json"})
    @ApiOperation(value="\u65b0\u589e\u8bbe\u5907\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse add(@RequestBody TExpAutoDevice item) {
        logger.info("\u6536\u5230\u65b0\u589e\u8bbe\u5907\u8bf7\u6c42:{}", (Object)JSONObject.toJSONString((Object)item));
        HttpBaseResponse response = new HttpBaseResponse();
        if (AutoDeviceTypeEnum.END_LINE.getType().equals(item.getDeviceType())) {
            this.processEndLine(item);
        }
        if (AutoDeviceTypeEnum.CROSSBELT.getType().equals(item.getDeviceType())) {
            String msg;
            String latticeNo;
            if (!"0".equals(item.getPhysicalExceptionLatticeNo())) {
                latticeNo = LatticeUtil.transferLatticeNo((String)item.getPhysicalExceptionLatticeNo());
                msg = LatticeUtil.checkLatticeNo((String)latticeNo, (boolean)true);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    response.setRespMessage(msg);
                    return response;
                }
                item.setPhysicalExceptionLatticeNo(latticeNo);
            }
            if (!"0".equals(item.getDirectlyDownLatticeNo())) {
                latticeNo = LatticeUtil.transferLatticeNo((String)item.getDirectlyDownLatticeNo());
                msg = LatticeUtil.checkLatticeNo((String)latticeNo, (boolean)false);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    response.setRespMessage(msg);
                    return response;
                }
                item.setDirectlyDownLatticeNo(latticeNo);
            }
        }
        if (this.checkDevice(response, item, false)) {
            item.setId(UUID.randomUUID().toString());
            item.setWcsMac(StringUtil.upperCase((String)item.getWcsMac()));
            Date date = new Date();
            item.setCreateTime(date);
            item.setModifyTime(date);
            int i = this.deviceService.insert(item);
            if (i > 0) {
                response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                response.setRespMessage("\u65b0\u589e\u6210\u529f");
            } else {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u65b0\u589e\u5931\u8d25");
            }
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/update"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u8bbe\u5907\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse update(@RequestBody TExpAutoDevice item) {
        logger.info("\u6536\u5230\u8bbe\u5907\u4fee\u6539\u8bf7\u6c42:{}", (Object)JSONObject.toJSONString((Object)item));
        HttpBaseResponse response = new HttpBaseResponse();
        TExpAutoDevice device = this.deviceService.selectById(item.getId());
        BaseResp baseResp = this.deviceService.inOutFlagChangeCheck(device, item);
        if (!"000".equals(baseResp.getCode())) {
            response.setRespCode("222");
            response.setRespMessage(baseResp.getMsg());
            return response;
        }
        if (AutoDeviceTypeEnum.END_LINE.getType().equals(item.getDeviceType())) {
            this.processEndLine(item);
        }
        if (AutoDeviceTypeEnum.CROSSBELT.getType().equals(item.getDeviceType())) {
            String msg;
            String latticeNo;
            if (!"0".equals(item.getPhysicalExceptionLatticeNo())) {
                latticeNo = LatticeUtil.transferLatticeNo((String)item.getPhysicalExceptionLatticeNo());
                msg = LatticeUtil.checkLatticeNo((String)latticeNo, (boolean)true);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    response.setRespMessage(msg);
                    return response;
                }
                item.setPhysicalExceptionLatticeNo(latticeNo);
            }
            if (!"0".equals(item.getDirectlyDownLatticeNo())) {
                latticeNo = LatticeUtil.transferLatticeNo((String)item.getDirectlyDownLatticeNo());
                msg = LatticeUtil.checkLatticeNo((String)latticeNo, (boolean)false);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    response.setRespMessage(msg);
                    return response;
                }
                item.setDirectlyDownLatticeNo(latticeNo);
            }
        }
        if (this.checkDevice(response, item, true)) {
            item.setModifyTime(new Date());
            item.setWcsMac(StringUtil.upperCase((String)item.getWcsMac()));
            int i = this.deviceService.update(item);
            if (i > 0) {
                if (null != device && !device.getDeviceName().equals(item.getDeviceName())) {
                    this.operationTableService.updateDeviceByOldDeviceId(item, device.getDeviceId());
                    this.latticeService.updateDeviceNameByDeviceId(item.getDeviceName(), device.getDeviceId());
                    this.schemeService.updateDeviceNameByDeviceId(item.getDeviceName(), device.getDeviceId());
                    this.printDeviceService.updateDeviceNameByDeviceId(item.getDeviceName(), device.getDeviceId());
                }
                if (null != device && !item.getInOutFlag().equals(device.getInOutFlag()) && !"3".equals(item.getInOutFlag())) {
                    this.operationTableService.updateInOutFlagByDeviceId(item);
                }
                response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                response.setRespMessage("\u4fee\u6539\u6210\u529f");
            } else {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u4fee\u6539\u5931\u8d25");
            }
        }
        return response;
    }

    private void processEndLine(TExpAutoDevice item) {
        List list;
        if (item.getSortingType() != null && EndLineSortingTypeEnum.ARTIFICIAL.getType() == item.getSortingType().intValue()) {
            item.setSupplier("");
            item.setWcsIp("");
            item.setWcsPort("");
        }
        if (StringUtils.isNotBlank((CharSequence)item.getAdapterMatrix()) && !"\u65e0".equals(item.getAdapterMatrix()) && !CollectionUtils.isEmpty((Collection)(list = this.deviceService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TExpAutoDevice::getDeviceName, (Object)item.getAdapterMatrix())).eq(TExpAutoDevice::getDeviceType, (Object)"2"))))) {
            item.setEndLineMatchMatrixId(((TExpAutoDevice)list.get(0)).getDeviceId());
        }
    }

    private boolean checkDevice(HttpBaseResponse response, TExpAutoDevice item, boolean isUpdate) {
        List deviceByIpPort;
        boolean idOk;
        AutoDeviceTypeEnum deviceTypeEnum = AutoDeviceTypeEnum.getEnumByType((String)item.getDeviceType());
        if (deviceTypeEnum == null) {
            response.setRespCode(ResponseTypeEnum.UNKNOW_BASE_DATA.getRespCode());
            response.setRespMessage("\u9519\u8bef\u7684\u8bbe\u5907\u7c7b\u578b\uff1a" + item.getDeviceType());
            return false;
        }
        String id = item.getId();
        TExpAutoDevice deviceByName = this.deviceService.selectByDeviceName(item);
        if (null != deviceByName && (!isUpdate || isUpdate && !id.equals(deviceByName.getId()))) {
            response.setRespCode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
            response.setRespMessage("\u5b58\u5728\u76f8\u540c\u7684\u8bbe\u5907\u540d\u79f0");
            return false;
        }
        if (!isUpdate && !(idOk = this.deviceService.checkDeviceId(item.getDeviceType(), item.getDeviceId(), true))) {
            Pair newDeviceId = this.deviceService.generateDeviceId(item.getDeviceType());
            if (newDeviceId == null) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u81ea\u52a8\u751f\u6210\u8bbe\u5907\u7f16\u7801\u5931\u8d25");
                return false;
            }
            item.setDeviceId((String)newDeviceId.getRight());
            item.setSerialCode((Integer)newDeviceId.getLeft());
        }
        if (StringUtils.isNotBlank((CharSequence)item.getWcsIp()) && StringUtils.isNotBlank((CharSequence)item.getWcsPort()) && !CollectionUtils.isEmpty((Collection)(deviceByIpPort = this.deviceService.selectByIpProt(item)))) {
            if (deviceByIpPort.size() > 1) {
                response.setRespCode(ResponseTypeEnum.UNKNOW_BASE_DATA.getRespCode());
                response.setRespMessage("\u5b58\u5728\u76f8\u540c\u7684\u8bbe\u5907ip\u7aef\u53e3");
                return false;
            }
            if (!isUpdate || isUpdate && !id.equals(((TExpAutoDevice)deviceByIpPort.get(0)).getId())) {
                response.setRespCode(ResponseTypeEnum.UNKNOW_BASE_DATA.getRespCode());
                response.setRespMessage("\u5b58\u5728\u76f8\u540c\u7684\u8bbe\u5907ip\u7aef\u53e3");
                return false;
            }
        }
        return true;
    }

    @HeadTokenVerification
    @PostMapping(value={"/get"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse<PageInfo<TExpAutoDevice>> get(@RequestBody PageInfoEntity pageInfoEntity) {
        HttpBaseResponse response = new HttpBaseResponse();
        PageInfo resultList = null;
        try {
            resultList = this.deviceService.getDeviceInfo(pageInfoEntity);
            response.setRespCode("000");
            response.setRespMessage("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            response.setRespCode("111");
            response.setRespMessage("\u67e5\u8be2\u5931\u8d25");
        }
        response.setData((Object)resultList);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/selectList"}, produces={"application/json"})
    public HttpBaseResponse<List<TExpAutoDevice>> selectList(@RequestBody PageInfoEntity pageInfoEntity) {
        HttpBaseResponse response = new HttpBaseResponse();
        List list = this.deviceService.selectList(pageInfoEntity);
        response.setData((Object)list);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getSerialCode"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u56db\u4f4d\u5e8f\u5217\u53f7", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse getSerialCode() {
        HttpBaseResponse response = new HttpBaseResponse();
        Integer serialCode = null;
        try {
            serialCode = this.deviceService.getSerialCode();
            response.setRespCode("000");
            response.setRespMessage("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            response.setRespCode("111");
            response.setRespMessage("\u67e5\u8be2\u5931\u8d25");
        }
        response.setData((Object)serialCode);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/checkName"}, produces={"application/json"})
    public HttpBaseResponse checkName(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="deviceName") String deviceName) {
        boolean body;
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            body = this.deviceService.checkName(deviceName, deviceId);
            response.setRespCode("000");
            response.setRespMessage("\u8bbe\u5907\u91cd\u590d");
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u51fa\u73b0\u9519\u8bef" + e.getMessage(), (Throwable)e);
            body = false;
            response.setRespCode("111");
            response.setRespMessage("fail");
        }
        response.setData((Object)body);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/checkDeviceId"}, produces={"application/json"})
    public HttpBaseResponse checkDeviceId(@RequestBody String checkDeviceId) {
        HttpBaseResponse response = new HttpBaseResponse();
        boolean body = true;
        try {
            body = this.deviceService.checkDeviceIdDuplicate(checkDeviceId);
            response.setRespCode("000");
            response.setRespMessage("\u8bbe\u5907\u7f16\u53f7\u91cd\u590d");
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u51fa\u73b0\u9519\u8bef" + e.getMessage());
            body = false;
            response.setRespCode("111");
            response.setRespMessage("fail");
        }
        response.setData((Object)body);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/checkMac"}, produces={"application/json"})
    public HttpBaseResponse checkMac(@RequestBody String mac) {
        HttpBaseResponse response = new HttpBaseResponse();
        boolean body = true;
        try {
            String lowerMac = StringUtil.upperCase((String)mac);
            body = this.deviceService.checkMac(lowerMac);
            response.setRespCode("000");
            response.setRespMessage("\u8bbe\u5907\u91cd\u590d");
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u51fa\u73b0\u9519\u8bef" + e.getMessage());
            body = false;
            response.setRespCode("111");
            response.setRespMessage("fail");
        }
        response.setData((Object)body);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/detailed"}, produces={"application/json"})
    public HttpBaseResponse detailed(@RequestBody String deviceId) {
        HttpBaseResponse response = new HttpBaseResponse();
        List list = Lists.newArrayList();
        try {
            list = this.deviceService.getOperationTableByDeviceId(deviceId);
            response.setRespCode("000");
            response.setRespMessage("success");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4ea4\u53c9\u5e26\u4e2d\u7684\u914d\u7f6e\u53f0\u51fa\u9519!" + e.getMessage());
            response.setRespCode("111");
            response.setRespMessage("fail");
        }
        response.setData((Object)list);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getDeviceByName"}, produces={"application/json"})
    public HttpBaseResponse getDeviceByName(@RequestBody String deviceName) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            TExpAutoDevice device = new TExpAutoDevice();
            device.setDeviceName(deviceName);
            TExpAutoDevice dbDevice = this.deviceService.selectByDeviceName(device);
            if (InOutFlagEnum.INANDOUT.codeStr().equals(dbDevice.getInOutFlag())) {
                dbDevice.setAllowInAndOut(Boolean.valueOf(this.checkWhiteListService.allowInAndOut()));
            }
            response.setData((Object)dbDevice);
            response.setRespCode("000");
            response.setRespMessage("success");
        }
        catch (Exception e) {
            logger.error("\u6839\u636edeviceName\u83b7\u53d6\u8bbe\u5907\u51fa\u9519!" + e.getMessage());
            response.setRespCode("111");
            response.setRespMessage("fail");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getDeviceByDeviceId"}, produces={"application/json"})
    public HttpBaseResponse getDeviceByDeviceId(@RequestBody String deviceId) {
        try {
            TExpAutoDevice device = new TExpAutoDevice();
            device.setDeviceId(deviceId);
            TExpAutoDevice dbDevice = this.deviceService.selectByDeviceId(device);
            return HttpBaseResponse.ok((Object)dbDevice);
        }
        catch (Exception e) {
            logger.error("\u6839\u636edeviceName\u83b7\u53d6\u8bbe\u5907\u51fa\u9519!" + e.getMessage());
            return HttpBaseResponse.fail((String)"111", (String)"fail");
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/dumpSql"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u5bfc\u51fasql", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse dumpSql(@RequestParam(value="createUserCode", required=false) String createUserCode, @RequestParam(value="createUserName", required=false) String createUserName) {
        HttpBaseResponse response = new HttpBaseResponse();
        String path = this.backUpDataBaseManager.exportSql();
        if (StringUtils.isBlank((CharSequence)path)) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5bfc\u51fasql\u5f02\u5e38");
            return response;
        }
        String errorMsg = this.backUpDataBaseManager.uploadSqlFile(path, createUserCode, createUserName);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(errorMsg);
            return response;
        }
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/executeSqlLocal"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6267\u884csql\u4ece\u672c\u5730", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse executeSqlLocal() {
        HttpBaseResponse response = new HttpBaseResponse();
        String errorMsg = this.backUpDataBaseManager.executeSqlLocal();
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(errorMsg);
            return response;
        }
        this.schemeService.schemeFullUpload(new String[0]);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/executeSqlRemote"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6267\u884csql\u4ece\u8fdc\u7a0b", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse executeSqlRemote(@RequestBody SqlBackupResponse request) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (request == null || StringUtils.isBlank((CharSequence)request.getFilePath())) {
            response.setRespCode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.PARAM_FAIL.getRespMessage());
            return response;
        }
        String errorMsg = this.backUpDataBaseManager.executeSqlRemote(request);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(errorMsg);
            return response;
        }
        this.schemeService.schemeFullUpload(new String[0]);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return response;
    }

    @HeadTokenVerification
    @GetMapping(value={"/queryBackupSql"})
    @ApiOperation(value="\u4ece\u7ba1\u7406\u5e73\u53f0\u67e5\u8be2\u5907\u4efd\u7684sql\u6587\u4ef6", httpMethod="GET", produces="application/json;charset=UTF-8")
    public HttpBaseResponse queryBackupSql() {
        HttpBaseResponse response = new HttpBaseResponse();
        List list = null;
        try {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            list = this.backUpDataBaseManager.queryBackupByOrgCode(SysPropertiesConfig.getOrgCode());
            response.setData((Object)list);
        }
        catch (ResourceAccessException e) {
            logger.info("\u67e5\u8be2\u5907\u4efdsql\u5f02\u5e38ResourceAccessException", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u5907\u4efdsql\u53ef\u80fd\u8d85\u65f6,\u8bf7\u91cd\u8bd5");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5907\u4efdsql\u5f02\u5e38Exception", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u5907\u4efdsql\u5f02\u5e38");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/deviceActive"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u6fc0\u6d3b\u7801", httpMethod="POST", produces="application/json;charset=UTF-8")
    public HttpBaseResponse deviceActive() {
        HttpBaseResponse response = new HttpBaseResponse();
        List list = this.deviceActiveService.list(null);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        response.setData((Object)list);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/wcsGatewayInfo"})
    public HttpBaseResponse deviceWcsGatewayInfo(@RequestParam(value="wcsIp") String wcsIp, @RequestParam(value="wcsPort") String wcsPort) {
        if (StringUtils.isBlank((CharSequence)wcsIp) || StringUtils.isBlank((CharSequence)wcsPort)) {
            return HttpBaseResponse.ok(Collections.emptyList());
        }
        try {
            AppInfoEntity condition = new AppInfoEntity();
            condition.setAppName("\u4e1a\u52a1\u7f51\u5173");
            condition.setExtend3(wcsIp);
            condition.setExtend4(wcsPort);
            List res = this.appInfoService.selectByCondition(condition);
            if (CollectionUtils.isEmpty((Collection)res)) {
                return HttpBaseResponse.ok(Collections.emptyList());
            }
            List appInfoEntities = this.appInfoService.fillData(res, true, false);
            return HttpBaseResponse.ok((Object)appInfoEntities);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2wcs\u5bf9\u5e94\u7684\u7f51\u5173\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return HttpBaseResponse.ok(Collections.emptyList());
        }
    }
}

