/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.newDevice;

import cn.com.yto56.basic.framework.core.collection.CollUtil;
import cn.com.yto56.basic.framework.core.util.StringUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.Property;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.AutoDeviceTypeEnum;
import com.yto.monitor.adapter.constant.DbStateEnum;
import com.yto.monitor.adapter.constant.LatticeOptTypeEnum;
import com.yto.monitor.adapter.constant.SendStatus;
import com.yto.monitor.adapter.entity.OptShareEntity;
import com.yto.monitor.adapter.entity.PageInfoEntity;
import com.yto.monitor.adapter.entity.excel.CrossBeltLatticeImportBody;
import com.yto.monitor.adapter.entity.excel.EndLineLatticeImportBody;
import com.yto.monitor.adapter.entity.newDevice.TExpAutoDevice;
import com.yto.monitor.adapter.entity.newDevice.TExpLattice;
import com.yto.monitor.adapter.entity.newDevice.TExpLatticeExtend;
import com.yto.monitor.adapter.entity.newDevice.TExpLatticeScheme;
import com.yto.monitor.adapter.entity.request.BatchUpdateLatNoReq;
import com.yto.monitor.adapter.entity.request.BlendPackRequest;
import com.yto.monitor.adapter.entity.request.ExpLatticeQueryParam;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.entity.response.BuildPkgRuleResp;
import com.yto.monitor.adapter.entity.response.DeliverySpotResp;
import com.yto.monitor.adapter.mapper.CountryStationMapper;
import com.yto.monitor.adapter.mapper.CustomerMapper;
import com.yto.monitor.adapter.mapper.EndCodeMapper;
import com.yto.monitor.adapter.mapper.OptShareMapper;
import com.yto.monitor.adapter.mapper.OrgInfoMapper;
import com.yto.monitor.adapter.mapper.WarehouseMapper;
import com.yto.monitor.adapter.mapper.newDevice.ExpLatticeExtendMapper;
import com.yto.monitor.adapter.mapper.newDevice.ExpLatticeMapper;
import com.yto.monitor.adapter.mapper.newDevice.ExpLatticeSchemeMapper;
import com.yto.monitor.adapter.service.ExpLatticeExtendService;
import com.yto.monitor.adapter.service.IExpEmployeeService;
import com.yto.monitor.adapter.service.IExpEndCodeService;
import com.yto.monitor.adapter.service.checkData.OnlineCheckDataService;
import com.yto.monitor.adapter.service.impl.newDevice.CrossBeltLatticeService;
import com.yto.monitor.adapter.service.impl.newDevice.EndLineLatticeService;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.adapter.service.newDevice.IExpLatticeSchemeService;
import com.yto.monitor.adapter.service.newDevice.IExpLatticeService;
import com.yto.monitor.adapter.service.newDevice.SegmentCodeChangeService;
import com.yto.monitor.adapter.utils.LatticeUtil;
import com.yto.monitor.adapter.utils.WebRequestUtil;
import com.yto.monitor.adapter.utils.excel.CustomizeReadListener;
import com.yto.monitor.adapter.utils.excel.ExcelUtil;
import com.yto.monitor.common.constant.InOutFlagEnum;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.Page;
import com.yto.monitor.common.entity.base.CountryStationEntity;
import com.yto.monitor.common.entity.base.CustomerResp;
import com.yto.monitor.common.entity.base.Employee;
import com.yto.monitor.common.entity.base.EndCodeEntity;
import com.yto.monitor.common.entity.base.OrgInfoEntity;
import com.yto.monitor.common.entity.base.Warehouse;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.entity.routesmerge.RequestPage;
import com.yto.monitor.common.exception.ImportExcelException;
import com.yto.monitor.common.http.ClientHttpResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u683c\u53e3\u914d\u7f6e\u9875\u9762"})
@RequestMapping(value={"/Yto_MonitorGateway/lattice"})
public class ExpLatticeMapController {
    private static final Logger logger = LoggerFactory.getLogger(ExpLatticeMapController.class);
    @Autowired
    private IExpLatticeService latticeService;
    @Autowired
    private CrossBeltLatticeService crossBeltLatticeService;
    @Autowired
    private EndLineLatticeService endLineLatticeService;
    @Autowired
    private IExpLatticeSchemeService latticeSchemeService;
    @Autowired
    private ExpLatticeSchemeMapper latticeSchemeMapper;
    @Autowired
    private IExpAutoDeviceService deviceService;
    @Autowired
    private OrgInfoMapper orgInfoMapper;
    @Autowired
    private ExpLatticeMapper latticeMapper;
    @Autowired
    private ExpLatticeExtendMapper latticeExtendMapper;
    @Autowired
    private IExpEmployeeService employeeService;
    @Autowired
    private EndCodeMapper endCodeMapper;
    @Autowired
    private CountryStationMapper countryStationMapper;
    @Autowired
    private OnlineCheckDataService onlineCheckDataService;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private OptShareMapper optShareMapper;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private WarehouseMapper warehouseMapper;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;
    @Autowired
    private IExpEndCodeService endCodeService;
    @Autowired
    private ExpLatticeExtendService latticeExtendService;
    @Autowired
    private SegmentCodeChangeService segmentCodeChangeService;
    public static final String BATCH_FLAG_DELAY = "1";
    public static final String BATCH_FLAG_ALL_PROCESS = "2";
    public static final String BATCH_FLAG_UNLOAD = "3";
    public static final String BATCH_FLAG_IN_OUT_INTERCEPT = "4";
    public static final String BATCH_FLAG_ALL_FRONT_INTERCEPT = "5";

    @HeadTokenVerification
    @PostMapping(value={"/getList"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868\u6570\u636e", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse getList(@RequestBody RequestPage<ExpLatticeQueryParam> r) {
        this.latticeService.deleteBatchInvalidExtend();
        ClientHttpResponse resp = new ClientHttpResponse();
        ExpLatticeQueryParam param = (ExpLatticeQueryParam)r.getCondition();
        PageInfo dataByPage = new PageInfo();
        Page page = new Page();
        if (1 == param.getFlag()) {
            dataByPage = this.latticeSchemeService.getList(param, r.getPage());
        } else if (2 == param.getFlag()) {
            if (StringUtil.isNotBlank((CharSequence)param.getLatticeNo()) && param.getLatticeNo().length() < 3) {
                param.setLatticeNo(StringUtil.leftPad((String)param.getLatticeNo(), (int)3, (char)'0'));
            }
            dataByPage = this.latticeService.getList(param, r.getPage());
        } else {
            resp.setRespcode("103");
            resp.setRespMessage("\u67e5\u8be2\u7c7b\u578b\u975e\u6cd5");
            return resp;
        }
        page.setPageData(dataByPage.getList());
        page.setTotal(dataByPage.getTotal());
        page.setPageNo(dataByPage.getPageNum());
        resp.setRespcode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        resp.setData((Object)page);
        return resp;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getSegmentCodeChange"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u6bb5\u7801\u53d8\u66f4\u6570\u636e", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse getSegmentCodeChange(@RequestBody RequestPage<ExpLatticeQueryParam> r) {
        HttpBaseResponse resp = new HttpBaseResponse();
        ExpLatticeQueryParam param = (ExpLatticeQueryParam)r.getCondition();
        logger.info("\u67e5\u8be2\u6bb5\u7801\u53d8\u66f4\u6570\u636e\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
        Page page = new Page();
        List segmentCodeChange = new ArrayList();
        if (!StringUtils.isNotBlank((String)param.getDeviceName()) || !StringUtils.isNotBlank((String)param.getSchemeNo())) {
            resp.setRespCode("103");
            resp.setRespMessage("\u67e5\u8be2\u7c7b\u578b\u975e\u6cd5");
            return resp;
        }
        segmentCodeChange = this.segmentCodeChangeService.getSegmentCodeChange(param);
        page.setPageData(segmentCodeChange);
        page.setTotal((long)segmentCodeChange.size());
        resp.setRespCode("000");
        resp.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        resp.setData((Object)page);
        logger.info("\u67e5\u8be2\u6bb5\u7801\u53d8\u66f4\u6570\u636e\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)resp));
        return resp;
    }

    @HeadTokenVerification
    @PostMapping(value={"/updateSegmentCodeChange"}, produces={"application/json"})
    @ApiOperation(value="\u6bb5\u7801\u53d8\u66f4\u6570\u636e\u4fee\u6539\u63a5\u53e3", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse updateSegmentCodeChange(@RequestBody Map<String, String> request) {
        logger.info("\u6bb5\u7801\u53d8\u66f4\u6570\u636e\u4fee\u6539\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(request));
        HttpBaseResponse baseResponse = this.segmentCodeChangeService.update(request.get("oldId"));
        this.latticeService.cloneExtendData(request.get("oldId"), request.get("newId"));
        return baseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/deleteSegmentCodeChange"}, produces={"application/json"})
    @ApiOperation(value="\u6bb5\u7801\u53d8\u66f4\u6570\u636e\u5220\u9664\u63a5\u53e3", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse deleteSegmentCodeChange(@RequestBody TExpLattice lattice) {
        logger.info("\u6bb5\u7801\u53d8\u66f4\u6570\u636e\u5220\u9664\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)lattice));
        HttpBaseResponse baseResponse = this.segmentCodeChangeService.delete(lattice);
        return baseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/exportData"}, produces={"application/json"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="POST", consumes="application/json")
    public List<TExpLattice> exportData(@RequestBody RequestPage<ExpLatticeQueryParam> r) {
        ExpLatticeQueryParam param = (ExpLatticeQueryParam)r.getCondition();
        List list = this.latticeService.getListByCondition(param);
        return list;
    }

    @HeadTokenVerification
    @PostMapping(value={"/exportFile"}, produces={"application/json"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="POST", consumes="application/json")
    public void exportData(HttpServletResponse response, @RequestBody RequestPage<ExpLatticeQueryParam> r) {
        ExpLatticeQueryParam param = (ExpLatticeQueryParam)r.getCondition();
        Integer deviceType = param.getDeviceType();
        AutoDeviceTypeEnum enumByType = AutoDeviceTypeEnum.getEnumByType((Integer)deviceType);
        if (enumByType == null) {
            return;
        }
        if (enumByType == AutoDeviceTypeEnum.CROSSBELT) {
            this.crossBeltLatticeService.exportExcel(response, param);
        } else if (enumByType == AutoDeviceTypeEnum.END_LINE) {
            this.endLineLatticeService.exportExcel(response, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HeadTokenVerification
    @PostMapping(value={"/importCrossBeltLattice"}, produces={"application/json"})
    public HttpBaseResponse importCrossBeltLattice(@RequestParam(value="file") MultipartFile file, @RequestParam(value="jsonData") String jsonData) {
        HttpBaseResponse httpBaseResponse;
        HttpBaseResponse response = new HttpBaseResponse();
        long l = System.currentTimeMillis();
        logger.info("\u6536\u5230\u4ea4\u53c9\u5e26\u683c\u53e3\u5bfc\u5165\u8bf7\u6c42 fileName\uff1a{} jsonData\uff1a{}", (Object)file.getOriginalFilename(), (Object)jsonData);
        ExcelReader excelReader = null;
        try {
            excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            CustomizeReadListener latticeReadListener = new CustomizeReadListener(CrossBeltLatticeImportBody.class, ExcelUtil.HEAD_VALIDATOR_CROSSBELT_LATTICE, ExcelUtil.BODY_VALIDATOR_CROSSBELT_LATTICE);
            ReadSheet sheet = ((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)latticeReadListener)).build();
            excelReader.read(new ReadSheet[]{sheet});
            List excelData = latticeReadListener.getExcelData();
            logger.info("\u89e3\u6790\u6570\u636e\u5b8c\u6210 \u6570\u91cf\uff1a{} \u8017\u65f6\uff1a{}", (Object)excelData.size(), (Object)(System.currentTimeMillis() - l));
            if (excelData.size() == 0) {
                response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
                response.setRespMessage("Excel\u4e2d\u65e0\u6570\u636e");
                HttpBaseResponse httpBaseResponse2 = response;
                return httpBaseResponse2;
            }
            long l1 = System.currentTimeMillis();
            TExpLattice tExpLattice = (TExpLattice)JSONObject.parseObject((String)jsonData, TExpLattice.class);
            tExpLattice.setDeviceType(Integer.valueOf(AutoDeviceTypeEnum.CROSSBELT.getTypeInt()));
            List lattices = this.crossBeltLatticeService.convertExcelDataToObj(excelData, tExpLattice);
            logger.info("\u6570\u636e\u8f6c\u5b9e\u4f53\u5b8c\u6210 \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - l1));
            boolean ok = this.crossBeltLatticeService.checkImportData(response, lattices);
            if (!ok) {
                HttpBaseResponse httpBaseResponse3 = response;
                return httpBaseResponse3;
            }
            long l2 = System.currentTimeMillis();
            if (!this.latticeService.insertExportData(lattices)) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u6570\u636e\u5165\u5e93\u5931\u8d25");
                HttpBaseResponse httpBaseResponse4 = response;
                return httpBaseResponse4;
            }
            logger.info("\u6570\u636e\u5165\u5e93\u5b8c\u6210 \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - l2));
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6210\u529f");
            logger.info("\u5bfc\u5165\u683c\u53e3\u6210\u529f \u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - l));
            HttpBaseResponse httpBaseResponse5 = response;
            return httpBaseResponse5;
        }
        catch (ImportExcelException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getErrorMessage());
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u683c\u53e3\u660e\u7ec6\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25");
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        finally {
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/importLatticeMapping"}, produces={"application/json"})
    public HttpBaseResponse importLatticeMapping(@RequestBody List<TExpLattice> latticeMapItem) {
        HttpBaseResponse resp = new HttpBaseResponse();
        logger.info("\u5f00\u59cb\u5bfc\u5165\u683c\u53e3\u65b9\u6848,\u6570\u636e\u6761\u6570:" + latticeMapItem.size());
        long startTime = System.currentTimeMillis();
        boolean pass = this.latticeService.checkImportData(resp, latticeMapItem);
        if (pass) {
            boolean ok = this.latticeService.insertExportData(latticeMapItem);
            if (ok) {
                resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
                resp.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            } else {
                resp.setRespMessage(ResponseTypeEnum.SAVE_FAIL.getRespMessage());
                resp.setRespCode(ResponseTypeEnum.SAVE_FAIL.getRespCode());
            }
        }
        long cost = System.currentTimeMillis() - startTime;
        logger.info("\u683c\u53e3\u65b9\u6848\u603b\u8017\u65f6(\u542b\u6821\u9a8c/\u66f4\u65b0\u8017\u65f6):" + cost);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HeadTokenVerification
    @PostMapping(value={"/importEndLineLattice"}, produces={"application/json"})
    public HttpBaseResponse importEndLineLattice(@RequestParam(value="file") MultipartFile file, @RequestParam(value="jsonData") String jsonData) {
        HttpBaseResponse httpBaseResponse;
        logger.info("\u6536\u5230\u672b\u7aef\u7ebf\u683c\u53e3\u660e\u7ec6\u5bfc\u5165\uff1a{}", (Object)jsonData);
        HttpBaseResponse response = new HttpBaseResponse();
        long l = System.currentTimeMillis();
        ExcelReader excelReader = null;
        try {
            excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            CustomizeReadListener latticeReadListener = new CustomizeReadListener(EndLineLatticeImportBody.class, ExcelUtil.HEAD_VALIDATOR_ENDLINE_LATTICE, ExcelUtil.BODY_VALIDATOR_ENDLINE_LATTICE);
            ReadSheet sheet = ((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)latticeReadListener)).build();
            excelReader.read(new ReadSheet[]{sheet});
            List excelData = latticeReadListener.getExcelData();
            logger.info("\u89e3\u6790\u6570\u636e\u5b8c\u6210 \u6570\u91cf\uff1a{} \u8017\u65f6\uff1a{}", (Object)excelData.size(), (Object)(System.currentTimeMillis() - l));
            if (excelData.size() == 0) {
                response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
                response.setRespMessage("Excel\u4e2d\u65e0\u6570\u636e");
                HttpBaseResponse httpBaseResponse2 = response;
                return httpBaseResponse2;
            }
            long l1 = System.currentTimeMillis();
            TExpLattice tExpLattice = (TExpLattice)JSONObject.parseObject((String)jsonData, TExpLattice.class);
            List lattices = this.endLineLatticeService.convertExcelDataToObj(excelData, tExpLattice);
            logger.info("\u6570\u636e\u8f6c\u5b9e\u4f53\u5b8c\u6210 \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - l1));
            BaseResp baseResp = this.endLineLatticeService.importDataCheck(lattices);
            if (!"000".equals(baseResp.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                HttpBaseResponse httpBaseResponse3 = response;
                return httpBaseResponse3;
            }
            List data = (List)baseResp.getData();
            this.endLineLatticeService.saveImportData(data);
            String latticeSchemeId = ((TExpLattice)data.get(0)).getLatticeSchemeId();
            this.latticeService.updateDestCount(latticeSchemeId);
            this.latticeService.updateLatticeCount(latticeSchemeId);
            this.latticeSchemeService.schemeFullUpload(new String[]{latticeSchemeId});
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u6210\u529f");
            logger.info("\u5bfc\u5165\u672b\u7aef\u7ebf\u683c\u53e3\u6210\u529f \u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - l));
            HttpBaseResponse httpBaseResponse4 = response;
            return httpBaseResponse4;
        }
        catch (ImportExcelException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getErrorMessage());
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        catch (Exception e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u5bfc\u5165\u5931\u8d25");
            httpBaseResponse = response;
            return httpBaseResponse;
        }
        finally {
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/addLattice"}, produces={"application/json"})
    @ApiOperation(value="\u589e\u52a0\u683c\u53e3", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse addLattice(@RequestBody TExpLattice lattice) {
        int result;
        String checkLatticeNoMsg;
        String errorMsg;
        lattice.setCreateUserCode(WebRequestUtil.getUserCode());
        lattice.setCreateUserName(WebRequestUtil.getUserName());
        lattice.setModifyUserCode(WebRequestUtil.getUserCode());
        lattice.setModifyUserName(WebRequestUtil.getUserName());
        Date date = new Date();
        lattice.setCreateTime(date);
        lattice.setModifyTime(date);
        logger.info("\u6536\u5230\u65b0\u589e\u683c\u53e3\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)lattice));
        HttpBaseResponse response = new HttpBaseResponse();
        if (AutoDeviceTypeEnum.CROSSBELT.getTypeInt() == lattice.getDeviceType().intValue() && StringUtils.isNotBlank((String)(errorMsg = this.crossBeltLatticeService.checkLatticeOpt(lattice.getOptFlag())))) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(errorMsg);
            return response;
        }
        this.latticeService.removeBlank(lattice);
        String afterLatNo = this.latticeService.transferLatticeNo(lattice.getLatticeNo());
        lattice.setLatticeNo(afterLatNo);
        String oldId = lattice.getId();
        String newId = UUID.randomUUID().toString();
        lattice.setId(newId);
        TExpAutoDevice device = new TExpAutoDevice();
        device.setDeviceName(lattice.getDeviceName());
        TExpAutoDevice dbDevice = this.deviceService.selectByDeviceName(device);
        lattice.setDeviceId(dbDevice.getDeviceId());
        TExpLatticeScheme scheme = new TExpLatticeScheme();
        scheme.setDeviceName(lattice.getDeviceName());
        scheme.setSchemeNo(lattice.getLatticeScheme());
        TExpLatticeScheme dbScheme = this.latticeSchemeService.selectByDeviceAndSchemeNo(scheme);
        if (null != dbScheme) {
            lattice.setLatticeSchemeId(dbScheme.getId());
        }
        if ((checkLatticeNoMsg = this.latticeService.checkLatticeNo(lattice.getLatticeNo(), true)) != null) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(checkLatticeNoMsg);
            return response;
        }
        BaseResp userProfileBaseResp = this.latticeService.checkAndSetUserProfile(lattice, true);
        if (!"000".equals(userProfileBaseResp.getCode())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(userProfileBaseResp.getMsg());
            return response;
        }
        if (!LatticeUtil.threeCodeCheck((String)lattice.getThreeCode(), (boolean)LatticeUtil.needCheckThreeCodeEmpty((String)dbDevice.getDeviceType()), (boolean)LatticeUtil.threeCodeNeedCheck((String)dbDevice.getDeviceType(), (String)lattice.getOptFlag()))) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4e09\u6bb5\u7801\u683c\u5f0f\u9519\u8bef");
            return response;
        }
        BaseResp checkThreeCodeRes = this.latticeService.checkThreeCode(lattice, false);
        if (StringUtils.isNotBlank((String)lattice.getThreeCode()) && !"000".equals(checkThreeCodeRes.getCode())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(checkThreeCodeRes.getMsg());
            return response;
        }
        if (StringUtils.isBlank((String)lattice.getThreeCode()) && !this.checkDestOrgAnd3CodeNull(lattice, true)) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4e09\u6bb5\u7801\u4e3a\u7a7a\u65f6\u76ee\u7684\u5730\u4e0d\u80fd\u91cd\u590d");
            return response;
        }
        String buildPkgErrorMsg = this.checkBuildPkgLattice(dbDevice.getDeviceType(), lattice, true);
        if (StringUtils.isNotBlank((String)buildPkgErrorMsg)) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(buildPkgErrorMsg);
            return response;
        }
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.WAREHOUSE_SCAN.getType()) && (StringUtils.isBlank((String)lattice.getEmpCode()) || StringUtils.isBlank((String)lattice.getThreeCode()))) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(LatticeOptTypeEnum.WAREHOUSE_SCAN.getName() + "\u4e1a\u52a1\u5458\u548c\u4e09\u6bb5\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return response;
        }
        if (StringUtils.isNotBlank((String)lattice.getEmpCode())) {
            if (this.commonConfig.getCheckEmp3Code() == 1 && !BATCH_FLAG_DELAY.equals(lattice.getReplaceDispatch())) {
                boolean emp3Code = false;
                if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.WAREHOUSE_SCAN.getType())) {
                    Warehouse warehouse;
                    String[] split = lattice.getThreeCode().split("-");
                    String fourCode = split[split.length - 1].trim();
                    LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Warehouse::getEmpCode, (Object)lattice.getEmpCode())).eq(Warehouse::getThreeCode, (Object)fourCode);
                    List warehouses = this.warehouseMapper.selectList((Wrapper)eq);
                    if (!CollectionUtils.isEmpty((Collection)warehouses) && StringUtils.isNotBlank((String)(warehouse = (Warehouse)warehouses.get(0)).getWarehouseCode()) && warehouse.getWarehouseCode().equals(lattice.getDestOrgCode())) {
                        emp3Code = true;
                    }
                } else if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.DISPATCH.getType())) {
                    Pair checkResult = this.crossBeltLatticeService.checkDispatchLatticeEmp3code(lattice.getDestOrgCode(), lattice.getEmpCode(), lattice.getThreeCode());
                    emp3Code = (Boolean)checkResult.getLeft();
                    lattice.setDestSource((String)checkResult.getRight());
                } else {
                    emp3Code = StringUtils.isNotBlank((String)lattice.getOptFlag()) && (lattice.getOptFlag().contains(LatticeOptTypeEnum.STATION.getType()) || lattice.getOptFlag().contains(LatticeOptTypeEnum.COUNTRY_STATION.getType()) || lattice.getOptFlag().contains(LatticeOptTypeEnum.NORMAL.getType())) ? true : this.onlineCheckDataService.checkEmp3Code(lattice.getDestOrgCode(), lattice.getEmpCode(), lattice.getThreeCode());
                }
                if (!emp3Code) {
                    response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    response.setRespMessage("\u4e1a\u52a1\u5458\u548c\u4e09\u6bb5\u7801\u4e0d\u5339\u914d");
                    return response;
                }
            } else {
                this.setDestSource(dbDevice, lattice);
            }
        }
        if (StringUtils.isNotBlank((String)lattice.getEmpCode())) {
            Employee em = this.employeeService.selectByCode(lattice.getEmpCode());
            if (em == null) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u5458\u5de5\u7f16\u53f7\u4e0d\u5408\u6cd5,\u65e0\u6548\u6216\u7981\u7528");
                return response;
            }
            lattice.setEmpName(em.getName());
        }
        if (StringUtils.isNotBlank((String)lattice.getDestOrgCode())) {
            BaseResp baseResp;
            QueryWrapper qw = new QueryWrapper();
            if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && (lattice.getOptFlag().contains(LatticeOptTypeEnum.DISPATCH.getType()) || lattice.getOptFlag().contains(LatticeOptTypeEnum.COUNTRY_STATION.getType()))) {
                qw.lambda().eq(EndCodeEntity::getStationCode, (Object)lattice.getDestOrgCode());
            } else {
                qw.lambda().eq(EndCodeEntity::getEndCodeId, (Object)lattice.getDestOrgCode());
            }
            List endCodelist = this.endCodeMapper.selectList((Wrapper)qw);
            QueryWrapper dest = new QueryWrapper();
            dest.lambda().eq(CountryStationEntity::getCountryStationCode, (Object)lattice.getDestOrgCode());
            List countryStationList = this.countryStationMapper.selectList((Wrapper)dest);
            OrgInfoEntity orgInfoEntity = this.orgInfoMapper.getOrgInfoByCode(lattice.getDestOrgCode());
            List warehouses = this.warehouseMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(Warehouse::getWarehouseCode, (Object)lattice.getDestOrgCode()));
            if (null == orgInfoEntity && endCodelist.isEmpty() && countryStationList.isEmpty() && CollectionUtils.isEmpty((Collection)warehouses)) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u76ee\u7684\u5730\u7f16\u53f7\u4e0d\u5408\u6cd5,\u65e0\u6548\u6216\u7981\u7528");
                return response;
            }
            if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.STATION.getType()) && !"000".equals((baseResp = this.crossBeltLatticeService.checkEndCodeId2ThreeCode(lattice)).getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            if (StringUtils.isBlank((String)lattice.getDestOrgName())) {
                if (null != orgInfoEntity) {
                    lattice.setDestOrgName(orgInfoEntity.getName());
                } else if (!endCodelist.isEmpty()) {
                    lattice.setDestOrgName(((EndCodeEntity)endCodelist.get(0)).getEndCodeName());
                } else if (!countryStationList.isEmpty()) {
                    lattice.setDestOrgName(((CountryStationEntity)countryStationList.get(0)).getCountryStationName());
                }
            }
        }
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.COUNTRY_STATION.getType()) && StringUtils.isNotBlank((String)lattice.getThreeCode())) {
            BaseResp countryStationRes = this.latticeService.getCountryStation(lattice.getEmpCode(), null, lattice.getThreeCode());
            if (!"000".equals(countryStationRes.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(countryStationRes.getMsg());
                return response;
            }
            lattice.setDestOrgCode((String)((Map)countryStationRes.getData()).get("code"));
            lattice.setDestOrgName((String)((Map)countryStationRes.getData()).get("name"));
        }
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.UPLOAD.getType()) && !this.latticeService.checkDestByLineSection(lattice.getDestOrgCode())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u76ee\u7684\u5730\u4e0d\u5728\u7ebf\u8def\u4e0a");
            return response;
        }
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.WAREHOUSE_SCAN.getType())) {
            String[] split = lattice.getThreeCode().split("-");
            String threeCode = split[split.length - 1].trim();
            List warehouses = this.warehouseMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Warehouse::getWarehouseCode, (Object)lattice.getDestOrgCode())).eq(Warehouse::getThreeCode, (Object)threeCode));
            if (!CollectionUtils.isEmpty((Collection)warehouses)) {
                lattice.setWarehouseOrgCode(((Warehouse)warehouses.get(0)).getOrgCode());
                lattice.setWarehouseOrgName(((Warehouse)warehouses.get(0)).getOrgName());
            }
        }
        if ((result = this.latticeService.insert(lattice)) == 1) {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u65b0\u589e\u6210\u529f");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("oldId", oldId);
            map.put("newId", newId);
            response.setData(map);
            return response;
        }
        response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
        response.setRespMessage("\u65b0\u589e\u5931\u8d25");
        return response;
    }

    private void setDestSource(TExpAutoDevice device, TExpLattice lattice) {
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.DISPATCH.getType()) && BATCH_FLAG_DELAY.equals(device.getDeviceType())) {
            Pair checkResult = this.crossBeltLatticeService.checkDispatchLatticeEmp3code(lattice.getDestOrgCode(), lattice.getEmpCode(), lattice.getThreeCode());
            lattice.setDestSource((String)checkResult.getRight());
        }
    }

    private String checkBuildPkgLattice(String deviceType, TExpLattice lattice, boolean isAdd) {
        if (BATCH_FLAG_DELAY.equals(deviceType) && StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.BUILD_PACK.getType()) && InOutFlagEnum.OUT.codeStr().equals(lattice.getInOutFlag())) {
            String[] latNoList;
            String threeCode = lattice.getThreeCode();
            if (StringUtils.isBlank((String)threeCode)) {
                return "\u4e09\u6bb5\u7801\u4e3a\u7a7a";
            }
            BuildPkgRuleResp ruleResp = this.crossBeltLatticeService.getOutBuildPkgLatticeDestOrg(threeCode, lattice.getDeviceId());
            if (ruleResp == null) {
                return "\u7ec4\u7ec7\u5efa\u5305\u89c4\u5219\u4e0d\u5b58\u5728";
            }
            lattice.setPackageFirstCode(ruleResp.getPackageFirstCode());
            for (String latNo : latNoList = lattice.getLatticeNo().split(",")) {
                List list = this.latticeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new Property[]{TExpLattice::getPackageFirstCode, TExpLattice::getThreeCode, TExpLattice::getId}).eq(TExpLattice::getLatticeSchemeId, (Object)lattice.getLatticeSchemeId())).like(TExpLattice::getOptFlag, (Object)LatticeOptTypeEnum.BUILD_PACK.getType())).ne(TExpLattice::getPackageFirstCode, (Object)lattice.getPackageFirstCode())).like(TExpLattice::getLatticeNo, (Object)latNo));
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                HashSet<String> threeCodeSet = new HashSet<String>();
                for (TExpLattice tExpLattice : list) {
                    if (!isAdd && tExpLattice.getId().equals(lattice.getId())) continue;
                    threeCodeSet.add(tExpLattice.getThreeCode());
                }
                if (CollectionUtils.isEmpty(threeCodeSet)) continue;
                return "\u683c\u53e3\u53f7[" + latNo + "]\u5df2\u914d\u7f6e\u8fc7\u51fa\u6e2f\u5efa\u5305\uff0c\u4e09\u6bb5\u7801\u4e3a\u3010" + StringUtils.join(threeCodeSet, (String)",") + "\u3011\uff0c\u4e0e\u5f53\u524d\u63d0\u4ea4\u4e09\u6bb5\u7801\u3010" + lattice.getThreeCode() + "\u3011\u5305\u7b7e\u7801\u4e0d\u4e00\u81f4\uff0c\u63d0\u4ea4\u5931\u8d25";
            }
        }
        return null;
    }

    private boolean checkDestOrgAnd3CodeNull(TExpLattice item, boolean isUpdate) {
        String id = item.getId();
        TExpLattice lattice = this.latticeService.selectBySchemeAndDestOrgAnd3CodeNull(item);
        return null == lattice || isUpdate && (!isUpdate || id.equals(lattice.getId()));
    }

    private boolean checkLatticeNo(String latticeNo) {
        List<String> latList = Arrays.asList(latticeNo.replace(";", ",").split(","));
        HashSet<String> latSet = new HashSet<String>(latList);
        return latList.size() == latSet.size();
    }

    @PostMapping(value={"/getDispatchDestOrg"})
    public HttpBaseResponse<Map<String, String>> getDispatchDestOrg(@RequestBody TExpLattice lattice, @RequestParam(value="empBelongOrg", required=false) String empBelongOrg) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (StringUtils.isBlank((String)lattice.getOptFlag()) || !lattice.getOptFlag().contains(LatticeOptTypeEnum.DISPATCH.getType()) || StringUtils.isBlank((String)lattice.getThreeCode()) || StringUtils.isBlank((String)lattice.getEmpCode())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            return response;
        }
        try {
            Employee employee;
            if (StringUtils.isBlank((String)empBelongOrg) && (employee = this.employeeService.selectByCode(lattice.getEmpCode())) != null) {
                empBelongOrg = employee.getBelongOrg();
            }
            Map destOrg = this.crossBeltLatticeService.getDispatchLatticeDestOrg(empBelongOrg, lattice.getEmpCode(), lattice.getThreeCode());
            response.setData((Object)destOrg);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        }
        catch (Exception e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u6d3e\u4ef6\u76ee\u7684\u5730\u5f02\u5e38");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/delLattice"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u683c\u53e3\u6620\u5c04", httpMethod="POST", consumes="application/json")
    public String delLattice(@RequestParam String id) {
        logger.info("\u6536\u5230\u5355\u6761\u5220\u9664\u683c\u53e3\u8bf7\u6c42\uff1a" + id);
        int result = this.latticeService.delete(id);
        if (result == 1) {
            return "success";
        }
        return "failure";
    }

    @HeadTokenVerification
    @PostMapping(value={"/delBatchLattice/{ids}"}, produces={"application/json"})
    public String delBatchLatticeMapping(@PathVariable String ids) {
        logger.info("\u6536\u5230\u6279\u91cf\u5220\u9664\u683c\u53e3\u8bf7\u6c42" + ids);
        boolean ok = this.latticeService.batchDel(ids);
        return ok ? "success" : "failure";
    }

    @HeadTokenVerification
    @PostMapping(value={"/updateLattice"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u683c\u53e3\u6620\u5c04", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse updateLattice(@RequestBody TExpLattice lattice) {
        String checkLatticeNoMsg;
        String errorMsg;
        lattice.setModifyUserName(WebRequestUtil.getUserName());
        lattice.setModifyUserCode(WebRequestUtil.getUserCode());
        lattice.setModifyTime(new Date());
        logger.info("\u6536\u5230\u4fee\u6539\u683c\u53e3\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)lattice));
        HttpBaseResponse response = new HttpBaseResponse();
        if (AutoDeviceTypeEnum.CROSSBELT.getTypeInt() == lattice.getDeviceType().intValue() && StringUtils.isNotBlank((String)(errorMsg = this.crossBeltLatticeService.checkLatticeOpt(lattice.getOptFlag())))) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(errorMsg);
            return response;
        }
        this.latticeService.removeBlank(lattice);
        String afterLatNo = this.latticeService.transferLatticeNo(lattice.getLatticeNo());
        lattice.setLatticeNo(afterLatNo);
        TExpAutoDevice device = new TExpAutoDevice();
        device.setDeviceName(lattice.getDeviceName());
        TExpAutoDevice dbDevice = this.deviceService.selectByDeviceName(device);
        lattice.setDeviceId(dbDevice.getDeviceId());
        TExpLatticeScheme scheme = new TExpLatticeScheme();
        scheme.setDeviceName(lattice.getDeviceName());
        scheme.setSchemeNo(lattice.getLatticeScheme());
        TExpLatticeScheme dbScheme = this.latticeSchemeService.selectByDeviceAndSchemeNo(scheme);
        if (null != dbScheme) {
            lattice.setLatticeSchemeId(dbScheme.getId());
        }
        if ((checkLatticeNoMsg = this.latticeService.checkLatticeNo(lattice.getLatticeNo(), true)) != null) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(checkLatticeNoMsg);
            return response;
        }
        BaseResp userProfileBaseResp = this.latticeService.checkAndSetUserProfile(lattice, true);
        if (!"000".equals(userProfileBaseResp.getCode())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(userProfileBaseResp.getMsg());
            return response;
        }
        if (!LatticeUtil.threeCodeCheck((String)lattice.getThreeCode(), (boolean)LatticeUtil.needCheckThreeCodeEmpty((String)dbDevice.getDeviceType()), (boolean)LatticeUtil.threeCodeNeedCheck((String)dbDevice.getDeviceType(), (String)lattice.getOptFlag()))) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4e09\u6bb5\u7801\u683c\u5f0f\u9519\u8bef");
            return response;
        }
        BaseResp checkThreeCodeRes = this.latticeService.checkThreeCode(lattice, true);
        if (StringUtils.isNotBlank((String)lattice.getThreeCode()) && !"000".equals(checkThreeCodeRes.getCode())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(checkThreeCodeRes.getMsg());
            return response;
        }
        String buildPkgErrorMsg = this.checkBuildPkgLattice(dbDevice.getDeviceType(), lattice, false);
        if (StringUtils.isNotBlank((String)buildPkgErrorMsg)) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(buildPkgErrorMsg);
            return response;
        }
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.WAREHOUSE_SCAN.getType()) && (StringUtils.isBlank((String)lattice.getEmpCode()) || StringUtils.isBlank((String)lattice.getThreeCode()))) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(LatticeOptTypeEnum.WAREHOUSE_SCAN.getName() + "\u4e1a\u52a1\u5458\u548c\u4e09\u6bb5\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return response;
        }
        if (StringUtils.isBlank((String)lattice.getThreeCode()) && !this.checkDestOrgAnd3CodeNull(lattice, true)) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4e09\u6bb5\u7801\u4e3a\u7a7a\u65f6\u76ee\u7684\u5730\u4e0d\u80fd\u91cd\u590d");
            return response;
        }
        if (StringUtils.isNotBlank((String)lattice.getEmpCode())) {
            Employee em = this.employeeService.selectByCode(lattice.getEmpCode());
            if (em == null) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u5458\u5de5\u7f16\u53f7\u4e0d\u5408\u6cd5,\u65e0\u6548\u6216\u7981\u7528");
                return response;
            }
            lattice.setEmpName(em.getName());
        }
        if (StringUtils.isNotBlank((String)lattice.getDestOrgCode())) {
            BaseResp baseResp;
            QueryWrapper qw = new QueryWrapper();
            if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && (lattice.getOptFlag().contains(LatticeOptTypeEnum.DISPATCH.getType()) || lattice.getOptFlag().contains(LatticeOptTypeEnum.COUNTRY_STATION.getType()))) {
                qw.lambda().eq(EndCodeEntity::getStationCode, (Object)lattice.getDestOrgCode());
            } else {
                qw.lambda().eq(EndCodeEntity::getEndCodeId, (Object)lattice.getDestOrgCode());
            }
            List endCodelist = this.endCodeMapper.selectList((Wrapper)qw);
            QueryWrapper dest = new QueryWrapper();
            dest.lambda().eq(CountryStationEntity::getCountryStationCode, (Object)lattice.getDestOrgCode());
            List countryStationList = this.countryStationMapper.selectList((Wrapper)dest);
            OrgInfoEntity orgInfoEntity = this.orgInfoMapper.getOrgInfoByCode(lattice.getDestOrgCode());
            List warehouses = this.warehouseMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(Warehouse::getWarehouseCode, (Object)lattice.getDestOrgCode()));
            if (null == orgInfoEntity && endCodelist.isEmpty() && countryStationList.isEmpty() && CollectionUtils.isEmpty((Collection)warehouses)) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u76ee\u7684\u5730\u7f16\u53f7\u4e0d\u5408\u6cd5,\u65e0\u6548\u6216\u7981\u7528");
                return response;
            }
            if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.STATION.getType()) && !"000".equals((baseResp = this.crossBeltLatticeService.checkEndCodeId2ThreeCode(lattice)).getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(baseResp.getMsg());
                return response;
            }
            if (StringUtils.isBlank((String)lattice.getDestOrgName())) {
                if (null != orgInfoEntity) {
                    lattice.setDestOrgName(orgInfoEntity.getName());
                } else if (!endCodelist.isEmpty()) {
                    lattice.setDestOrgName(((EndCodeEntity)endCodelist.get(0)).getEndCodeName());
                } else if (!countryStationList.isEmpty()) {
                    lattice.setDestOrgName(((CountryStationEntity)countryStationList.get(0)).getCountryStationName());
                }
            }
        }
        if (StringUtils.isNotBlank((String)lattice.getEmpCode())) {
            if (this.commonConfig.getCheckEmp3Code() == 1 && !BATCH_FLAG_DELAY.equals(lattice.getReplaceDispatch())) {
                boolean emp3Code = false;
                if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.WAREHOUSE_SCAN.getType())) {
                    Warehouse warehouse;
                    String[] split = lattice.getThreeCode().split("-");
                    String fourCode = split[split.length - 1].trim();
                    LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Warehouse::getEmpCode, (Object)lattice.getEmpCode())).eq(Warehouse::getThreeCode, (Object)fourCode);
                    List warehouses = this.warehouseMapper.selectList((Wrapper)eq);
                    if (!CollectionUtils.isEmpty((Collection)warehouses) && StringUtils.isNotBlank((String)(warehouse = (Warehouse)warehouses.get(0)).getWarehouseCode()) && warehouse.getWarehouseCode().equals(lattice.getDestOrgCode())) {
                        emp3Code = true;
                    }
                } else if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.DISPATCH.getType())) {
                    Pair checkResult = this.crossBeltLatticeService.checkDispatchLatticeEmp3code(lattice.getDestOrgCode(), lattice.getEmpCode(), lattice.getThreeCode());
                    emp3Code = (Boolean)checkResult.getLeft();
                    lattice.setDestSource((String)checkResult.getRight());
                } else {
                    emp3Code = StringUtils.isNotBlank((String)lattice.getOptFlag()) && (lattice.getOptFlag().contains(LatticeOptTypeEnum.STATION.getType()) || lattice.getOptFlag().contains(LatticeOptTypeEnum.COUNTRY_STATION.getType()) || lattice.getOptFlag().contains(LatticeOptTypeEnum.NORMAL.getType())) ? true : this.onlineCheckDataService.checkEmp3Code(lattice.getDestOrgCode(), lattice.getEmpCode(), lattice.getThreeCode());
                }
                if (!emp3Code) {
                    response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    response.setRespMessage("\u4e1a\u52a1\u5458\u548c\u4e09\u6bb5\u7801\u4e0d\u5339\u914d");
                    return response;
                }
            } else {
                this.setDestSource(dbDevice, lattice);
            }
        }
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.COUNTRY_STATION.getType()) && StringUtils.isNotBlank((String)lattice.getThreeCode())) {
            BaseResp countryStationRes = this.latticeService.getCountryStation(lattice.getEmpCode(), null, lattice.getThreeCode());
            if (!"000".equals(countryStationRes.getCode())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(countryStationRes.getMsg());
                return response;
            }
            lattice.setDestOrgCode((String)((Map)countryStationRes.getData()).get("code"));
            lattice.setDestOrgName((String)((Map)countryStationRes.getData()).get("name"));
        }
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.UPLOAD.getType()) && !this.latticeService.checkDestByLineSection(lattice.getDestOrgCode())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u76ee\u7684\u5730\u4e0d\u5728\u7ebf\u8def\u4e0a");
            return response;
        }
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && lattice.getOptFlag().contains(LatticeOptTypeEnum.WAREHOUSE_SCAN.getType())) {
            String[] split = lattice.getThreeCode().split("-");
            String threeCode = split[split.length - 1].trim();
            List warehouses = this.warehouseMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Warehouse::getWarehouseCode, (Object)lattice.getDestOrgCode())).eq(Warehouse::getThreeCode, (Object)threeCode));
            if (!CollectionUtils.isEmpty((Collection)warehouses)) {
                lattice.setWarehouseOrgCode(((Warehouse)warehouses.get(0)).getOrgCode());
                lattice.setWarehouseOrgName(((Warehouse)warehouses.get(0)).getOrgName());
            }
        } else {
            lattice.setWarehouseOrgCode("");
            lattice.setWarehouseOrgName("");
        }
        int result = this.latticeService.update(lattice);
        this.updateExtendInfo(lattice);
        if (result == 1) {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fee\u6539\u6210\u529f");
            return response;
        }
        response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
        response.setRespMessage("\u4fee\u6539\u5931\u8d25");
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/batchUpdateLattice"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u683c\u53e3", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse batchUpdateLattice(@RequestBody TExpLattice expLattice) {
        logger.info("\u6536\u5230\u6279\u91cf\u4fee\u6539\u683c\u53e3\u8bf7\u6c42 {}", (Object)JSONObject.toJSONString((Object)expLattice));
        HttpBaseResponse response = new HttpBaseResponse();
        if (expLattice == null || CollectionUtils.isEmpty((Collection)expLattice.getLatticeIds()) || StringUtils.isBlank((String)expLattice.getLatticeNo())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u53c2\u6570\u4e3a\u7a7a");
            return response;
        }
        String afterLatNo = this.latticeService.transferLatticeNo(expLattice.getLatticeNo());
        String checkLatticeNoErrMsg = this.latticeService.checkLatticeNo(afterLatNo, true);
        if (StringUtils.isNotBlank((String)checkLatticeNoErrMsg)) {
            response.setRespCode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
            response.setRespMessage(checkLatticeNoErrMsg);
            return response;
        }
        expLattice.setLatticeNo(afterLatNo);
        try {
            this.latticeService.batchUpdateLattice(expLattice);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fee\u6539\u5931\u8d25");
            logger.error("\u6279\u91cf\u4fee\u6539\u683c\u53e3\u5f02\u5e38", (Throwable)e);
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/selectDestOrgList"})
    @ApiOperation(value="\u83b7\u53d6\u76ee\u7684\u5730", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse selectDestOrgList(@RequestBody JSONObject request) {
        HttpBaseResponse response = new HttpBaseResponse();
        ArrayList respMapList = new ArrayList();
        String keyword = request.getString("keyword");
        Integer limit = request.getInteger("limit");
        List orgInfoEntities = this.orgInfoMapper.selectList(keyword, limit);
        this.orgInfoListToMapList(orgInfoEntities, respMapList);
        List endCodeEntities = this.endCodeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new Property[]{EndCodeEntity::getStationCode, EndCodeEntity::getEndCodeName}).like(EndCodeEntity::getStationCode, (Object)keyword)).or()).like(EndCodeEntity::getEndCodeName, (Object)keyword)).last("limit " + limit));
        this.endCodeListToMapList(endCodeEntities, respMapList);
        List countryStations = this.countryStationMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CountryStationEntity::getStatus, (Object)"VALID")).and(e -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.like(CountryStationEntity::getCountryStationCode, (Object)keyword)).or()).like(CountryStationEntity::getCountryStationName, (Object)keyword))).last("limit " + limit));
        this.countryStationListToMapList(countryStations, respMapList);
        response.setData(respMapList);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        return response;
    }

    private void orgInfoListToMapList(List<OrgInfoEntity> orgInfoEntities, List<Map<String, String>> respMapList) {
        if (CollectionUtils.isEmpty(orgInfoEntities)) {
            return;
        }
        for (OrgInfoEntity orgInfoEntity : orgInfoEntities) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("name", orgInfoEntity.getName());
            map.put("code", orgInfoEntity.getCode());
            respMapList.add(map);
        }
    }

    private void endCodeListToMapList(List<EndCodeEntity> endCodeEntities, List<Map<String, String>> respMapList) {
        if (CollectionUtils.isEmpty(endCodeEntities)) {
            return;
        }
        for (EndCodeEntity endCodeEntity : endCodeEntities) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("name", endCodeEntity.getEndCodeName());
            map.put("code", endCodeEntity.getStationCode());
            respMapList.add(map);
        }
    }

    private void countryStationListToMapList(List<CountryStationEntity> countryStations, List<Map<String, String>> respMapList) {
        if (CollectionUtils.isEmpty(countryStations)) {
            return;
        }
        for (CountryStationEntity countryStation : countryStations) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("name", countryStation.getCountryStationName());
            map.put("code", countryStation.getCountryStationCode());
            respMapList.add(map);
        }
    }

    private void updateExtendInfo(TExpLattice lattice) {
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && !lattice.getOptFlag().contains(LatticeOptTypeEnum.DISPATCH.getType())) {
            this.latticeMapper.updateLatticeNoIsDelayDispatch("0", lattice.getId());
            TExpLatticeExtend delLatticeExtend = new TExpLatticeExtend();
            delLatticeExtend.setExtendSendStatus(Integer.valueOf(SendStatus.UPDATE.getStatus()));
            this.latticeExtendMapper.update((Object)delLatticeExtend, (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(TExpLatticeExtend::getLatticeId, (Object)lattice.getId())).eq(TExpLatticeExtend::getExtendType, (Object)BATCH_FLAG_DELAY));
            this.latticeExtendMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TExpLatticeExtend::getLatticeId, (Object)lattice.getId())).eq(TExpLatticeExtend::getExtendType, (Object)BATCH_FLAG_DELAY));
        }
        if (StringUtils.isNotBlank((String)lattice.getOptFlag()) && !lattice.getOptFlag().contains(LatticeOptTypeEnum.UPLOAD.getType())) {
            lattice.setCreateUnloadFlag("0");
            this.latticeMapper.updateCreateUnloadFlagById(lattice, lattice.getId());
        }
        if (!"-101".equals(lattice.getThreeCode())) {
            TExpLatticeExtend extend = new TExpLatticeExtend();
            extend.setLatticeId(lattice.getId());
            extend.setExtendType(BATCH_FLAG_ALL_PROCESS);
            this.latticeExtendMapper.deleteByLatIdAndType(extend);
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/getLattice"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u683c\u53e3\u6620\u5c04", httpMethod="POST", consumes="application/json")
    public TExpLattice getLattice(@RequestParam String id) {
        TExpLattice lattice = this.latticeService.queryById(id);
        return lattice;
    }

    @HeadTokenVerification
    @PostMapping(value={"/addScheme"}, produces={"application/json"})
    @ApiOperation(value="\u589e\u52a0\u683c\u53e3\u65b9\u6848", httpMethod="POST", consumes="application/json")
    public String addScheme(@RequestBody TExpLatticeScheme latticeScheme) {
        logger.info("\u65b0\u589e\u683c\u53e3\u65b9\u6848\u8bf7\u6c42\uff1a{} ", (Object)JSONObject.toJSONString((Object)latticeScheme));
        if (this.latticeSchemeService.checkSchemeNo(latticeScheme)) {
            return "\u65b9\u6848\u7f16\u53f7\u91cd\u590d";
        }
        this.latticeSchemeService.changeStatus(latticeScheme);
        TExpAutoDevice device = new TExpAutoDevice();
        device.setDeviceName(latticeScheme.getDeviceName());
        TExpAutoDevice dbDevice = this.deviceService.selectByDeviceName(device);
        this.setInoutFlag(dbDevice, latticeScheme);
        latticeScheme.setDeviceId(dbDevice.getDeviceId());
        latticeScheme.setId(UUID.randomUUID().toString());
        latticeScheme.setCreateTime(new Date());
        latticeScheme.setModifyTime(new Date());
        int result = this.latticeSchemeService.insert(latticeScheme);
        if (result == 1) {
            return "success";
        }
        return "failure";
    }

    private void setInoutFlag(TExpAutoDevice dbDevice, TExpLatticeScheme latticeScheme) {
        if (InOutFlagEnum.IN.codeStr().equals(dbDevice.getInOutFlag()) || InOutFlagEnum.OUT.codeStr().equals(dbDevice.getInOutFlag())) {
            latticeScheme.setInOutFlag(dbDevice.getInOutFlag());
            return;
        }
        if (InOutFlagEnum.INANDOUT.codeStr().equals(dbDevice.getInOutFlag()) && (AutoDeviceTypeEnum.MATRIX.getType().equals(dbDevice.getDeviceType()) || AutoDeviceTypeEnum.END_LINE.getType().equals(dbDevice.getDeviceType()))) {
            latticeScheme.setInOutFlag(InOutFlagEnum.INANDOUT.codeStr());
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/delScheme"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u683c\u53e3\u65b9\u6848", httpMethod="POST", consumes="application/json")
    public String delScheme(@RequestParam String id) {
        logger.info("\u5220\u9664\u7684\u683c\u53e3\u65b9\u6848id\u4e3a\uff1a" + id);
        TExpLatticeScheme scheme = (TExpLatticeScheme)this.latticeSchemeMapper.selectById((Serializable)((Object)id));
        logger.info("\u65b9\u6848\u5bf9\u8c61:{}", (Object)JSONObject.toJSONString((Object)scheme));
        if (BATCH_FLAG_DELAY.equals(scheme.getStatus())) {
            return "existed";
        }
        scheme.setModifyUserCode(WebRequestUtil.getUserCode());
        scheme.setModifyUserName(WebRequestUtil.getUserName());
        int result = this.latticeSchemeService.delete(scheme);
        if (result == 1) {
            return "success";
        }
        logger.info("\u5220\u9664\u65b9\u6848,\u53d7\u5f71\u54cd:{}\u884c", (Object)result);
        return "failure";
    }

    @HeadTokenVerification
    @PostMapping(value={"/updateScheme"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u683c\u53e3\u65b9\u6848", httpMethod="POST", consumes="application/json")
    public String updateScheme(@RequestBody TExpLatticeScheme latticeScheme) {
        TExpAutoDevice device;
        logger.info("\u4fee\u6539\u683c\u53e3\u65b9\u6848\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)latticeScheme));
        TExpLatticeScheme dbScheme = (TExpLatticeScheme)this.latticeSchemeMapper.selectById((Serializable)((Object)latticeScheme.getId()));
        if (null != dbScheme && !BATCH_FLAG_DELAY.equals(dbScheme.getInOutFlag()) && !BATCH_FLAG_ALL_PROCESS.equals(dbScheme.getInOutFlag())) {
            device = this.deviceService.selectByDeviceId(dbScheme.getDeviceId());
            dbScheme.setInOutFlag(device.getInOutFlag());
        }
        if (null != dbScheme && !dbScheme.getInOutFlag().equals(latticeScheme.getInOutFlag())) {
            QueryWrapper lq = new QueryWrapper();
            lq.lambda().eq(TExpLattice::getLatticeSchemeId, (Object)latticeScheme.getId());
            List latticetList = this.latticeMapper.selectList((Wrapper)lq);
            if (null != latticetList && latticetList.size() > 0) {
                return "\u539f\u65b9\u6848\u4e2d\u5df2\u914d\u7f6e\u683c\u53e3\u660e\u7ec6\uff0c\u4e0d\u80fd\u5207\u6362\u8fdb\u51fa\u6e2f";
            }
        }
        if (null != dbScheme && !dbScheme.getSchemeNo().equals(latticeScheme.getSchemeNo())) {
            this.latticeService.updateLatticeSchemeNoBySchemeId(latticeScheme);
        }
        device = new TExpAutoDevice();
        device.setDeviceName(latticeScheme.getDeviceName());
        TExpAutoDevice dbDevice = this.deviceService.selectByDeviceName(device);
        if (this.latticeSchemeService.checkSchemeNo(latticeScheme)) {
            return "\u65b9\u6848\u7f16\u53f7\u91cd\u590d";
        }
        logger.info("\u65b0\u65e7\u65b9\u6848\u72b6\u6001 \u65e7\uff1a{} \u65b0\uff1a{}", (Object)(dbScheme != null ? dbScheme.getStatus() : ""), (Object)latticeScheme.getStatus());
        this.latticeSchemeService.changeStatus(latticeScheme);
        if (null != dbDevice) {
            latticeScheme.setDeviceId(dbDevice.getDeviceId());
        }
        latticeScheme.setModifyTime(new Date());
        latticeScheme.setThreeCodeCount(Integer.valueOf(this.latticeService.threeCodeCountBySchemeId(latticeScheme.getId())));
        int result = this.latticeSchemeService.update(latticeScheme);
        if (result == 1) {
            if (BATCH_FLAG_DELAY.equals(latticeScheme.getStatus())) {
                this.latticeSchemeService.push(latticeScheme, "0");
            }
            return "success";
        }
        return "failure";
    }

    private String checkUploadDispatchTime(TExpLatticeScheme latticeScheme, TExpLattice lattice) {
        if (null == lattice && StringUtils.isNotBlank((String)latticeScheme.getOpStartTime()) && StringUtils.isNotBlank((String)latticeScheme.getOpEndTime()) && StringUtils.isNotBlank((String)latticeScheme.getUploadDispatchTime())) {
            List list;
            int nextDay = latticeScheme.getOpStartTime().compareTo(latticeScheme.getOpEndTime());
            if (BATCH_FLAG_DELAY.equals(latticeScheme.getIsDelayDispatch()) && "0".equals(latticeScheme.getIsLatticeDelay())) {
                int start = latticeScheme.getOpStartTime().compareTo(latticeScheme.getUploadDispatchTime());
                int end = latticeScheme.getOpEndTime().compareTo(latticeScheme.getUploadDispatchTime());
                if (nextDay < 0 && start <= 0 && end >= 0 || nextDay > 0 && (start <= 0 || end >= 0)) {
                    return "\u6d3e\u4ef6\u4e0a\u4f20\u65f6\u95f4\u4e0d\u80fd\u8bbe\u7f6e\u5728\u5206\u62e3\u8d77\u6b62\u65f6\u95f4\u5185";
                }
            }
            if (BATCH_FLAG_DELAY.equals(latticeScheme.getIsDelayDispatch()) && BATCH_FLAG_DELAY.equals(latticeScheme.getIsLatticeDelay()) && (list = this.latticeMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TExpLattice::getLatticeSchemeId, (Object)latticeScheme.getId()))).size() > 0) {
                for (TExpLattice tExpLattice : list) {
                    if (!StringUtils.isNotBlank((String)tExpLattice.getUploadDispatchTime())) continue;
                    int start = latticeScheme.getOpStartTime().compareTo(tExpLattice.getUploadDispatchTime());
                    int end = latticeScheme.getOpEndTime().compareTo(tExpLattice.getUploadDispatchTime());
                    if ((nextDay >= 0 || start > 0 || end < 0) && (nextDay <= 0 || start > 0 && end < 0)) continue;
                    return "\u5f53\u524d\u65b9\u6848\u683c\u53e3\u53f7\u4e3a'" + tExpLattice.getLatticeNo() + "'\u7684\u6d3e\u4ef6\u4e0a\u4f20\u65f6\u95f4\u4e0d\u80fd\u8bbe\u7f6e\u5728\u6b64\u5206\u62e3\u8d77\u6b62\u65f6\u95f4\u5185";
                }
            }
        } else if (null != lattice && StringUtils.isNotBlank((String)latticeScheme.getOpStartTime()) && StringUtils.isNotBlank((String)latticeScheme.getOpEndTime()) && StringUtils.isNotBlank((String)lattice.getUploadDispatchTime())) {
            int nextDay = latticeScheme.getOpStartTime().compareTo(latticeScheme.getOpEndTime());
            int start = latticeScheme.getOpStartTime().compareTo(lattice.getUploadDispatchTime());
            int end = latticeScheme.getOpEndTime().compareTo(lattice.getUploadDispatchTime());
            if (nextDay < 0 && start <= 0 && end >= 0 || nextDay > 0 && (start <= 0 || end >= 0)) {
                return "\u6d3e\u4ef6\u4e0a\u4f20\u65f6\u95f4\u4e0d\u80fd\u8bbe\u7f6e\u5728\u6240\u5c5e\u65b9\u6848\u7684\u5206\u62e3\u8d77\u6b62\u65f6\u95f4\u5185";
            }
        }
        return null;
    }

    private String checkUploadDispatchTime(TExpLattice param) {
        if (BATCH_FLAG_DELAY.equals(param.getIsDelayDispatch())) {
            List uploadDispatchTimeList = param.getUploadDispatchTimeList();
            List opStartTimeList = param.getOpStartTimeList();
            List opEndTimeList = param.getOpEndTimeList();
            if (null == uploadDispatchTimeList || null == opStartTimeList || null == opEndTimeList) {
                return "\u7f3a\u5c11\u65f6\u95f4\u914d\u7f6e";
            }
            if (uploadDispatchTimeList.size() != opStartTimeList.size() || opStartTimeList.size() != opEndTimeList.size() || uploadDispatchTimeList.size() != opEndTimeList.size()) {
                return "\u65f6\u95f4\u914d\u7f6e\u6570\u91cf\u4e0d\u4e00\u81f4";
            }
            for (int i = 0; i < uploadDispatchTimeList.size(); ++i) {
                String opEndTime;
                String opStartTime;
                String uploadDispatchTime = (String)uploadDispatchTimeList.get(i);
                BaseResp baseResp = this.latticeService.delayConfigSingleCheck(uploadDispatchTime, opStartTime = (String)opStartTimeList.get(i), opEndTime = (String)opEndTimeList.get(i));
                if ("000".equals(baseResp.getCode())) continue;
                return baseResp.getMsg();
            }
        }
        return null;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getScheme"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u683c\u53e3\u65b9\u6848", httpMethod="POST", consumes="application/json")
    public TExpLatticeScheme getScheme(@RequestParam String id) {
        TExpLatticeScheme latticeScheme = this.latticeSchemeService.queryById(id);
        return latticeScheme;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getSchemeByNoName"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u65b9\u6848\u7f16\u53f7\u548c\u8bbe\u5907\u540d\u79f0\u67e5\u8be2\u683c\u53e3\u65b9\u6848", httpMethod="POST", consumes="application/json")
    public TExpLatticeScheme getSchemeByNoName(@RequestBody TExpLatticeScheme latticeScheme) {
        TExpAutoDevice device;
        TExpLatticeScheme scheme = this.latticeSchemeService.selectByDeviceAndSchemeNo(latticeScheme);
        if (null != scheme && !BATCH_FLAG_DELAY.equals(scheme.getInOutFlag()) && !BATCH_FLAG_ALL_PROCESS.equals(scheme.getInOutFlag()) && null != (device = this.deviceService.selectByDeviceId(scheme.getDeviceId()))) {
            scheme.setInOutFlag(device.getInOutFlag());
        }
        return scheme;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getDeviceName"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907\u540d\u79f0", httpMethod="POST", consumes="application/json")
    public List<String> getDeviceName(@RequestParam(required=false) String deviceType) {
        List deviceNameList = this.deviceService.selectDeviceNames(deviceType);
        return deviceNameList;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getInOutTypeByDeviceName"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u8bbe\u5907\u540d\u79f0\u67e5\u8be2\u8bbe\u5907\u8fdb\u51fa\u6e2f", httpMethod="POST", consumes="application/json")
    public String getInOutTypeByDeviceName(@RequestParam(required=false) String deviceName) {
        if (StringUtils.isBlank((String)deviceName)) {
            return "";
        }
        List list = this.deviceService.list((Wrapper)new LambdaQueryWrapper().eq(TExpAutoDevice::getDeviceName, (Object)deviceName));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return "";
        }
        return ((TExpAutoDevice)list.get(0)).getInOutFlag();
    }

    @HeadTokenVerification
    @PostMapping(value={"/getDevices"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907", httpMethod="POST", consumes="application/json")
    public List<TExpAutoDevice> getDevices(@RequestParam(required=false) String deviceType) {
        List deviceist = this.deviceService.selectDevices(deviceType);
        return deviceist;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getSchemeNo"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u65b9\u6848\u7f16\u53f7", httpMethod="POST", consumes="application/json")
    public List<String> getSchemeNo(@RequestBody String deviceName) {
        List schemeNoList = this.latticeSchemeService.selectSchemeByDeviceName(deviceName);
        return schemeNoList;
    }

    @HeadTokenVerification
    @PostMapping(value={"/selectSchemeList"}, produces={"application/json"})
    public HttpBaseResponse<List<TExpLatticeScheme>> selectSchemeList(@RequestBody PageInfoEntity request) {
        List schemes = this.latticeSchemeService.selectList(request);
        HttpBaseResponse response = new HttpBaseResponse();
        response.setData((Object)schemes);
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/checkSchemeNo"}, produces={"application/json"})
    public HttpBaseResponse checkSchemeNo(@RequestBody TExpLatticeScheme latticeScheme) {
        HttpBaseResponse response = new HttpBaseResponse();
        boolean body = true;
        try {
            body = this.latticeSchemeService.checkSchemeNo(latticeScheme);
            response.setRespCode("000");
            response.setRespMessage("\u8be5\u8bbe\u5907\u65b9\u6848\u7f16\u53f7\u91cd\u590d");
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u51fa\u73b0\u9519\u8bef" + e.getMessage());
            body = false;
            response.setRespCode("111");
            response.setRespMessage("fail");
        }
        response.setData((Object)body);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getEndCodeByThreeCode"}, produces={"application/json"})
    public HttpBaseResponse getEndCodeByThreeCode(@RequestBody String threeCode) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            EndCodeEntity entity = this.endCodeService.findMaxEndCodeEntity(threeCode);
            if (entity == null) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u6839\u636e\u4e09\u6bb5\u7801\u672a\u67e5\u8be2\u5230\u9a7f\u7ad9\u7801");
                return response;
            }
            String entityThreeCode = entity.getThreeCode();
            String[] split = entityThreeCode.split(",");
            entity.setWholeThreeCode(Arrays.asList(split));
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u6839\u636e\u4e09\u6bb5\u7801\u67e5\u8be2\u9a7f\u7ad9\u7801\u8bf7\u6c42\u6210\u529f");
            response.setData((Object)entity);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u4e09\u6bb5\u7801\u67e5\u8be2\u9a7f\u7ad9\u7801\u8bf7\u6c42\u9519\u8bef" + e.getMessage(), (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("fail");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getThreeCodeByEndCode"}, produces={"application/json"})
    public HttpBaseResponse getThreeCodeByEndCode(@RequestBody String endCode) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            QueryWrapper qw = new QueryWrapper();
            qw.lambda().eq(EndCodeEntity::getEndCodeId, (Object)endCode);
            List endCodelist = this.endCodeMapper.selectList((Wrapper)qw);
            if (endCodelist.size() > 0) {
                response.setRespCode("000");
                response.setRespMessage("\u6839\u636e\u9a7f\u7ad9\u7801\u67e5\u8be2\u4e09\u6bb5\u7801\u8bf7\u6c42\u6210\u529f");
                EndCodeEntity codeEntity = (EndCodeEntity)endCodelist.get(0);
                String[] threeCodeArr = codeEntity.getThreeCode().split(",");
                codeEntity.setThreeCode(threeCodeArr[0]);
                response.setData((Object)codeEntity);
            } else {
                response.setRespCode("999");
                response.setRespMessage("\u6839\u636e\u9a7f\u7ad9\u7801\u672a\u67e5\u8be2\u5230\u4e09\u6bb5\u7801");
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u9a7f\u7ad9\u7801\u67e5\u8be2\u4e09\u6bb5\u7801\u8bf7\u6c42\u9519\u8bef" + e.getMessage(), (Throwable)e);
            response.setRespCode("111");
            response.setRespMessage("fail");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getDestByCountryStation"}, produces={"application/json"})
    public HttpBaseResponse getDestByCountryStation(@RequestBody ExpLatticeQueryParam param) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            String empCode = param.getEmp().split("-")[0].trim();
            BaseResp countryStationRes = this.latticeService.getCountryStation(empCode, null, param.getThreeCode());
            if ("000".equals(countryStationRes.getCode())) {
                response.setRespCode("000");
                response.setRespMessage("\u67e5\u8be2\u6d3e\u5165\u5408\u4e00\u8bf7\u6c42\u6210\u529f");
                response.setData(countryStationRes.getData());
            } else {
                response.setRespCode("999");
                response.setRespMessage(countryStationRes.getMsg());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5230\u6d3e\u5165\u5408\u4e00\u8bf7\u6c42\u9519\u8bef", (Throwable)e);
            response.setRespCode("111");
            response.setRespMessage("\u67e5\u8be2\u6d3e\u5165\u5408\u4e00\u5931\u8d25");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getWarehouseByThreeCodeAndEmp"})
    public HttpBaseResponse<Warehouse> getWarehouseByThreeCodeAndEmp(@RequestBody Warehouse param) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (param == null || StringUtils.isBlank((String)param.getEmpJoinStr()) || StringUtils.isBlank((String)param.getThreeCode())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.MISS_DATA_FAIL.getRespMessage());
            return response;
        }
        try {
            String empCode = param.getEmpJoinStr().split("-")[0].trim();
            String[] split = param.getThreeCode().split("-");
            String threeCode = split[split.length - 1].trim();
            if (StringUtils.isBlank((String)empCode) || StringUtils.isBlank((String)threeCode)) {
                response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
                response.setRespMessage(ResponseTypeEnum.MISS_DATA_FAIL.getRespMessage() + ":" + empCode + "-" + threeCode);
                return response;
            }
            LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Warehouse::getEmpCode, (Object)empCode)).eq(Warehouse::getThreeCode, (Object)threeCode);
            List warehouses = this.warehouseMapper.selectList((Wrapper)eq);
            if (CollectionUtils.isEmpty((Collection)warehouses)) {
                response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                return response;
            }
            response.setData(warehouses.get(0));
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            return response;
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u8fdb\u4ed3\u57fa\u7840\u6570\u636e\u5f02\u5e38\uff0cparam\uff1a{}", (Object)JSONObject.toJSONString((Object)param), (Object)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u5f02\u5e38");
            return response;
        }
    }

    private Pair<TExpAutoDevice, String> getInoutFlag(ExpLatticeQueryParam param) {
        String inOutFlag = param.getInOutFlag();
        TExpAutoDevice one = (TExpAutoDevice)this.deviceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new Property[]{TExpAutoDevice::getDeviceId, TExpAutoDevice::getInOutFlag}).eq(TExpAutoDevice::getDeviceName, (Object)param.getDeviceName())).last("LIMIT 1"));
        if (one == null) {
            return null;
        }
        if (StringUtils.isNotBlank((String)inOutFlag)) {
            return Pair.of((Object)one, (Object)inOutFlag);
        }
        if (StringUtils.isBlank((String)param.getDeviceName())) {
            return null;
        }
        if (!InOutFlagEnum.INANDOUT.codeStr().equals(one.getInOutFlag())) {
            return Pair.of((Object)one, (Object)one.getInOutFlag());
        }
        if (StringUtils.isBlank((String)param.getSchemeNo())) {
            return null;
        }
        TExpLatticeScheme latticeScheme = (TExpLatticeScheme)this.latticeSchemeMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new Property[]{TExpLatticeScheme::getInOutFlag}).eq(TExpLatticeScheme::getDeviceName, (Object)param.getDeviceName())).eq(TExpLatticeScheme::getSchemeNo, (Object)param.getSchemeNo())).last("LIMIT 1"));
        if (latticeScheme == null) {
            return null;
        }
        return Pair.of((Object)one, (Object)latticeScheme.getInOutFlag());
    }

    @HeadTokenVerification
    @PostMapping(value={"/getDestByPackageCode"}, produces={"application/json"})
    public HttpBaseResponse getDestByPackageCode(@RequestBody ExpLatticeQueryParam param) {
        HttpBaseResponse response = new HttpBaseResponse();
        String threeCode = param.getThreeCode();
        if (StringUtils.isBlank((String)threeCode)) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u4e09\u6bb5\u7801\u4e3a\u7a7a");
            return response;
        }
        Pair pair = this.getInoutFlag(param);
        if (pair == null || !InOutFlagEnum.OUT.codeStr().equals(pair.getRight())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u975e\u51fa\u6e2f");
            return response;
        }
        try {
            BuildPkgRuleResp bagRule = this.crossBeltLatticeService.getOutBuildPkgLatticeDestOrg(threeCode, ((TExpAutoDevice)pair.getLeft()).getDeviceId());
            if (bagRule != null) {
                response.setRespCode("000");
                response.setRespMessage("\u67e5\u8be2\u67e5\u8be2\u5efa\u5305\u89c4\u5219\u8bf7\u6c42\u6210\u529f");
                response.setData((Object)bagRule);
            } else {
                response.setRespCode("999");
                response.setRespMessage("\u672a\u67e5\u8be2\u5230\u67e5\u8be2\u5efa\u5305\u89c4\u5219");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u67e5\u8be2\u5efa\u5305\u89c4\u5219\u8bf7\u6c42\u9519\u8bef" + e.getMessage(), (Throwable)e);
            response.setRespCode("111");
            response.setRespMessage("fail");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/setBatchFlag"}, produces={"application/json"})
    public HttpBaseResponse setBatchFlag(@RequestParam String flag, @RequestBody TExpLattice param) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            List latticeList = param.getLatticeList();
            switch (flag) {
                case "1": {
                    String msg = this.checkUploadDispatchTime(param);
                    if (StringUtils.isNotBlank((String)msg)) {
                        response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                        response.setRespMessage(msg);
                        return response;
                    }
                    for (TExpLattice lat : latticeList) {
                        TExpLatticeExtend delLatticeExtend = new TExpLatticeExtend();
                        delLatticeExtend.setExtendSendStatus(Integer.valueOf(SendStatus.UPDATE.getStatus()));
                        delLatticeExtend.setModifyTime(new Date());
                        delLatticeExtend.setModifyUserCode(param.getModifyUserCode());
                        delLatticeExtend.setModifyUserName(param.getModifyUserName());
                        this.latticeExtendMapper.update((Object)delLatticeExtend, (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(TExpLatticeExtend::getLatticeId, (Object)lat.getId())).eq(TExpLatticeExtend::getExtendType, (Object)BATCH_FLAG_DELAY));
                        this.latticeExtendMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TExpLatticeExtend::getLatticeId, (Object)lat.getId())).eq(TExpLatticeExtend::getExtendType, (Object)BATCH_FLAG_DELAY));
                        List uploadDispatchTimeList = param.getUploadDispatchTimeList();
                        List opStartTimeList = param.getOpStartTimeList();
                        List opEndTimeList = param.getOpEndTimeList();
                        if (BATCH_FLAG_DELAY.equals(param.getIsDelayDispatch()) && !CollectionUtils.isEmpty((Collection)uploadDispatchTimeList)) {
                            for (int i = 0; i < uploadDispatchTimeList.size(); ++i) {
                                TExpLatticeExtend latticeExtend = this.latticeExtendService.createLatticeExtend(lat.getId(), param, (String)uploadDispatchTimeList.get(i), (String)opStartTimeList.get(i), (String)opEndTimeList.get(i), BATCH_FLAG_DELAY, null, null, null, null, null, null, null, null, null, null, null);
                                latticeExtend.setConfigOptFlag("ADD");
                                latticeExtend.setCreateUserName(WebRequestUtil.getUserName());
                                latticeExtend.setCreateUserCode(WebRequestUtil.getUserCode());
                                latticeExtend.setModifyUserName(WebRequestUtil.getUserName());
                                latticeExtend.setModifyUserCode(WebRequestUtil.getUserCode());
                                this.latticeExtendMapper.insert((Object)latticeExtend);
                            }
                        }
                        this.latticeMapper.updateDeleyDisptchById(param, lat.getId());
                    }
                    response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                    response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
                    break;
                }
                case "2": {
                    for (TExpLattice lat : latticeList) {
                        this.latticeMapper.updateAllProcessFlagById(param, lat.getId());
                    }
                    response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                    response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
                    break;
                }
                case "3": {
                    for (TExpLattice lat : latticeList) {
                        this.latticeMapper.updateCreateUnloadFlagById(param, lat.getId());
                    }
                    response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                    response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
                    break;
                }
                case "5": {
                    logger.info("\u6536\u5230 \u6dfb\u52a0/\u4fee\u6539 \u5f02\u5e38\u4ef6\u524d\u7aef\u62e6\u622a\u914d\u7f6e\u8bf7\u6c42,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)param));
                    TExpLatticeExtend latticeExtend = this.latticeExtendService.createLatticeExtend("flashed", param, null, null, null, BATCH_FLAG_IN_OUT_INTERCEPT, null, null, null, null, null, null, null, null, null, null, null);
                    latticeExtend.setConfigOptFlag("ADD");
                    latticeExtend.setCreateUserName(WebRequestUtil.getUserName());
                    latticeExtend.setCreateUserCode(WebRequestUtil.getUserCode());
                    latticeExtend.setModifyUserName(WebRequestUtil.getUserName());
                    latticeExtend.setModifyUserCode(WebRequestUtil.getUserCode());
                    int res = this.latticeService.saveFrontInterceptConfig(latticeExtend);
                    if (res > 0) {
                        response.setRespCode("000");
                        response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
                        break;
                    }
                    response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    response.setRespMessage("\u4fdd\u5b58\u5931\u8d25,\u5f71\u54cd\u884c\u6570:" + res);
                    break;
                }
                default: {
                    response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                    response.setRespMessage("\u9519\u8bef\u7684\u64cd\u4f5c\u6807\u8bc6\uff1a" + flag);
                }
            }
            this.latticeSchemeService.schemeUpload();
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u8bbe\u7f6e\u63a5\u53e3\u8bf7\u6c42\u9519\u8bef,flag:{}", (Object)flag, (Object)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u6279\u91cf\u8bbe\u7f6e\u63a5\u53e3\u8bf7\u6c42\u9519\u8bef");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/checkDuplicateLatNo"}, produces={"application/json"})
    public HttpBaseResponse<String> checkDuplicateLatNo(@RequestBody TExpLattice param) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            logger.info("\u67e5\u8be2\u683c\u53e3\u53f7\u662f\u5426\u91cd\u590d\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString((Object)param));
            String latticeNo = this.latticeService.transferLatticeNo(param.getLatticeNo());
            if (StringUtils.isBlank((String)latticeNo)) {
                response.setRespCode("000");
                return response;
            }
            boolean isOutAndBuildPackage = false;
            HashSet latticeNoSet = Sets.newHashSet((Object[])latticeNo.split(","));
            String msg = "";
            for (String latNo : latticeNoSet) {
                String threeCodeStr;
                if (StringUtils.isNotBlank((String)msg)) break;
                LambdaQueryWrapper qw = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.like(TExpLattice::getLatticeNo, (Object)latNo)).eq(TExpLattice::getLatticeScheme, (Object)param.getLatticeScheme())).eq(TExpLattice::getDeviceName, (Object)param.getDeviceName());
                List latList = this.latticeMapper.selectList((Wrapper)qw);
                if (latList.size() <= 0) continue;
                StringBuilder threeCode = new StringBuilder();
                StringBuilder destOrgCodeJoinStr = new StringBuilder();
                HashSet<String> destOrgCodeSet = new HashSet<String>();
                for (TExpLattice lat : latList) {
                    if (lat.getId().equals(param.getId())) continue;
                    if (isOutAndBuildPackage && StringUtils.isNotBlank((String)lat.getOptFlag())) {
                        List<String> optFlags = Arrays.asList(lat.getOptFlag().split(";"));
                        if (!optFlags.contains(LatticeOptTypeEnum.BUILD_PACK.getType())) continue;
                        boolean isBuildPackLat = false;
                        if (optFlags.size() == 1) {
                            isBuildPackLat = true;
                        } else if (StringUtils.isNotBlank((String)lat.getLatticeNo())) {
                            String[] latNos = lat.getLatticeNo().split(";");
                            for (int i = 0; i < optFlags.size(); ++i) {
                                if (!LatticeOptTypeEnum.BUILD_PACK.getType().equals(optFlags.get(i))) continue;
                                try {
                                    String buildPackLatNo = latNos[i];
                                    if (!buildPackLatNo.contains(latNo)) continue;
                                    isBuildPackLat = true;
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.error("\u6821\u9a8c\u51fa\u6e2f\u5efa\u5305\u683c\u53e3\u5f02\u5e38", (Throwable)e);
                                }
                            }
                        }
                        if (!isBuildPackLat || param.getDestOrgCode().equals(lat.getDestOrgCode()) || destOrgCodeSet.contains(lat.getDestOrgCode())) continue;
                        destOrgCodeSet.add(lat.getDestOrgCode());
                        destOrgCodeJoinStr.append(lat.getDestOrgCode()).append(",");
                        continue;
                    }
                    threeCode.append(lat.getThreeCode()).append(",");
                }
                String s = destOrgCodeJoinStr.toString();
                if (StringUtils.isNotBlank((String)s)) {
                    msg = msg + "\u683c\u53e3\u53f7[" + latNo + "]\u5df2\u914d\u7f6e\u51fa\u6e2f\u5efa\u5305\uff0c\u683c\u53e3\u53f7\u76ee\u7684\u5730\u4e3a[" + s + "]\uff0c\u662f\u5426\u5c06\u683c\u53e3\u76ee\u7684\u5730\u6539\u4e3a\u5f53\u524d\u76ee\u7684\u5730?";
                }
                if (StringUtils.isNotBlank((String)(threeCodeStr = threeCode.toString()))) {
                    msg = msg + "\u683c\u53e3\u53f7\u3010" + latNo + "\u3011\u5df2\u914d\u7f6e\u4e09\u6bb5\u7801" + threeCodeStr + "\u662f\u5426\u628a\u4e09\u6bb5\u7801" + param.getThreeCode() + "\u4e5f\u914d\u7f6e\u5230\u8be5\u683c\u53e3\uff1f";
                }
                if (!StringUtils.isNotBlank((String)msg)) continue;
                break;
            }
            response.setData((Object)msg);
            response.setRespCode("000");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u683c\u53e3\u53f7\u662f\u5426\u91cd\u590d\u5f02\u5e38" + e, (Throwable)e);
            response.setRespCode("111");
            response.setRespMessage("\u67e5\u8be2\u683c\u53e3\u53f7\u662f\u5426\u91cd\u590d\u5f02\u5e38");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/deleteReturn"}, produces={"application/json"})
    public HttpBaseResponse deleteReturn(@RequestParam String param) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            logger.info("\u5220\u9664\u62e6\u622a\u4ef6\u7ec6\u5206\u914d\u7f6e\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString((Object)param));
            QueryWrapper ledqw = new QueryWrapper();
            if (StringUtils.isBlank((String)param)) {
                response.setRespMessage("\u7f3a\u5c11\u53c2\u6570");
                response.setRespCode("111");
                return response;
            }
            if (BATCH_FLAG_DELAY.equals(param)) {
                this.latticeExtendMapper.deleteInReturn();
            } else {
                this.latticeExtendMapper.deleteOutReturn();
            }
            response.setRespCode("000");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u62e6\u622a\u4ef6\u7ec6\u5206\u914d\u7f6e\u5f02\u5e38" + e, (Throwable)e);
            response.setRespCode("111");
            response.setRespMessage("\u5220\u9664\u62e6\u622a\u4ef6\u7ec6\u5206\u914d\u7f6e\u5f02\u5e38");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/frontIntercept"}, produces={"application/json"})
    public HttpBaseResponse queryFrontIntercept(@RequestBody TExpLatticeExtend param) {
        logger.info("\u6536\u5230\u67e5\u8be2\u5f02\u5e38\u4ef6\u524d\u7aef\u62e6\u622a\u914d\u7f6e\u8bf7\u6c42,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)param));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            TExpLatticeExtend result = this.latticeService.selectFrontIntercept(param);
            response.setRespCode("000");
            response.setData((Object)result);
        }
        catch (Exception e) {
            response.setRespCode("111");
            response.setRespMessage("\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/deleteFrontIntercept"}, produces={"application/json"})
    public HttpBaseResponse deleteFrontIntercept(@RequestBody TExpLatticeExtend param) {
        logger.info("\u6536\u5230\u5220\u9664\u5f02\u5e38\u4ef6\u524d\u7aef\u62e6\u622a\u914d\u7f6e\u8bf7\u6c42,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)param));
        HttpBaseResponse response = new HttpBaseResponse();
        String s = this.checkFrontInterceptParam(param);
        if (s != null) {
            response.setRespCode("111");
            response.setRespMessage(s);
            return response;
        }
        try {
            this.latticeService.deleteFrontIntercept(param);
            this.latticeSchemeService.schemeUpload();
            response.setRespCode("000");
            response.setRespMessage("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            response.setRespCode("111");
            response.setRespMessage("\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        return response;
    }

    String checkFrontInterceptParam(TExpLatticeExtend param) {
        if (param == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)param.getDeviceName())) {
            return "\u8bbe\u5907\u540d\u79f0\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)param.getSchemeNo())) {
            return "\u683c\u53e3\u65b9\u6848\u4e3a\u7a7a";
        }
        return null;
    }

    @HeadTokenVerification
    @PostMapping(value={"/updateBlendPackRule"})
    public HttpBaseResponse updateBlendPackRule(@RequestBody BlendPackRequest request) {
        logger.info("\u6536\u5230\u66f4\u65b0\u6df7\u5305\u6309\u5305\u7c7b\u578b\u5206\u62e3\u914d\u7f6e\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            if (this.packRuleEmpty(request)) {
                this.latticeService.deleteBlendPackRuleAll(request.getDeviceName(), request.getSchemeNo());
                this.latticeSchemeService.schemeUpload();
                response.setRespCode("000");
                response.setRespMessage("\u64cd\u4f5c\u6210\u529f");
                return response;
            }
            this.latticeService.updateBlendPackRule(request);
            response.setRespCode("000");
            response.setRespMessage("\u64cd\u4f5c\u6210\u529f");
            this.latticeSchemeService.schemeUpload();
            return response;
        }
        catch (Exception e) {
            response.setRespCode("111");
            response.setRespMessage("\u66f4\u65b0\u6df7\u5305\u89c4\u5219\u5f02\u5e38");
            logger.error("\u66f4\u65b0\u6df7\u5305\u6309\u5305\u7c7b\u578b\u5206\u62e3\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            return response;
        }
    }

    @HeadTokenVerification
    @PostMapping(value={"/selectBlendPackRule"})
    public HttpBaseResponse selectBlendPackRule(@RequestBody BlendPackRequest request) {
        HttpBaseResponse response = new HttpBaseResponse();
        if (StringUtils.isBlank((String)request.getDeviceName()) || StringUtils.isBlank((String)request.getSchemeNo())) {
            response.setRespCode("111");
            response.setRespMessage("\u53c2\u6570\u9519\u8bef");
            return response;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TExpLatticeExtend::getDeviceName, (Object)request.getDeviceName())).eq(TExpLatticeExtend::getSchemeNo, (Object)request.getSchemeNo())).eq(TExpLatticeExtend::getExtendType, (Object)BATCH_FLAG_ALL_FRONT_INTERCEPT)).orderByAsc((Object[])new Property[]{TExpLatticeExtend::getPackType});
        List tExpLatticeExtends = this.latticeExtendMapper.selectList((Wrapper)queryWrapper);
        response.setRespCode("000");
        response.setData((Object)tExpLatticeExtends);
        return response;
    }

    @HeadTokenVerification
    @GetMapping(value={"/selectCustomerList"})
    public HttpBaseResponse selectCustomerList(@RequestParam(value="keyword") String keyword) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            List customerRespList = this.customerMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerResp::getStatus, (Object)DbStateEnum.VALID.name())).eq(CustomerResp::getUsed, (Object)"Y")).and(StringUtils.isNotBlank((String)keyword), e -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.like(CustomerResp::getCode, (Object)keyword)).or()).like(CustomerResp::getName, (Object)keyword)));
            response.setData((Object)customerRespList);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        }
        catch (Exception e2) {
            logger.info("\u67e5\u8be2\u5ba2\u6237\u96c6\u5408\u5f02\u5e38", (Throwable)e2);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u67e5\u8be2\u5ba2\u6237\u96c6\u5408\u5f02\u5e38");
        }
        return response;
    }

    private boolean packRuleEmpty(BlendPackRequest request) {
        if (CollUtil.isEmpty((Collection)request.getPackRule())) {
            return true;
        }
        return request.getPackRule().size() == 1 && (((BlendPackRequest.PackRule)request.getPackRule().get(0)).getPackType() == null || StringUtils.isBlank((String)((BlendPackRequest.PackRule)request.getPackRule().get(0)).getLatticeNo()));
    }

    @HeadTokenVerification
    @PostMapping(value={"/savePreciseDispatchConfig"})
    public HttpBaseResponse savePreciseDispatchConfig(@RequestBody TExpLatticeExtend request) {
        logger.info("\u4fdd\u5b58\u7cbe\u51c6\u6d3e\u914d\u7f6e {}", (Object)JSONObject.toJSONString((Object)request));
        HttpBaseResponse response = new HttpBaseResponse();
        if (StringUtils.isBlank((String)request.getDeviceName()) || StringUtils.isBlank((String)request.getSchemeNo())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u7f3a\u5c11\u8bbe\u5907\u540d\u79f0\u6216\u65b9\u6848\u7f16\u53f7");
            return response;
        }
        TransactionStatus transactionStatus = this.platformTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            request.setExtendType("7");
            this.latticeExtendMapper.logicallyDeleteByDeviceNameAndSchemeNo(request);
            List latticeExtendList = request.getLatticeExtendList();
            List list = latticeExtendList = CollectionUtils.isEmpty((Collection)latticeExtendList) ? null : latticeExtendList.stream().filter(e -> StringUtils.isNotBlank((String)e.getLatticeNo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)latticeExtendList)) {
                this.platformTransactionManager.commit(transactionStatus);
                response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
                this.latticeSchemeService.schemeUpload();
                return response;
            }
            for (TExpLatticeExtend extend : latticeExtendList) {
                String latticeNo = this.latticeService.transferLatticeNo(extend.getLatticeNo().replaceAll("[\\n\\r]", "").trim());
                String checkLatticeNoMsg = this.latticeService.checkLatticeNo(latticeNo, false);
                if (StringUtils.isNotBlank((String)checkLatticeNoMsg)) {
                    response.setRespCode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
                    response.setRespMessage(checkLatticeNoMsg);
                    this.platformTransactionManager.rollback(transactionStatus);
                    return response;
                }
                extend.setId(UUID.randomUUID().toString());
                extend.setLatticeId("flashed");
                extend.setLatticeNo(latticeNo);
                extend.setExtendType("7");
                extend.setDeviceName(request.getDeviceName());
                extend.setSchemeNo(request.getSchemeNo());
                extend.setConfigOptFlag("ADD");
                extend.setCreateTime(new Date());
                extend.setCreateUserCode(request.getCreateUserCode());
                extend.setCreateUserName(request.getCreateUserName());
                extend.setModifyTime(new Date());
                extend.setModifyUserCode(request.getModifyUserCode());
                extend.setModifyUserName(request.getModifyUserName());
                extend.setExtendSendStatus(Integer.valueOf(SendStatus.UNSENT.getStatus()));
                extend.setExtendSendTime(new Date());
                extend.setRetry(Integer.valueOf(0));
                this.latticeExtendMapper.insert((Object)extend);
            }
            this.platformTransactionManager.commit(transactionStatus);
            this.latticeSchemeService.schemeUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e2) {
            logger.info("\u4fdd\u5b58\u7cbe\u51c6\u6d3e\u914d\u7f6e\u5f02\u5e38", (Throwable)e2);
            this.platformTransactionManager.rollback(transactionStatus);
            response.setRespCode(ResponseTypeEnum.SAVE_FAIL.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u5931\u8d25");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/selectPreciseDispatchConfig"})
    public HttpBaseResponse<List<TExpLatticeExtend>> selectPreciseDispatchConfig(@RequestBody TExpLatticeExtend request) {
        HttpBaseResponse response = new HttpBaseResponse();
        List optShareList = this.optShareMapper.queryAllOptShareOrg();
        if (CollectionUtils.isEmpty((Collection)optShareList)) {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            return response;
        }
        List extendList = this.latticeExtendMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TExpLatticeExtend::getDeviceName, (Object)request.getDeviceName())).eq(TExpLatticeExtend::getSchemeNo, (Object)request.getSchemeNo())).eq(TExpLatticeExtend::getExtendType, (Object)"7"));
        boolean extendListIsEmp = CollectionUtils.isEmpty((Collection)extendList);
        ArrayList<TExpLatticeExtend> res = new ArrayList<TExpLatticeExtend>(optShareList.size());
        for (OptShareEntity entity : optShareList) {
            boolean exist = false;
            if (!extendListIsEmp) {
                for (TExpLatticeExtend extend : extendList) {
                    if (!entity.getOrgCode().equals(extend.getDestOrgCode())) continue;
                    res.add(extend);
                    exist = true;
                    break;
                }
            }
            if (exist) continue;
            TExpLatticeExtend latticeExtend = new TExpLatticeExtend();
            latticeExtend.setDestOrgCode(entity.getOrgCode());
            latticeExtend.setDestOrgName(entity.getOrgName());
            latticeExtend.setLatticeNo("");
            res.add(latticeExtend);
        }
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setData(res);
        return response;
    }

    @HeadTokenVerification
    @GetMapping(value={"/queryDeliveryOrgList"})
    public HttpBaseResponse<List<DeliverySpotResp>> queryDeliveryOrgList(@RequestParam String threeCode) {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        List deliverySpotResps = this.onlineCheckDataService.queryDeliverySpot(SysPropertiesConfig.getOrgCode(), threeCode);
        baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        baseResponse.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        baseResponse.setData((Object)deliverySpotResps);
        return baseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/delayConfigList"})
    public HttpBaseResponse<List<TExpLattice>> delayConfigList(@RequestBody TExpLattice lattice) {
        HttpBaseResponse baseResponse = new HttpBaseResponse();
        List lattices = this.crossBeltLatticeService.selectLatDelayConfigList(lattice.getDeviceName(), lattice.getLatticeScheme());
        baseResponse.setData((Object)lattices);
        baseResponse.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        baseResponse.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return baseResponse;
    }

    @HeadTokenVerification
    @PostMapping(value={"/batchUpdateLatNo"})
    public HttpBaseResponse batchUpdateLatNo(@RequestBody BatchUpdateLatNoReq request) {
        HttpBaseResponse response = new HttpBaseResponse();
        List schemeList = request.getSchemeList();
        if (CollectionUtils.isEmpty((Collection)schemeList) || StringUtils.isBlank((String)request.getDestOrgCode()) || StringUtils.isBlank((String)request.getLatticeNo())) {
            response.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.MISS_DATA_FAIL.getRespMessage());
            return response;
        }
        TExpLattice updateEntity = new TExpLattice();
        updateEntity.setLatticeNo(request.getLatticeNo());
        updateEntity.setModifyTime(new Date());
        updateEntity.setLatticeSendStatus(Integer.valueOf(SendStatus.UPDATE.getStatus()));
        updateEntity.setRetry(Integer.valueOf(0));
        updateEntity.setModifyUserCode(WebRequestUtil.getUserCode());
        updateEntity.setModifyUserName(WebRequestUtil.getUserName());
        try {
            for (BatchUpdateLatNoReq.SchemeInfo schemeInfo : schemeList) {
                this.latticeService.update((Object)updateEntity, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TExpLattice::getDeviceId, (Object)schemeInfo.getDeviceId())).eq(TExpLattice::getLatticeScheme, (Object)schemeInfo.getSchemeNo())).eq(TExpLattice::getOptFlag, (Object)LatticeOptTypeEnum.UPLOAD.getType())).eq(TExpLattice::getDestOrgCode, (Object)request.getDestOrgCode()));
            }
            this.latticeSchemeService.schemeUpload();
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage("\u4fee\u6539\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u4fee\u6539\u683c\u53e3\u53f7\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fee\u6539\u5931\u8d25");
            return response;
        }
    }
}

