/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.newDevice;

import cn.com.yto56.basic.framework.core.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.constant.AutoDeviceTypeEnum;
import com.yto.monitor.adapter.constant.OperationTableAttrEnum;
import com.yto.monitor.adapter.entity.newDevice.TExpAutoDevice;
import com.yto.monitor.adapter.entity.newDevice.TExpOperationTable;
import com.yto.monitor.adapter.entity.newDevice.TExpPdaInfo;
import com.yto.monitor.adapter.entity.request.OpTableQueryEntity;
import com.yto.monitor.adapter.service.impl.newDevice.ExpPdaInfoServiceImpl;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.adapter.service.newDevice.IExpOperationTableService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.Page;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.exception.ServiceException;
import com.yto.monitor.common.util.DateUtil;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u64cd\u4f5c\u53f0\u57fa\u7840\u4fe1\u606f\u7ba1\u7406\u9875\u9762"})
@RequestMapping(value={"/Yto_MonitorGateway/opTable/"})
public class ExpOperationTableController {
    private static final Logger logger = LoggerFactory.getLogger(ExpOperationTableController.class);
    @Autowired
    private IExpOperationTableService service;
    @Autowired
    private ExpPdaInfoServiceImpl expPdaInfoService;
    @Autowired
    private IExpAutoDeviceService autoDeviceService;

    @HeadTokenVerification
    @PostMapping(value={"query"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u63a5\u53e3", httpMethod="POST", produces="application/json")
    public HttpBaseResponse query(@RequestBody OpTableQueryEntity queryInfo) {
        String baseInfoJson = GoogleJsonUtil.toJson((Object)queryInfo);
        logger.info("\u6536\u5230\u67e5\u8be2\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + baseInfoJson);
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            PageInfo dataByPage = this.service.getList(queryInfo);
            Page page = new Page();
            page.setPageData(dataByPage.getList());
            page.setTotal(dataByPage.getTotal());
            page.setPageNo(dataByPage.getPageNum());
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            response.setData((Object)page);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u64cd\u4f5c\u53f0\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getMessage());
        }
        logger.info("\u54cd\u5e94\u67e5\u8be2\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\u6210\u529f\u3002");
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"addOptable"}, produces={"application/json"})
    @ApiOperation(value="\u65b0\u589e\u64cd\u4f5c\u53f0\u63a5\u53e3", httpMethod="POST", produces="application/json")
    public HttpBaseResponse addOptable(@RequestBody TExpOperationTable requestInfo) {
        String baseInfoJson = GoogleJsonUtil.toJson((Object)requestInfo);
        logger.info("\u6536\u5230\u65b0\u589e\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + baseInfoJson);
        HttpBaseResponse response = new HttpBaseResponse();
        if (!this.setSurveillanc(requestInfo, response)) {
            return response;
        }
        requestInfo.setId(UUID.randomUUID().toString());
        requestInfo.setCreateTime(new Date());
        requestInfo.setModifyTime(new Date());
        requestInfo.setOperationMac(StringUtil.upperCase((String)requestInfo.getOperationMac()));
        if (this.checkOptable(response, requestInfo, false)) {
            try {
                this.service.add(requestInfo);
                response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            }
            catch (Exception e) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage(e.getMessage());
            }
            logger.info("\u54cd\u5e94\u65b0\u589e\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)response));
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"editOptable"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u64cd\u4f5c\u53f0\u63a5\u53e3", httpMethod="POST", produces="application/json")
    public HttpBaseResponse editOptable(@RequestBody TExpOperationTable requestInfo) {
        String baseInfoJson = GoogleJsonUtil.toJson((Object)requestInfo);
        logger.info("\u6536\u5230\u4fee\u6539\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + baseInfoJson);
        HttpBaseResponse response = new HttpBaseResponse();
        requestInfo.setOperationMac(StringUtil.upperCase((String)requestInfo.getOperationMac()));
        if (!this.setSurveillanc(requestInfo, response)) {
            return response;
        }
        if (this.checkOptable(response, requestInfo, true)) {
            try {
                this.service.update(requestInfo);
                response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
                response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            }
            catch (RuntimeException e) {
                logger.info("\u4fee\u6539\u64cd\u4f5c\u53f0\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u4fee\u6539\u64cd\u4f5c\u53f0\u63a5\u53e3\u5f02\u5e38");
            }
            logger.info("\u54cd\u5e94\u4fee\u6539\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)response));
        }
        return response;
    }

    private boolean setSurveillanc(TExpOperationTable requestInfo, HttpBaseResponse response) {
        List cameraInfoList = requestInfo.getCameraInfoList();
        List list = cameraInfoList = CollectionUtils.isEmpty((Collection)cameraInfoList) ? null : cameraInfoList.stream().filter(e -> StringUtils.isNotBlank((String)e.getCameraIndexCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)cameraInfoList)) {
            requestInfo.setSurveillancName("");
            requestInfo.setSurveillanc("");
        } else {
            ArrayList surveillancNames = new ArrayList();
            ArrayList surveillancs = new ArrayList();
            cameraInfoList.forEach(e -> {
                surveillancNames.add(e.getCameraName());
                surveillancs.add(e.getCameraIndexCode());
            });
            HashSet strings = new HashSet(surveillancs);
            if (strings.size() != surveillancs.size()) {
                response.setRespCode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
                response.setRespMessage("\u6709\u76d1\u63a7\u70b9\u4f4d\u91cd\u590d\u914d\u7f6e");
                return false;
            }
            requestInfo.setSurveillancName(StringUtils.join(surveillancNames, (String)","));
            requestInfo.setSurveillanc(StringUtils.join(surveillancs, (String)","));
        }
        if (requestInfo.getDeviceAttribute() != null && requestInfo.getDeviceAttribute().intValue() == OperationTableAttrEnum.BACK_PACKAGE_LINE.getValue()) {
            requestInfo.setDisplay("0");
        }
        return true;
    }

    private boolean checkOptable(HttpBaseResponse response, TExpOperationTable item, boolean isUpdate) {
        String id = item.getId();
        String operationMac = item.getOperationMac();
        TExpOperationTable optableByMac = this.service.selectByMac(item);
        if (null != optableByMac && (!isUpdate || isUpdate && !id.equals(optableByMac.getId()))) {
            response.setRespCode("999");
            response.setRespMessage("MAC\u5730\u5740\u91cd\u590d");
            response.setData((Object)"existed");
            return false;
        }
        TExpOperationTable optable = null;
        try {
            optable = this.service.selectByIpRoom(item);
        }
        catch (ServiceException e) {
            response.setRespCode("999");
            response.setRespMessage(e.getErrorMessage());
            response.setData((Object)"existed");
            return false;
        }
        if (null != optable && (!isUpdate || isUpdate && !id.equals(optable.getId()))) {
            response.setRespCode("999");
            response.setRespMessage("ip\u5730\u5740\u91cd\u590d");
            response.setData((Object)"existed");
            return false;
        }
        TExpOperationTable operationTable = this.service.selectByOpNameAndAdapterDevice(item.getOperationName(), item.getAdapterDevice());
        if (null != operationTable && (!isUpdate || isUpdate && !id.equals(operationTable.getId()))) {
            response.setRespCode("999");
            response.setRespMessage("\u64cd\u4f5c\u53f0\u540d\u79f0\u91cd\u590d");
            return false;
        }
        List pdaDeviceNos = item.getPdaDeviceNoList();
        if (!CollectionUtils.isEmpty((Collection)pdaDeviceNos)) {
            HashSet strings = new HashSet(pdaDeviceNos);
            if (strings.size() != pdaDeviceNos.size()) {
                response.setRespCode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
                response.setRespMessage("\u5b58\u5728\u91cd\u590d\u8bbe\u5907\u53f7");
                return false;
            }
            for (String pdaNo : pdaDeviceNos) {
                List list = this.expPdaInfoService.selectList(pdaNo);
                if (list.isEmpty() || operationMac.equals(((TExpPdaInfo)list.get(0)).getOperationMac())) continue;
                response.setRespCode("999");
                response.setRespMessage(pdaNo + "\u5df2\u7ecf\u7ed1\u5b9a\u5176\u4ed6\u64cd\u4f5c\u53f0");
                return false;
            }
        }
        if (item.getDeviceAttribute() != null && OperationTableAttrEnum.END_LINE.getValue() == item.getDeviceAttribute().intValue()) {
            if (StringUtils.isBlank((String)item.getAdapterDevice())) {
                response.setRespCode("999");
                response.setRespMessage("\u8bf7\u9009\u62e9\u672b\u7aef\u7ebf");
                return false;
            }
            TExpAutoDevice param = new TExpAutoDevice();
            param.setDeviceName(item.getAdapterDevice());
            TExpAutoDevice tExpAutoDevice = this.autoDeviceService.selectByDeviceName(param);
            if (tExpAutoDevice == null) {
                response.setRespCode("999");
                response.setRespMessage("\u642d\u914d\u8bbe\u5907\u4e0d\u5b58\u5728");
                return false;
            }
            if (!"3".equals(tExpAutoDevice.getDeviceType())) {
                response.setRespCode("999");
                response.setRespMessage("\u8bf7\u9009\u62e9\u672b\u7aef\u7ebf\u8bbe\u5907");
                return false;
            }
        }
        return true;
    }

    @HeadTokenVerification
    @PostMapping(value={"checkOpName"}, produces={"application/json"})
    @ApiOperation(value="\u9a8c\u8bc1\u64cd\u4f5c\u53f0\u540d\u79f0", httpMethod="POST", produces="application/json")
    public HttpBaseResponse checkOpName(@RequestBody OpTableQueryEntity requestInfo) {
        String baseInfoJson = GoogleJsonUtil.toJson((Object)requestInfo);
        logger.info("\u6536\u5230\u9a8c\u8bc1\u64cd\u4f5c\u53f0\u540d\u79f0\u8bf7\u6c42\uff1a" + baseInfoJson);
        HttpBaseResponse response = new HttpBaseResponse();
        TExpOperationTable operationTable = this.service.selectByOpNameAndAdapterDevice(requestInfo.getNameStr(), requestInfo.getAdapterDevice());
        if (null != requestInfo.getDeviceType() && "9".equals(requestInfo.getDeviceType())) {
            if (null != operationTable && null == requestInfo.getId() && operationTable.getOperationName().equals(requestInfo.getNameStr())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u64cd\u4f5c\u53f0\u540d\u79f0\u91cd\u590d");
            } else if (null != operationTable && null != requestInfo.getId() && !requestInfo.getId().equals(operationTable.getId())) {
                response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
                response.setRespMessage("\u64cd\u4f5c\u53f0\u540d\u79f0\u91cd\u590d");
            } else {
                response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            }
        } else if (null != operationTable && !requestInfo.getId().equals(operationTable.getId()) && StringUtil.isNotEmpty((String)requestInfo.getAdapterDevice()) && !"\u65e0".equals(requestInfo.getAdapterDevice()) && requestInfo.getAdapterDevice().equals(operationTable.getAdapterDevice())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u64cd\u4f5c\u53f0\u540d\u79f0\u91cd\u590d");
        } else {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        }
        logger.info("\u54cd\u5e94\u9a8c\u8bc1\u64cd\u4f5c\u53f0\u540d\u79f0\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"checkOpMac"}, produces={"application/json"})
    @ApiOperation(value="\u9a8c\u8bc1\u64cd\u4f5c\u53f0mac", httpMethod="POST", produces="application/json")
    public HttpBaseResponse checkOpMac(@RequestBody OpTableQueryEntity requestInfo) {
        String baseInfoJson = GoogleJsonUtil.toJson((Object)requestInfo);
        logger.info("\u6536\u5230\u9a8c\u8bc1\u64cd\u4f5c\u53f0mac\u8bf7\u6c42\uff1a" + baseInfoJson);
        HttpBaseResponse response = new HttpBaseResponse();
        List list = this.service.selectByOpMac(requestInfo.getNameStr());
        if (!list.isEmpty()) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u64cd\u4f5c\u53f0mac\u91cd\u590d,\u5237\u65b0\u9875\u9762\u91cd\u65b0\u751f\u6210");
        } else {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        }
        logger.info("\u54cd\u5e94\u9a8c\u8bc1\u64cd\u4f5c\u53f0mac\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"validateOpNum"}, produces={"application/json"})
    @ApiOperation(value="\u9a8c\u8bc1\u64cd\u4f5c\u53f0\u7f16\u53f7", httpMethod="POST", produces="application/json")
    public HttpBaseResponse validateOpNum(@RequestBody OpTableQueryEntity requestInfo) {
        String baseInfoJson = GoogleJsonUtil.toJson((Object)requestInfo);
        logger.info("\u6536\u5230\u9a8c\u8bc1\u64cd\u4f5c\u53f0\u7f16\u53f7\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + baseInfoJson);
        HttpBaseResponse response = new HttpBaseResponse();
        List list = this.service.selectByDeviceAndOpNum(requestInfo);
        if (null != list && list.size() > 0 && !requestInfo.getId().equals(((TExpOperationTable)list.get(0)).getId())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u64cd\u4f5c\u53f0\u7f16\u53f7\u91cd\u590d");
        } else {
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        }
        logger.info("\u54cd\u5e94\u9a8c\u8bc1\u64cd\u4f5c\u53f0\u7f16\u53f7\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"delOptable/{id}"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u64cd\u4f5c\u53f0\u4fe1\u606f", httpMethod="POST", produces="application/json")
    public HttpBaseResponse delOptable(@PathVariable(value="id") String id) {
        logger.info("\u6536\u5230\u5220\u9664\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570id\uff1a" + id);
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            this.service.delete(id);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        }
        catch (RuntimeException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getMessage());
        }
        logger.info("\u54cd\u5e94\u5220\u9664\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/batchDelOptable/{ids}"}, produces={"application/json"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u64cd\u4f5c\u53f0\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse batchDelOptable(@PathVariable(value="ids") String ids) {
        logger.info("\u6536\u5230\u5220\u9664\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\uff0c\u53c2\u6570ids\uff1a" + ids);
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            this.service.batchDelete(ids);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        }
        catch (RuntimeException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getMessage());
        }
        logger.info("\u54cd\u5e94\u5220\u9664\u64cd\u4f5c\u53f0\u4fe1\u606f\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"getProductionTime"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u642d\u914d\u8bbe\u5907\u540d\u79f0\u5e26\u51fa\u6295\u4ea7\u65f6\u95f4", httpMethod="POST", produces="application/json")
    public HttpBaseResponse getProductionTime(@RequestBody String adapterDevName) {
        logger.info("\u6536\u5230\u5e26\u51fa\u6295\u4ea7\u65f6\u95f4\u8bf7\u6c42\uff0c\u53c2\u6570adapterDevName\uff1a" + adapterDevName);
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            Date date = this.service.getDeviceProductionTime(adapterDevName);
            if (date != null) {
                response.setData((Object)DateUtil.formatYMDHMS((Date)date));
            }
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        }
        catch (RuntimeException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getMessage());
            response.setData(null);
        }
        logger.info("\u54cd\u5e94\u5e26\u51fa\u6295\u4ea7\u65f6\u95f4\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"getCamTypeAndMAC"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u64cd\u4f5c\u53f0MAC\u5730\u5740\u5e26\u51fa\u76f8\u673a\u578b\u53f7\u548c\u76f8\u673aMAC", httpMethod="POST", produces="application/json")
    public HttpBaseResponse getCamTypeAndMAC(@RequestBody String devMac) {
        logger.info("\u6536\u5230\u5e26\u51fa\u76f8\u673a\u578b\u53f7\u548c\u76f8\u673aMAC\u8bf7\u6c42\uff0c\u53c2\u6570mac\uff1a" + devMac);
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            response.setData((Object)this.service.getCamTypeAndMac(devMac));
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        }
        catch (RuntimeException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getMessage());
            response.setData(null);
        }
        logger.info("\u54cd\u5e94\u5e26\u51fa\u76f8\u673a\u578b\u53f7\u548c\u76f8\u673aMAC\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"remoteAdapterDevice/{type}"}, produces={"application/json"})
    @ApiOperation(value="\u6a21\u7cca\u5339\u914d\u642d\u914d\u8bbe\u5907\u540d\u79f0", httpMethod="POST", produces="application/json")
    public HttpBaseResponse remoteAdapterDevice(@PathVariable(value="type") int type, @RequestBody(required=false) String queryStr) {
        logger.info("\u6536\u5230\u6a21\u7cca\u5339\u914d\u642d\u914d\u8bbe\u5907\u540d\u79f0\u8bf7\u6c42\uff0c\u53c2\u6570type\uff1a" + type + "\u67e5\u8be2\u5b57\u7b26\u4e32\uff1a" + queryStr);
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            if (type == 1) {
                List crossBeltNames = this.service.queryDeviceByNameAndType(StringUtils.isBlank((String)queryStr) ? "" : queryStr, AutoDeviceTypeEnum.CROSSBELT.getType());
                crossBeltNames.add(0, this.emptyAutoDevice());
                response.setData((Object)crossBeltNames);
            } else if (type == 2) {
                List armNames = this.service.queryDeviceByNameAndType(StringUtils.isBlank((String)queryStr) ? "" : queryStr, AutoDeviceTypeEnum.MATRIX.getType());
                armNames.add(0, this.emptyAutoDevice());
                response.setData((Object)armNames);
            } else if (type == 3) {
                List endLineNames = this.service.queryDeviceByNameAndType(StringUtils.isBlank((String)queryStr) ? "" : queryStr, AutoDeviceTypeEnum.END_LINE.getType());
                endLineNames.add(0, this.emptyAutoDevice());
                response.setData((Object)endLineNames);
            } else if (type == 0) {
                List crossBeltNames = this.service.queryDeviceByNameAndType(StringUtils.isBlank((String)queryStr) ? "" : queryStr, AutoDeviceTypeEnum.CROSSBELT.getType());
                List armNames = this.service.queryDeviceByNameAndType(StringUtils.isBlank((String)queryStr) ? "" : queryStr, AutoDeviceTypeEnum.MATRIX.getType());
                crossBeltNames.add(0, this.emptyAutoDevice());
                crossBeltNames.addAll(armNames);
                response.setData((Object)crossBeltNames);
            }
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        }
        catch (RuntimeException e) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(e.getMessage());
        }
        logger.info("\u54cd\u5e94\u6a21\u7cca\u5339\u914d\u642d\u914d\u8bbe\u5907\u540d\u79f0\u8bf7\u6c42\u6210\u529f\uff0c\u7ed3\u679c\uff1a" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    private TExpAutoDevice emptyAutoDevice() {
        TExpAutoDevice tExpAutoDevice = new TExpAutoDevice();
        tExpAutoDevice.setDeviceName("\u65e0");
        return tExpAutoDevice;
    }

    @Deprecated
    @HeadTokenVerification
    @PostMapping(value={"getRemoteCameraList"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u8fdc\u7a0b\u6444\u50cf\u673a\u5217\u8868", httpMethod="POST", produces="application/json")
    public HttpBaseResponse getRemoteCameraList(@RequestBody HashMap<String, String> map) {
        if (StringUtils.isBlank((String)map.get("str"))) {
            return HttpBaseResponse.requestParamFail((String)"\u8f93\u5165\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return HttpBaseResponse.success((Object)this.service.getRemoteCameraList(map.get("str")));
    }

    @HeadTokenVerification
    @PostMapping(value={"getRemoteCameraListV1"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u8fdc\u7a0b\u6444\u50cf\u673a\u5217\u8868", httpMethod="POST", produces="application/json")
    public HttpBaseResponse getRemoteCameraListV1(@RequestBody HashMap<String, String> map) {
        if (StringUtils.isBlank((String)map.get("str"))) {
            return HttpBaseResponse.requestParamFail((String)"\u8f93\u5165\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return HttpBaseResponse.success((Object)this.service.getRemoteCameraListV1(map.get("str")));
    }

    @HeadTokenVerification
    @PostMapping(value={"/getSelectedMatrixLatticeNoList"})
    public HttpBaseResponse getSelectedMatrixLatticeNoList(@RequestBody JSONObject request) {
        HttpBaseResponse response = new HttpBaseResponse();
        try {
            String deviceId = request.getString("deviceId");
            Integer attr = request.getInteger("attr");
            Integer no = request.getInteger("no");
            Map res = this.service.getSelectedMatrixLatticeNoList(deviceId, attr, no);
            response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
            response.setData((Object)(CollectionUtils.isEmpty((Map)res) ? null : res));
            return response;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5df2\u9009\u62e9\u672b\u7aef\u7ebf\u7f16\u53f7\u5f02\u5e38", (Throwable)e);
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(ResponseTypeEnum.GENERAL_FAIL.getRespMessage());
            return response;
        }
    }
}

