/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.newDevice;

import cn.com.yto56.basic.framework.core.util.StringUtil;
import com.github.pagehelper.PageInfo;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.entity.PageInfoEntity;
import com.yto.monitor.adapter.entity.newDevice.TExpAutoDevice;
import com.yto.monitor.adapter.entity.newDevice.TExpPrintDevice;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.adapter.service.newDevice.IExpPrintDeviceService;
import com.yto.monitor.adapter.utils.CommonUtils;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.websocket.server.PathParam;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6253\u5370\u673a\u4fe1\u606f\u7ba1\u7406\u9875\u9762"})
@RequestMapping(value={"/Yto_MonitorGateway/printerDevice"})
public class ExpPrintDeviceController {
    private static final Logger logger = LoggerFactory.getLogger(ExpPrintDeviceController.class);
    @Autowired
    private IExpAutoDeviceService deviceService;
    @Autowired
    private IExpPrintDeviceService printService;

    @HeadTokenVerification
    @PostMapping(value={"/del"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u8bbe\u5907\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse deleteById(@PathParam(value="ids") String ids) {
        HttpBaseResponse response = new HttpBaseResponse();
        boolean isOk = this.printService.deleteById(ids);
        if (isOk) {
            response.setRespCode("000");
            response.setRespMessage("\u5220\u9664\u6210\u529f");
        } else {
            response.setRespCode("999");
            response.setRespMessage("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7");
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/add"}, produces={"application/json"})
    @ApiOperation(value="\u65b0\u589e\u8bbe\u5907\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse add(@RequestBody TExpPrintDevice item) {
        item.setLatticeNo(item.getLatticeNo().replaceAll("[\\n\\r]", "").replace(" ", ""));
        HttpBaseResponse response = new HttpBaseResponse();
        if (this.checkData(response, item, false)) {
            int i;
            item.setId(UUID.randomUUID().toString());
            item.setCreateTime(new Date());
            item.setModifyTime(new Date());
            TExpAutoDevice autoDevice = new TExpAutoDevice();
            autoDevice.setDeviceName(item.getDeviceName());
            TExpAutoDevice dbAutoDevice = this.deviceService.selectByDeviceName(autoDevice);
            if (null != dbAutoDevice) {
                item.setDeviceId(dbAutoDevice.getDeviceId());
            }
            if ((i = this.printService.insert(item)) > 0) {
                response.setRespCode("000");
                response.setRespMessage("\u65b0\u589e\u6210\u529f");
            } else {
                response.setRespCode("111");
                response.setRespMessage("\u65b0\u589e\u5931\u8d25");
            }
        }
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/update"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u8bbe\u5907\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse update(@RequestBody TExpPrintDevice item) {
        HttpBaseResponse response = new HttpBaseResponse();
        item.setLatticeNo(item.getLatticeNo().replaceAll("[\\n\\r]", "").replace(" ", ""));
        if (this.checkData(response, item, true)) {
            int i;
            item.setModifyTime(new Date());
            TExpAutoDevice autoDevice = new TExpAutoDevice();
            autoDevice.setDeviceName(item.getDeviceName());
            TExpAutoDevice dbAutoDevice = this.deviceService.selectByDeviceName(autoDevice);
            if (null != dbAutoDevice) {
                item.setDeviceId(dbAutoDevice.getDeviceId());
            }
            if ((i = this.printService.update(item)) > 0) {
                response.setRespCode("000");
                response.setRespMessage("\u66f4\u65b0\u6210\u529f");
            } else {
                response.setRespCode("111");
                response.setRespMessage("\u66f4\u65b0\u5931\u8d25");
            }
        }
        return response;
    }

    private boolean checkData(HttpBaseResponse response, TExpPrintDevice item, boolean isUpdate) {
        try {
            if (!CommonUtils.isboolIp((String)item.getPrinterIp())) {
                response.setRespCode("999");
                response.setRespMessage(item.getPrinterIp() + "\u975e\u6cd5ip");
                return false;
            }
            if (!this.checkLatticeNo(item.getLatticeNo())) {
                response.setRespCode("999");
                response.setRespMessage("\u683c\u53e3\u53f7\u4e0d\u6ee1\u8db3\u4e09\u4f4d\u7f16\u53f7\u683c\u5f0f");
                return false;
            }
            String id = item.getId();
            TExpPrintDevice dbPrinter = this.printService.selectByPrinterIp(item);
            if (null != dbPrinter && (!isUpdate || isUpdate && !id.equals(dbPrinter.getId()))) {
                response.setRespCode("999");
                response.setRespMessage("\u6253\u5370\u673aIP\u91cd\u590d");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u6253\u5370\u8bbe\u5907\u51fa\u73b0\u9519\u8bef" + e.getMessage(), (Throwable)e);
            response.setRespCode("999");
            response.setRespMessage("\u6821\u9a8c\u6253\u5370\u673a\u6570\u636e\u51fa\u9519");
            return false;
        }
    }

    private boolean checkLatticeNo(String latticeNo) {
        String[] latticeNos;
        for (String la : latticeNos = latticeNo.replace(";", ",").split(",")) {
            if (CommonUtils.isNumeric((String)la, (int)3)) continue;
            return false;
        }
        return true;
    }

    @HeadTokenVerification
    @PostMapping(value={"/get"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse<PageInfo<TExpPrintDevice>> get(@RequestBody PageInfoEntity pageInfoEntity) {
        if (StringUtil.isNotBlank((CharSequence)pageInfoEntity.getLatticeNo()) && pageInfoEntity.getLatticeNo().length() < 3) {
            pageInfoEntity.setLatticeNo(StringUtil.leftPad((String)pageInfoEntity.getLatticeNo(), (int)3, (char)'0'));
        }
        HttpBaseResponse response = new HttpBaseResponse();
        PageInfo resultList = null;
        try {
            resultList = this.printService.selectListByPage(pageInfoEntity);
            response.setRespCode("000");
            response.setRespMessage("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6253\u5370\u8bbe\u5907\u51fa\u73b0\u9519\u8bef" + e.getMessage(), (Throwable)e);
            response.setRespCode("111");
            response.setRespMessage("\u67e5\u8be2\u5931\u8d25");
        }
        response.setData((Object)resultList);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/importPrinter"}, produces={"application/json"})
    public HttpBaseResponse importLatticeMapping(@RequestBody List<TExpPrintDevice> list) {
        HttpBaseResponse resp = new HttpBaseResponse();
        logger.info("latticeMapItem.size = " + list.size());
        boolean pass = this.checkExcelData(resp, list);
        if (pass) {
            boolean ok = this.printService.insertExcelData(list);
            if (ok) {
                resp.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
                resp.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
            } else {
                resp.setRespMessage(ResponseTypeEnum.SAVE_FAIL.getRespMessage());
                resp.setRespCode(ResponseTypeEnum.SAVE_FAIL.getRespCode());
            }
        }
        return resp;
    }

    private boolean checkExcelData(HttpBaseResponse resp, List<TExpPrintDevice> list) {
        if (CollectionUtils.isEmpty(list)) {
            resp.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            resp.setRespMessage(ResponseTypeEnum.MISS_DATA_FAIL.getRespMessage());
            return false;
        }
        HashSet<String> printerIpSet = new HashSet<String>();
        StringBuffer msg = new StringBuffer();
        for (TExpPrintDevice p : list) {
            this.removeBlank(p);
            boolean isAppend = false;
            StringBuffer buf = new StringBuffer();
            buf.append("\u7b2c" + p.getRowNum() + "\u884c\u6821\u9a8c\u7ed3\u679c:");
            if (StringUtils.isBlank((String)p.getPrinterIp())) {
                buf.append("\u6253\u5370\u673aIP\u5fc5\u586b,");
                isAppend = true;
            } else {
                if (!CommonUtils.isboolIp((String)p.getPrinterIp())) {
                    buf.append("\u6253\u5370\u673aIP\u975e\u6cd5,");
                    isAppend = true;
                }
                if (printerIpSet.contains(p.getPrinterIp())) {
                    buf.append("\u6b64\u6253\u5370\u673aIP\u5728\u8868\u683c\u4e2d\u91cd\u590d,");
                    isAppend = true;
                } else {
                    printerIpSet.add(p.getPrinterIp());
                }
            }
            if (StringUtils.isBlank((String)p.getLatticeNo())) {
                buf.append("\u683c\u53e3\u53f7\u5fc5\u586b,");
                isAppend = true;
            } else {
                String[] latticeNos;
                for (String la : latticeNos = p.getLatticeNo().split(",")) {
                    if (CommonUtils.isNumeric((String)la, (int)3)) continue;
                    buf.append("\u683c\u53e3\u53f7\u4e0d\u6ee1\u8db3\u4e09\u4f4d\u6570\u5b57\u7f16\u53f7,");
                    isAppend = true;
                }
            }
            if (StringUtils.isBlank((String)p.getDeviceName())) {
                buf.append("\u8bbe\u5907\u540d\u79f0\u5fc5\u586b,");
                isAppend = true;
            } else {
                TExpAutoDevice d = new TExpAutoDevice();
                d.setDeviceName(p.getDeviceName());
                TExpAutoDevice dbDevice = this.deviceService.selectByDeviceName(d);
                if (null == dbDevice) {
                    buf.append("\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6b64\u8bbe\u5907,");
                    isAppend = true;
                }
            }
            if (!isAppend) continue;
            msg.append(buf + "<br/>");
        }
        resp.setRespMessage(msg.toString());
        resp.setRespCode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
        return StringUtils.isBlank((String)msg.toString());
    }

    private void removeBlank(TExpPrintDevice p) {
        if (StringUtils.isNotBlank((String)p.getPrinterIp())) {
            p.setPrinterIp(p.getPrinterIp().replaceAll("[\\n\\r]", "").replace(" ", ""));
        }
        if (StringUtils.isNotBlank((String)p.getLatticeNo())) {
            p.setLatticeNo(p.getLatticeNo().replaceAll("[\\n\\r]", "").replace(" ", ""));
        }
        if (StringUtils.isNotBlank((String)p.getDeviceName())) {
            p.setDeviceName(p.getDeviceName().replaceAll("[\\n\\r]", "").replace(" ", ""));
        }
    }
}

